/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.enhydra.jawe.ButtonPropertyChangedListener;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.PanelUtilities;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jawe.base.panel.panels.tablesorting.BasicSortingTable;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.XMLUtil;

public class XMLBasicTablePanel
extends XMLBasicPanel
implements XMLElementChangeListener {
    public static Color FOREIGN_EL_COLOR_BKG = Color.lightGray;
    public static Color SPEC_EL_COLOR_BKG = Color.orange;
    protected static Dimension miniTableDimension = new Dimension(450, 125);
    protected static Dimension smallTableDimension = new Dimension(450, 200);
    protected static Dimension mediumTableDimension = new Dimension(550, 200);
    protected static Dimension largeTableDimension = new Dimension(650, 200);
    protected XMLElement movingElement;
    protected int movingElementPosition;
    protected int newMovingElementPosition;
    protected boolean dragging = false;
    protected boolean changing = false;
    protected JTable allItems;
    protected JPanel toolbox;
    protected Vector columnNames;
    protected List columnsToShow;
    protected InlinePanel ipc;
    protected Action newElementAction = new AbstractAction("New"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            int n;
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            XMLCollection xMLCollection = (XMLCollection)XMLBasicTablePanel.this.getOwner();
            XMLElement xMLElement = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(xMLCollection, null, false);
            boolean bl = PanelUtilities.isForModalDialog(xMLElement);
            if (!bl && XMLBasicTablePanel.this.ipc.isModified() && ((n = XMLBasicTablePanel.this.ipc.showModifiedWarning()) == 2 || n == 0 && XMLBasicTablePanel.this.ipc.isModified())) {
                return;
            }
            n = 0;
            if (bl) {
                serializable = new StandardXPDLElementEditor();
                ((StandardXPDLElementEditor)serializable).editXPDLElement(xMLElement);
                boolean bl2 = ((StandardXPDLElementEditor)serializable).getStatus() == 0;
                boolean bl3 = true;
                if (bl2) {
                    bl3 = jaWEController.canInsertElement(xMLCollection, xMLElement);
                }
                if (!bl2 || !bl3) {
                    if (!bl3) {
                        jaWEController.message(((StandardXPDLElementEditor)serializable).getLanguageDependentString("WarningCannotInsertElement"), 2);
                    }
                    return;
                }
                n = 1;
            }
            jaWEController.startUndouableChange();
            xMLCollection.add(xMLElement);
            serializable = new ArrayList();
            serializable.add(xMLElement);
            jaWEController.endUndouableChange((List)((Object)serializable));
            if (n != 0) {
                XMLBasicTablePanel.this.setSelectedElement(xMLElement);
            }
            XMLBasicTablePanel.this.adjustActions();
        }
    };
    protected Action editElementAction = new AbstractAction("EditProperties"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLBasicTablePanel.this.getSelectedElement();
            if (xMLElement != null) {
                int n;
                if (XMLBasicTablePanel.this.ipc.isModified() && ((n = XMLBasicTablePanel.this.ipc.showModifiedWarning()) == 2 || n == 0 && XMLBasicTablePanel.this.ipc.isModified())) {
                    return;
                }
                JaWEManager.getInstance().getXPDLElementEditor().editXPDLElement(xMLElement);
            }
        }
    };
    protected Action deleteElementAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLBasicTablePanel.this.getSelectedElement();
            if (xMLElement != null) {
                JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
                ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
                arrayList.add(xMLElement.getParent());
                if (jaWEController.confirmDelete(arrayList, xMLElement)) {
                    XMLCollection xMLCollection = (XMLCollection)XMLBasicTablePanel.this.getOwner();
                    jaWEController.startUndouableChange();
                    xMLCollection.remove(xMLElement);
                    jaWEController.endUndouableChange(arrayList);
                    XMLBasicTablePanel.this.ipc.getPanelSettings().adjustActions();
                    XMLBasicTablePanel.this.adjustActions();
                }
            }
        }
    };
    protected Action moveUpAction = new AbstractAction("MoveUp"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLBasicTablePanel.this.moveItem(0);
            XMLBasicTablePanel.this.adjustActions();
        }
    };
    protected Action moveDownAction = new AbstractAction("MoveDown"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLBasicTablePanel.this.moveItem(1);
            XMLBasicTablePanel.this.adjustActions();
        }
    };

    public XMLBasicTablePanel(InlinePanel inlinePanel, XMLCollection xMLCollection, List list, List list2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(inlinePanel, (XMLElement)xMLCollection, string, true, bl, bl2);
        this.ipc = inlinePanel;
        xMLCollection.addListener((XMLElementChangeListener)this);
        xMLCollection.setNotifyListeners(true);
        this.columnNames = this.getColumnNames(list);
        this.columnsToShow = list;
        this.allItems = this.createTable(bl5);
        this.setupTable(bl4, bl3, bl6);
        this.fillTableContent(list2);
        this.toolbox = this.createToolbar();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.createScrollPane());
        this.add(this.toolbox);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel);
        this.adjustActions();
    }

    public JTable getTable() {
        return this.allItems;
    }

    public XMLElement getSelectedElement() {
        int n = this.allItems.getSelectedRow();
        if (n >= 0) {
            return (XMLElement)this.allItems.getValueAt(n, 0);
        }
        return null;
    }

    public boolean setSelectedElement(Object object) {
        try {
            int n = this.allItems.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (object != this.allItems.getValueAt(i, 0)) continue;
                    this.allItems.setRowSelectionInterval(i, i);
                    JViewport jViewport = (JViewport)this.allItems.getParent();
                    Rectangle rectangle = this.allItems.getCellRect(i, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setSelectedRow(int n) {
        try {
            this.allItems.setRowSelectionInterval(n, n);
            this.adjustActions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow(XMLElement xMLElement) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(xMLElement);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        defaultTableModel.removeRow(n);
    }

    protected void moveItem(int n) {
        this.newMovingElementPosition = this.movingElementPosition;
        if (this.newMovingElementPosition == -1) {
            return;
        }
        this.newMovingElementPosition = n == 0 ? --this.newMovingElementPosition : ++this.newMovingElementPosition;
        this.moveItem();
    }

    protected void moveItem() {
        this.changing = true;
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        int n = this.allItems.getRowCount();
        if (this.movingElement == null || this.movingElementPosition == -1 || this.newMovingElementPosition == -1 || this.newMovingElementPosition == this.movingElementPosition || n - 1 < this.movingElementPosition || n - 1 < this.newMovingElementPosition || !xMLCollection.contains(this.movingElement)) {
            this.changing = false;
            return;
        }
        if (JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, this.movingElement)) {
            XMLElement xMLElement = (XMLElement)this.allItems.getValueAt(this.newMovingElementPosition, 0);
            int n2 = xMLCollection.indexOf(xMLElement);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
            Vector vector = this.getRow(this.movingElement);
            defaultTableModel.removeRow(this.movingElementPosition);
            defaultTableModel.insertRow(this.newMovingElementPosition, vector);
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            jaWEController.startUndouableChange();
            xMLCollection.reposition(this.movingElement, n2);
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            arrayList.add(this.movingElement);
            jaWEController.endUndouableChange(arrayList);
            this.setSelectedRow(this.newMovingElementPosition);
            this.movingElementPosition = this.newMovingElementPosition;
        }
        this.changing = false;
    }

    protected Vector getColumnNames(List list) {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        XMLElement xMLElement = ((XMLCollection)this.getOwner()).generateNewElement();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLElement xMLElement2 = ((XMLComplexElement)xMLElement).get(string);
                if (xMLElement2 != null) {
                    vector.add(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement2));
                    continue;
                }
                iterator.remove();
            }
        } else {
            vector.add(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement));
        }
        return vector;
    }

    protected JTable createTable(final boolean bl) {
        BasicSortingTable basicSortingTable = new BasicSortingTable(this, new Vector(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (!this.isCellSelected(n, n2) && bl) {
                    XMLElement xMLElement = (XMLElement)this.getValueAt(n, 0);
                    if (xMLElement instanceof XMLCollectionElement) {
                        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)xMLElement;
                        XMLCollection xMLCollection = (XMLCollection)xMLCollectionElement.getParent();
                        if (xMLCollection == null) {
                            component.setBackground(SPEC_EL_COLOR_BKG);
                        } else if (xMLCollection != XMLBasicTablePanel.this.getOwner()) {
                            component.setBackground(FOREIGN_EL_COLOR_BKG);
                        } else {
                            component.setBackground(this.getBackground());
                        }
                    } else {
                        component.setBackground(this.getBackground());
                    }
                }
                return component;
            }
        };
        Color color = new Color(245, 245, 245);
        if (this.ipc.getSettings() instanceof PanelSettings) {
            color = ((PanelSettings)this.ipc.getSettings()).getBackgroundColor();
        }
        basicSortingTable.setBackground(color);
        return basicSortingTable;
    }

    protected void setupTable(boolean bl, boolean bl2, final boolean bl3) {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        int n = this.columnNames.size() - 1;
        Dimension dimension = bl ? new Dimension(miniTableDimension) : (n <= 3 ? new Dimension(smallTableDimension) : (n <= 5 ? new Dimension(mediumTableDimension) : new Dimension(largeTableDimension)));
        if (bl2) {
            dimension.width = this.allItems.getPreferredScrollableViewportSize().width;
        }
        this.allItems.setPreferredScrollableViewportSize(new Dimension(dimension));
        this.allItems.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
        this.allItems.getActionMap().put("edit", this.editElementAction);
        this.allItems.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0, false), "delete");
        this.allItems.getActionMap().put("delete", this.deleteElementAction);
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        final boolean bl4 = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        if (!this.getOwner().isReadOnly()) {
            this.allItems.setToolTipText(ResourceManager.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
        }
        this.allItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    XMLBasicTablePanel.this.editElementAction.actionPerformed(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                XMLBasicTablePanel.this.movingElement = null;
                XMLBasicTablePanel.this.movingElementPosition = -1;
                if (bl3 && !XMLBasicTablePanel.this.getOwner().isReadOnly() && bl4) {
                    XMLBasicTablePanel.this.dragging = true;
                }
                try {
                    XMLBasicTablePanel.this.movingElementPosition = XMLBasicTablePanel.this.allItems.getSelectedRow();
                    if (XMLBasicTablePanel.this.movingElementPosition >= 0) {
                        XMLBasicTablePanel.this.movingElement = (XMLElement)XMLBasicTablePanel.this.allItems.getValueAt(XMLBasicTablePanel.this.movingElementPosition, 0);
                        XMLBasicTablePanel.this.adjustActions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                XMLBasicTablePanel.this.dragging = false;
            }
        });
        if (bl3 && !this.myOwner.isReadOnly() && bl4) {
            ListSelectionModel listSelectionModel = this.allItems.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (XMLBasicTablePanel.this.dragging && !XMLBasicTablePanel.this.changing) {
                        XMLBasicTablePanel.this.newMovingElementPosition = -1;
                        try {
                            XMLBasicTablePanel.this.newMovingElementPosition = XMLBasicTablePanel.this.allItems.getSelectedRow();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        XMLBasicTablePanel.this.moveItem();
                    }
                    XMLBasicTablePanel.this.adjustActions();
                }
            });
        }
    }

    protected void fillTableContent(List list) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (XMLElement xMLElement : list) {
            Vector vector = this.getRow(xMLElement);
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(XMLElement xMLElement) {
        Vector<XMLElementView> vector = new Vector<XMLElementView>();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = this.columnsToShow.iterator();
            vector = new Vector();
            XMLComplexElement xMLComplexElement = (XMLComplexElement)xMLElement;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLElement xMLElement2 = xMLComplexElement.get(string);
                if (xMLElement2 == null) continue;
                vector.add(new XMLElementView((PanelContainer)this.ipc, xMLElement2, 2));
            }
        } else {
            vector.add(new XMLElementView((PanelContainer)this.ipc, xMLElement, 2));
        }
        vector.add(0, (XMLElementView)xMLElement);
        return vector;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected JPanel createToolbar() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.newElementAction);
        jButton.setRolloverEnabled(true);
        JButton jButton2 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.editElementAction);
        jButton2.setRolloverEnabled(true);
        JButton jButton3 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.deleteElementAction);
        jButton3.setRolloverEnabled(true);
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton3);
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JPanel createArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton();
        jButton.setIcon(this.ipc.getPanelSettings().getArrowUpImageIcon());
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setEnabled(false);
        jButton.addActionListener(this.moveUpAction);
        this.moveUpAction.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton));
        JButton jButton2 = new JButton();
        jButton2.setIcon(this.ipc.getPanelSettings().getArrowDownImageIcon());
        jButton2.setPreferredSize(new Dimension(16, 16));
        jButton2.setEnabled(false);
        jButton2.addActionListener(this.moveDownAction);
        this.moveDownAction.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton2));
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jButton2);
        return jPanel;
    }

    public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
        block3: {
            block2: {
                if (xMLElementChangeInfo.getAction() != 5) break block2;
                for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                    int n = this.getElementRow(xMLElement);
                    if (n == -1) continue;
                    this.removeRow(n);
                }
                break block3;
            }
            if (xMLElementChangeInfo.getAction() != 3) break block3;
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                this.addRow(xMLElement);
            }
        }
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = (XMLElement)this.allItems.getValueAt(i, 0);
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void adjustActions() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        XMLElement xMLElement = this.getSelectedElement();
        this.newElementAction.setEnabled(jaWEController.canCreateElement((XMLCollection)this.getOwner()));
        this.editElementAction.setEnabled(xMLElement != null && XMLUtil.getPackage((XMLElement)xMLElement) != null);
        this.deleteElementAction.setEnabled(xMLElement != null && jaWEController.canRemoveElement((XMLCollection)this.getOwner(), xMLElement));
        boolean bl = JaWEManager.getInstance().getJaWEController().canRepositionElement((XMLCollection)this.getOwner(), null);
        this.moveUpAction.setEnabled(xMLElement != null && this.allItems.getSelectedRow() > 0 && bl);
        this.moveDownAction.setEnabled(xMLElement != null && this.allItems.getSelectedRow() < this.allItems.getModel().getRowCount() - 1 && bl);
    }

    @Override
    public void cleanup() {
        this.myOwner.removeListener((XMLElementChangeListener)this);
    }

    @Override
    public boolean isEmpty() {
        return this.allItems.getRowCount() == 0;
    }

    @Override
    public boolean validateEntry() {
        if (this.isEmpty() && this.getOwner().isRequired() && !this.getOwner().isReadOnly()) {
            XMLBasicPanel.defaultErrorMessage(this.getWindow(), this.getTitle() + ": ");
            this.allItems.requestFocus();
            return false;
        }
        return true;
    }
}

