/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.enhydra.jawe.ButtonPropertyChangedListener;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.NewActionBase;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.controller.JaWESelectionManager;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.PanelUtilities;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jawe.base.panel.panels.tablesorting.SortingTable;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.Performer;

public class XMLTablePanel
extends XMLBasicPanel
implements XMLElementChangeListener,
FocusListener,
ChoiceButtonListener {
    public static Color FOREIGN_EL_COLOR_BKG = Color.lightGray;
    public static Color SPEC_EL_COLOR_BKG = Color.orange;
    protected static Dimension miniTableDimension = new Dimension(450, 125);
    protected static Dimension smallTableDimension = new Dimension(450, 200);
    protected static Dimension mediumTableDimension = new Dimension(550, 200);
    protected static Dimension largeTableDimension = new Dimension(650, 200);
    protected XMLElement movingElement;
    protected int movingElementPosition;
    protected int newMovingElementPosition;
    protected int replacingElementPosition;
    protected boolean dragging = false;
    protected boolean changing = false;
    protected boolean lostFocusHandle = true;
    protected JTable allItems;
    protected JPanel toolbox;
    protected Vector columnNames;
    protected List columnsToShow;
    protected InlinePanel ipc;
    protected Dimension customDim;
    protected NewActionBase newElementAction = null;
    protected boolean notifyPanel;
    protected int newPos;
    protected int oldPos;
    protected Action duplicateElementAction = new AbstractAction("Duplicate"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLTablePanel.this.getSelectedElement();
            if (xMLElement != null) {
                JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
                XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                XMLTablePanel.this.allItems.clearSelection();
                jaWESelectionManager.setSelection(xMLElement, false);
                JaWEManager.getInstance().getJaWEController().getEdit().duplicate();
                if (!XMLTablePanel.this.setSelectedElement(jaWESelectionManager.getSelectedElement())) {
                    jaWESelectionManager.setSelection(XMLTablePanel.this.ipc.getActiveElement(), false);
                }
                XMLTablePanel.this.adjustActions();
                XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
            }
        }
    };
    protected Action editElementAction = new AbstractAction("EditProperties"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLTablePanel.this.getSelectedElement();
            if (xMLElement != null) {
                Window window;
                if (XMLTablePanel.this.ipc.isModified()) {
                    XMLTablePanel.this.lostFocusHandle = false;
                    int n = XMLTablePanel.this.ipc.showModifiedWarning();
                    if (n == 2 || n == 0 && XMLTablePanel.this.ipc.isModified()) {
                        XMLTablePanel.this.lostFocusHandle = true;
                        return;
                    }
                }
                if ((window = XMLTablePanel.this.getWindow()) instanceof JDialog && ((JDialog)window).isModal()) {
                    JaWEManager.getInstance().getXPDLElementEditor().editXPDLElement(xMLElement);
                } else {
                    JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
                }
            }
        }
    };
    protected Action deleteElementAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLTablePanel.this.getSelectedElement();
            if (xMLElement != null) {
                XMLElement xMLElement2 = xMLElement.getParent();
                XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                XMLTablePanel.this.lostFocusHandle = false;
                JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
                jaWESelectionManager.setSelection(xMLElement, false);
                JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("Delete").actionPerformed(null);
                XMLTablePanel.this.ipc.getHistoryManager().removeFromHistory(xMLElement);
                XMLTablePanel.this.ipc.getPanelSettings().adjustActions();
                XMLElement xMLElement3 = jaWESelectionManager.getSelectedElement();
                if (xMLElement3 != xMLElement2 && !XMLTablePanel.this.setSelectedElement(xMLElement3)) {
                    jaWESelectionManager.setSelection(XMLTablePanel.this.ipc.getActiveElement(), true);
                }
                XMLTablePanel.this.lostFocusHandle = true;
                XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                XMLTablePanel.this.adjustActions();
            }
        }
    };
    protected Action referencesElementAction = new AbstractAction("References"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("References").actionPerformed(null);
        }
    };
    protected Action moveUpAction = new AbstractAction("MoveUp"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLTablePanel.this.moveItem(0);
            XMLTablePanel.this.adjustActions();
        }
    };
    protected Action moveDownAction = new AbstractAction("MoveDown"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLTablePanel.this.moveItem(1);
            XMLTablePanel.this.adjustActions();
        }
    };

    public XMLTablePanel(InlinePanel inlinePanel, XMLCollection xMLCollection, List list, List list2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(inlinePanel, xMLCollection, list, list2, string, bl, bl2, bl3, bl4, null, bl5, bl6, false, false);
    }

    public XMLTablePanel(final InlinePanel inlinePanel, final XMLCollection xMLCollection, List list, List list2, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, Dimension dimension, boolean bl5, boolean bl6, boolean bl7, boolean bl8) {
        super(inlinePanel, (XMLElement)xMLCollection, string, true, bl, bl2);
        this.ipc = inlinePanel;
        this.customDim = dimension;
        this.notifyPanel = bl8;
        Class<?> clazz = null;
        if (xMLCollection instanceof ExtendedAttributes) {
            clazz = xMLCollection.getParent().getClass();
        }
        this.newElementAction = new NewActionBase(inlinePanel.getJaWEComponent(), "New", xMLCollection.getClass(), clazz){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inlinePanel.getJaWEComponent().setUpdateInProgress(true);
                XMLTablePanel.this.lostFocusHandle = false;
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)xMLCollection, false);
                XMLTablePanel.this.allItems.clearSelection();
                XMLTablePanel.this.adjustActions();
            }

            @Override
            public void enableDisableAction() {
                this.setEnabled(JaWEManager.getInstance().getJaWEController().canCreateElement((XMLCollection)XMLTablePanel.this.getOwner()));
            }
        };
        xMLCollection.addListener((XMLElementChangeListener)this);
        xMLCollection.setNotifyListeners(true);
        this.columnNames = this.getColumnNames(list);
        this.columnsToShow = list;
        this.allItems = this.createTable(bl5);
        this.setupTable(bl4, bl3, bl6);
        this.fillTableContent(list2);
        this.toolbox = this.createToolbar(bl7);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.createScrollPane());
        this.add(this.toolbox);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel);
        this.allItems.addFocusListener(this);
        this.adjustActions();
    }

    public JTable getTable() {
        return this.allItems;
    }

    public XMLElement getSelectedElement() {
        int n = this.allItems.getSelectedRow();
        if (n >= 0) {
            return (XMLElement)this.allItems.getValueAt(n, 0);
        }
        return null;
    }

    public boolean setSelectedElement(Object object) {
        try {
            int n = this.allItems.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (object != this.allItems.getValueAt(i, 0)) continue;
                    this.allItems.setRowSelectionInterval(i, i);
                    JViewport jViewport = (JViewport)this.allItems.getParent();
                    Rectangle rectangle = this.allItems.getCellRect(i, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setSelectedRow(int n) {
        try {
            this.allItems.setRowSelectionInterval(n, n);
            this.ipc.getJaWEComponent().setUpdateInProgress(true);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(this.getSelectedElement(), false);
            this.ipc.getJaWEComponent().setUpdateInProgress(false);
            this.adjustActions();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow(XMLElement xMLElement) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(xMLElement);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        defaultTableModel.removeRow(n);
    }

    protected void moveItem(int n) {
        this.newMovingElementPosition = this.movingElementPosition;
        if (this.newMovingElementPosition == -1) {
            return;
        }
        this.lostFocusHandle = false;
        this.newMovingElementPosition = n == 0 ? --this.newMovingElementPosition : ++this.newMovingElementPosition;
        this.lostFocusHandle = true;
        this.moveItem();
    }

    protected void moveItem() {
        this.changing = true;
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        int n = this.allItems.getRowCount();
        if (this.movingElement == null || this.movingElementPosition == -1 || this.newMovingElementPosition == -1 || this.newMovingElementPosition == this.movingElementPosition || n - 1 < this.movingElementPosition || n - 1 < this.newMovingElementPosition || !xMLCollection.contains(this.movingElement)) {
            this.changing = false;
            return;
        }
        if (JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, this.movingElement)) {
            this.ipc.getJaWEComponent().setUpdateInProgress(true);
            XMLElement xMLElement = (XMLElement)this.allItems.getValueAt(this.replacingElementPosition, 0);
            int n2 = xMLCollection.indexOf(xMLElement);
            Vector vector = this.getRow(this.movingElement);
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            jaWEController.startUndouableChange();
            xMLCollection.reposition(this.movingElement, n2);
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            arrayList.add(this.movingElement);
            jaWEController.endUndouableChange(arrayList);
            this.setSelectedRow(this.newMovingElementPosition);
            this.movingElementPosition = this.newMovingElementPosition;
            this.ipc.getJaWEComponent().setUpdateInProgress(false);
        }
        this.changing = false;
    }

    protected Vector getColumnNames(List list) {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        XMLElement xMLElement = ((XMLCollection)this.getOwner()).generateNewElement();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.equals("ElementValue")) {
                    XMLElement xMLElement2 = ((XMLComplexElement)xMLElement).get(string);
                    if (xMLElement2 == null && string.equals("Performer") && xMLElement instanceof Activity) {
                        xMLElement2 = new Performer((Activity)xMLElement);
                    }
                    if (xMLElement2 != null) {
                        vector.add(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement2));
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                vector.add(this.ipc.getSettings().getLanguageDependentString("ElementValueKey"));
            }
        } else {
            vector.add(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement));
        }
        return vector;
    }

    protected JTable createTable(final boolean bl) {
        SortingTable sortingTable = new SortingTable(this, new Vector(), this.columnNames, this.ipc){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (!this.isCellSelected(n, n2) && bl) {
                    XMLElement xMLElement = (XMLElement)this.getValueAt(n, 0);
                    if (xMLElement instanceof XMLCollectionElement) {
                        XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)xMLElement;
                        XMLCollection xMLCollection = (XMLCollection)xMLCollectionElement.getParent();
                        if (xMLCollection == null) {
                            component.setBackground(SPEC_EL_COLOR_BKG);
                        } else if (xMLCollection != XMLTablePanel.this.getOwner()) {
                            component.setBackground(FOREIGN_EL_COLOR_BKG);
                        } else {
                            component.setBackground(this.getBackground());
                        }
                    } else {
                        component.setBackground(this.getBackground());
                    }
                }
                return component;
            }
        };
        Color color = new Color(245, 245, 245);
        if (this.ipc.getSettings() instanceof PanelSettings) {
            color = ((PanelSettings)this.ipc.getSettings()).getBackgroundColor();
        }
        sortingTable.setBackground(color);
        return sortingTable;
    }

    protected void setupTable(boolean bl, boolean bl2, final boolean bl3) {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        int n = this.columnNames.size() - 1;
        Dimension dimension = this.customDim != null ? this.customDim : (bl ? new Dimension(miniTableDimension) : (n <= 3 ? new Dimension(smallTableDimension) : (n <= 5 ? new Dimension(mediumTableDimension) : new Dimension(largeTableDimension))));
        if (bl2) {
            dimension.width = this.allItems.getPreferredScrollableViewportSize().width;
        }
        this.allItems.setPreferredScrollableViewportSize(new Dimension(dimension));
        this.allItems.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
        this.allItems.getActionMap().put("edit", this.editElementAction);
        this.allItems.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0, false), "delete");
        this.allItems.getActionMap().put("delete", this.deleteElementAction);
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        final boolean bl4 = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        if (!this.getOwner().isReadOnly()) {
            this.allItems.setToolTipText(this.pc.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
        }
        this.allItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    XMLTablePanel.this.editElementAction.actionPerformed(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                XMLTablePanel.this.movingElement = null;
                XMLTablePanel.this.movingElementPosition = -1;
                if (bl3 && !XMLTablePanel.this.getOwner().isReadOnly() && bl4) {
                    XMLTablePanel.this.dragging = true;
                }
                try {
                    XMLTablePanel.this.oldPos = XMLTablePanel.this.movingElementPosition = XMLTablePanel.this.allItems.getSelectedRow();
                    if (XMLTablePanel.this.movingElementPosition >= 0) {
                        XMLTablePanel.this.movingElement = (XMLElement)XMLTablePanel.this.allItems.getValueAt(XMLTablePanel.this.movingElementPosition, 0);
                        XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(XMLTablePanel.this.movingElement, false);
                        XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                        XMLTablePanel.this.adjustActions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                XMLTablePanel.this.dragging = false;
                XMLTablePanel.this.newMovingElementPosition = XMLTablePanel.this.allItems.getSelectedRow();
                XMLTablePanel.this.moveItem();
                try {
                    XMLElement xMLElement = XMLTablePanel.this.getSelectedElement();
                    if (xMLElement != null) {
                        XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
                        XMLTablePanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                        XMLTablePanel.this.adjustActions();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        if (bl3 && !this.myOwner.isReadOnly() && bl4) {
            ListSelectionModel listSelectionModel = this.allItems.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (XMLTablePanel.this.dragging) {
                        XMLTablePanel.this.newPos = XMLTablePanel.this.allItems.getSelectedRow();
                        if (XMLTablePanel.this.oldPos != XMLTablePanel.this.newPos) {
                            for (int i = 0; i < XMLTablePanel.this.allItems.getColumnCount(); ++i) {
                                Object object = XMLTablePanel.this.allItems.getValueAt(XMLTablePanel.this.oldPos, i);
                                Object object2 = XMLTablePanel.this.allItems.getValueAt(XMLTablePanel.this.newPos, i);
                                XMLTablePanel.this.allItems.setValueAt(object, XMLTablePanel.this.newPos, i);
                                XMLTablePanel.this.allItems.setValueAt(object2, XMLTablePanel.this.oldPos, i);
                            }
                            XMLTablePanel.this.replacingElementPosition = XMLTablePanel.this.oldPos;
                        }
                        XMLTablePanel.this.oldPos = XMLTablePanel.this.newPos;
                    }
                }
            });
        }
    }

    protected void fillTableContent(List list) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (XMLElement xMLElement : list) {
            Vector vector = this.getRow(xMLElement);
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(XMLElement xMLElement) {
        Vector<XMLElementView> vector = new Vector<XMLElementView>();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = this.columnsToShow.iterator();
            vector = new Vector();
            XMLComplexElement xMLComplexElement = (XMLComplexElement)xMLElement;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.equals("ElementValue")) {
                    XMLElement xMLElement2 = xMLComplexElement.get(string);
                    if (xMLElement2 == null && string.equals("Performer") && xMLComplexElement instanceof Activity && (xMLElement2 = ((Activity)xMLComplexElement).getFirstPerformerObj()) == null) {
                        xMLElement2 = new Performer((Activity)xMLComplexElement);
                    }
                    if (xMLElement2 == null) continue;
                    vector.add(new XMLElementView((PanelContainer)this.ipc, xMLElement2, 2));
                    continue;
                }
                vector.add(new XMLElementView((PanelContainer)this.ipc, xMLElement.toValue(), false));
            }
        } else {
            vector.add(new XMLElementView((PanelContainer)this.ipc, xMLElement, 2));
        }
        vector.add(0, (XMLElementView)xMLElement);
        return vector;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected JPanel createToolbar(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.newElementAction, this);
        jButton.setRolloverEnabled(true);
        JButton jButton2 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.editElementAction);
        jButton2.setRolloverEnabled(true);
        JButton jButton3 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.referencesElementAction);
        jButton3.setRolloverEnabled(true);
        JButton jButton4 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.deleteElementAction);
        jButton4.setRolloverEnabled(true);
        JButton jButton5 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.duplicateElementAction);
        jButton5.setRolloverEnabled(true);
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton4);
        jPanel.add(Box.createRigidArea(new Dimension(5, 3)));
        if (!bl) {
            jPanel.add(jButton5);
            jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
            jPanel.add(jButton3);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JPanel createArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = new JButton();
        jButton.setIcon(this.ipc.getPanelSettings().getArrowUpImageIcon());
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setEnabled(false);
        jButton.addActionListener(this.moveUpAction);
        this.moveUpAction.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton));
        jButton.addFocusListener(this);
        JButton jButton2 = new JButton();
        jButton2.setIcon(this.ipc.getPanelSettings().getArrowDownImageIcon());
        jButton2.setPreferredSize(new Dimension(16, 16));
        jButton2.setEnabled(false);
        jButton2.addActionListener(this.moveDownAction);
        this.moveDownAction.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton2));
        jButton2.addFocusListener(this);
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jButton2);
        return jPanel;
    }

    public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
        if (xMLElementChangeInfo.getAction() == 5) {
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                int n = this.getElementRow(xMLElement);
                if (n == -1) continue;
                this.removeRow(n);
            }
            if (this.notifyPanel) {
                this.getPanelContainer().panelChanged(this, null);
            }
        } else if (xMLElementChangeInfo.getAction() == 3) {
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                this.addRow(xMLElement);
            }
            if (this.notifyPanel) {
                this.getPanelContainer().panelChanged(this, null);
            }
        }
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = (XMLElement)this.allItems.getValueAt(i, 0);
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    protected void adjustActions() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        JaWESelectionManager jaWESelectionManager = jaWEController.getSelectionManager();
        this.newElementAction.enableDisableAction();
        this.referencesElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canGetReferences());
        this.editElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canEditProperties());
        this.duplicateElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canDuplicate());
        this.deleteElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canDelete());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.adjustActions();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.lostFocusHandle && !this.ipc.getJaWEComponent().isUpdateInProgress()) {
            JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
            List list = jaWESelectionManager.getSelectedElements();
            XMLElement xMLElement = null;
            if (list != null && list.size() > 0) {
                xMLElement = (XMLElement)list.get(0);
            }
            if (xMLElement != null && ((XMLCollection)this.getOwner()).contains(xMLElement)) {
                this.ipc.getJaWEComponent().setUpdateInProgress(true);
                jaWESelectionManager.setSelection(this.ipc.getActiveElement(), false);
                this.ipc.getJaWEComponent().setUpdateInProgress(false);
            }
            if (this.allItems != null) {
                this.allItems.clearSelection();
            }
        }
        this.adjustActions();
    }

    @Override
    public void selectionChanged(ChoiceButton choiceButton, Object object) {
        this.ipc.getJaWEComponent().setUpdateInProgress(false);
        this.lostFocusHandle = true;
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        JaWESelectionManager jaWESelectionManager = jaWEController.getSelectionManager();
        if (choiceButton.getChoiceType().equals(JaWEType.class)) {
            XMLElement xMLElement;
            JaWEType jaWEType = (JaWEType)object;
            String string = null;
            if (jaWEType != null) {
                string = jaWEType.getTypeId();
            }
            if (!((xMLElement = jaWESelectionManager.getSelectedElement()) instanceof XMLCollection)) {
                xMLElement = xMLElement.getParent();
            }
            if (xMLElement instanceof XMLCollection) {
                Serializable serializable;
                int n;
                XMLCollection xMLCollection = (XMLCollection)xMLElement;
                XMLElement xMLElement2 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(xMLCollection, string, false);
                boolean bl = PanelUtilities.isForModalDialog(xMLElement2);
                if (!bl && this.ipc.isModified() && ((n = this.ipc.showModifiedWarning()) == 2 || n == 0 && this.ipc.isModified())) {
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                    jaWESelectionManager.setSelection(this.ipc.getActiveElement(), true);
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                    return;
                }
                n = 0;
                if (bl) {
                    this.lostFocusHandle = false;
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                    serializable = new StandardXPDLElementEditor();
                    ((StandardXPDLElementEditor)serializable).editXPDLElement(xMLElement2);
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                    this.lostFocusHandle = true;
                    boolean bl2 = ((StandardXPDLElementEditor)serializable).getStatus() == 0;
                    boolean bl3 = true;
                    if (bl2) {
                        bl3 = jaWEController.canInsertElement(xMLCollection, xMLElement2);
                    }
                    if (!bl2 || !bl3) {
                        if (!bl3) {
                            jaWEController.message(((StandardXPDLElementEditor)serializable).getLanguageDependentString("WarningCannotInsertElement"), 2);
                        }
                        this.ipc.getJaWEComponent().setUpdateInProgress(true);
                        jaWESelectionManager.setSelection(this.ipc.getActiveElement(), true);
                        this.ipc.getJaWEComponent().setUpdateInProgress(false);
                        return;
                    }
                    n = 1;
                }
                if (n != 0) {
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                }
                jaWEController.startUndouableChange();
                xMLCollection.add(xMLElement2);
                serializable = new ArrayList();
                serializable.add(xMLElement2);
                jaWEController.endUndouableChange((List)((Object)serializable));
                if (n != 0) {
                    this.setSelectedElement(xMLElement2);
                    this.adjustActions();
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                }
            }
        }
    }

    @Override
    public Object getSelectedObject(ChoiceButton choiceButton) {
        return null;
    }

    @Override
    public List getChoices(ChoiceButton choiceButton) {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        ArrayList arrayList = new ArrayList();
        if (choiceButton.getChoiceType().equals(JaWEType.class)) {
            XMLElement xMLElement = (XMLElement)jaWEController.getSelectionManager().getSelectedElements().toArray()[0];
            arrayList.addAll(jaWEController.getJaWETypes().getTypes(xMLElement));
        }
        return arrayList;
    }

    @Override
    public void cleanup() {
        this.myOwner.removeListener((XMLElementChangeListener)this);
        this.allItems.removeFocusListener(this);
    }

    @Override
    public boolean isEmpty() {
        return this.allItems.getRowCount() == 0;
    }

    @Override
    public boolean validateEntry() {
        if (this.isEmpty() && this.getOwner().isRequired() && !this.getOwner().isReadOnly()) {
            XMLBasicPanel.defaultErrorMessage(this.getWindow(), this.getTitle() + ": ");
            this.allItems.requestFocus();
            return false;
        }
        return true;
    }
}

