/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels.tablesorting;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.enhydra.jawe.base.panel.panels.XMLBasicTablePanel;
import org.enhydra.jawe.base.panel.panels.tablesorting.SortingTableModel;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;

public class BasicSortingTable
extends JTable {
    protected int sortedColIndex = -1;
    protected boolean ascending = true;
    XMLBasicTablePanel owner;

    public BasicSortingTable(XMLBasicTablePanel xMLBasicTablePanel, Vector vector, Vector vector2) {
        super(new SortingTableModel((XMLCollection)xMLBasicTablePanel.getOwner(), vector, vector2));
        this.owner = xMLBasicTablePanel;
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SHRenderer());
    }

    public int getSortedColumnIndex() {
        return this.sortedColIndex;
    }

    public boolean isSortedColumnAscending() {
        return this.ascending;
    }

    public void performSorting(MouseEvent mouseEvent) {
        if (this.owner.getOwner().isReadOnly() && ((XMLCollection)this.owner.getOwner()).getParent().isReadOnly()) {
            return;
        }
        if (mouseEvent == null && this.sortedColIndex == -1) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.sortedColIndex;
        if (mouseEvent != null) {
            n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        }
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortingTableModel sortingTableModel = (SortingTableModel)this.getModel();
        Object object = null;
        int n3 = this.getSelectedRow();
        if (n3 >= 0) {
            object = sortingTableModel.getValueAt(n3, 0);
        }
        if (this.sortedColIndex == n && mouseEvent != null) {
            this.ascending = !this.ascending;
        }
        this.sortedColIndex = n;
        sortingTableModel.sortByColumn(n2, this.ascending);
        XMLCollection xMLCollection = (XMLCollection)this.owner.getOwner();
        for (int i = 0; i < sortingTableModel.getRowCount(); ++i) {
            XMLElement xMLElement = (XMLElement)sortingTableModel.getValueAt(i, 0);
            if (!xMLCollection.contains(xMLElement)) continue;
            xMLCollection.reposition(xMLElement, i);
        }
        if (object != null) {
            try {
                this.owner.setSelectedElement(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.update(this.getGraphics());
        this.getTableHeader().update(this.getTableHeader().getGraphics());
    }

    static class SHRenderer
    extends DefaultTableCellRenderer {
        static Icon NONSORTED = null;
        static Icon ASCENDING = null;
        static Icon DESCENDING = null;

        public SHRenderer() {
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            int n3 = -1;
            boolean bl3 = true;
            BasicSortingTable basicSortingTable = (BasicSortingTable)jTable;
            n3 = basicSortingTable.getSortedColumnIndex();
            bl3 = basicSortingTable.isSortedColumnAscending();
            if (jTable != null && (object2 = jTable.getTableHeader()) != null) {
                this.setForeground(((Component)object2).getForeground());
                this.setBackground(((Component)object2).getBackground());
                this.setFont(((Component)object2).getFont());
            }
            object2 = null;
            object2 = bl3 ? ASCENDING : DESCENDING;
            if (n2 == n3) {
                this.setIcon((Icon)object2);
            } else {
                this.setIcon(NONSORTED);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

