/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.recentfiles;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEConstants;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.recentfiles.RecentFilesManager;
import org.enhydra.jxpdl.XMLUtil;

public class RecentFilesMenu
extends JMenu
implements JaWEComponentView,
ActionListener {
    public static final String RFL_FILENAME = "/.rfl";
    protected RecentFilesManager controller;

    @Override
    public void configure() {
    }

    public RecentFilesMenu(RecentFilesManager recentFilesManager) {
        this.controller = recentFilesManager;
    }

    @Override
    public void init() {
        this.setText(this.controller.getSettings().getLanguageDependentString(this.controller.getName() + "Label"));
        String string = XMLUtil.fileToString((String)(JaWEConstants.JAWE_USER_HOME + RFL_FILENAME));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                this.addToRecentFiles(stringTokenizer.nextToken());
            }
        }
    }

    public void addToRecentFiles(String string) {
        JMenuItem jMenuItem;
        int n;
        if (string == null) {
            return;
        }
        for (n = 0; n < this.getItemCount(); ++n) {
            jMenuItem = (JMenuItem)this.getMenuComponent(n);
            if (!string.equals(jMenuItem.getText().substring(2))) continue;
            this.remove(n);
        }
        n = 10;
        if (this.getItemCount() == n) {
            this.remove(n - 1);
        }
        jMenuItem = new JMenuItem("1 " + string);
        jMenuItem.addActionListener(this);
        this.insert(jMenuItem, 0);
        for (int i = 0; i < this.getItemCount(); ++i) {
            jMenuItem = (JMenuItem)this.getMenuComponent(i);
            String string2 = jMenuItem.getText();
            String string3 = String.valueOf(i + 1);
            String string4 = string3.substring(string3.length() - 1, string3.length());
            jMenuItem.setText(string4 + " " + string2.substring(2));
            BarFactory.setMnemonic(jMenuItem, string4);
        }
    }

    public void saveRecentFiles() {
        try {
            String string = "";
            int n = this.getItemCount();
            while (n > 0) {
                JMenuItem jMenuItem = (JMenuItem)this.getMenuComponent(--n);
                string = string + jMenuItem.getText().substring(2);
                if (n <= 0) continue;
                string = string + "\n";
            }
            FileOutputStream fileOutputStream = new FileOutputStream(JaWEConstants.JAWE_USER_HOME + RFL_FILENAME);
            fileOutputStream.write(string.getBytes(JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding()));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand().substring(2);
        if (JaWEManager.getInstance().getJaWEController().tryToClosePackage(null, false)) {
            JaWEManager.getInstance().getJaWEController().openPackageFromFile(string);
        }
    }

    @Override
    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    @Override
    public JComponent getDisplay() {
        return this;
    }
}

