/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.xpdlvalidator;

import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jxpdl.ParsingErrors;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLValidationError;

public final class ValidationError {
    private XMLValidationError verr;

    public ValidationError(XMLValidationError xMLValidationError) {
        this.verr = xMLValidationError;
    }

    public String getType() {
        return this.verr.getType();
    }

    public String getSubType() {
        return this.verr.getSubType();
    }

    public String getId() {
        return this.verr.getId();
    }

    public String getDescription() {
        return this.verr.getDescription();
    }

    public XMLElement getElement() {
        return this.verr.getElement();
    }

    public String toString() {
        String string = "";
        XMLElement xMLElement = this.verr.getElement();
        if (xMLElement != null) {
            string = string + Utils.getLocString(Utils.getLocation(xMLElement), xMLElement) + ": ";
            string = string + ResourceManager.getLanguageDependentString("TypeKey") + "=" + ResourceManager.getLanguageDependentString(this.verr.getType() + "TypeKey");
            string = string + ", " + ResourceManager.getLanguageDependentString("SubTypeKey") + "=" + ResourceManager.getLanguageDependentString(this.verr.getSubType() + "TypeKey");
            String string2 = ResourceManager.getLanguageDependentString(this.verr.getId());
            if (string2 == null) {
                string2 = this.verr.getId();
            }
            string = string + ", " + string2;
            if (this.verr.getDescription() != null && this.verr.getDescription().length() > 0) {
                String string3 = this.verr.getDescription();
                if (this.verr.getSubType().equals("SCHEMA")) {
                    if (string3.indexOf(ParsingErrors.ERROR) == 0) {
                        String string4 = ResourceManager.getLanguageDependentString(ParsingErrors.ERROR + "Key") + " " + ResourceManager.getLanguageDependentString("AtLineNumberKey") + " ";
                        string3 = string4 + string3.substring(ParsingErrors.ERROR.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                    } else if (string3.indexOf(ParsingErrors.WARNING) == 0) {
                        String string5 = ResourceManager.getLanguageDependentString(ParsingErrors.WARNING + "Key") + " " + ResourceManager.getLanguageDependentString("AtLineNumberKey") + " ";
                        string3 = string5 + string3.substring(ParsingErrors.WARNING.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                    } else if (string3.indexOf(ParsingErrors.FATAL_ERROR) == 0) {
                        String string6 = ResourceManager.getLanguageDependentString(ParsingErrors.FATAL_ERROR + "Key") + " " + ResourceManager.getLanguageDependentString("AtLineNumberKey") + " ";
                        string3 = string6 + string3.substring(ParsingErrors.FATAL_ERROR.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                    }
                } else {
                    string = string + ": ";
                }
                string = string + string3;
            }
        }
        return string;
    }
}

