/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components;

import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.enhydra.jawe.CombinedIcon;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.xpdlvalidator.ValidationError;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;

public class XPDLTreeCellRenderer
extends DefaultTreeCellRenderer {
    protected JaWEComponent owner;
    protected Icon defaultImage;
    protected Icon warning;
    protected Icon error;
    protected Set errors = new HashSet();
    protected Set warnings = new HashSet();

    public XPDLTreeCellRenderer(JaWEComponent jaWEComponent) {
        this.owner = jaWEComponent;
        try {
            this.defaultImage = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/default.gif"));
            this.warning = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/warning_icon_small.gif"));
            this.error = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/error_icon_small.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        boolean bl5 = false;
        boolean bl6 = false;
        if (this.warnings.contains(object2)) {
            bl6 = true;
        }
        if (this.errors.contains(object2)) {
            bl5 = true;
        }
        Icon icon = null;
        JaWEType jaWEType = null;
        if (object2 instanceof XMLElement) {
            jaWEType = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)object2);
        }
        if (jaWEType != null) {
            icon = bl5 ? new CombinedIcon(this.getIcon((XMLElement)object2, jaWEType), this.error) : (bl6 ? new CombinedIcon(this.getIcon((XMLElement)object2, jaWEType), this.warning) : this.getIcon((XMLElement)object2, jaWEType));
        }
        if (icon == null) {
            icon = bl5 ? new CombinedIcon(this.defaultImage, this.error) : (bl6 ? new CombinedIcon(this.defaultImage, this.warning) : this.defaultImage);
        }
        this.setIcon(icon);
        return this;
    }

    public void setValidationErrors(List list) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        HashSet<XMLElement> hashSet2 = new HashSet<XMLElement>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ValidationError validationError = (ValidationError)list.get(i);
                if (validationError.getType().equals("ERROR")) {
                    hashSet.add(validationError.getElement());
                    continue;
                }
                hashSet2.add(validationError.getElement());
            }
        }
        this.errors = new HashSet(hashSet);
        this.warnings = new HashSet(hashSet2);
        for (XMLElement xMLElement : hashSet) {
            this.errors.addAll(XMLUtil.getAllParents((XMLElement)xMLElement));
        }
        for (XMLElement xMLElement : hashSet2) {
            this.warnings.addAll(XMLUtil.getAllParents((XMLElement)xMLElement));
        }
    }

    public void setErrors(Set set) {
        this.errors = set;
    }

    public Set getErrors() {
        return this.errors;
    }

    public void setWarnings(Set set) {
        this.warnings = set;
    }

    public Set getWarnings() {
        return this.warnings;
    }

    public ImageIcon getIcon(XMLElement xMLElement, JaWEType jaWEType) {
        if (xMLElement instanceof Activity) {
            String string = ((Activity)xMLElement).getIcon();
            ImageIcon imageIcon = null;
            if (!string.equals("")) {
                imageIcon = (ImageIcon)Utils.getOriginalActivityIconsMap().get((Object)string);
            }
            if (imageIcon == null) {
                imageIcon = jaWEType.getIcon();
            }
            return imageIcon;
        }
        return jaWEType.getIcon();
    }
}

