/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.DataTypes;
import org.enhydra.jxpdl.elements.Package;

public class XPDLTreeModel
extends DefaultTreeModel {
    protected JaWEComponent comp;

    public XPDLTreeModel(JaWEComponent jaWEComponent) {
        super(new XPDLTreeNode(), true);
        this.comp = jaWEComponent;
    }

    public XPDLTreeNode getRootNode() {
        return (XPDLTreeNode)super.getRoot();
    }

    public void clearTree() {
        this.getRootNode().removeAllChildren();
    }

    public XPDLTreeNode insertNode(XMLElement xMLElement) {
        XPDLTreeNode xPDLTreeNode = null;
        if (xMLElement instanceof Package) {
            xPDLTreeNode = this.findNode(this.getRootNode(), xMLElement);
            if (xPDLTreeNode == null) {
                xPDLTreeNode = this.insertNode(this.getRootNode(), xMLElement);
            }
        } else {
            XPDLTreeNode xPDLTreeNode2 = this.findNode(xMLElement.getParent());
            if (xPDLTreeNode2 != null) {
                Set set;
                if (xPDLTreeNode2.getXPDLElement() instanceof XMLCollection && (set = this.getHiddenElements((XMLCollection)xPDLTreeNode2.getXPDLElement())).contains(xMLElement)) {
                    return null;
                }
                xPDLTreeNode = this.findNode(xPDLTreeNode2, xMLElement);
                xPDLTreeNode = xPDLTreeNode == null ? this.insertNode(xPDLTreeNode2, xMLElement) : null;
            }
        }
        return xPDLTreeNode;
    }

    protected XPDLTreeNode insertNode(XPDLTreeNode xPDLTreeNode, XMLElement xMLElement) {
        XPDLTreeNode xPDLTreeNode2;
        block4: {
            block3: {
                xPDLTreeNode2 = this.createNode(xMLElement);
                this.insertNodeInto(xPDLTreeNode2, xPDLTreeNode, xPDLTreeNode.getChildCount());
                if (!(xMLElement instanceof XMLBaseForCollectionAndComplex)) break block3;
                XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex = (XMLBaseForCollectionAndComplex)xMLElement;
                Set set = null;
                set = xMLBaseForCollectionAndComplex instanceof XMLComplexElement ? this.getHiddenElements((XMLComplexElement)xMLBaseForCollectionAndComplex) : this.getHiddenElements((XMLCollection)xMLBaseForCollectionAndComplex);
                if (set.size() == 1 && set.contains("*")) {
                    return xPDLTreeNode2;
                }
                for (XMLElement xMLElement2 : xMLBaseForCollectionAndComplex.toElements()) {
                    if (set.contains(xMLElement2)) continue;
                    this.insertNode(xPDLTreeNode2, xMLElement2);
                }
                break block4;
            }
            if (!(xMLElement instanceof XMLComplexChoice) || xMLElement instanceof DataTypes) break block4;
            XMLComplexChoice xMLComplexChoice = (XMLComplexChoice)xMLElement;
            for (XMLElement xMLElement3 : xMLComplexChoice.getChoices()) {
                this.insertNode(xPDLTreeNode2, xMLElement3);
            }
        }
        return xPDLTreeNode2;
    }

    public XPDLTreeNode removeNode(XMLElement xMLElement) {
        XPDLTreeNode xPDLTreeNode = this.findNode(xMLElement);
        if (xPDLTreeNode != null) {
            this.removeNodeFromParent(xPDLTreeNode);
        }
        return xPDLTreeNode;
    }

    public void repositionNode(XMLElement xMLElement, int n) {
        XPDLTreeNode xPDLTreeNode = this.findNode(xMLElement);
        if (xPDLTreeNode != null) {
            XPDLTreeNode xPDLTreeNode2 = (XPDLTreeNode)xPDLTreeNode.getParent();
            if (xPDLTreeNode2.getChildCount() < n + 1) {
                return;
            }
            this.removeNodeFromParent(xPDLTreeNode);
            this.insertNodeInto(xPDLTreeNode, xPDLTreeNode2, n);
        }
    }

    public XPDLTreeNode findNode(XMLElement xMLElement) {
        XPDLTreeNode xPDLTreeNode = this.getRootNode();
        XPDLTreeNode xPDLTreeNode2 = this.findNode(xPDLTreeNode, xMLElement);
        return xPDLTreeNode2;
    }

    protected XPDLTreeNode findNode(XPDLTreeNode xPDLTreeNode, XMLElement xMLElement) {
        if (xPDLTreeNode.getUserObject() == xMLElement) {
            return xPDLTreeNode;
        }
        Enumeration<TreeNode> enumeration = xPDLTreeNode.children();
        while (enumeration.hasMoreElements()) {
            XPDLTreeNode xPDLTreeNode2 = (XPDLTreeNode)enumeration.nextElement();
            XPDLTreeNode xPDLTreeNode3 = this.findNode(xPDLTreeNode2, xMLElement);
            if (xPDLTreeNode3 == null) continue;
            return xPDLTreeNode3;
        }
        return null;
    }

    protected XPDLTreeNode createNode(XMLElement xMLElement) {
        return new XPDLTreeNode(xMLElement);
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((TreeNode)object).isLeaf();
    }

    protected Set getHiddenElements(XMLComplexElement xMLComplexElement) {
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = (String)this.comp.getSettings().getSetting("HideSubElements." + xMLComplexElement.toName());
        String[] stringArray = XMLUtil.tokenize((String)string, (String)" ");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Package package_;
                XMLElement xMLElement = xMLComplexElement.get(stringArray[i]);
                if (xMLElement != null) {
                    hashSet.add(xMLElement);
                    continue;
                }
                if (!(xMLComplexElement instanceof Package) || !stringArray[i].equals((package_ = (Package)xMLComplexElement).getNamespaces().toName())) continue;
                hashSet.add(package_.getNamespaces());
            }
        }
        return hashSet;
    }

    protected Set getHiddenElements(XMLCollection xMLCollection) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        String string = (String)this.comp.getSettings().getSetting("HideElements." + xMLCollection.toName());
        String[] stringArray = XMLUtil.tokenize((String)string, (String)" ");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = (String)this.comp.getSettings().getSetting("HideElements." + xMLCollection.toName() + "." + string2);
            String[] stringArray2 = XMLUtil.tokenize((String)string3, (String)" ");
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals("*")) {
                    hashSet.addAll(xMLCollection.toElements());
                    return hashSet;
                }
                for (XMLElement xMLElement : xMLCollection.toElements()) {
                    XMLElement xMLElement2;
                    if (string2.equals("")) {
                        if (!xMLElement.toValue().equals(stringArray2[j])) continue;
                        hashSet.add(xMLElement);
                        continue;
                    }
                    if (!(xMLElement instanceof XMLComplexElement) || (xMLElement2 = ((XMLComplexElement)xMLElement).get(string2)) == null || !xMLElement2.toValue().equals(stringArray2[j])) continue;
                    hashSet.add(xMLElement);
                }
            }
        }
        return hashSet;
    }
}

