/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphActivityRendererInterface;
import org.enhydra.jawe.components.graph.GraphActivityViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.graph.VertexView;

public class DefaultGraphEventActivityRenderer
extends VertexRenderer
implements GraphActivityRendererInterface {
    public void paint(Graphics graphics) {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        int n = 1;
        if (activity.getActivityType() == 7) {
            n = 3;
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = ((GraphActivityViewInterface)this.view).getOriginalBounds();
        Graphics graphics2 = graphics.create((int)(rectangle2.getX() - rectangle.getX()), (int)(rectangle2.getY() - rectangle.getY()), (int)rectangle2.getWidth(), (int)rectangle2.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics2;
        Color color = this.getFillColor();
        this.bordercolor = this.getBorderColor();
        if (this.selected) {
            color = GraphUtilities.getGraphController().getGraphSettings().getSelectedActivityColor();
        }
        this.setText(null);
        Object object = RenderingHints.VALUE_ANTIALIAS_ON;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        Dimension dimension = rectangle2.getSize();
        if (super.isOpaque()) {
            int n2 = color.getRed();
            int n3 = color.getGreen();
            int n4 = color.getBlue();
            Color color2 = new Color(n2, n3, n4, 255);
            Color color3 = new Color(n2, n3, n4, 0);
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color2, dimension.width - 1, dimension.height - 1, color3);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillOval(1, 1, dimension.width - 2, dimension.height - 2);
        }
        graphics2D.setColor(this.bordercolor);
        DefaultGraphEventActivityRenderer.drawOwal(graphics2D, dimension.width, dimension.height, n);
        String string = activity.getName();
        if (!string.trim().equals("")) {
            this.paintLabel(graphics, string, dimension.height);
        }
    }

    public Color getBorderColor() {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getBorderColor());
        }
        if (color == null) {
            color = Color.BLACK;
        }
        return color;
    }

    public Color getFillColor() {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)this.view.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        Color color = null;
        if (nodeGraphicsInfo != null) {
            color = Utils.getColor(nodeGraphicsInfo.getFillColor());
        }
        if (color == null) {
            color = GraphUtilities.getGraphController().getGraphSettings().getStartEventColor();
            if (activity.getActivityType() == 7) {
                color = GraphUtilities.getGraphController().getGraphSettings().getEndEventColor();
            }
        }
        return color;
    }

    protected void paintLabel(Graphics graphics, String string, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics.setFont(this.getFont());
        if (string != null && string.length() > 0) {
            Dimension dimension = this.getLabelDimension((GraphActivityViewInterface)this.view);
            int n2 = (int)graphics.getClipBounds().getWidth();
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = fontMetrics.getHeight();
            graphics.setFont(font);
            graphics.setColor(this.getBackground());
            graphics.setColor(Color.BLACK);
            graphics.drawString(string, dimension.width < n2 ? (n2 - dimension.width) / 2 : 0, n + n3 - 3);
        }
    }

    @Override
    public Dimension getLabelDimension(GraphActivityViewInterface graphActivityViewInterface) {
        GraphActivityInterface graphActivityInterface = (GraphActivityInterface)graphActivityViewInterface.getCell();
        Activity activity = (Activity)graphActivityInterface.getUserObject();
        if (!(activity.getActivityType() != 0 && activity.getActivityType() != 7 && activity.getActivityType() != 6 || activity.getName().trim().equals(""))) {
            String string = activity.getName();
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            return new Dimension(n, n2);
        }
        return new Dimension(0, 0);
    }

    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D) {
        double d;
        double d2;
        double d3;
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY();
        double d6 = (rectangle2D.getWidth() + 1.0) / 2.0;
        double d7 = (rectangle2D.getHeight() + 1.0) / 2.0;
        double d8 = d4 + d6;
        double d9 = d5 + d7;
        double d10 = point2D.getX();
        double d11 = point2D.getY();
        double d12 = d10 - d8;
        double d13 = d11 - d9;
        if (d12 == 0.0) {
            return new Point((int)d8, (int)(d9 + d7 * d13 / Math.abs(d13)));
        }
        double d14 = d13 / d12;
        double d15 = d9 - d14 * d8;
        double d16 = d6 * d6 * d14 * d14 + d7 * d7;
        double d17 = -2.0 * d8 * d16;
        double d18 = d6 * d6 * d14 * d14 * d8 * d8 + d7 * d7 * d8 * d8 - d6 * d6 * d7 * d7;
        double d19 = Math.sqrt(d17 * d17 - 4.0 * d16 * d18);
        double d20 = (-d17 + d19) / (2.0 * d16);
        double d21 = (-d17 - d19) / (2.0 * d16);
        double d22 = d14 * d20 + d15;
        double d23 = d14 * d21 + d15;
        double d24 = Math.sqrt(Math.pow(d20 - d10, 2.0) + Math.pow(d22 - d11, 2.0));
        if (d24 < (d3 = Math.sqrt(Math.pow(d21 - d10, 2.0) + Math.pow(d23 - d11, 2.0)))) {
            d2 = d20;
            d = d22;
        } else {
            d2 = d21;
            d = d23;
        }
        return new Point2D.Double(d2, d);
    }

    protected static void drawOwal(Graphics graphics, int n, int n2, int n3) {
        int n4 = n / 2;
        int n5 = n2 / 2;
        int n6 = n / 2;
        int n7 = n2 / 2;
        --n6;
        --n7;
        for (int i = 0; i < n3; ++i) {
            graphics.drawOval(n4 - (n6 - i), n5 - (n7 - i), 2 * (n6 - i), 2 * (n7 - i));
        }
    }
}

