/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphPortRendererInterface;
import org.enhydra.jawe.components.graph.GraphPortViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;

public class DefaultGraphPortView
extends GraphPortViewInterface {
    protected static Map renderers = new HashMap();

    public DefaultGraphPortView(Object object) {
        super(object);
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setSize((Map)attributeMap, (Dimension)new Dimension(30, 30));
        super.setAttributes(attributeMap);
    }

    @Override
    public void setPortSize(Dimension dimension) {
        if (SIZE < 2) {
            SIZE = 2;
        }
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setSize((Map)attributeMap, (Dimension)dimension);
        super.setAttributes(attributeMap);
    }

    @Override
    public Dimension getPortsSize() {
        return (Dimension)this.getAttributes().get((Object)"size");
    }

    @Override
    public GraphCommonInterface getGraphActivityOrArtifact() {
        return (GraphCommonInterface)this.getParentView().getCell();
    }

    public CellViewRenderer getRenderer() {
        String string = ((GraphPortInterface)((Object)super.getCell())).getType();
        GraphPortRendererInterface graphPortRendererInterface = (GraphPortRendererInterface)renderers.get(string);
        if (graphPortRendererInterface == null) {
            graphPortRendererInterface = this.createRenderer(string);
            renderers.put(string, graphPortRendererInterface);
        }
        return graphPortRendererInterface;
    }

    public Rectangle2D getBounds() {
        AttributeMap attributeMap = new AttributeMap();
        Rectangle2D rectangle2D = attributeMap.createRect(this.getLocation());
        rectangle2D.setFrame(rectangle2D.getX() - (double)(this.getPortsSize().width / 2), rectangle2D.getY() - (double)(this.getPortsSize().height / 2), rectangle2D.getWidth() + (double)this.getPortsSize().width, rectangle2D.getHeight() + (double)this.getPortsSize().height);
        return rectangle2D;
    }

    protected GraphPortRendererInterface createRenderer(String string) {
        return GraphUtilities.getGraphController().getGraphObjectRendererFactory().createPortRenderer(string);
    }
}

