/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphMarqueeHandler;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphPortViewInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphTransitionRendererInterface;
import org.enhydra.jawe.components.graph.GraphTransitionViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfo;
import org.enhydra.jxpdl.elements.Transition;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;

public class DefaultGraphTransitionView
extends GraphTransitionViewInterface {
    protected static Map renderers = new HashMap();

    public DefaultGraphTransitionView(Object object) {
        super(object);
        int n = 500;
        int n2 = 10;
        Point point = new Point(n, n2);
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setLabelPosition((Map)attributeMap, (Point2D)point);
        GraphConstants.setAutoSize((Map)attributeMap, (boolean)true);
        this.setAttributes(attributeMap);
    }

    public CellViewRenderer getRenderer() {
        String string = ((GraphTransitionInterface)super.getCell()).getType();
        GraphTransitionRendererInterface graphTransitionRendererInterface = (GraphTransitionRendererInterface)renderers.get(string);
        if (graphTransitionRendererInterface == null) {
            graphTransitionRendererInterface = this.createRenderer((XMLCollectionElement)((GraphTransitionInterface)super.getCell()).getUserObject());
            renderers.put(string, graphTransitionRendererInterface);
        }
        return graphTransitionRendererInterface;
    }

    public void mergeAttributes() {
        super.mergeAttributes();
    }

    public CellHandle getHandle(GraphContext graphContext) {
        return new TransitionHandle(this, graphContext);
    }

    @Override
    public void addPoint(Graph graph, Point point) {
        boolean bl;
        boolean bl2 = bl = graph.isBendable() && GraphConstants.isBendable((Map)this.getAttributes());
        if (bl) {
            int n = -1;
            int n2 = graph.getHandleSize();
            Rectangle rectangle = new Rectangle(point.x - n2, point.y - n2, 2 * n2, 2 * n2);
            if (this.intersects(graph, rectangle)) {
                Point point2;
                Point point3 = new Point(point);
                double d = Double.MAX_VALUE;
                double d2 = 0.0;
                for (int i = 0; i < this.getPointCount() - 1; ++i) {
                    Point point4;
                    point2 = new Point((int)this.getPoint(i).getX(), (int)this.getPoint(i).getY());
                    d2 = new Line2D.Double(point2, point4 = new Point((int)this.getPoint(i + 1).getX(), (int)this.getPoint(i + 1).getY())).ptLineDistSq(point3);
                    if (!(d2 < d)) continue;
                    d = d2;
                    n = i + 1;
                }
                if (n != -1) {
                    this.addPoint(n, point3);
                    HashMap<Object, Point> hashMap = new HashMap<Object, Point>();
                    point2 = new AttributeMap((Map)((GraphCell)this.cell).getAttributes());
                    GraphConstants.setPoints((Map)((Object)point2), (List)this.points);
                    hashMap.put(this.cell, point2);
                    ((JaWEGraphModel)graph.getModel()).insertAndEdit(null, hashMap, null, null, null);
                }
            }
        }
    }

    @Override
    public void removePoint(Graph graph, Point point) {
        boolean bl;
        boolean bl2 = bl = graph.isBendable() && GraphConstants.isBendable((Map)this.getAttributes());
        if (bl) {
            int n = -1;
            int n2 = graph.getHandleSize();
            Rectangle rectangle = new Rectangle(point.x - n2, point.y - n2, 2 * n2, 2 * n2);
            if (this.intersects(graph, rectangle)) {
                Point point2;
                Point point3 = new Point(point);
                double d = Double.MAX_VALUE;
                double d2 = 0.0;
                for (int i = 0; i < this.getPointCount(); ++i) {
                    point2 = new Point((int)this.getPoint(i).getX(), (int)this.getPoint(i).getY());
                    d2 = Math.sqrt(point3.distanceSq(point2));
                    if (!(d2 < d)) continue;
                    d = d2;
                    n = i;
                }
                if (n != -1 && d <= (double)(n2 + 2) && n != 0 && n != this.getPointCount() - 1) {
                    this.removePoint(n);
                    HashMap<Object, Point> hashMap = new HashMap<Object, Point>();
                    point2 = new AttributeMap((Map)((GraphCell)this.cell).getAttributes());
                    GraphConstants.setPoints((Map)((Object)point2), (List)this.points);
                    hashMap.put(this.cell, point2);
                    ((JaWEGraphModel)graph.getModel()).insertAndEdit(null, hashMap, null, null, null);
                }
            }
        }
    }

    protected GraphTransitionRendererInterface createRenderer(XMLCollectionElement xMLCollectionElement) {
        return GraphUtilities.getGraphController().getGraphObjectRendererFactory().createTransitionRenderer(xMLCollectionElement);
    }

    public static class TransitionHandle
    extends EdgeView.EdgeHandle {
        public TransitionHandle(EdgeView edgeView, GraphContext graphContext) {
            super(edgeView, graphContext);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                if (this.source || this.target) {
                    GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)this.edge.getCell();
                    GraphPortViewInterface graphPortViewInterface = (GraphPortViewInterface)this.edge.getSource();
                    GraphPortViewInterface graphPortViewInterface2 = (GraphPortViewInterface)this.edge.getTarget();
                    GraphCommonInterface graphCommonInterface = graphTransitionInterface.getSourceActivityOrArtifact();
                    GraphCommonInterface graphCommonInterface2 = graphTransitionInterface.getTargetActivityOrArtifact();
                    GraphCommonInterface graphCommonInterface3 = null;
                    try {
                        graphCommonInterface3 = (GraphCommonInterface)((Object)((GraphPortInterface)((Object)graphPortViewInterface.getCell())).getParent());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GraphCommonInterface graphCommonInterface4 = null;
                    try {
                        graphCommonInterface4 = (GraphCommonInterface)((Object)((GraphPortInterface)((Object)graphPortViewInterface2.getCell())).getParent());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (graphCommonInterface != graphCommonInterface3 || graphCommonInterface2 != graphCommonInterface4) {
                        ConnectorGraphicsInfo connectorGraphicsInfo;
                        XMLCollectionElement xMLCollectionElement;
                        GraphMarqueeHandler graphMarqueeHandler = (GraphMarqueeHandler)this.graph.getMarqueeHandler();
                        boolean bl = graphMarqueeHandler.validateConnection(graphPortViewInterface, graphPortViewInterface2, xMLCollectionElement = (XMLCollectionElement)graphTransitionInterface.getPropertyObject());
                        if (!bl) {
                            this.clean(graphTransitionInterface);
                            return;
                        }
                        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
                        ((Graph)this.graph).getGraphController().setUpdateInProgress(true);
                        jaWEController.startUndouableChange();
                        this.setChanges();
                        String string = ((XMLCollectionElement)graphCommonInterface3.getPropertyObject()).getId();
                        String string2 = ((XMLCollectionElement)graphCommonInterface4.getPropertyObject()).getId();
                        if (xMLCollectionElement instanceof Transition) {
                            ((Transition)xMLCollectionElement).setFrom(string);
                            ((Transition)xMLCollectionElement).setTo(string2);
                        } else {
                            ((Association)xMLCollectionElement).setSource(string);
                            ((Association)xMLCollectionElement).setTarget(string2);
                        }
                        if (string.equals(string2) && (connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement)) == null) {
                            int n;
                            GraphManager graphManager = ((Graph)this.graph).getGraphManager();
                            GraphActivityInterface graphActivityInterface = graphManager.getGraphActivity(string);
                            Point point = new Point(50, 50);
                            if (graphActivityInterface != null) {
                                point = graphManager.getCenter(graphActivityInterface);
                            }
                            ArrayList<Point> arrayList = new ArrayList<Point>();
                            int n2 = point.x - 50;
                            int n3 = point.x + 50;
                            if (n2 < 0) {
                                n3 -= n2;
                                n2 = 0;
                            }
                            if ((n = point.y - 50) < 0) {
                                n = point.y + 50;
                            }
                            Point point2 = new Point(Math.abs(n2), Math.abs(n));
                            Point point3 = new Point(Math.abs(n3), Math.abs(n));
                            arrayList.add(point2);
                            arrayList.add(point3);
                            GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, arrayList, true);
                            HashMap<Object, AttributeMap> hashMap = new HashMap<Object, AttributeMap>();
                            AttributeMap attributeMap = new AttributeMap((Map)this.edge.getAttributes());
                            hashMap.put(this.edge.getCell(), attributeMap);
                            Point2D point2D = this.edge.getPoint(0);
                            Point2D point2D2 = this.edge.getPoint(1);
                            ArrayList<Point2D> arrayList2 = new ArrayList<Point2D>();
                            arrayList2.add(point2D);
                            arrayList2.addAll(arrayList);
                            arrayList2.add(point2D2);
                            GraphConstants.setPoints((Map)attributeMap, arrayList2);
                            ((JaWEGraphModel)this.graph.getModel()).insertAndEdit(null, hashMap, null, null, null);
                        }
                        connectorGraphicsInfo = new ArrayList();
                        connectorGraphicsInfo.add(xMLCollectionElement);
                        jaWEController.endUndouableChange((List)connectorGraphicsInfo);
                        this.graph.refresh();
                        ((Graph)this.graph).getGraphController().setUpdateInProgress(false);
                        return;
                    }
                }
                this.setChanges();
            }
            finally {
                mouseEvent.consume();
            }
        }

        protected void setChanges() {
            Object object;
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            boolean bl = jaWEController.isUndoableChangeInProgress();
            if (!bl) {
                ((Graph)this.graph).getGraphController().setUpdateInProgress(true);
                jaWEController.startUndouableChange();
            }
            if (this.edgeModified) {
                int n = this.edge.getPointCount();
                object = new ArrayList<Point>();
                for (int i = 1; i < n - 1; ++i) {
                    object.add(new Point((int)this.edge.getPoint(i).getX(), (int)this.edge.getPoint(i).getY()));
                }
                GraphUtilities.setBreakpoints((XMLCollectionElement)((GraphTransitionInterface)this.edge.getCell()).getPropertyObject(), (List)object);
            }
            ConnectionSet connectionSet = this.createConnectionSet(this.edge, false);
            object = GraphConstants.createAttributes((Object[])new CellView[]{this.edge}, null);
            this.graph.getGraphLayoutCache().edit((Map)object, connectionSet, null, null);
            if (!bl) {
                GraphTransitionInterface graphTransitionInterface = (GraphTransitionInterface)this.edge.getCell();
                ArrayList<XMLComplexElement> arrayList = new ArrayList<XMLComplexElement>();
                arrayList.add(graphTransitionInterface.getPropertyObject());
                jaWEController.endUndouableChange(arrayList);
                ((Graph)this.graph).getGraphController().setUpdateInProgress(false);
            }
        }

        protected void clean(GraphTransitionInterface graphTransitionInterface) {
            Graphics graphics = this.graph.getGraphics();
            this.overlay(graphics);
            this.firstOverlayCall = true;
            this.graph.removeSelectionCell((Object)graphTransitionInterface);
        }
    }
}

