/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLGroupPanel;
import org.enhydra.jawe.base.panel.panels.XMLMultiLineTextPanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jawe.base.panel.panels.XMLTextPanel;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class ExpressionLaneEditor {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    protected JDialog dialog;
    protected Properties properties = new Properties();
    protected Lane elementToEdit;
    protected XMLPanel panelToEdit = new XMLBasicPanel();
    protected JButton buttonOK;
    protected JButton buttonCancel;
    protected String title = null;
    protected XMLPanel pIdPanel;
    protected int status = 0;
    protected WindowListener wl = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            ExpressionLaneEditor.this.status = 1;
            ExpressionLaneEditor.this.dialog.dispose();
        }
    };
    protected ActionListener cl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExpressionLaneEditor.this.status = 1;
            ExpressionLaneEditor.this.dialog.dispose();
        }
    };
    protected ActionListener okl = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ExpressionLaneEditor.this.elementToEdit == null || ExpressionLaneEditor.this.panelToEdit.getOwner().isReadOnly()) {
                ExpressionLaneEditor.this.status = 1;
                ExpressionLaneEditor.this.dialog.dispose();
            } else if (ExpressionLaneEditor.this.canApplyChanges()) {
                ExpressionLaneEditor.this.applyChanges();
                ExpressionLaneEditor.this.status = 0;
                ExpressionLaneEditor.this.dialog.dispose();
                if (ExpressionLaneEditor.this.dialog.getParent() != null) {
                    ExpressionLaneEditor.this.dialog.getParent().repaint();
                }
            }
        }
    };

    public void configure(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(String string, String string2) {
        this.properties.setProperty(string, string2);
    }

    public ExpressionLaneEditor(Lane lane) {
        this.elementToEdit = lane;
        this.dialog = new JDialog((Frame)JaWEManager.getInstance().getJaWEController().getJaWEFrame(), true);
        this.title = ResourceManager.getLanguageDependentString(lane.toName() + "Key");
        this.initDialog();
    }

    public void setTitle(String string) {
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public void editXPDLElement() {
        this.editXPDLElement(this.getLanePanel());
    }

    public void editXPDLElement(XMLPanel xMLPanel) {
        Container container = this.dialog.getContentPane();
        container.remove(this.panelToEdit);
        this.panelToEdit = xMLPanel;
        container.add((Component)this.panelToEdit, 0);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.getParentWindow());
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public boolean canApplyChanges() {
        return this.panelToEdit.validateEntry();
    }

    public void applyChanges() {
        GraphController graphController = GraphUtilities.getGraphController();
        WorkflowProcess workflowProcess = JaWEManager.getInstance().getXPDLUtils().getProcessForPool(XMLUtil.getPool((XMLElement)this.elementToEdit));
        String string = GraphUtilities.getLanesFirstPerformer(this.elementToEdit);
        String string2 = null;
        if (string != null) {
            string2 = ((XMLMultiLineTextPanel)this.pIdPanel).getText();
            if (!string2.equals(string)) {
                ActivitySet activitySet;
                int n;
                List list = workflowProcess.getActivities().toElements();
                ArrayList arrayList = workflowProcess.getActivitySets().toElements();
                for (n = 0; n < arrayList.size(); ++n) {
                    activitySet = (ActivitySet)arrayList.get(n);
                    list.addAll(activitySet.getActivities().toElements());
                }
                graphController.setUpdateInProgress(true);
                JaWEManager.getInstance().getJaWEController().startUndouableChange();
                GraphUtilities.setLanesFirstPerformer(this.elementToEdit, string2);
                this.elementToEdit.setName(string2);
                list = GraphUtilities.getAllActivitiesAndArtifactsForLaneId(list, this.elementToEdit.getId());
                for (n = 0; n < list.size(); ++n) {
                    activitySet = (Activity)list.get(n);
                    int n2 = activitySet.getActivityType();
                    if (n2 != 1 && n2 != 2) continue;
                    activitySet.setFirstPerformer(string2);
                }
                ArrayList arrayList2 = new ArrayList();
                JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList2);
                graphController.getGraph((XMLCollectionElement)workflowProcess).refresh();
                graphController.setUpdateInProgress(false);
            }
        } else {
            string2 = ((XMLTextPanel)this.pIdPanel).getText();
            JaWEManager.getInstance().getJaWEController().startUndouableChange();
            this.elementToEdit.setName(string2);
            ArrayList<Lane> arrayList = new ArrayList<Lane>();
            arrayList.add(this.elementToEdit);
            JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
            graphController.getGraph((XMLCollectionElement)workflowProcess).refresh();
        }
    }

    public void requestFocus() {
    }

    public int getStatus() {
        return this.status;
    }

    public Window getWindow() {
        return this.dialog;
    }

    public Window getParentWindow() {
        return JaWEManager.getInstance().getJaWEController().getJaWEFrame();
    }

    protected void initDialog() {
        try {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setAlignmentX(0.0f);
            jPanel.setAlignmentY(0.0f);
            this.buttonOK = new JButton(ResourceManager.getLanguageDependentString("OKKey"));
            this.buttonCancel = new JButton(ResourceManager.getLanguageDependentString("CancelKey"));
            jPanel.add(Box.createHorizontalGlue());
            jPanel.add(this.buttonOK);
            jPanel.add(Box.createHorizontalStrut(4));
            jPanel.add(this.buttonCancel);
            jPanel.add(Box.createHorizontalStrut(4));
            Container container = this.dialog.getContentPane();
            container.setLayout(new BoxLayout(container, 1));
            container.add(this.panelToEdit);
            container.add(Box.createVerticalStrut(5));
            container.add(jPanel);
            this.buttonOK.addActionListener(this.okl);
            this.buttonCancel.addActionListener(this.cl);
            this.dialog.addWindowListener(this.wl);
            this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "Cancel");
            this.dialog.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExpressionLaneEditor.this.cl.actionPerformed(actionEvent);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setResizable(true);
        this.buttonOK.setDefaultCapable(true);
        this.dialog.getRootPane().setDefaultButton(this.buttonOK);
        this.dialog.setTitle(this.title);
    }

    protected XMLGroupPanel getLanePanel() {
        ArrayList<XMLPanel> arrayList = new ArrayList<XMLPanel>();
        if (this.elementToEdit instanceof Lane) {
            this.pIdPanel = this.elementToEdit.getPerformers().size() > 0 ? new XMLMultiLineTextPanel(null, this.elementToEdit.getPerformers().get(0), "Expression", false, true, XMLMultiLineTextPanel.SIZE_MEDIUM, false, !this.elementToEdit.isReadOnly()) : new XMLTextPanel(null, this.elementToEdit.get("Name"), false, false, !this.elementToEdit.isReadOnly());
            arrayList.add(this.pIdPanel);
        }
        XMLGroupPanel xMLGroupPanel = new XMLGroupPanel(null, (XMLElement)this.elementToEdit, arrayList, "", true, false, true);
        return xMLGroupPanel;
    }
}

