/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.enhydra.jawe.BarFactory;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.controller.JaWEFrame;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphCommonInterface;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphPortViewInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jawe.components.graph.JaWEGraphUI;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

public class GraphMarqueeHandler
extends BasicMarqueeHandler {
    protected Point start;
    protected Point current;
    protected GraphPortViewInterface port;
    protected GraphPortViewInterface firstPort;
    protected GraphPortViewInterface lastPort;
    protected Vector points = new Vector();
    protected Point popupPoint;
    protected GraphController graphController;
    protected String mainType = "SELECT";
    protected String subType = "SELECT_DEFAULT";

    public GraphMarqueeHandler(GraphController graphController) {
        this.graphController = graphController;
    }

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        boolean bl = this.isSelectButtonSelected();
        return bl && SwingUtilities.isRightMouseButton(mouseEvent) || !bl || super.isForceMarqueeEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startPoint = mouseEvent.getPoint();
        this.marqueeBounds = new Rectangle2D.Double(this.startPoint.getX(), this.startPoint.getY(), 0.0, 0.0);
        if (mouseEvent != null && !(mouseEvent.getSource() instanceof JGraph)) {
            throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && this.marqueeBounds != null) {
                Rectangle2D rectangle2D = this.getGraph().fromScreen(this.marqueeBounds);
                CellView[] cellViewArray = this.getGraph().getGraphLayoutCache().getRoots(rectangle2D);
                CellView[] cellViewArray2 = AbstractCellView.getDescendantViews((CellView[])cellViewArray);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (int i = 0; i < cellViewArray2.length; ++i) {
                    if (!rectangle2D.contains(cellViewArray2[i].getBounds())) continue;
                    if (cellViewArray2[i].getCell() instanceof DefaultGraphCell && !(((DefaultGraphCell)cellViewArray2[i].getCell()).getUserObject() instanceof Participant)) {
                        arrayList3.add(cellViewArray2[i].getCell());
                    } else {
                        arrayList2.add(cellViewArray2[i].getCell());
                    }
                    arrayList.add(cellViewArray2[i].getCell());
                }
                Object[] objectArray = arrayList.toArray();
                this.getGraph().getUI().selectCellsForEvent((JGraph)this.getGraph(), objectArray, mouseEvent);
                Rectangle rectangle = this.marqueeBounds.getBounds();
                ++rectangle.width;
                ++rectangle.height;
                this.getGraph().repaint(rectangle);
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
        }
    }

    protected JPopupMenu createPopupMenu(Object object) {
        int n;
        Object object2;
        JComponent jComponent;
        Object object3;
        boolean bl = object instanceof WorkflowElement;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (bl) {
            object3 = (XMLElement)((DefaultGraphCell)object).getUserObject();
            if (object instanceof GraphActivityInterface) {
                string = "ACTIVITY";
                string2 = Utils.getActivityStringType(((Activity)object3).getActivityType());
                string3 = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)object3).getTypeId();
            }
            if (object instanceof GraphArtifactInterface) {
                string = "ARTIFACT";
                string2 = Utils.getArtifactStringType(((Artifact)object3).getArtifactType());
                string3 = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)object3).getTypeId();
            }
            if (object instanceof GraphSwimlaneInterface) {
                string = "LANE";
            }
            if (object instanceof GraphTransitionInterface) {
                string = "TRANSITION";
                string2 = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)object3).getTypeId();
            }
        } else {
            string = "SELECT";
        }
        object3 = BarFactory.createPopupMenu(string, this.graphController);
        if (string2 != null) {
            jComponent = BarFactory.createPopupMenu(string2, this.graphController);
            object2 = jComponent.getComponents();
            if (((Component[])object2).length != 0) {
                ((JPopupMenu)object3).addSeparator();
            }
            for (n = 0; n < ((Component[])object2).length; ++n) {
                ((Container)object3).add(object2[n]);
            }
        }
        if (string2 != null && string3 != null && !string2.equals(string3)) {
            jComponent = BarFactory.createPopupMenu(string3, this.graphController);
            object2 = jComponent.getComponents();
            if (((Component[])object2).length != 0) {
                ((JPopupMenu)object3).addSeparator();
            }
            for (n = 0; n < ((Component[])object2).length; ++n) {
                ((Container)object3).add(object2[n]);
            }
        }
        if (object instanceof GraphSwimlaneInterface && ((WorkflowElement)object).getPropertyObject() instanceof Lane) {
            jComponent = (Lane)((WorkflowElement)object).getPropertyObject();
            object2 = GraphUtilities.getLanesFirstPerformer((Lane)jComponent);
            if (object2 == null) {
                JMenuItem jMenuItem = BarFactory.createMenuItem(this.getGraphController().getSettings().getAction("SetLanesName"), this.getGraphController(), false);
                ((JPopupMenu)object3).addSeparator();
                ((JPopupMenu)object3).add(jMenuItem);
            }
            if (object2 != null && XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)this.getGraph().getWorkflowProcess(), (String)object2) == null) {
                JMenuItem jMenuItem = BarFactory.createMenuItem(this.getGraphController().getSettings().getAction("SetPerformerExpression"), this.getGraphController(), false);
                ((JPopupMenu)object3).addSeparator();
                ((JPopupMenu)object3).add(jMenuItem);
            }
        }
        if (object instanceof GraphTransitionInterface) {
            if (((WorkflowElement)object).getPropertyObject() instanceof Transition) {
                jComponent = BarFactory.createMenuItem(this.getGraphController().getSettings().getAction("SelectConnectingActivitiesForSelectedTransitions"), this.getGraphController(), false);
                ((JPopupMenu)object3).addSeparator();
                ((JPopupMenu)object3).add((JMenuItem)jComponent);
            } else {
                jComponent = BarFactory.createMenuItem(this.getGraphController().getSettings().getAction("SelectConnectingActivitiesForSelectedAssociations"), this.getGraphController(), false);
                ((JPopupMenu)object3).addSeparator();
                ((JPopupMenu)object3).add((JMenuItem)jComponent);
                jComponent = BarFactory.createMenuItem(this.getGraphController().getSettings().getAction("SelectConnectingArtifactsForSelectedAssociations"), this.getGraphController(), false);
                ((JPopupMenu)object3).addSeparator();
                ((JPopupMenu)object3).add((JMenuItem)jComponent);
            }
        }
        return object3;
    }

    public Point getPopupPoint() {
        return this.popupPoint;
    }

    public boolean validateSource(GraphPortViewInterface graphPortViewInterface) {
        if (graphPortViewInterface != null && graphPortViewInterface.getCell() != null && graphPortViewInterface.getCell() instanceof GraphPortInterface) {
            GraphCommonInterface graphCommonInterface = graphPortViewInterface.getGraphActivityOrArtifact();
            if (this.isTransitionButtonSelected() && graphCommonInterface instanceof GraphArtifactInterface) {
                return false;
            }
            if (!graphCommonInterface.acceptsSource()) {
                return false;
            }
            if (this.isAssociationButtonSelected()) {
                return true;
            }
            boolean bl = this.getSubType().equals("TRANSITION_EXCEPTION");
            if (!JaWEManager.getInstance().getTransitionHandler().acceptsSource((Activity)graphCommonInterface.getPropertyObject(), bl)) {
                JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningCannotAcceptMoreOutgoingTransitions"), this.getJaWEController().getAppTitle(), 1);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean validateConnection(GraphPortViewInterface graphPortViewInterface, GraphPortViewInterface graphPortViewInterface2, XMLCollectionElement xMLCollectionElement) {
        if (graphPortViewInterface != null && graphPortViewInterface.getCell() != null && graphPortViewInterface.getCell() instanceof GraphPortInterface && graphPortViewInterface2 != null && graphPortViewInterface2.getCell() != null && graphPortViewInterface2.getCell() instanceof GraphPortInterface) {
            boolean bl;
            GraphCommonInterface graphCommonInterface = graphPortViewInterface.getGraphActivityOrArtifact();
            GraphCommonInterface graphCommonInterface2 = graphPortViewInterface2.getGraphActivityOrArtifact();
            if (this.isTransitionButtonSelected() || xMLCollectionElement instanceof Transition) {
                if (graphCommonInterface instanceof GraphArtifactInterface || graphCommonInterface2 instanceof GraphArtifactInterface) {
                    return false;
                }
            } else {
                if (graphCommonInterface.getPropertyObject() instanceof Artifact && graphCommonInterface2.getPropertyObject() instanceof Artifact || graphCommonInterface.getPropertyObject() instanceof Activity && graphCommonInterface2.getPropertyObject() instanceof Activity) {
                    return false;
                }
                if (graphCommonInterface != graphCommonInterface2 && graphCommonInterface2.acceptsTarget()) {
                    Iterator iterator = XMLUtil.getPackage((XMLElement)this.getGraph().getXPDLObject()).getAssociations().toElements().iterator();
                    String string = graphCommonInterface.getPropertyObject().get("Id").toValue();
                    String string2 = graphCommonInterface2.getPropertyObject().get("Id").toValue();
                    while (iterator.hasNext()) {
                        Association association = (Association)iterator.next();
                        if ((!association.getSource().equals(string) || !association.getTarget().equals(string2)) && (!association.getSource().equals(string2) || !association.getTarget().equals(string))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            Transition transition = (Transition)xMLCollectionElement;
            if (!graphCommonInterface.acceptsSource()) {
                return false;
            }
            if (!graphCommonInterface2.acceptsTarget()) {
                return false;
            }
            if (!JaWEManager.getInstance().getTransitionHandler().acceptsTarget((Activity)graphCommonInterface2.getUserObject())) {
                JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningCannotAcceptMoreIncomingTransitions"), this.getJaWEController().getAppTitle(), 2);
                return false;
            }
            Activity activity = (Activity)graphCommonInterface.getUserObject();
            Activity activity2 = (Activity)graphCommonInterface2.getUserObject();
            int n = activity.getActivityType();
            int n2 = activity2.getActivityType();
            if (transition.getCondition().getType().equals("CONDITION") && n == 0 && ((Activity)graphCommonInterface.getPropertyObject()).getActivityTypes().getRoute().getGatewayType().equals("Parallel")) {
                JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningCannotInsertElement"), this.getJaWEController().getAppTitle(), 2);
                return false;
            }
            ArrayList arrayList = new ArrayList(1);
            boolean bl2 = bl = XMLUtil.isExceptionalTransition((Transition)transition) || this.getSubType().equals("TRANSITION_EXCEPTION");
            if (!JaWEManager.getInstance().getTransitionHandler().allowsConnection(activity, activity2, transition, bl, arrayList)) {
                String string = "WarningSourceActivityCannotHaveMoreOutgoingTransitions";
                boolean bl3 = false;
                if ((Integer)arrayList.get(0) == 2) {
                    string = "WarningTargetActivityCannotHaveMoreIncomingTransitions";
                } else if ((Integer)arrayList.get(0) == 3) {
                    bl3 = true;
                    string = "ErrorActivityCannotHaveMoreThenOneIncomingOutgoingTransitionFromToTheSameActivity";
                }
                JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString(string), this.getJaWEController().getAppTitle(), bl3 ? 0 : 1);
                return false;
            }
            return true;
        }
        return false;
    }

    protected GraphController getGraphController() {
        return this.graphController;
    }

    protected Graph getGraph() {
        return this.getGraphController().getSelectedGraph();
    }

    protected GraphManager getGraphManager() {
        return this.getGraph().getGraphManager();
    }

    protected JaWEController getJaWEController() {
        return JaWEManager.getInstance().getJaWEController();
    }

    protected JaWEFrame getJaWEFrame() {
        return this.getJaWEController().getJaWEFrame();
    }

    public boolean isSelectButtonSelected() {
        return this.mainType.equals("SELECT");
    }

    protected boolean isParticipantButtonSelected() {
        return this.mainType.equals("LANE");
    }

    protected boolean isArtifactButtonSelected() {
        return this.mainType.equals("ARTIFACT");
    }

    protected boolean isActivityButtonSelected() {
        return this.mainType.equals("ACTIVITY");
    }

    public boolean isAssociationButtonSelected() {
        return this.mainType.equals("ASSOCIATION");
    }

    public boolean isTransitionButtonSelected() {
        return this.mainType.equals("TRANSITION");
    }

    protected boolean isStartButtonSelected() {
        return this.mainType.equals("START");
    }

    protected boolean isEndButtonSelected() {
        return this.mainType.equals("END");
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public int getStatus() {
        if (this.isSelectButtonSelected()) {
            return 0;
        }
        if (this.isParticipantButtonSelected()) {
            return 3;
        }
        if (this.isTransitionButtonSelected()) {
            return 5;
        }
        if (this.isAssociationButtonSelected()) {
            return 7;
        }
        return 2;
    }

    public void setSelectionMode() {
        this.mainType = "SELECT";
        this.subType = "SELECT_DEFAULT";
        this.getGraph().setCursor(Cursor.getDefaultCursor());
        this.reset();
    }

    public void reset() {
        this.firstPort = null;
        this.port = null;
        this.start = null;
        this.current = null;
        this.getGraph().repaint();
        ((JaWEGraphUI)this.getGraph().getUI()).reset();
    }

    public void popupMenu(Point point) {
        double d = this.getGraph().getScale();
        Point point2 = new Point();
        point2.setLocation(point.getX() / d, point.getY() / d);
        Object object = this.getGraph().getFirstCellForLocation(point2.x, point2.y);
        this.popupPoint = new Point(point2);
        JPopupMenu jPopupMenu = this.createPopupMenu(object);
        jPopupMenu.show((Component)((Object)this.getGraph()), (int)point.getX(), (int)point.getY());
    }

    public void insertParticipant(Point point) {
        Object object;
        this.graphController.setUpdateInProgress(true);
        Participant participant = null;
        Participants participants = XMLUtil.getPackage((XMLElement)this.getGraph().getWorkflowProcess()).getParticipants();
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(this.getGraph().getXPDLObject());
        Lane lane = null;
        GraphSwimlaneInterface graphSwimlaneInterface = this.getGraph().getGraphManager().getParticipantForLocation(point);
        if (graphSwimlaneInterface != null && graphSwimlaneInterface.getPropertyObject() instanceof Lane && graphSwimlaneInterface.howManyChildActivitiesOrArtifacts() > 0) {
            JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningInvalidOperation"), this.getJaWEController().getAppTitle(), 2);
            return;
        }
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        if ("LANE_FREE_TEXT_EXPRESSION".equals(this.subType)) {
            lane = GraphUtilities.createDefaultLane(pool);
        } else if ("LANE_COMMON_EXPRESSION".equals(this.subType)) {
            lane = GraphUtilities.createLaneForPerformer(pool, "Common expression lane");
        } else {
            participant = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(participants, this.subType, false);
            participants.add((XMLElement)participant);
            lane = GraphUtilities.createLaneForPerformer(pool, participant.getId());
        }
        if (graphSwimlaneInterface != null && graphSwimlaneInterface.getPropertyObject() instanceof Lane) {
            object = (Lane)graphSwimlaneInterface.getPropertyObject();
            NestedLane nestedLane = (NestedLane)object.getNestedLanes().generateNewElement();
            nestedLane.setLaneId(lane.getId());
            object.getNestedLanes().add((XMLElement)nestedLane);
        }
        GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)lane, null, null, true);
        this.getGraphManager().insertParticipantAndArrangeParticipants(lane, point);
        object = new ArrayList();
        if (participant != null) {
            object.add(participant);
        }
        JaWEManager.getInstance().getJaWEController().endUndouableChange((List)object);
        this.graphController.setUpdateInProgress(false);
        this.graphController.adjustActions();
    }

    public void insertSpecialElement() {
    }

    public void insertElement(Point point) {
        if (this.isActivityButtonSelected() || this.isStartButtonSelected() || this.isEndButtonSelected() || this.isArtifactButtonSelected()) {
            if (!this.getGraphManager().hasLane()) {
                JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningInvalidOperation"), this.getJaWEController().getAppTitle(), 2);
            } else {
                Object object;
                GraphSwimlaneInterface graphSwimlaneInterface = this.getGraphManager().findParentParticipantForLocation(point, null, null);
                if (!(graphSwimlaneInterface.getPropertyObject() instanceof Lane)) {
                    JOptionPane.showMessageDialog(this.getJaWEFrame(), this.getGraphController().getSettings().getLanguageDependentString("WarningInvalidOperation"), this.getJaWEController().getAppTitle(), 2);
                    return;
                }
                Point point2 = this.getGraphManager().getCBounds(graphSwimlaneInterface, null).getBounds().getLocation();
                Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                Lane lane = (Lane)graphSwimlaneInterface.getPropertyObject();
                Artifacts artifacts = null;
                Artifact artifact = null;
                if (!this.isArtifactButtonSelected()) {
                    object = (Activities)this.getGraph().getXPDLObject().get("Activities");
                    Activity activity = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Activities)object, this.subType, false);
                    int n = activity.getActivityType();
                    if (n == 1 || n == 2) {
                        String string = GraphUtilities.getLanesFirstPerformer(lane);
                        activity.setFirstPerformer(string != null ? string : "");
                    }
                    artifact = activity;
                    artifacts = object;
                } else {
                    Artifact artifact2;
                    object = XMLUtil.getPackage((XMLElement)this.getGraph().getXPDLObject()).getArtifacts();
                    artifact = artifact2 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Artifacts)object, this.subType, false);
                    artifacts = object;
                }
                GraphUtilities.setOffsetPoint((XMLCollectionElement)artifact, point3, lane.getId());
                this.graphController.setUpdateInProgress(true);
                JaWEManager.getInstance().getJaWEController().startUndouableChange();
                artifacts.add((XMLElement)artifact);
                this.getGraphManager().insertActivityOrArtifact((XMLCollectionElement)artifact);
                object = new ArrayList();
                object.add(artifact);
                JaWEManager.getInstance().getJaWEController().endUndouableChange((List)object);
                if (artifact instanceof Activity) {
                    this.getGraph().selectActivity((Activity)artifact, false);
                } else {
                    this.getGraph().selectArtifact(artifact, false);
                }
                this.graphController.setUpdateInProgress(false);
            }
        }
    }

    public boolean insertTransitionFirstPort(GraphPortViewInterface graphPortViewInterface) {
        if (graphPortViewInterface != null && this.firstPort == null && this.validateSource(graphPortViewInterface)) {
            this.points = new Vector();
            this.firstPort = graphPortViewInterface;
            double d = this.getGraph().getScale();
            this.start = this.firstPort.getBounds().getBounds().getLocation();
            this.start.x += this.firstPort.getPortsSize().width / 2;
            this.start.y += this.firstPort.getPortsSize().height / 2;
            this.start = new Point((int)(this.start.getX() * d), (int)(this.start.getY() * d));
            return true;
        }
        return false;
    }

    public boolean insertTransitionSecondPort(GraphPortViewInterface graphPortViewInterface) {
        if (graphPortViewInterface != null) {
            Object object;
            Associations associations = null;
            Association association = null;
            if (this.isTransitionButtonSelected()) {
                object = (Transitions)this.getGraph().getXPDLObject().get("Transitions");
                association = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Transitions)object, this.subType, false);
                associations = object;
            } else {
                object = XMLUtil.getPackage((XMLElement)this.getGraph().getXPDLObject()).getAssociations();
                association = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject((Associations)object, this.subType, false);
                associations = object;
            }
            if (graphPortViewInterface != this.firstPort) {
                if (this.validateConnection(this.firstPort, graphPortViewInterface, (XMLCollectionElement)association)) {
                    object = ((GraphPortInterface)((Object)this.firstPort.getCell())).getActivityOrArtifact();
                    GraphCommonInterface graphCommonInterface = ((GraphPortInterface)((Object)graphPortViewInterface.getCell())).getActivityOrArtifact();
                    XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)object.getPropertyObject();
                    XMLCollectionElement xMLCollectionElement2 = (XMLCollectionElement)graphCommonInterface.getPropertyObject();
                    String string = xMLCollectionElement.getId();
                    String string2 = xMLCollectionElement2.getId();
                    if (association instanceof Transition) {
                        ((Transition)association).setFrom(string);
                        ((Transition)association).setTo(string2);
                    } else {
                        association.set("Source", string);
                        association.set("Target", string2);
                        if ("ASSOCIATION_DEFAULT".equals(this.subType)) {
                            if (graphCommonInterface instanceof GraphArtifactInterface) {
                                association.set("AssociationDirection", "From");
                            } else {
                                association.set("AssociationDirection", "To");
                            }
                        }
                    }
                    if (string.equals(string2)) {
                        GraphUtilities.setStyle((XMLCollectionElement)association, "NO_ROUTING_BEZIER");
                    } else {
                        GraphUtilities.setStyle((XMLCollectionElement)association, this.getGraphController().getGraphSettings().getDefaultTransitionStyle());
                    }
                    GraphUtilities.setBreakpoints((XMLCollectionElement)association, this.points);
                    this.points.clear();
                    this.graphController.setUpdateInProgress(true);
                    JaWEManager.getInstance().getJaWEController().startUndouableChange();
                    associations.add((XMLElement)association);
                    this.getGraphManager().insertTransitionOrAssociation((XMLCollectionElement)association);
                    ArrayList<Association> arrayList = new ArrayList<Association>();
                    arrayList.add(association);
                    JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
                    this.getGraph().selectTransition((XMLCollectionElement)association, false);
                    this.graphController.setUpdateInProgress(false);
                    this.getGraph().refresh();
                    return true;
                }
            } else if (this.validateConnection(graphPortViewInterface, graphPortViewInterface, (XMLCollectionElement)association)) {
                object = (Transition)association;
                Point point = (Point)this.getGraph().fromScreen(new Point(this.start));
                ArrayList<Point> arrayList = new ArrayList<Point>();
                if (this.points.size() == 0) {
                    int n;
                    int n2 = point.x - 50;
                    int n3 = point.x + 50;
                    if (n2 < 0) {
                        n3 -= n2;
                        n2 = 0;
                    }
                    if ((n = point.y - 50) < 0) {
                        n = point.y + 50;
                    }
                    arrayList.add(new Point(Math.abs(n2), Math.abs(n)));
                    arrayList.add(new Point(Math.abs(n3), Math.abs(n)));
                } else {
                    arrayList.addAll(this.points);
                    this.points.clear();
                }
                Activity activity = (Activity)((GraphActivityInterface)((GraphPortInterface)((Object)this.firstPort.getCell())).getActivityOrArtifact()).getPropertyObject();
                object.setFrom(activity.getId());
                object.setTo(activity.getId());
                GraphUtilities.setStyle((XMLCollectionElement)object, "NO_ROUTING_BEZIER");
                GraphUtilities.setBreakpoints((XMLCollectionElement)object, arrayList);
                this.getGraphController().setUpdateInProgress(true);
                JaWEManager.getInstance().getJaWEController().startUndouableChange();
                associations.add((XMLElement)object);
                this.getGraphManager().insertTransitionOrAssociation((XMLCollectionElement)object);
                ArrayList<Associations> arrayList2 = new ArrayList<Associations>();
                arrayList2.add((Associations)object);
                JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList2);
                this.getGraph().selectTransition((XMLCollectionElement)object, false);
                this.getGraphController().setUpdateInProgress(false);
                this.getGraph().refresh();
                return true;
            }
        }
        return false;
    }

    public void overlay(JGraph jGraph, Graphics graphics, boolean bl) {
        super.overlay(jGraph, graphics, bl);
        if (this.getGraph() != null) {
            this.paintPort(this.getGraph().getGraphics());
        }
        if (this.start != null && (this.isTransitionButtonSelected() || this.isAssociationButtonSelected())) {
            this.drawTransition(graphics);
        }
    }

    protected void drawTransition(MouseEvent mouseEvent) {
        Graphics graphics = this.getGraph().getGraphics();
        Color color = this.getGraph().getBackground();
        Color color2 = Color.black;
        graphics.setColor(color2);
        graphics.setXORMode(color);
        this.overlay(this.getGraph(), graphics, false);
        this.current = (Point)this.getGraph().snap(mouseEvent.getPoint());
        double d = this.getGraph().getScale();
        this.port = (GraphPortViewInterface)this.getGraph().getPortViewAt(mouseEvent.getX(), mouseEvent.getY());
        if (this.port != null) {
            this.current = this.port.getBounds().getBounds().getLocation();
            this.current = new Point((int)((double)this.current.x * d), (int)((double)this.current.y * d));
            this.current.x += this.port.getPortsSize().width / 2;
            this.current.y += this.port.getPortsSize().height / 2;
        }
        graphics.setColor(color);
        graphics.setXORMode(color2);
        this.overlay(this.getGraph(), graphics, false);
    }

    protected void drawTransition(Graphics graphics) {
        Point point = this.start;
        if (this.points.size() != 0) {
            point = (Point)this.points.get(this.points.size() - 1);
        }
        if (this.current != null) {
            if (this.isAssociationButtonSelected()) {
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f}, 0.0f));
            } else {
                ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
            }
            graphics.drawLine(point.x, point.y, this.current.x, this.current.y);
        }
    }

    protected void paintPort(Graphics graphics) {
        if (this.port != null) {
            boolean bl = GraphConstants.getOffset((Map)this.port.getAttributes()) != null;
            CellView cellView = this.port.getParentView();
            Rectangle rectangle = cellView.getBounds().getBounds();
            Rectangle rectangle2 = bl ? this.port.getBounds().getBounds() : rectangle;
            rectangle2 = (Rectangle)this.getGraph().toScreen(new Rectangle(rectangle2));
            int n = 3;
            rectangle2.translate(-n, -n);
            rectangle2.setSize(rectangle2.width + 2 * n, rectangle2.height + 2 * n);
            JaWEGraphUI jaWEGraphUI = (JaWEGraphUI)this.getGraph().getUI();
            jaWEGraphUI.paintCell(graphics, (CellView)this.port, rectangle2, true);
        }
    }

    public String getMainType() {
        return this.mainType;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setType(String string, String string2, Cursor cursor) {
        this.mainType = string;
        this.subType = string2;
        if (cursor != null) {
            this.getGraph().setCursor(cursor);
        } else {
            this.getGraph().setCursor(Cursor.getDefaultCursor());
        }
        this.reset();
    }
}

