/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;

public class JaWEGraphModel
extends DefaultGraphModel
implements Serializable {
    public JaWEGraphModel() {
        this.setRemoveEmptyGroups(false);
    }

    public JaWEGraphModel(List list, AttributeMap attributeMap) {
        super(list, attributeMap);
        this.setRemoveEmptyGroups(false);
    }

    public JaWEGraphModel(List list, AttributeMap attributeMap, ConnectionSet connectionSet) {
        super(list, attributeMap, connectionSet);
        this.setRemoveEmptyGroups(false);
    }

    public void insertAndEdit(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createInsertEdit(objectArray, map, connectionSet, parentMap, undoableEditArray);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    if (!(undoableEditArray[i] instanceof GraphLayoutCache.GraphLayoutCacheEdit)) continue;
                    ((GraphLayoutCache.GraphLayoutCacheEdit)undoableEditArray[i]).execute();
                }
            }
            this.postEdit((UndoableEdit)graphModelEdit);
        }
    }

    public void removeAndEdit(Object[] objectArray, Map map) {
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createRemoveAndCellEdit(objectArray, map);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
            this.postEdit((UndoableEdit)graphModelEdit);
        }
    }

    public void editFonts(Map map) {
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createCellEdit(map, null, null, null);
        if (graphModelEdit != null) {
            graphModelEdit.execute();
        }
    }

    protected DefaultGraphModel.GraphModelEdit createInsertEdit(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createEdit(objectArray, null, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    graphModelEdit.addEdit(undoableEditArray[i]);
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected DefaultGraphModel.GraphModelEdit createRemoveAndCellEdit(Object[] objectArray, Map map) {
        ParentMap parentMap;
        ConnectionSet connectionSet = ConnectionSet.create((GraphModel)this, (Object[])objectArray, (boolean)true);
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createEdit(null, objectArray, map, connectionSet, parentMap = ParentMap.create((GraphModel)this, (Object[])objectArray, (boolean)true, (boolean)false));
        if (graphModelEdit != null) {
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected DefaultGraphModel.GraphModelEdit createCellEdit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        DefaultGraphModel.GraphModelEdit graphModelEdit = this.createEdit(null, null, map, connectionSet, parentMap);
        if (graphModelEdit != null) {
            if (undoableEditArray != null) {
                for (int i = 0; i < undoableEditArray.length; ++i) {
                    graphModelEdit.addEdit(undoableEditArray[i]);
                }
            }
            graphModelEdit.end();
        }
        return graphModelEdit;
    }

    protected DefaultGraphModel.GraphModelEdit createEdit(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet, ParentMap parentMap) {
        return new DefaultGraphModel.GraphModelEdit((DefaultGraphModel)this, objectArray, objectArray2, map, connectionSet, parentMap);
    }

    public static List getAllCellsInModel(GraphModel graphModel) {
        List list = JaWEGraphModel.getDescendants((GraphModel)graphModel, (Object[])JaWEGraphModel.getRoots((GraphModel)graphModel));
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    public static Set getRootParticipants(GraphModel graphModel) {
        Object[] objectArray = JaWEGraphModel.getRoots((GraphModel)graphModel);
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof GraphSwimlaneInterface)) continue;
            hashSet.add(objectArray[i]);
        }
        return hashSet;
    }

    public static List getAllParticipantsInModel(GraphModel graphModel) {
        if (!(graphModel instanceof JaWEGraphModel)) {
            return null;
        }
        List list = JaWEGraphModel.getAllCellsInModel(graphModel);
        if (list == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        for (Object e : list) {
            if (!(e instanceof GraphSwimlaneInterface)) continue;
            linkedList.add(e);
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList;
    }

    public static List getAllArtifactsInModel(GraphModel graphModel) {
        if (!(graphModel instanceof JaWEGraphModel)) {
            return null;
        }
        List list = JaWEGraphModel.getAllCellsInModel(graphModel);
        if (list == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        for (Object e : list) {
            if (!(e instanceof GraphArtifactInterface)) continue;
            linkedList.add(e);
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList;
    }

    public static List getAllActivitiesInModel(GraphModel graphModel) {
        if (!(graphModel instanceof JaWEGraphModel)) {
            return null;
        }
        List list = JaWEGraphModel.getAllCellsInModel(graphModel);
        if (list == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        for (Object e : list) {
            if (!(e instanceof GraphActivityInterface)) continue;
            linkedList.add(e);
        }
        if (linkedList.size() == 0) {
            return null;
        }
        return linkedList;
    }

    public static List getAllTransitionsInModel(GraphModel graphModel) {
        if (!(graphModel instanceof JaWEGraphModel)) {
            return null;
        }
        Object[] objectArray = JaWEGraphModel.getRoots((GraphModel)graphModel);
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof GraphTransitionInterface)) continue;
            linkedList.add(objectArray[i]);
        }
        return linkedList;
    }
}

