/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.actions;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jxpdl.XMLElement;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SaveAsSVG
extends ActionBase {
    public SaveAsSVG(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    @Override
    public void enableDisableAction() {
        GraphController graphController = (GraphController)this.jawecomponent;
        if (graphController.getSelectedGraph() != null) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = JaWEManager.getInstance().getJaWEController().saveDialog(ResourceManager.getLanguageDependentString("SaveAsSVGLabel"), 2, JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)((GraphController)this.jawecomponent).getSelectedGraph().getXPDLObject()));
            if (string != null && string.length() > 0) {
                SaveAsSVG.saveGraphAsSVG(string, ((GraphController)this.jawecomponent).getSelectedGraph());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = ResourceManager.getLanguageDependentString("ErrorSVGSavingFailed");
            JaWEManager.getInstance().getJaWEController().message(string, 2);
        }
    }

    public static void saveGraphAsSVG(String string, Graph graph) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, JaWEManager.getInstance().getJaWEController().getControllerSettings().getEncoding());
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        String string2 = "http://www.w3.org/2000/svg";
        Document document = dOMImplementation.createDocument(string2, "svg", null);
        SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
        graph.paint((Graphics)sVGGraphics2D);
        boolean bl = true;
        sVGGraphics2D.stream((Writer)outputStreamWriter, bl);
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

