/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.xpdlview;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.xpdlview.XPDLViewControllerPanel;
import org.enhydra.jawe.components.xpdlview.XPDLViewSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Package;

public class XPDLViewController
implements Observer,
JaWEComponent {
    protected String type = "MAIN";
    protected boolean updateInProgress = false;
    protected XPDLViewControllerPanel panel;
    protected XPDLViewSettings settings;

    public XPDLViewController(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (XPDLViewSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)object);
        int n = xPDLElementChangeInfo.getAction();
        if (n != 1 && n != 3 && n != 5 && n != 7 && n != 8 && n != 15 && n != 16 && n != 17) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("XPDLViewController -> update for event " + (Object)((Object)xPDLElementChangeInfo) + " started ...");
        if (n == 15 || n == 16 || n == 17) {
            this.panel.setSelectedElement(null);
        } else {
            this.update(xPDLElementChangeInfo);
        }
        JaWEManager.getInstance().getLoggingManager().info("XPDLViewController -> update ended");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF XPDL COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    @Override
    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    @Override
    public JaWEComponentView getView() {
        return this.panel;
    }

    @Override
    public String getName() {
        return "XPDLComponent";
    }

    @Override
    public String getComponentType() {
        return this.type;
    }

    @Override
    public void setComponentType(String string) {
        this.type = string;
    }

    @Override
    public boolean adjustXPDL(Package package_) {
        return false;
    }

    @Override
    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    @Override
    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    @Override
    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    @Override
    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    protected void init() {
        this.panel = this.createPanel();
    }

    protected XPDLViewControllerPanel createPanel() {
        XPDLViewControllerPanel xPDLViewControllerPanel = new XPDLViewControllerPanel(this);
        xPDLViewControllerPanel.configure();
        xPDLViewControllerPanel.init();
        return xPDLViewControllerPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            int n = xPDLElementChangeInfo.getAction();
            if (n == 5) {
                this.panel.setSelectedElement(null);
                return;
            }
            XMLElement xMLElement = this.panel.getSelectedElement();
            Object object = this.settings.showXPDLDetails() ? xPDLElementChangeInfo.getChangedElement() : XMLUtil.getPackage((XMLElement)xPDLElementChangeInfo.getChangedElement());
            if (n != 8 && (xMLElement != object || n != 1)) {
                object = null;
            }
            if (xMLElement != object || n == 1) {
                this.panel.setSelectedElement((XMLElement)object);
            }
        }
        finally {
            this.updateInProgress = false;
        }
    }

    public XPDLViewSettings getXPDLViewSettings() {
        return this.settings;
    }

    @Override
    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = true;
    }

    @Override
    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

