/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.ldap;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.AdditionalResourceManager;
import org.enhydra.jawe.JaWEAction;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.components.ldap.actions.ConfigureLDAP;
import org.enhydra.jawe.components.ldap.actions.ImportAll;
import org.enhydra.jawe.components.ldap.actions.ImportSelected;
import org.enhydra.jawe.components.ldap.actions.SearchLDAP;
import org.enhydra.jxpdl.XMLUtil;

public class LDAPSettings
extends JaWEComponentSettings {
    public void init(JaWEComponent jaWEComponent) {
        this.PROPERTYFILE_PATH = "org/enhydra/jawe/components/ldap/properties/";
        this.PROPERTYFILE_NAME = "ldap.properties";
        super.init(jaWEComponent);
    }

    public void loadDefault(JaWEComponent jaWEComponent, Properties properties) {
        this.arm = new AdditionalResourceManager(properties);
        this.componentSettings.put("LDAPReferralHandling", properties.getProperty("LDAPReferralHandling", "follow"));
        this.componentSettings.put("LDAPCountLimit", new Integer(properties.getProperty("LDAPCountLimit", "0")));
        this.componentSettings.put("LDAPTimeLimit", new Integer(properties.getProperty("LDAPTimeLimit", "0")));
        this.componentSettings.put("LDAPPageSize", new Integer(properties.getProperty("LDAPPageSize", "1000")));
        this.componentSettings.put("LDAPHost", properties.getProperty("LDAPHost", "localhost"));
        this.componentSettings.put("LDAPPort", properties.getProperty("LDAPPort", "389"));
        this.componentSettings.put("LDAPBaseDN", properties.getProperty("LDAPBaseDN", ""));
        this.componentSettings.put("LDAPObjectClassFilter", properties.getProperty("LDAPObjectClassFilter", "group"));
        this.componentSettings.put("LDAPSearchScope", properties.getProperty("LDAPSearchScope", "SCOPE_SUB"));
        this.componentSettings.put("LDAPSecurityLevel", properties.getProperty("LDAPSecurityLevel", "UserAndPassword"));
        this.componentSettings.put("LDAPSecurityUserDN", properties.getProperty("LDAPSecurityUserDN", "username@company.com"));
        this.componentSettings.put("LDAPSecurityPassword", properties.getProperty("LDAPSecurityPassword", "somepwd"));
        this.componentSettings.put("LDAPShowConfigDialog", properties.getProperty("LDAPShowConfigDialog", "true"));
        this.componentSettings.put("LDAPObjectClassFilterChoices", properties.getProperty("LDAPObjectClassFilterChoices", "group,organizationalUnit,organizationalRole,user,person,organizationalPerson,inetOrgPerson,AllListed"));
        this.componentSettings.put("LDAPGroupUniqueAttributeName", "sAMAccountName");
        this.componentSettings.put("LDAPGroupNameAttributeName", "displayName");
        this.componentSettings.put("LDAPGroupDescriptionAttributeName", "description");
        this.componentSettings.put("LDAPUserUniqueAttributeName", "sAMAccountName");
        this.componentSettings.put("LDAPUserNameAttributeName", "displayName");
        this.componentSettings.put("LDAPUserDescriptionAttributeName", "description");
        this.componentSettings.put("LDAPDistinguishedNameAttributeName", "distinguishedName");
        URL uRL = ResourceManager.getResource((Properties)properties, (String)"Role.Icon");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/participantrole.gif"));
        this.componentSettings.put("Role.Icon", imageIcon);
        uRL = ResourceManager.getResource((Properties)properties, (String)"Group.Icon");
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/participantorgunit.png"));
        this.componentSettings.put("Group.Icon", imageIcon);
        uRL = ResourceManager.getResource((Properties)properties, (String)"User.Icon");
        imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/participant.gif"));
        this.componentSettings.put("User.Icon", imageIcon);
        this.loadDefaultMenusToolbarsAndActions(jaWEComponent);
        this.componentSettings.putAll(Utils.loadAllMenusAndToolbars((Properties)properties));
        this.componentAction.putAll(Utils.loadActions((Properties)properties, (JaWEComponent)jaWEComponent, (Map)this.componentAction));
    }

    public String getToolbarActionOrder(String string) {
        return (String)this.componentSettings.get(string + "Toolbar");
    }

    public void loadDefaultMenusToolbarsAndActions(JaWEComponent jaWEComponent) {
        this.componentSettings.put("defaultToolbarToolbar", "ConfigureLDAP SearchLDAP - ImportSelected ImportAll");
        ActionBase actionBase = new ConfigureLDAP(jaWEComponent);
        ImageIcon imageIcon = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/config.gif"));
        String string = "ConfigureLDAP";
        JaWEAction jaWEAction = new JaWEAction(actionBase, imageIcon, string);
        this.componentAction.put(actionBase.getValue("Name"), jaWEAction);
        actionBase = new SearchLDAP(jaWEComponent);
        imageIcon = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/searchldap.png"));
        string = "SearchLDAP";
        jaWEAction = new JaWEAction(actionBase, imageIcon, string);
        this.componentAction.put(actionBase.getValue("Name"), jaWEAction);
        actionBase = new ImportSelected(jaWEComponent);
        imageIcon = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/importselected.png"));
        string = "ImportSelected";
        jaWEAction = new JaWEAction(actionBase, imageIcon, string);
        this.componentAction.put(actionBase.getValue("Name"), jaWEAction);
        actionBase = new ImportAll(jaWEComponent);
        imageIcon = new ImageIcon(ResourceManager.class.getClassLoader().getResource("org/enhydra/jawe/images/importexternalparticipants.gif"));
        string = "ImportAll";
        jaWEAction = new JaWEAction(actionBase, imageIcon, string);
        this.componentAction.put(actionBase.getValue("Name"), jaWEAction);
    }

    public String getLDAPReferralHandling() {
        return this.getSettingString("LDAPReferralHandling");
    }

    public String getLDAPCountLimit() {
        return this.getSettingString("LDAPCountLimit");
    }

    public String getLDAPTimeLimit() {
        return this.getSettingString("LDAPTimeLimit");
    }

    public String getLDAPPageSize() {
        return this.getSettingString("LDAPPageSize");
    }

    public String getLDAPHost() {
        return this.getSettingString("LDAPHost");
    }

    public String getLDAPPort() {
        return this.getSettingString("LDAPPort");
    }

    public String getLDAPBaseDN() {
        return this.getSettingString("LDAPBaseDN");
    }

    public String getLDAPObjectClassFilter() {
        return this.getSettingString("LDAPObjectClassFilter");
    }

    public String getLDAPSearchScope() {
        return this.getSettingString("LDAPSearchScope");
    }

    public String getLDAPSecurityLevel() {
        return this.getSettingString("LDAPSecurityLevel");
    }

    public String getLDAPSecurityUserDN() {
        return this.getSettingString("LDAPSecurityUserDN");
    }

    public String getLDAPSecurityPassword() {
        return this.getSettingString("LDAPSecurityPassword");
    }

    public String[] getLDAPObjectClassFilterChoices() {
        String string = this.getSettingString("LDAPObjectClassFilterChoices");
        return XMLUtil.tokenize((String)string, (String)",");
    }

    public String getLDAPGroupUniqueAttributeName() {
        return this.getSettingString("LDAPGroupUniqueAttributeName");
    }

    public String getLDAPGroupNameAttributeName() {
        return this.getSettingString("LDAPGroupNameAttributeName");
    }

    public String getLDAPGroupDescriptionAttributeName() {
        return this.getSettingString("LDAPGroupDescriptionAttributeName");
    }

    public String getLDAPUserUniqueAttributeName() {
        return this.getSettingString("LDAPUserUniqueAttributeName");
    }

    public String getLDAPUserNameAttributeName() {
        return this.getSettingString("LDAPUserNameAttributeName");
    }

    public String getLDAPUserDescriptionAttributeName() {
        return this.getSettingString("LDAPUserDescriptionAttributeName");
    }

    public String getLDAPDistinguishedNameAttributeName() {
        return this.getSettingString("LDAPDistinguishedNameAttributeName");
    }

    public ImageIcon getRoleIcon() {
        return (ImageIcon)this.componentSettings.get("Role.Icon");
    }

    public ImageIcon getGroupIcon() {
        return (ImageIcon)this.componentSettings.get("Group.Icon");
    }

    public ImageIcon getUserIcon() {
        return (ImageIcon)this.componentSettings.get("User.Icon");
    }
}

