/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.ReferralException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.ldap.LDAPConfiguration;
import org.enhydra.jawe.components.ldap.LDAPEntryInfo;
import org.enhydra.jawe.components.ldap.LDAPSecurity;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Participants;

public class LDAPUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getEntries(LDAPConfiguration lDAPConfiguration, List list, String string, String string2, List list2) throws Exception {
        Object object;
        String string3;
        String string4;
        int n;
        try {
            n = Integer.valueOf(lDAPConfiguration.get("Port").toValue());
        }
        catch (Exception exception) {
            n = 389;
        }
        int n2 = lDAPConfiguration.get("SearchScope").toValue().equals("SCOPE_ONE") ? 1 : 2;
        String string5 = lDAPConfiguration.get("Host").toValue();
        String string6 = lDAPConfiguration.get("BaseDN").toValue();
        int n3 = LDAPUtils.getSearchType(string);
        if (n3 == -1) {
            string4 = "(|";
            for (int i = 0; i < list.size(); ++i) {
                string3 = (String)list.get(i);
                if (string3.equals("AllListed")) continue;
                string4 = string4 + "(objectClass=" + list.get(i) + ")";
            }
            string4 = string4 + ")";
        } else {
            string4 = "(objectClass=" + string + ")";
        }
        if (!string2.trim().equals("")) {
            string4 = "(&" + string4;
            if (n3 == -1) {
                string4 = string4 + "(|(" + lDAPConfiguration.get("LDAPGroupUniqueAttributeName").toValue() + "=" + string2 + ")(" + lDAPConfiguration.get("LDAPUserUniqueAttributeName").toValue() + "=" + string2 + "))";
            } else {
                String string7 = n3 == 0 ? lDAPConfiguration.get("LDAPUserUniqueAttributeName").toValue() : lDAPConfiguration.get("LDAPGroupUniqueAttributeName").toValue();
                string4 = string4 + "(" + string7 + "=" + string2 + ")";
            }
            string4 = string4 + ")";
        }
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        string3 = "follow";
        try {
            object = JaWEManager.getInstance().getJaWEController().getControllerSettings().getSettingString("LDAPReferralHandling");
            if (object.equals("throw") || object.equals("ignore")) {
                string3 = object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        properties.put("java.naming.referral", string3);
        properties.put("java.naming.provider.url", "ldap://" + string5 + ":" + n);
        properties.put("java.naming.ldap.version", "3");
        object = (LDAPSecurity)lDAPConfiguration.get("LDAPSecurity");
        if (object.get("Level").toValue().equals("Anonymous")) {
            properties.put("java.naming.security.authentication", "none");
        } else {
            properties.put("java.naming.security.authentication", "simple");
            String string8 = object.get("UserDN").toValue();
            String string9 = object.get("Password").toValue();
            properties.put("java.naming.security.principal", string8);
            properties.put("java.naming.security.credentials", string9);
        }
        int n4 = 0;
        try {
            n4 = Integer.parseInt(lDAPConfiguration.get("LDAPCountLimit").toValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(lDAPConfiguration.get("LDAPTimeLimit").toValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n6 = 1000;
        try {
            n6 = Integer.parseInt(lDAPConfiguration.get("LDAPPageSize").toValue());
            if (n6 <= 0) {
                n6 = Integer.MAX_VALUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LdapContext ldapContext = new InitialLdapContext(properties, null);
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(n2);
            searchControls.setCountLimit(n4);
            searchControls.setTimeLimit(n5);
            boolean bl = true;
            block16: while (bl) {
                byte[] byArray = null;
                ldapContext.setRequestControls(new Control[]{new PagedResultsControl(n6, true)});
                do {
                    try {
                        Object object2;
                        NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(string6, string4, searchControls);
                        while (namingEnumeration.hasMore()) {
                            object2 = namingEnumeration.next();
                            LDAPEntryInfo lDAPEntryInfo = LDAPUtils.convertLDAPEntryToInfoObject((SearchResult)object2, lDAPConfiguration);
                            if (lDAPEntryInfo == null) continue;
                            list2.add(lDAPEntryInfo);
                        }
                        object2 = ldapContext.getResponseControls();
                        if (object2 != null) {
                            for (int i = 0; i < ((Control[])object2).length; ++i) {
                                if (!(object2[i] instanceof PagedResultsResponseControl)) continue;
                                PagedResultsResponseControl pagedResultsResponseControl = (PagedResultsResponseControl)object2[i];
                                byArray = pagedResultsResponseControl.getCookie();
                            }
                        }
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(n6, byArray, true)});
                        bl = false;
                    }
                    catch (ReferralException referralException) {
                        bl = referralException.skipReferral();
                        if (!bl) continue block16;
                        ldapContext = (LdapContext)referralException.getReferralContext();
                        continue block16;
                    }
                } while (byArray != null);
            }
        }
        finally {
            ldapContext.close();
        }
    }

    protected static LDAPEntryInfo convertLDAPEntryToInfoObject(SearchResult searchResult, LDAPConfiguration lDAPConfiguration) {
        try {
            String string;
            LDAPEntryInfo lDAPEntryInfo = new LDAPEntryInfo();
            Attributes attributes = searchResult.getAttributes();
            NamingEnumeration<?> namingEnumeration = attributes.get("objectClass").getAll();
            if (namingEnumeration != null) {
                while (namingEnumeration.hasMoreElements()) {
                    string = (String)namingEnumeration.nextElement();
                    if (string.toLowerCase().endsWith("person") || string.toLowerCase().equals("user")) {
                        lDAPEntryInfo.setType("HUMAN");
                        break;
                    }
                    if (!string.equals("organizationalUnit")) continue;
                    lDAPEntryInfo.setType("ORGANIZATIONAL_UNIT");
                    break;
                }
            }
            if (lDAPEntryInfo.getType().equals("")) {
                lDAPEntryInfo.setType("ROLE");
            }
            string = null;
            String string2 = "";
            String string3 = "";
            string = lDAPEntryInfo.getType().equals("HUMAN") ? (String)attributes.get(lDAPConfiguration.get("LDAPUserUniqueAttributeName").toValue()).get() : (String)attributes.get(lDAPConfiguration.get("LDAPGroupUniqueAttributeName").toValue()).get();
            lDAPEntryInfo.setId(string);
            JaWEManager.getInstance().getLoggingManager().debug("LDAPUtils -> Handling entry with Id " + string);
            try {
                string2 = lDAPEntryInfo.getType().equals("HUMAN") ? (String)attributes.get(lDAPConfiguration.get("LDAPUserNameAttributeName").toValue()).get() : (String)attributes.get(lDAPConfiguration.get("LDAPGroupNameAttributeName").toValue()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string3 = lDAPEntryInfo.getType().equals("HUMAN") ? (String)attributes.get(lDAPConfiguration.get("LDAPUserDescriptionAttributeName").toValue()).get() : (String)attributes.get(lDAPConfiguration.get("LDAPGroupDescriptionAttributeName").toValue()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            lDAPEntryInfo.setDescription(string3);
            if (string2 == null) {
                try {
                    int n = searchResult.getName().indexOf("=") + 1;
                    int n2 = searchResult.getName().indexOf(",");
                    if (n2 == -1) {
                        n2 = searchResult.getName().length();
                    }
                    string2 = searchResult.getName().substring(n, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            lDAPEntryInfo.setName(string2);
            String string4 = "";
            try {
                string4 = (String)attributes.get(lDAPConfiguration.get("LDAPDistinguishedNameAttributeName").toValue()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            lDAPEntryInfo.setDN(string4);
            lDAPEntryInfo.setDetails(searchResult.toString());
            return lDAPEntryInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void createParticipants(List list) {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        Participants participants = jaWEController.getMainPackage().getParticipants();
        Iterator iterator = list.iterator();
        ArrayList<Participant> arrayList = new ArrayList<Participant>();
        while (iterator.hasNext()) {
            LDAPEntryInfo lDAPEntryInfo = (LDAPEntryInfo)((Object)iterator.next());
            boolean bl = false;
            Participant participant = participants.getParticipant(lDAPEntryInfo.getId());
            if (participant == null) {
                participant = (Participant)participants.generateNewElement();
                bl = true;
            }
            participant.setId(lDAPEntryInfo.getId());
            participant.setName(lDAPEntryInfo.getName());
            participant.getParticipantType().getTypeAttribute().setValue(lDAPEntryInfo.getType());
            participant.setDescription(lDAPEntryInfo.getDescription());
            ExtendedAttributes extendedAttributes = participant.getExtendedAttributes();
            ArrayList arrayList2 = extendedAttributes.getElementsForName("DN");
            ExtendedAttribute extendedAttribute = null;
            if (arrayList2 != null && arrayList2.size() > 0) {
                extendedAttribute = (ExtendedAttribute)arrayList2.get(0);
            } else {
                extendedAttribute = new ExtendedAttribute(extendedAttributes);
                extendedAttributes.add((XMLElement)extendedAttribute);
            }
            extendedAttribute.setName("DN");
            String string = lDAPEntryInfo.getDN();
            extendedAttribute.setVValue(string);
            if (!bl) continue;
            arrayList.add(participant);
        }
        jaWEController.startUndouableChange();
        for (int i = 0; i < arrayList.size(); ++i) {
            participants.add((XMLElement)arrayList.get(i));
        }
        ArrayList<Participants> arrayList3 = new ArrayList<Participants>();
        arrayList3.add(participants);
        jaWEController.endUndouableChange(arrayList3);
    }

    protected static int getSearchType(String string) {
        if (string.equals("AllListed")) {
            return -1;
        }
        if (string.toLowerCase().endsWith("person") || string.toLowerCase().equals("user")) {
            return 0;
        }
        return 1;
    }
}

