/*
 * Decompiled with CFR 0.152.
 */
package com.textflex.jarajar.common;

import com.textflex.jarajar.common.LibJarAjar;
import com.textflex.jarajar.common.UndoManagerTTx;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;

public class TextBoard
extends JTextPane
implements StateEditable {
    private File file;
    private boolean changed = false;
    private String path;
    private UndoManagerTTx undoManager = new UndoManagerTTx();
    private Hashtable actions;
    private InputMap imap = null;
    private ActionMap amap = null;
    private boolean autoIndent = false;
    private int tabSize = 4;
    private static boolean JVM_15 = false;

    public TextBoard() {
        JVM_15 = System.getProperty("java.vm.version").indexOf("1.5") != -1;
        this.applyDocumentSettings();
        this.imap = this.getInputMap(0);
        this.amap = this.getActionMap();
        this.createActionTable(this);
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (keyEvent.isControlDown() && c == '\b') {
                    keyEvent.consume();
                } else if (TextBoard.this.autoIndent && c == '\n') {
                    TextBoard.this.autoIndent();
                } else if (TextBoard.this.autoIndent && c == '\t' && TextBoard.this.isLeadingTab()) {
                    TextBoard.this.indentCurrentParagraph(TextBoard.this.getTabSize());
                } else if (TextBoard.this.autoIndent && c == '\b' && TextBoard.this.isLeadingTab()) {
                    TextBoard.this.indentCurrentParagraph(TextBoard.this.getTabSize(), !JVM_15);
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (keyEvent.isControlDown() && n == 90) {
                    TextBoard.this.undo();
                }
            }
        });
        this.hybridKeybindings();
        LibJarAjar.addEditorPaneHyperlinkListener(this.getThis());
    }

    private TextBoard getThis() {
        return this;
    }

    public void standardKeybindings() {
        this.createActionTable(this);
        this.universalShortcuts();
    }

    public void hybridKeybindings() {
        this.createActionTable(this);
        this.universalShortcuts();
        this.partialEmacsShortcuts();
    }

    public void emacsKeybindings() {
        this.createActionTable(this);
        this.universalShortcuts();
        this.partialEmacsShortcuts();
        this.emacsShortcuts();
    }

    private void universalShortcuts() {
        this.imap.put(KeyStroke.getKeyStroke(8, 2), "deleteWord");
        this.amap.put("deleteWord", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TextBoard.this.getWordPosition();
                try {
                    TextBoard.this.getDocument().remove(n, TextBoard.this.getCaretPosition() - n);
                    TextBoard.this.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    System.out.println("Deletion out of range.");
                }
            }
        });
        this.imap.put(KeyStroke.getKeyStroke(8, 1), "deletePrevChar");
        this.amap.put("deletePrevChar", this.getActionByName("delete-previous"));
    }

    private void partialEmacsShortcuts() {
        this.imap.put(KeyStroke.getKeyStroke(70, 2), "forwardChar");
        this.amap.put("forwardChar", this.getActionByName("caret-forward"));
        this.imap.put(KeyStroke.getKeyStroke(66, 2), "backwardChar");
        this.amap.put("backwardChar", this.getActionByName("caret-backward"));
        this.imap.put(KeyStroke.getKeyStroke(78, 2), "downChar");
        this.amap.put("downChar", this.getActionByName("caret-down"));
        this.imap.put(KeyStroke.getKeyStroke(80, 2), "upChar");
        this.amap.put("upChar", this.getActionByName("caret-up"));
        this.imap.put(KeyStroke.getKeyStroke(65, 2), "beginLine");
        this.amap.put("beginLine", this.getActionByName("caret-begin-line"));
        this.imap.put(KeyStroke.getKeyStroke(69, 2), "endLineChar");
        this.amap.put("endLineChar", this.getActionByName("caret-end-line"));
        this.imap.put(KeyStroke.getKeyStroke(68, 2), "deleteNextChar");
        this.amap.put("deleteNextChar", this.getActionByName("delete-next"));
        this.imap.put(KeyStroke.getKeyStroke(66, 8), "wordStart");
        this.amap.put("wordStart", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextBoard.this.setCaretPosition(TextBoard.this.getWordPosition());
            }
        });
        this.imap.put(KeyStroke.getKeyStroke(70, 8), "nextWord");
        this.amap.put("nextWord", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextBoard.this.setCaretPosition(TextBoard.this.getNextWordPosition());
            }
        });
        this.imap.put(KeyStroke.getKeyStroke(76, 2), "selectAll");
        this.amap.put("selectAll", this.getActionByName("select-all"));
    }

    private void emacsShortcuts() {
        this.imap.put(KeyStroke.getKeyStroke(86, 2), "pageDown");
        this.amap.put("pageDown", this.getActionByName("page-down"));
        this.imap.put(KeyStroke.getKeyStroke(86, 8), "pageUp");
        this.amap.put("pageUp", this.getActionByName("page-up"));
        this.imap.put(KeyStroke.getKeyStroke(44, 9), "begin");
        this.amap.put("begin", this.getActionByName("caret-begin"));
        this.imap.put(KeyStroke.getKeyStroke(46, 9), "end");
        this.amap.put("end", this.getActionByName("caret-end"));
    }

    public void setDefaultTabs(int n) {
        int n2 = this.getFontMetrics(this.getFont()).charWidth(' ');
        int n3 = n2 * n;
        TabStop[] tabStopArray = new TabStop[30];
        for (int i = 0; i < tabStopArray.length; ++i) {
            tabStopArray[i] = new TabStop((i + 1) * n3);
        }
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        StyleConstants.setLeftIndent(simpleAttributeSet, 0.0f);
        this.undoManager.setIgnoreNextStyleChange(true);
        this.getStyledDocument().setParagraphAttributes(0, this.getDocument().getLength() + 1, simpleAttributeSet, false);
    }

    public void setNoTabs() {
        TabStop[] tabStopArray = new TabStop[]{new TabStop(0.0f)};
        TabSet tabSet = new TabSet(tabStopArray);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setTabSet(simpleAttributeSet, tabSet);
        this.undoManager.setIgnoreNextStyleChange(true);
        this.getStyledDocument().setParagraphAttributes(0, this.getDocument().getLength() + 1, simpleAttributeSet, false);
    }

    public void setIndentTabs(int n) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        String string = this.getAllText();
        while (n3 < string.length() && (n4 = string.indexOf("\n", n3 + 1)) != -1) {
            n2 = this.leadingTabsCount(string, n3);
            if (n2 > 0) {
                this.indent(n, n2, n3, n4 - n3 + 1);
            }
            n3 = n4 + 1;
        }
        n2 = this.leadingTabsCount(string, n3);
        this.indent(n, n2, n3, string.length() + 1);
    }

    public int leadingTabsCount(String string, int n) {
        int n2 = 0;
        for (int i = n; i < string.length() && string.charAt(i) == '\t'; ++i) {
            ++n2;
        }
        return n2;
    }

    public void indent(int n, int n2, int n3, int n4) {
        int n5 = this.getFontMetrics(this.getFont()).charWidth(' ');
        int n6 = n5 * n;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setLeftIndent(simpleAttributeSet, n2 * n6);
        this.undoManager.setIgnoreNextStyleChange(true);
        this.getStyledDocument().setParagraphAttributes(n3, n4, simpleAttributeSet, false);
    }

    public void indentCurrentParagraph(int n, boolean bl) {
        String string = this.getAllText();
        int n2 = LibJarAjar.reverseIndexOf(string, "\n", this.getCaretPosition()) + 1;
        int n3 = this.leadingTabsCount(string, n2);
        if (bl) {
            --n3;
        }
        this.indent(n, n3, n2, string.indexOf("\n", n2) - n2);
    }

    public void indentCurrentParagraph() {
        this.indentCurrentParagraph(this.getTabSize(), false);
    }

    public void indentCurrentParagraph(int n) {
        this.indentCurrentParagraph(n, false);
    }

    public boolean isLeadingTab() {
        try {
            int n;
            for (n = this.getCaretPosition() - 1; n > 0 && this.getDocument().getText(n, 1).equals("\t"); --n) {
            }
            return n == 0 || this.getDocument().getText(n, 1).equals("\n");
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Can't find no tabs, dude.");
            return false;
        }
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public String getPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public File getFile() {
        return this.file;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getDir() {
        String string = "";
        string = this.file.getParent();
        return string != null ? string : "";
    }

    public boolean getAutoIndent() {
        return this.autoIndent;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFile(String string) {
        this.file = new File(string);
    }

    public void setUndoableText(String string) {
        StateEdit stateEdit = new StateEdit(this);
        this.setText(string);
        stateEdit.end();
        this.undoManager.addEdit(stateEdit);
    }

    public void setAutoIndent(boolean bl) {
        this.autoIndent = bl;
        if (this.autoIndent) {
            this.setNoTabs();
            this.setIndentTabs(this.getTabSize());
        } else {
            this.setDefaultTabs(this.getTabSize());
        }
    }

    public boolean fileExists() {
        return this.file.exists();
    }

    public void undo() {
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void applyDocumentSettings() {
        Document document = this.getDocument();
        document.addUndoableEditListener(this.undoManager);
        if (this.autoIndent) {
            this.setIndentTabs(this.getTabSize());
            this.setNoTabs();
        } else {
            this.setDefaultTabs(this.getTabSize());
        }
    }

    public boolean isEmpty() {
        String string = this.getText();
        return string == null || !new StringTokenizer(string).hasMoreTokens();
    }

    public String getAllText() {
        try {
            Document document = this.getDocument();
            int n = document.getLength();
            return document.getText(0, n);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Couldn't get it all.");
            return "";
        }
    }

    public void replaceAllText(String string) {
        try {
            Document document = this.getDocument();
            int n = document.getLength();
            document.remove(0, n);
            document.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Couldn't replace it all.");
        }
    }

    public void viewPlain() {
        StateEdit stateEdit = new StateEdit(this);
        String string = this.getText();
        this.setEditorKit(this.createDefaultEditorKit());
        this.setDocument(this.getEditorKit().createDefaultDocument());
        this.setText(string);
        this.applyDocumentSettings();
        stateEdit.end();
        this.undoManager.addEdit(stateEdit);
    }

    public void viewHTML() {
        StateEdit stateEdit = new StateEdit(this);
        String string = this.getText();
        this.setDocument(this.getEditorKit().createDefaultDocument());
        this.setContentType("text/html");
        this.setText(string);
        this.applyDocumentSettings();
        stateEdit.end();
        this.undoManager.addEdit(stateEdit);
    }

    public void viewRTF() {
        StateEdit stateEdit = new StateEdit(this);
        String string = this.getText();
        this.setDocument(this.getEditorKit().createDefaultDocument());
        this.setContentType("text/rtf");
        this.setText(string);
        this.applyDocumentSettings();
        stateEdit.end();
        this.undoManager.addEdit(stateEdit);
        if (this.getText() == null) {
            this.undo();
        }
    }

    public int getWordPosition() {
        int n;
        int n2 = this.getCaretPosition();
        String string = " .,;:-\\'\"/_\t\n";
        try {
            for (n = n2 - 1; n > 0 && string.indexOf(this.getDocument().getText(n, 1)) != -1; --n) {
            }
            while (n > 0 && string.indexOf(this.getDocument().getText(n - 1, 1)) == -1) {
                --n;
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Ack!  Can't find the beginning of the word.");
        }
        return n <= 0 ? 0 : n;
    }

    public int getNextWordPosition() {
        int n;
        int n2 = this.getText().length();
        String string = " .,;:-\\'\"/_\t\n";
        try {
            int n3;
            for (n = n3 = this.getCaretPosition(); n < n2 && string.indexOf(this.getDocument().getText(n, 1)) == -1; ++n) {
            }
            while (n < n2 && string.indexOf(this.getDocument().getText(n, 1)) != -1) {
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Arrgh!  Can't find the beginning of the word.");
        }
        return n;
    }

    public void autoIndent() {
        try {
            int n = 0;
            int n2 = 0;
            for (n = this.getCaretPosition() - 2; n >= 0 && !this.getDocument().getText(n, 1).equals("\n"); --n) {
            }
            if (n == 0) {
                n = -1;
            }
            n2 = 0;
            while (this.getDocument().getText(++n, 1).equals("\t")) {
                ++n2;
            }
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('\t');
            }
            this.getDocument().insertString(this.getCaretPosition(), stringBuffer.toString(), null);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Insert location " + this.getCaretPosition() + " does not exist");
        }
    }

    private void createActionTable(JTextComponent jTextComponent) {
        this.imap.clear();
        this.amap.clear();
        this.actions = new Hashtable();
        Action[] actionArray = jTextComponent.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            this.actions.put(action.getValue("Name"), action);
        }
    }

    private Action getActionByName(String string) {
        return (Action)this.actions.get(string);
    }

    public void storeState(Hashtable hashtable) {
        hashtable.put("editorkit", this.getEditorKit());
        hashtable.put("doc", this.getStyledDocument());
    }

    public void restoreState(Hashtable hashtable) {
        EditorKit editorKit = (EditorKit)hashtable.get("editorkit");
        StyledDocument styledDocument = (StyledDocument)hashtable.get("doc");
        if (editorKit != null) {
            this.setEditorKit(editorKit);
        }
        if (styledDocument != null) {
            this.setDocument(styledDocument);
        }
    }

    public void paste() {
        int n = this.getCaretPosition();
        super.paste();
        if (this.autoIndent) {
            int n2;
            int n3 = n2 = this.getCaretPosition();
            String string = this.getAllText();
            do {
                this.setCaretPosition(n3);
                this.indentCurrentParagraph();
            } while (n < (n3 = LibJarAjar.reverseIndexOf(string, "\n", n3)));
            this.setCaretPosition(n2);
        }
    }

    public void setTabSize(int n) {
        this.tabSize = n;
    }

    public int getTabSize() {
        return this.tabSize;
    }
}

