/*
 * Decompiled with CFR 0.152.
 */
package com.textflex.jarajar.selfextractor;

import com.textflex.jarajar.common.ExternalEntityResolver;
import com.textflex.jarajar.common.FileOpenAction;
import com.textflex.jarajar.common.ImagePanel;
import com.textflex.jarajar.common.JarAjarXML;
import com.textflex.jarajar.common.LibJarAjar;
import com.textflex.jarajar.common.TextBoard;
import com.textflex.jarajar.common.XMLErrorHandler;
import com.textflex.jarajar.selfextractor.Prefs;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.UIManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SelfExtractor
extends JFrame {
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String EXTRACTOR_FILE = "extractor.xml";
    private static final int WELCOME_STATE_INDEX = 0;
    private static final int LICENSE_STATE_INDEX = 1;
    private static final int EXTRACTION_LOCATION_STATE = 2;
    private static final int EXTRACTION_STATE = 3;
    private static final int WRAP_UP_STATE = 4;
    private static final int ALREADY_INSTALLED_STATE = 5;
    private static final String ARG_FRESH = "--fresh";
    private static final String ARG_RESET_PREFS = "--resetprefs";
    private static final String ARG_PREFIX = "--prefix";
    private boolean fresh = false;
    private boolean resetPrefs = false;
    private String prefix = "";
    private boolean nonInteractive = false;
    private String welcomeMsg = "";
    private String packageName = "";
    private String version = "";
    private String zipPath = "";
    private String logoPath = "";
    private String runAppStr = "";
    private String readmePath = "";
    private String licensePath = "";
    private String installDirPath = "";
    private int silent = 0;
    private Container contentPane = null;
    private ImagePanel logoPanel = null;
    private JScrollPane scrollPane = null;
    private TextBoard notice = null;
    private JTextField input = new JTextField(7);
    private int state = 0;
    private File installLoc = null;
    private JButton aboutButton = null;
    private JButton browseButton = null;
    private JButton backButton = null;
    private JButton nextButton = null;
    private JButton cancelButton = null;
    private JButton gbyeButton = null;
    private static boolean standalone = false;
    private ProgressMonitor progressMonitor = null;
    private JPanel wrapupPanel = null;
    private JCheckBox runAppChkBox = null;
    private JCheckBox readmeChkBox = null;
    private JCheckBox justLaunchChkBox = null;
    private TextBoard noticeWrapup = null;
    private JScrollPane scrollPaneWrapup = null;
    private JRadioButton acceptRadBtn = null;
    private JRadioButton declineRadBtn = null;
    private ButtonGroup acceptDeclineBtnGrp = null;
    private Prefs prefs = new Prefs();
    private Preferences installPrefs = null;

    public SelfExtractor(boolean bl, String[] stringArray) {
        Object object;
        standalone = bl;
        this.filterArgs(stringArray);
        JarAjarXML jarAjarXML = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(true);
            ((DocumentBuilderFactory)object).setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setErrorHandler(new XMLErrorHandler());
            documentBuilder.setEntityResolver(new ExternalEntityResolver());
            Document document = documentBuilder.parse(LibJarAjar.class.getResourceAsStream("/extractor.xml"));
            jarAjarXML = LibJarAjar.parseExtractor(document.getDocumentElement());
            this.welcomeMsg = jarAjarXML.getWelcomeMsg();
            this.packageName = jarAjarXML.getPkgName();
            this.version = jarAjarXML.getVersion();
            this.zipPath = jarAjarXML.getZipPath();
            if (this.zipPath == null || this.zipPath.equals("")) {
                this.zipPath = jarAjarXML.getPkgID() + ".zip";
            }
            this.logoPath = jarAjarXML.getLogoPath();
            this.runAppStr = jarAjarXML.getRunAppStr();
            this.readmePath = jarAjarXML.getReadmePath();
            this.licensePath = jarAjarXML.getLicensePath();
            this.installDirPath = jarAjarXML.getInstallDirPath();
            this.silent = jarAjarXML.getSilent();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.installPrefs = this.prefs.getVersionNode(this.packageName, this.version);
        if (this.getResetPrefs()) {
            this.prefs.resetPrefs(this.installPrefs);
            this.prefs.resetPref(this.installPrefs);
            this.installPrefs = this.prefs.getVersionNode(this.packageName, this.version);
        }
        if (!this.getFresh() && this.installPrefs != null && this.runAppStr != null && !this.runAppStr.equals("")) {
            object = this.prefs.getFirstFile(this.installPrefs);
            if (!((String)object).equals("") && new File((String)object).exists()) {
                this.installLoc = new File(this.prefs.getInstallDir(this.installPrefs));
                if (this.prefs.getJustLaunch(this.installPrefs)) {
                    this.runApp();
                    this.close();
                } else {
                    this.setState(5);
                }
            } else {
                this.prefs.resetPrefs(this.installPrefs);
            }
        }
        this.installDirPath = this.installDirPath.replace("/", File.separator);
        this.installDirPath = this.installDirPath.replace("\\", File.separator);
        this.installDirPath = this.installDirPath.replace("user.home", System.getProperty("user.home"));
        this.installDirPath = this.installDirPath.replace("user.dir", System.getProperty("user.dir"));
        object = new File(this.installDirPath);
        if (this.getNonInteractive()) {
            this.installLoc = new File(this.getPrefix());
            this.extractionNonInteractive(this.getPrefix());
            this.close();
        } else if (this.silent == 1) {
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (((File)object).exists()) {
                this.installLoc = object;
                this.extractionNonInteractive(this.installDirPath);
                this.prefs.storeJustLaunch(this.installPrefs, true);
                this.runApp();
                this.close();
            }
        }
        if (!((File)object).exists()) {
            this.installDirPath = System.getProperty("user.dir");
        }
        int n = 500;
        int n2 = 300;
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SelfExtractor.exit();
            }
        });
        ImageIcon imageIcon = LibJarAjar.makeIcon("/com/textflex/jarajar/common/iconimg-32x32.png");
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        LibJarAjar.setToolTipTiming(1000, 60000);
        new UIBuilder().start();
        this.setTitle(this.packageName + " - Jar Ajar Self-Extractor");
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.getDefaults().put("ToolTipUI", "javax.swing.plaf.basic.BasicToolTipUI");
            if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            String string = "Sorry, couldn't find that look-and-feel.  Defaulting to the Metal one.";
            System.out.println(string);
        }
        SelfExtractor selfExtractor = new SelfExtractor(true, stringArray);
        selfExtractor.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        });
        selfExtractor.setVisible(true);
    }

    public void filterArgs(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(ARG_RESET_PREFS) == 0) {
                this.setResetPrefs(true);
                continue;
            }
            if (stringArray[i].indexOf(ARG_FRESH) == 0) {
                this.setFresh(true);
                continue;
            }
            if (stringArray[i].indexOf(ARG_PREFIX) != 0) continue;
            this.setNonInteractive(true);
            int n = stringArray[i].indexOf("=");
            if (n != -1) {
                this.setPrefix(stringArray[i].substring(++n));
                continue;
            }
            this.prefix = ".";
        }
    }

    public static void exit() {
        System.exit(0);
    }

    public void close() {
        if (standalone) {
            SelfExtractor.exit();
        } else {
            this.dispose();
        }
    }

    public void changeState(int n, boolean bl) throws IOException {
        switch (n) {
            case 0: {
                this.welcomeState();
                break;
            }
            case 1: {
                if (this.licensePath.equals("")) {
                    this.acceptRadBtn.setSelected(true);
                    this.state += bl ? -1 : 1;
                    this.changeState(this.state);
                    break;
                }
                this.licenseDisplayState();
                break;
            }
            case 2: {
                if (!this.acceptRadBtn.isSelected()) {
                    this.cancelExtractionQuery();
                    --this.state;
                    break;
                }
                this.extractLocState();
                break;
            }
            case 3: {
                this.extractState();
                break;
            }
            case 4: {
                this.wrapUpState();
                break;
            }
            case 5: {
                this.alreadyInstalledState();
                break;
            }
            default: {
                this.state = this.state < 0 ? 0 : 1;
            }
        }
    }

    public void changeState(int n) throws IOException {
        this.changeState(n, false);
    }

    public void cancelExtractionQuery() {
        String string = "Cancel and exit";
        Object[] objectArray = new String[]{string, "No"};
        int n = JOptionPane.showOptionDialog(this.getThis(), "The extraction cannot continue without acceptance of the license." + NEWLINE + "Would you like to exit the extraction?", "Extraction cancellation", 0, 3, null, objectArray, string);
        switch (n) {
            case 0: {
                SelfExtractor.exit();
                break;
            }
        }
    }

    public void welcomeState() throws IOException {
        this.backButton.setEnabled(false);
        this.contentPane.remove(this.acceptRadBtn);
        this.contentPane.remove(this.declineRadBtn);
        this.contentPane.remove(this.input);
        this.contentPane.remove(this.browseButton);
        this.contentPane.validate();
        this.input.setEditable(false);
        this.browseButton.setEnabled(false);
        this.notice.setEditable(false);
        this.notice.viewHTML();
        this.notice.setText(this.convertToStandardFont(this.welcomeMsg));
        this.notice.setCaretPosition(0);
    }

    public void licenseDisplayState() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.contentPane.remove(this.input);
        this.contentPane.remove(this.browseButton);
        this.declineRadBtn.setSelected(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        LibJarAjar.addGridBagComponent(this.acceptRadBtn, gridBagConstraints, 1, 1, 2, 1, 100, 0, this.contentPane);
        LibJarAjar.addGridBagComponent(this.declineRadBtn, gridBagConstraints, 3, 1, 1, 1, 100, 0, this.contentPane);
        this.contentPane.validate();
        this.notice.viewPlain();
        this.notice.setText("");
        String string = LibJarAjar.readText(this.licensePath, true, true);
        LibJarAjar.appendToNotice(string, this.notice);
        this.notice.setCaretPosition(0);
    }

    public String convertToStandardFont(String string) {
        return "<font face=\"sans serif\" size=\"-1\">" + NEWLINE + string + NEWLINE + "</font>";
    }

    public void extractLocState() {
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.contentPane.remove(this.acceptRadBtn);
        this.contentPane.remove(this.declineRadBtn);
        this.browseButton.setEnabled(true);
        this.input.setEditable(true);
        this.input.setText(this.installDirPath);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        LibJarAjar.addGridBagComponent(this.input, gridBagConstraints, 1, 1, 2, 1, 100, 0, this.contentPane);
        LibJarAjar.addGridBagComponent(this.browseButton, gridBagConstraints, 3, 1, 1, 1, 100, 0, this.contentPane);
        this.contentPane.validate();
        this.notice.viewPlain();
        String string = "Where would you like to extract the package contents? ";
        this.notice.setText("");
        LibJarAjar.appendToNotice(string, this.notice);
    }

    public void extractState() throws IOException {
        this.input.setEditable(false);
        this.backButton.setEnabled(false);
        this.browseButton.setEnabled(false);
        String string = this.input.getText();
        this.installLoc = new File(string);
        this.notice.setText("Extracting files to " + string + "\n");
        this.zipPath = "/" + this.zipPath;
        InputStream inputStream = SelfExtractor.class.getResourceAsStream(this.zipPath);
        if (inputStream == null) {
            this.pkgBugNotice();
            return;
        }
        String string2 = "Extracting files...";
        ProgressMonitorInputStream progressMonitorInputStream = new ProgressMonitorInputStream(this, string2, inputStream);
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(progressMonitorInputStream));
        this.extractionThreaded(zipInputStream, string, this.notice);
    }

    public void extraction(ZipInputStream zipInputStream, String string, JTextPane jTextPane) {
        ArrayList arrayList = new ArrayList(100);
        if (!LibJarAjar.unzip(zipInputStream, string, jTextPane, true, arrayList)) {
            String string2 = "Sorry, but the extraction couldn't " + NEWLINE + "be completed. It may have been canceled, or you" + NEWLINE + "you may need to try another install location.";
            this.unzipError(string2);
            this.backButton.setEnabled(true);
            this.nextButton.setSelected(false);
            this.nextButton.setEnabled(false);
        } else {
            LibJarAjar.appendToNotice("Done deal.", jTextPane, true);
            this.prefs.resetPrefs(this.installPrefs);
            if (arrayList.size() > 0) {
                this.installPrefs = this.prefs.storeInstallationPrefs(this.packageName, this.version, string, (String)arrayList.get(0));
            }
        }
    }

    public void extractionThreaded(final ZipInputStream zipInputStream, final String string, final JTextPane jTextPane) {
        Thread thread = new Thread(){

            public void run() {
                SelfExtractor.this.extraction(zipInputStream, string, jTextPane);
            }
        };
        thread.start();
    }

    public void extractionNonInteractive(String string) {
        this.zipPath = "/" + this.zipPath;
        InputStream inputStream = SelfExtractor.class.getResourceAsStream(this.zipPath);
        if (inputStream == null) {
            this.pkgBugNotice();
            return;
        }
        System.out.println("The files to be extracted are subject to the terms" + NEWLINE + "of any provided license.");
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
        this.extraction(zipInputStream, string, null);
    }

    public void wrapUpState() {
        this.contentPane.remove(this.scrollPane);
        this.contentPane.remove(this.cancelButton);
        this.nextButton.setEnabled(false);
        this.nextButton.setSelected(false);
        String string = this.packageName + " has been installed to " + NEWLINE + this.installLoc.getPath() + "." + NEWLINE + "Thank you for using the Jar Ajar self-extractor!";
        LibJarAjar.appendToNotice(string, this.noticeWrapup);
        this.noticeWrapup.setCaretPosition(0);
        if (this.runAppStr.equals("")) {
            this.wrapupPanel.remove(this.runAppChkBox);
        }
        if (this.readmePath.equals("")) {
            this.wrapupPanel.remove(this.readmeChkBox);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        LibJarAjar.addGridBagComponent(this.wrapupPanel, gridBagConstraints, 1, 0, 3, 1, 100, 100, this.contentPane);
        LibJarAjar.addGridBagComponent(this.gbyeButton, gridBagConstraints, 3, 2, 1, 1, 100, 0, this.contentPane);
        this.contentPane.validate();
        this.gbyeButton.setSelected(true);
        this.gbyeButton.requestFocusInWindow();
    }

    public void alreadyInstalledState() {
        this.contentPane.remove(this.scrollPane);
        this.contentPane.remove(this.cancelButton);
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.nextButton.setSelected(false);
        this.gbyeButton.setText("Go");
        String string = this.packageName + " was installed to " + this.installLoc + "." + "To reinstall it, remove the files installed to this directory." + "Would you like to run/view it now?";
        LibJarAjar.appendToNotice(string, this.noticeWrapup);
        this.noticeWrapup.setCaretPosition(0);
        this.readmeChkBox.setSelected(false);
        this.justLaunchChkBox.setSelected(true);
        if (this.runAppStr.equals("")) {
            this.wrapupPanel.remove(this.runAppChkBox);
        }
        if (this.readmePath.equals("")) {
            this.wrapupPanel.remove(this.readmeChkBox);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        LibJarAjar.addGridBagComponent(this.justLaunchChkBox, gridBagConstraints, 0, 3, 1, 1, 100, 100, this.wrapupPanel);
        this.wrapupPanel.validate();
        LibJarAjar.addGridBagComponent(this.wrapupPanel, gridBagConstraints, 1, 0, 3, 1, 100, 100, this.contentPane);
        LibJarAjar.addGridBagComponent(this.gbyeButton, gridBagConstraints, 3, 2, 1, 1, 100, 0, this.contentPane);
        this.contentPane.validate();
        this.gbyeButton.requestFocusInWindow();
    }

    private void pkgBugNotice() {
        String string = "Hm, either there's a bug in this program or what's running it, or this archive hasn't been packaged properly.  Please check back with whoever packaged it or Ajar Jar.";
        LibJarAjar.appendToNotice(string, this.notice);
    }

    private void unzipError(String string) {
        LibJarAjar.appendToNotice(string, this.notice);
        if (this.backButton != null) {
            this.backButton.setEnabled(true);
        }
    }

    public void runApp() {
        String[] stringArray;
        if (this.runAppStr != null && !this.runAppStr.equals("") && (stringArray = this.runAppStr.split(" ")).length > 0) {
            if (stringArray[0].equals("java")) {
                stringArray[0] = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            }
            try {
                Runtime.getRuntime().exec(stringArray, null, this.installLoc);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static void setStandalone(boolean bl) {
        standalone = bl;
    }

    public void setResetPrefs(boolean bl) {
        this.resetPrefs = bl;
    }

    public void setFresh(boolean bl) {
        this.fresh = bl;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setNonInteractive(boolean bl) {
        this.nonInteractive = bl;
    }

    public static boolean getStandalone() {
        return standalone;
    }

    public boolean getResetPrefs() {
        return this.resetPrefs;
    }

    public boolean getFresh() {
        return this.fresh;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean getNonInteractive() {
        return this.nonInteractive;
    }

    private JFrame getThis() {
        return this;
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    private class UIBuilder
    implements Runnable {
        private UIBuilder() {
        }

        public void start() {
            new Thread((Runnable)this, "thread").start();
        }

        public void run() {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SelfExtractor.this.logoPanel = new ImagePanel("/" + SelfExtractor.this.logoPath);
                    SelfExtractor.this.notice = new TextBoard();
                    SelfExtractor.this.scrollPane = new JScrollPane(SelfExtractor.this.notice, 20, 31);
                    SelfExtractor.this.scrollPane.setBorder(null);
                    String string = "/com/textflex/jarajar/common/logo-packaged.png";
                    AbstractAction abstractAction = new AbstractAction("", LibJarAjar.makeIcon(string)){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                LibJarAjar.aboutDialog(SelfExtractor.this, LibJarAjar.makeIcon("/com/textflex/jarajar/common/logo.png"), true);
                            }
                            catch (IOException iOException) {
                                String string = "Please see http://textflex/jarajar for more info\nabout the Jar Ajar self-extractor.";
                                System.out.println(string);
                            }
                        }
                    };
                    SelfExtractor.this.aboutButton = new JButton(abstractAction);
                    SelfExtractor.this.aboutButton.setBorderPainted(false);
                    AbstractAction abstractAction2 = new AbstractAction("Back"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                SelfExtractor.this.changeState(--SelfExtractor.this.state, true);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    };
                    LibJarAjar.setAcceleratedAction(abstractAction2, "Back", 'B', KeyStroke.getKeyStroke("alt B"));
                    SelfExtractor.this.backButton = new JButton(abstractAction2);
                    SelfExtractor.this.backButton.setBorderPainted(false);
                    AbstractAction abstractAction3 = new AbstractAction("Next"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            try {
                                SelfExtractor.this.changeState(++SelfExtractor.this.state);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    };
                    LibJarAjar.setAcceleratedAction(abstractAction3, "Next", 'N', KeyStroke.getKeyStroke("alt N"));
                    SelfExtractor.this.nextButton = new JButton(abstractAction3);
                    SelfExtractor.this.nextButton.setBorderPainted(false);
                    SelfExtractor.this.nextButton.setSelected(true);
                    SelfExtractor.this.acceptRadBtn = new JRadioButton("Accept", false);
                    SelfExtractor.this.declineRadBtn = new JRadioButton("Decline", true);
                    SelfExtractor.this.acceptDeclineBtnGrp = new ButtonGroup();
                    SelfExtractor.this.acceptDeclineBtnGrp.add(SelfExtractor.this.acceptRadBtn);
                    SelfExtractor.this.acceptDeclineBtnGrp.add(SelfExtractor.this.declineRadBtn);
                    FileOpenAction fileOpenAction = new FileOpenAction(SelfExtractor.this, "Browse", null, SelfExtractor.this.input, 2, false);
                    LibJarAjar.setAcceleratedAction(fileOpenAction, "Browse", 'R', KeyStroke.getKeyStroke("alt R"));
                    SelfExtractor.this.browseButton = new JButton(fileOpenAction);
                    SelfExtractor.this.browseButton.setBorderPainted(false);
                    SelfExtractor.this.browseButton.setEnabled(false);
                    fileOpenAction.setChooserDirectory(SelfExtractor.this.installDirPath);
                    AbstractAction abstractAction4 = new AbstractAction("Cancel"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SelfExtractor.this.close();
                        }
                    };
                    LibJarAjar.setAcceleratedAction(abstractAction4, "Cancel and Exit", 'C', KeyStroke.getKeyStroke("alt C"));
                    SelfExtractor.this.cancelButton = new JButton(abstractAction4);
                    SelfExtractor.this.cancelButton.setBorderPainted(false);
                    AbstractAction abstractAction5 = new AbstractAction("Done"){

                        public void actionPerformed(ActionEvent actionEvent) {
                            File file;
                            if (SelfExtractor.this.runAppChkBox.isSelected() || SelfExtractor.this.justLaunchChkBox.isSelected()) {
                                SelfExtractor.this.runApp();
                            }
                            if (SelfExtractor.this.readmeChkBox.isSelected() && SelfExtractor.this.readmePath != null && (file = new File(SelfExtractor.this.installLoc, SelfExtractor.this.readmePath)).isFile()) {
                                String string = LibJarAjar.readText(file);
                                LibJarAjar.msgDialog(SelfExtractor.this.getThis(), null, string, SelfExtractor.this.packageName + "Readme.", 1, null, 450, 400, false);
                            }
                            if (SelfExtractor.this.justLaunchChkBox.isSelected()) {
                                SelfExtractor.this.prefs.storeJustLaunch(SelfExtractor.this.installPrefs, true);
                            }
                            SelfExtractor.this.close();
                        }
                    };
                    LibJarAjar.setAcceleratedAction(abstractAction5, "gbye and Exit", 'C', KeyStroke.getKeyStroke("alt C"));
                    SelfExtractor.this.gbyeButton = new JButton(abstractAction5);
                    SelfExtractor.this.gbyeButton.setBorderPainted(false);
                    SelfExtractor.this.contentPane = SelfExtractor.this.getContentPane();
                    GridBagLayout gridBagLayout = new GridBagLayout();
                    SelfExtractor.this.contentPane.setLayout(gridBagLayout);
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 10;
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.logoPanel, gridBagConstraints, 0, 0, 1, 1, 100, 100, SelfExtractor.this.contentPane);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.aboutButton, gridBagConstraints, 0, 1, 1, 2, 100, 0, SelfExtractor.this.contentPane);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.scrollPane, gridBagConstraints, 1, 0, 3, 1, 100, 100, SelfExtractor.this.contentPane);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.backButton, gridBagConstraints, 1, 2, 1, 1, 100, 0, SelfExtractor.this.contentPane);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.nextButton, gridBagConstraints, 2, 2, 1, 1, 100, 0, SelfExtractor.this.contentPane);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.cancelButton, gridBagConstraints, 3, 2, 1, 1, 100, 0, SelfExtractor.this.contentPane);
                    SelfExtractor.this.contentPane.validate();
                    SelfExtractor.this.nextButton.requestFocusInWindow();
                    SelfExtractor.this.wrapupPanel = new JPanel();
                    SelfExtractor.this.noticeWrapup = new TextBoard();
                    SelfExtractor.this.noticeWrapup.setEditable(false);
                    SelfExtractor.this.scrollPaneWrapup = new JScrollPane(SelfExtractor.this.noticeWrapup, 20, 31);
                    SelfExtractor.this.scrollPaneWrapup.setBorder(null);
                    SelfExtractor.this.runAppChkBox = new JCheckBox("Run " + SelfExtractor.this.packageName);
                    SelfExtractor.this.runAppChkBox.setSelected(true);
                    SelfExtractor.this.readmeChkBox = new JCheckBox("Open readme");
                    SelfExtractor.this.readmeChkBox.setSelected(true);
                    SelfExtractor.this.justLaunchChkBox = new JCheckBox("Don't show this message again; just launch");
                    SelfExtractor.this.justLaunchChkBox.setSelected(false);
                    SelfExtractor.this.wrapupPanel.setLayout(gridBagLayout);
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.anchor = 10;
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.scrollPaneWrapup, gridBagConstraints, 0, 0, 1, 1, 100, 100, SelfExtractor.this.wrapupPanel);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.runAppChkBox, gridBagConstraints, 0, 1, 1, 1, 100, 100, SelfExtractor.this.wrapupPanel);
                    LibJarAjar.addGridBagComponent(SelfExtractor.this.readmeChkBox, gridBagConstraints, 0, 2, 1, 1, 100, 100, SelfExtractor.this.wrapupPanel);
                    SelfExtractor.this.wrapupPanel.validate();
                    try {
                        SelfExtractor.this.changeState(SelfExtractor.this.state);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
        }
    }
}

