/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsDevice;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.MenuSelectionManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.bufferset.BufferSetManager;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowFactory;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.DockingFrameworkProvider;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.StatusBar;
import org.gjt.sp.jedit.gui.ToolBarManager;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchBar;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.ScrollListener;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.visitors.JEditVisitor;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class View
extends JFrame
implements InputHandlerProvider {
    public static final String VIEW_DOCKING_FRAMEWORK_PROPERTY = "view.docking.framework";
    private static final String ORIGINAL_DOCKING_FRAMEWORK = "Original";
    public static final String DOCKING_FRAMEWORK_PROVIDER_SERVICE = "org.gjt.sp.jedit.gui.DockingFrameworkProvider";
    private static DockingFrameworkProvider dockingFrameworkProvider;
    public static final int TOP_GROUP = 0;
    public static final int BOTTOM_GROUP = 1;
    public static final int DEFAULT_GROUP = 0;
    public static final int TOP_LAYER = Integer.MAX_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int BOTTOM_LAYER = Integer.MIN_VALUE;
    public static final int ABOVE_SYSTEM_BAR_LAYER = 150;
    public static final int SYSTEM_BAR_LAYER = 100;
    public static final int BELOW_SYSTEM_BAR_LAYER = 75;
    public static final int SEARCH_BAR_LAYER = 75;
    public static final int BELOW_SEARCH_BAR_LAYER = 50;
    public static final int ACTION_BAR_LAYER = -75;
    public static final int STATUS_BAR_LAYER = -100;
    public static final int BELOW_STATUS_BAR_LAYER = -150;
    public static final int VIEW = 0;
    public static final int TEXT_AREA = 1;
    public static final int ACTION_BAR = 2;
    View prev;
    View next;
    private boolean closed;
    private final DockableWindowManager dockableWindowManager;
    private final JPanel mainPanel;
    private final JPanel topToolBars;
    private final JPanel bottomToolBars;
    private ToolBarManager toolBarManager;
    private Container toolBar;
    private SearchBar searchBar;
    private ActionBar actionBar;
    private EditPane editPane;
    private JSplitPane splitPane;
    private String lastSplitConfig;
    private final StatusBar status;
    private InputHandler inputHandler;
    private Macros.Recorder recorder;
    private Component prefixFocusOwner;
    private int waitCount;
    private boolean showFullPath;
    private final boolean plainView;
    private Socket waitSocket;
    private Component mainContent;
    private boolean fullScreenMode = false;
    private Rectangle windowedBounds;
    private JMenuBar menuBar = null;
    private String userTitle;

    public DockableWindowManager getDockableWindowManager() {
        return this.dockableWindowManager;
    }

    public static String getDockingFrameworkName() {
        String framework = jEdit.getProperty(VIEW_DOCKING_FRAMEWORK_PROPERTY, ORIGINAL_DOCKING_FRAMEWORK);
        return framework;
    }

    public static DockingFrameworkProvider getDockingFrameworkProvider() {
        String framework;
        if (dockingFrameworkProvider == null && (dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, framework = View.getDockingFrameworkName())) == null) {
            Log.log(9, View.class, "No docking framework " + framework + " available, using the original one");
            dockingFrameworkProvider = (DockingFrameworkProvider)ServiceManager.getService(DOCKING_FRAMEWORK_PROVIDER_SERVICE, ORIGINAL_DOCKING_FRAMEWORK);
        }
        return dockingFrameworkProvider;
    }

    public Container getToolBar() {
        return this.toolBar;
    }

    public void addToolBar(Component toolBar) {
        this.addToolBar(0, 0, toolBar);
    }

    public void addToolBar(int group, Component toolBar) {
        this.addToolBar(group, 0, toolBar);
    }

    public void addToolBar(int group, int layer, Component toolBar) {
        this.toolBarManager.addToolBar(group, layer, toolBar);
        this.getRootPane().revalidate();
    }

    public void removeToolBar(Component toolBar) {
        if (this.toolBarManager == null) {
            return;
        }
        if (toolBar == null) {
            return;
        }
        this.toolBarManager.removeToolBar(toolBar);
        this.getRootPane().revalidate();
    }

    public synchronized void showWaitCursor() {
        if (this.waitCount++ == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(3);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public synchronized void hideWaitCursor() {
        if (this.waitCount > 0) {
            --this.waitCount;
        }
        if (this.waitCount == 0) {
            Cursor cursor = Cursor.getPredefinedCursor(0);
            this.setCursor(cursor);
            this.visit(new SetCursorVisitor(cursor));
        }
    }

    public final SearchBar getSearchBar() {
        return this.searchBar;
    }

    public final ActionBar getActionBar() {
        return this.actionBar;
    }

    public StatusBar getStatus() {
        return this.status;
    }

    public void quickIncrementalSearch(boolean word) {
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(false);
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            } else if (text.indexOf(10) != -1) {
                text = null;
            }
            if (text != null && SearchAndReplace.getRegexp()) {
                text = SearchAndReplace.escapeRegexp(text, false);
            }
            this.searchBar.getField().setText(text);
        }
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void quickHyperSearch(boolean word) {
        JEditTextArea textArea = this.getTextArea();
        if (word) {
            String text = textArea.getSelectedText();
            if (text == null) {
                textArea.selectWord();
                text = textArea.getSelectedText();
            }
            if (text != null && text.indexOf(10) == -1) {
                if (SearchAndReplace.getRegexp()) {
                    text = SearchAndReplace.escapeRegexp(text, false);
                }
                HistoryModel.getModel("find").addItem(text);
                SearchAndReplace.setSearchString(text);
                SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
                SearchAndReplace.hyperSearch(this);
                return;
            }
        }
        if (this.searchBar == null) {
            this.searchBar = new SearchBar(this, true);
        }
        if (this.searchBar.getParent() == null) {
            this.addToolBar(0, 75, this.searchBar);
        }
        this.searchBar.setHyperSearch(true);
        this.searchBar.getField().setText(null);
        this.searchBar.getField().requestFocus();
        this.searchBar.getField().selectAll();
    }

    public void actionBar() {
        if (this.actionBar == null) {
            this.actionBar = new ActionBar(this, true);
        }
        if (this.actionBar.getParent() == null) {
            this.addToolBar(1, -75, this.actionBar);
        }
        this.actionBar.goToActionBar();
    }

    public KeyListener getKeyEventInterceptor() {
        return this.inputHandler.getKeyEventInterceptor();
    }

    public void setKeyEventInterceptor(KeyListener listener) {
        this.inputHandler.setKeyEventInterceptor(listener);
    }

    @Override
    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public Macros.Recorder getMacroRecorder() {
        return this.recorder;
    }

    public void setMacroRecorder(Macros.Recorder recorder) {
        this.recorder = recorder;
    }

    @Override
    public void processKeyEvent(KeyEvent evt) {
        this.inputHandler.processKeyEvent(evt, 0, false);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public void processKeyEvent(KeyEvent evt, boolean calledFromTextArea) {
        this.processKeyEvent(evt, calledFromTextArea ? 1 : 0);
    }

    public void processKeyEvent(KeyEvent evt, int from) {
        this.inputHandler.processKeyEvent(evt, from, false);
        if (!evt.isConsumed()) {
            super.processKeyEvent(evt);
        }
    }

    public EditPane splitHorizontally() {
        return this.split(0);
    }

    public EditPane splitVertically() {
        return this.split(1);
    }

    public EditPane split(int orientation) {
        PerspectiveManager.setPerspectiveDirty(true);
        this.editPane.saveCaretInfo();
        EditPane oldEditPane = this.editPane;
        EditPane newEditPane = this.createEditPane(oldEditPane.getBufferSet(), oldEditPane.getBuffer());
        newEditPane.loadCaretInfo();
        JComponent oldParent = (JComponent)oldEditPane.getParent();
        final JSplitPane newSplitPane = new JSplitPane(orientation);
        newSplitPane.setOneTouchExpandable(true);
        newSplitPane.setBorder(null);
        newSplitPane.setMinimumSize(new Dimension(0, 0));
        newSplitPane.setResizeWeight(0.5);
        int parentSize = orientation == 0 ? oldEditPane.getHeight() : oldEditPane.getWidth();
        final int dividerPosition = (int)((double)(parentSize - newSplitPane.getDividerSize()) * 0.5);
        newSplitPane.setDividerLocation(dividerPosition);
        if (oldParent instanceof JSplitPane) {
            JSplitPane oldSplitPane = (JSplitPane)oldParent;
            int dividerPos = oldSplitPane.getDividerLocation();
            Component left = oldSplitPane.getLeftComponent();
            if (left == oldEditPane) {
                oldSplitPane.setLeftComponent(newSplitPane);
            } else {
                oldSplitPane.setRightComponent(newSplitPane);
            }
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            oldSplitPane.setDividerLocation(dividerPos);
        } else {
            this.splitPane = newSplitPane;
            newSplitPane.setLeftComponent(oldEditPane);
            newSplitPane.setRightComponent(newEditPane);
            this.setMainContent(newSplitPane);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                newSplitPane.setDividerLocation(dividerPosition);
            }
        });
        newEditPane.focusOnTextArea();
        return newEditPane;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            for (EditPane _editPane : this.getEditPanes()) {
                if (this.editPane == _editPane) continue;
                if (scope == BufferSet.Scope.editpane) {
                    View.mergeBufferSets(this.editPane, _editPane);
                }
                _editPane.close();
            }
            this.setMainContent(this.editPane);
            this.splitPane = null;
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            JComponent parent;
            Container comp;
            this.lastSplitConfig = this.getSplitConfig();
            PerspectiveManager.setPerspectiveDirty(true);
            for (comp = this.editPane; !(comp instanceof JSplitPane) && comp != null; comp = comp.getParent()) {
            }
            BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
            for (EditPane _editPane : this.getEditPanes()) {
                if (!GUIUtilities.isAncestorOf(comp, _editPane) || _editPane == this.editPane) continue;
                if (scope == BufferSet.Scope.editpane) {
                    View.mergeBufferSets(this.editPane, _editPane);
                }
                _editPane.close();
            }
            JComponent jComponent = parent = comp == null ? null : (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                JSplitPane parentSplit = (JSplitPane)parent;
                int pos = parentSplit.getDividerLocation();
                if (parentSplit.getLeftComponent() == comp) {
                    parentSplit.setLeftComponent(this.editPane);
                } else {
                    parentSplit.setRightComponent(this.editPane);
                }
                parentSplit.setDividerLocation(pos);
                parent.revalidate();
            } else {
                this.setMainContent(this.editPane);
                this.splitPane = null;
            }
            this.updateTitle();
            this.editPane.focusOnTextArea();
        } else {
            this.getToolkit().beep();
        }
    }

    public void resplit() {
        if (this.lastSplitConfig == null) {
            this.getToolkit().beep();
        } else {
            this.setSplitConfig(null, this.lastSplitConfig);
        }
    }

    public String getSplitConfig() {
        StringBuilder splitConfig = new StringBuilder();
        if (this.splitPane != null) {
            View.getSplitConfig(this.splitPane, splitConfig);
        } else {
            View.appendToSplitConfig(splitConfig, this.editPane);
        }
        return splitConfig.toString();
    }

    public void setSplitConfig(Buffer buffer, String splitConfig) {
        try {
            Component comp = this.restoreSplitConfig(buffer, splitConfig);
            this.setMainContent(comp);
            this.updateTitle();
        }
        catch (IOException e) {
            throw new InternalError();
        }
    }

    public void nextTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == editPanes.length - 1) {
                editPanes[0].focusOnTextArea();
                break;
            }
            editPanes[i + 1].focusOnTextArea();
            break;
        }
    }

    public void prevTextArea() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            if (this.editPane != editPanes[i]) continue;
            if (i == 0) {
                editPanes[editPanes.length - 1].focusOnTextArea();
                break;
            }
            editPanes[i - 1].focusOnTextArea();
            break;
        }
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public Buffer getBuffer() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getBuffer();
    }

    public Buffer[] getBuffers() {
        BufferSetManager mgr = jEdit.getBufferSetManager();
        HashSet retval = new HashSet();
        for (EditPane ep : this.getEditPanes()) {
            BufferSet bs = ep.getBufferSet();
            Collections.addAll(retval, bs.getAllBuffers());
            if (mgr.getScope() != BufferSet.Scope.editpane) break;
        }
        Buffer[] bufs = new Buffer[retval.size()];
        retval.toArray(bufs);
        return bufs;
    }

    public void setBuffer(Buffer buffer) {
        this.editPane.setBuffer(buffer);
    }

    public EditPane goToBuffer(Buffer buffer) {
        return this.showBuffer(buffer, true);
    }

    public EditPane showBuffer(Buffer buffer) {
        return this.showBuffer(buffer, false);
    }

    public JEditTextArea getTextArea() {
        if (this.editPane == null) {
            return null;
        }
        return this.editPane.getTextArea();
    }

    public EditPane getEditPane() {
        return this.editPane;
    }

    public EditPane[] getEditPanes() {
        if (this.splitPane == null) {
            EditPane[] ep = new EditPane[]{this.editPane};
            return ep;
        }
        ArrayList<EditPane> vec = new ArrayList<EditPane>();
        View.getEditPanes(vec, this.splitPane);
        EditPane[] ep = new EditPane[vec.size()];
        vec.toArray(ep);
        return ep;
    }

    public ViewConfig getViewConfig() {
        ViewConfig config = new ViewConfig();
        config.plainView = this.isPlainView();
        config.splitConfig = this.getSplitConfig();
        config.extState = this.getExtendedState();
        config.docking = this.dockableWindowManager.getDockingLayout(config);
        config.title = this.userTitle;
        String prefix = config.plainView ? "plain-view" : "view";
        switch (config.extState) {
            case 1: 
            case 6: {
                config.x = jEdit.getIntegerProperty(prefix + ".x", this.getX());
                config.y = jEdit.getIntegerProperty(prefix + ".y", this.getY());
                config.width = jEdit.getIntegerProperty(prefix + ".width", this.getWidth());
                config.height = jEdit.getIntegerProperty(prefix + ".height", this.getHeight());
                break;
            }
            case 4: {
                config.x = this.getX();
                config.y = jEdit.getIntegerProperty(prefix + ".y", this.getY());
                config.width = this.getWidth();
                config.height = jEdit.getIntegerProperty(prefix + ".height", this.getHeight());
                break;
            }
            case 2: {
                config.x = jEdit.getIntegerProperty(prefix + ".x", this.getX());
                config.y = this.getY();
                config.width = jEdit.getIntegerProperty(prefix + ".width", this.getWidth());
                config.height = this.getHeight();
                break;
            }
            default: {
                config.x = this.getX();
                config.y = this.getY();
                config.width = this.getWidth();
                config.height = this.getHeight();
            }
        }
        return config;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPlainView() {
        return this.plainView;
    }

    public View getNext() {
        return this.next;
    }

    public View getPrev() {
        return this.prev;
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged msg) {
        this.propertiesChanged();
    }

    @EditBus.EBHandler
    public void handleSearchSettingsChanged(SearchSettingsChanged msg) {
        if (this.searchBar != null) {
            this.searchBar.update();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setWaitSocket(Socket waitSocket) {
        this.waitSocket = waitSocket;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '[' + (jEdit.getActiveView() == this ? "active" : "inactive") + ']';
    }

    public void updateTitle() {
        ArrayList<Buffer> buffers = new ArrayList<Buffer>();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            Buffer buffer = editPanes[i].getBuffer();
            if (buffers.contains(buffer)) continue;
            buffers.add(buffer);
        }
        StringBuilder title = new StringBuilder();
        if (!OperatingSystem.isMacOS()) {
            if (this.userTitle != null) {
                title.append(this.userTitle);
            } else {
                title.append(jEdit.getProperty("view.title"));
            }
        }
        for (int i = 0; i < buffers.size(); ++i) {
            if (i != 0) {
                title.append(", ");
            }
            Buffer buffer = (Buffer)buffers.get(i);
            title.append(this.showFullPath && !buffer.isNewFile() ? buffer.getPath(true) : buffer.getName());
            if (!buffer.isDirty()) continue;
            title.append(jEdit.getProperty("view.title.dirty"));
        }
        this.setTitle(title.toString());
    }

    public void setUserTitle(String title) {
        this.userTitle = title + " - ";
        this.updateTitle();
    }

    public void showUserTitleDialog() {
        String title = JOptionPane.showInputDialog(this, (Object)jEdit.getProperty("view.title.select"));
        if (title == null) {
            return;
        }
        this.setUserTitle(title);
    }

    public Component getPrefixFocusOwner() {
        return this.prefixFocusOwner;
    }

    public void setPrefixFocusOwner(Component prefixFocusOwner) {
        this.prefixFocusOwner = prefixFocusOwner;
    }

    public void visit(JEditVisitor visitor) {
        EditPane[] panes = this.getEditPanes();
        for (int i = 0; i < panes.length; ++i) {
            EditPane editPane = panes[i];
            visitor.visit(editPane);
            visitor.visit(editPane.getTextArea());
        }
    }

    public void closeAllMenus() {
        MenuSelectionManager.defaultManager().clearSelectedPath();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
    }

    View(Buffer buffer, ViewConfig config) {
        this.plainView = config.plainView;
        this.enableEvents(8L);
        if (!OperatingSystem.isMacOS()) {
            this.setIconImage(GUIUtilities.getEditorIcon());
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.dockableWindowManager = View.getDockingFrameworkProvider().create(this, DockableWindowFactory.getInstance(), config);
        this.userTitle = config.title;
        this.dockableWindowManager.setMainPanel(this.mainPanel);
        this.topToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.bottomToolBars = new JPanel(new VariableGridLayout(2, 1));
        this.toolBarManager = new ToolBarManager(this.topToolBars, this.bottomToolBars);
        this.status = new StatusBar(this);
        this.inputHandler = new DefaultInputHandler(this, (DefaultInputHandler)jEdit.getInputHandler());
        this.setSplitConfig(buffer, config.splitConfig);
        this.getContentPane().add("Center", this.dockableWindowManager);
        this.dockableWindowManager.init();
        this.propertiesChanged();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowHandler());
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        EditBus.addToBus(this);
        GUIUtilities.addSizeSaver(this, null, this.plainView ? "plain-view" : "view");
    }

    public void updateFullScreenProps() {
        boolean alternateLayout = jEdit.getBooleanProperty("view.toolbar.alternateLayout");
        boolean showMenu = jEdit.getBooleanProperty("fullScreenIncludesMenu");
        boolean showToolbars = jEdit.getBooleanProperty("fullScreenIncludesToolbar");
        boolean showStatus = jEdit.getBooleanProperty("fullScreenIncludesStatus");
        if (!showMenu) {
            this.menuBar = this.getJMenuBar();
            this.setJMenuBar(null);
        } else if (this.menuBar != null) {
            this.setJMenuBar(this.menuBar);
        }
        this.loadToolBars();
        if (alternateLayout) {
            if (!showStatus) {
                this.removeToolBar(this.status);
            } else {
                this.addToolBar(1, -100, this.status);
            }
        } else if (!showStatus) {
            this.getContentPane().remove(this.status);
        } else {
            this.getContentPane().add("South", this.status);
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void toggleFullScreen() {
        this.fullScreenMode = !this.fullScreenMode;
        GraphicsDevice sd = this.getGraphicsConfiguration().getDevice();
        this.dispose();
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
            this.windowedBounds = this.getBounds();
            this.setUndecorated(true);
            this.setBounds(sd.getDefaultConfiguration().getBounds());
            this.validate();
        } else {
            boolean showStatus;
            boolean bl = showStatus = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
            if (this.menuBar != null && this.getJMenuBar() != this.menuBar) {
                this.setJMenuBar(this.menuBar);
            }
            boolean alternateLayout = jEdit.getBooleanProperty("view.toolbar.alternateLayout");
            this.loadToolBars();
            if (showStatus) {
                if (alternateLayout) {
                    this.addToolBar(1, -100, this.status);
                } else {
                    this.getContentPane().add("South", this.status);
                }
            }
            this.setUndecorated(false);
            this.setBounds(this.windowedBounds);
        }
        this.setVisible(true);
        this.toFront();
        this.closeAllMenus();
        this.editPane.getTextArea().requestFocus();
    }

    boolean confirmToCloseDirty() {
        Set<Buffer> checkingBuffers = this.getOpenBuffers();
        for (View view : jEdit.getViews()) {
            if (view == this) continue;
            checkingBuffers.removeAll(view.getOpenBuffers());
        }
        for (Buffer buffer : checkingBuffers) {
            if (!buffer.isDirty()) continue;
            return new CloseDialog(this, checkingBuffers).isOK();
        }
        return true;
    }

    void close() {
        EditBus.send(new ViewUpdate(this, ViewUpdate.CLOSED));
        this.closed = true;
        this.dockableWindowManager.close();
        EditBus.removeFromBus(this);
        this.dispose();
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].close();
        }
        this.toolBarManager = null;
        this.toolBar = null;
        this.searchBar = null;
        this.splitPane = null;
        this.inputHandler = null;
        this.recorder = null;
        this.getContentPane().removeAll();
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setMainContent(Component c) {
        if (this.mainContent != null) {
            this.mainPanel.remove(this.mainContent);
        }
        this.mainContent = c;
        this.mainPanel.add(this.mainContent, "Center");
        if (c instanceof JSplitPane) {
            this.splitPane = (JSplitPane)c;
        } else {
            this.splitPane = null;
            this.editPane = (EditPane)c;
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private static void getEditPanes(List<EditPane> vec, Component comp) {
        if (comp instanceof EditPane) {
            vec.add((EditPane)comp);
        } else if (comp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)comp;
            View.getEditPanes(vec, split.getLeftComponent());
            View.getEditPanes(vec, split.getRightComponent());
        }
    }

    private EditPane showBuffer(Buffer buffer, boolean focus) {
        if (this.editPane.getBuffer() == buffer && this.editPane.getTextArea().getVisibleLines() > 1) {
            if (focus) {
                this.editPane.focusOnTextArea();
            }
            return this.editPane;
        }
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            EditPane ep = editPanes[i];
            if (ep.getBuffer() != buffer || ep.getTextArea().getVisibleLines() <= 1) continue;
            this.setEditPane(ep);
            if (focus) {
                ep.focusOnTextArea();
            }
            return ep;
        }
        this.editPane.setBuffer(buffer, focus);
        return this.editPane;
    }

    private static void getSplitConfig(JSplitPane splitPane, StringBuilder splitConfig) {
        Component right = splitPane.getRightComponent();
        View.appendToSplitConfig(splitConfig, right);
        splitConfig.append(' ');
        Component left = splitPane.getLeftComponent();
        View.appendToSplitConfig(splitConfig, left);
        splitConfig.append(' ');
        splitConfig.append(splitPane.getDividerLocation());
        splitConfig.append(' ');
        splitConfig.append(splitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder splitConfig, Component component) {
        if (component instanceof JSplitPane) {
            View.getSplitConfig((JSplitPane)component, splitConfig);
        } else {
            Buffer[] buffers;
            EditPane editPane = (EditPane)component;
            splitConfig.append('\"');
            splitConfig.append(StandardUtilities.charsToEscapes(editPane.getBuffer().getPath()));
            splitConfig.append("\" buffer");
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer : buffers = bufferSet.getAllBuffers()) {
                if (buffer.isNewFile()) continue;
                splitConfig.append(" \"");
                splitConfig.append(StandardUtilities.charsToEscapes(buffer.getPath()));
                splitConfig.append("\" buff");
            }
            splitConfig.append(" \"");
            splitConfig.append((Object)jEdit.getBufferSetManager().getScope());
            splitConfig.append("\" bufferset");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private Component restoreSplitConfig(Buffer buffer, String splitConfig) throws IOException {
        void var7_14;
        if (buffer != null) {
            this.editPane = this.createEditPane(buffer);
            return this.editPane;
        }
        if (splitConfig == null || splitConfig.trim().length() == 0) {
            Buffer buf = jEdit.getFirstBuffer();
            if (buf == null) {
                buf = BufferSetManager.createUntitledBuffer();
            }
            this.editPane = this.createEditPane(buf);
            return this.editPane;
        }
        Buffer[] buffers = jEdit.getBuffers();
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(splitConfig));
        st.whitespaceChars(0, 32);
        st.wordChars(35, 126);
        st.commentChar(33);
        st.quoteChar(34);
        st.eolIsSignificant(false);
        ArrayList<Buffer> editPaneBuffers = new ArrayList<Buffer>();
        block6: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block6;
                }
                case -3: {
                    if ("vertical".equals(st.sval) || "horizontal".equals(st.sval)) {
                        void var10_25;
                        void var9_20;
                        int n = "vertical".equals(st.sval) ? 0 : 1;
                        int divider = (Integer)stack.pop();
                        Object e = stack.pop();
                        Object e2 = stack.pop();
                        if (e instanceof Buffer) {
                            Buffer b1 = buffer = (Buffer)e;
                            EditPane editPane = this.editPane = this.createEditPane(b1);
                        }
                        if (e2 instanceof Buffer) {
                            Buffer b2 = (Buffer)e2;
                            EditPane editPane = this.createEditPane(b2);
                        }
                        this.splitPane = new JSplitPane(n, (Component)var9_20, (Component)var10_25);
                        stack.push(this.splitPane);
                        this.splitPane.setOneTouchExpandable(true);
                        this.splitPane.setBorder(null);
                        this.splitPane.setMinimumSize(new Dimension(0, 0));
                        this.splitPane.setDividerLocation(divider);
                        break;
                    }
                    if ("buffer".equals(st.sval)) {
                        String path;
                        Object e = stack.pop();
                        if (e instanceof Integer) {
                            int index = (Integer)e;
                            if (index >= 0 && index < buffers.length) {
                                buffer = buffers[index];
                            }
                        } else if (e instanceof String && (buffer = jEdit.getBuffer(path = (String)e)) == null) {
                            buffer = jEdit.openTemporary(jEdit.getActiveView(), null, path, true, null);
                            jEdit.commitTemporary(buffer);
                        }
                        if (buffer == null) {
                            buffer = jEdit.getFirstBuffer();
                        }
                        stack.push(buffer);
                        editPaneBuffers.add(buffer);
                        break;
                    }
                    if ("buff".equals(st.sval)) {
                        String string = (String)stack.pop();
                        buffer = jEdit.getBuffer(string);
                        if (buffer == null) {
                            Log.log(7, this, "Buffer " + string + " doesn't exist");
                            break;
                        }
                        editPaneBuffers.add(buffer);
                        break;
                    }
                    if (!"bufferset".equals(st.sval)) break;
                    stack.pop();
                    buffer = (Buffer)stack.pop();
                    this.editPane = this.createEditPane(buffer);
                    stack.push(this.editPane);
                    BufferSet bufferSet = this.editPane.getBufferSet();
                    int i = 0;
                    for (Buffer buffer2 : editPaneBuffers) {
                        bufferSet.addBufferAt(buffer2, i);
                        ++i;
                    }
                    editPaneBuffers.clear();
                    break;
                }
                case -2: {
                    stack.push((int)st.nval);
                    break;
                }
                case 34: {
                    stack.push(st.sval);
                }
            }
        }
        Object e = stack.peek();
        if (e instanceof Buffer) {
            EditPane editPane = this.editPane = this.createEditPane((Buffer)e);
        }
        this.updateGutterBorders();
        return (Component)var7_14;
    }

    private void propertiesChanged() {
        boolean showStatus;
        JMenuBar mbar = GUIUtilities.loadMenuBar("view.mbar");
        for (int i = 0; i < mbar.getMenuCount(); ++i) {
            Object keyBinding;
            JMenu menu = mbar.getMenu(i);
            int mnemonic = menu.getMnemonic();
            if (mnemonic == 0 || (keyBinding = this.inputHandler.getKeyBinding("A+" + Character.toLowerCase((char)mnemonic))) == null) continue;
            menu.setMnemonic(0);
        }
        this.setJMenuBar(mbar);
        this.loadToolBars();
        this.showFullPath = jEdit.getBooleanProperty("view.showFullPath");
        this.updateTitle();
        this.status.propertiesChanged();
        this.removeToolBar(this.status);
        this.getContentPane().remove(this.status);
        boolean bl = showStatus = this.plainView ? jEdit.getBooleanProperty("view.status.plainview.visible") : jEdit.getBooleanProperty("view.status.visible");
        if (jEdit.getBooleanProperty("view.toolbar.alternateLayout")) {
            this.getContentPane().add("North", this.topToolBars);
            this.getContentPane().add("South", this.bottomToolBars);
            if (showStatus) {
                this.addToolBar(1, -100, this.status);
            }
        } else {
            this.mainPanel.add((Component)this.topToolBars, "North");
            this.mainPanel.add((Component)this.bottomToolBars, "South");
            if (showStatus) {
                this.getContentPane().add("South", this.status);
            }
        }
        this.updateBufferSwitcherStates();
        this.getRootPane().revalidate();
        if (this.fullScreenMode) {
            this.updateFullScreenProps();
        }
    }

    public void updateBufferSwitcherStates() {
        int i;
        boolean show = jEdit.getBooleanProperty("view.showBufferSwitcher");
        JMenuBar menubar = this.getJMenuBar();
        if (menubar == null) {
            return;
        }
        String viewmenu_label = jEdit.getProperty("view.label");
        viewmenu_label = viewmenu_label.replace("$", "");
        String sbs_label = jEdit.getProperty("focus-buffer-switcher.label");
        sbs_label = sbs_label.replace("$", "");
        JMenu viewmenu = null;
        for (i = 0; i < menubar.getMenuCount(); ++i) {
            JMenu menu = menubar.getMenu(i);
            if (!menu.getText().equals(viewmenu_label)) continue;
            viewmenu = menu;
            break;
        }
        if (viewmenu != null) {
            for (i = 0; i < viewmenu.getMenuComponentCount(); ++i) {
                Component item = viewmenu.getMenuComponent(i);
                if (!(item instanceof JMenuItem) || !((JMenuItem)item).getText().equals(sbs_label)) continue;
                item.setEnabled(show);
            }
        }
        for (View v : jEdit.getViews()) {
            for (EditPane ep : v.getEditPanes()) {
                ep.loadBufferSwitcher();
            }
        }
    }

    private void loadToolBars() {
        if (!this.plainView && (this.fullScreenMode ? jEdit.getBooleanProperty("fullScreenIncludesToolbar") : jEdit.getBooleanProperty("view.showToolbar"))) {
            if (this.toolBar != null) {
                this.toolBarManager.removeToolBar(this.toolBar);
            }
            this.toolBar = GUIUtilities.loadToolBar("view.toolbar");
            this.addToolBar(0, 100, this.toolBar);
        } else if (this.toolBar != null) {
            this.removeToolBar(this.toolBar);
            this.toolBar = null;
        }
        if (this.searchBar != null) {
            this.searchBar.propertiesChanged();
            this.removeToolBar(this.searchBar);
        }
        if (jEdit.getBooleanProperty("view.showSearchbar") && !this.plainView) {
            if (this.searchBar == null) {
                this.searchBar = new SearchBar(this, false);
            }
            this.addToolBar(0, 75, this.searchBar);
        }
    }

    private EditPane createEditPane(@Nonnull Buffer buffer) {
        return this.createEditPane(null, buffer);
    }

    private EditPane createEditPane(@Nullable BufferSet bufferSetSource, @Nonnull Buffer buffer) {
        EditPane editPane = new EditPane(this, bufferSetSource, buffer);
        JEditTextArea textArea = editPane.getTextArea();
        textArea.addFocusListener(new FocusHandler());
        textArea.addCaretListener(new CaretHandler());
        textArea.addScrollListener(new ScrollHandler());
        EditBus.send(new EditPaneUpdate(editPane, EditPaneUpdate.CREATED));
        return editPane;
    }

    private void setEditPane(EditPane editPane) {
        this.editPane = editPane;
        this.status.updateCaretStatus();
        this.status.updateBufferStatus();
        this.status.updateMiscStatus();
        this.updateGutterBorders();
        EditBus.send(new ViewUpdate(this, ViewUpdate.EDIT_PANE_CHANGED));
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate msg) {
        Buffer buffer = msg.getBuffer();
        if (msg.getWhat() == BufferUpdate.DIRTY_CHANGED || msg.getWhat() == BufferUpdate.LOADED) {
            EditPane[] editPanes = this.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                if (editPanes[i].getBuffer() != buffer) continue;
                this.updateTitle();
                break;
            }
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate msg) {
        EditPane editPane = msg.getEditPane();
        if (editPane != null && editPane.getView() == this && msg.getWhat() == EditPaneUpdate.BUFFER_CHANGED && editPane.getBuffer().isLoaded()) {
            this.closeDuplicateBuffers(msg);
            this.status.updateCaretStatus();
            this.status.updateBufferStatus();
            this.status.updateMiscStatus();
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate msg) {
        if (msg.getView() == null || msg.getView() != this) {
            return;
        }
        int check = jEdit.getIntegerProperty("checkFileStatus");
        if (check == 0 || !jEdit.isStartupDone()) {
            return;
        }
        if (msg.getWhat() == ViewUpdate.EDIT_PANE_CHANGED && (check & 2) > 0) {
            jEdit.checkBufferStatus(this, true);
        } else if (msg.getWhat() == ViewUpdate.ACTIVATED && (check & 1) > 0) {
            jEdit.checkBufferStatus(this, check != 1);
        }
    }

    private void closeDuplicateBuffers(EditPaneUpdate epu) {
        if (!jEdit.getBooleanProperty("buffersets.exclusive")) {
            return;
        }
        final BufferSet.Scope scope = jEdit.getBufferSetManager().getScope();
        if (scope == BufferSet.Scope.global) {
            return;
        }
        final EditPane ep = epu.getEditPane();
        final View view = ep.getView();
        if (view != this) {
            return;
        }
        final Buffer b = ep.getBuffer();
        if (b.isDirty()) {
            return;
        }
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                if (editPane == ep || scope == BufferSet.Scope.view && editPane.getView() == view) {
                    return;
                }
                if (editPane.getBufferSet().indexOf(b) < 0) {
                    return;
                }
                jEdit.getBufferSetManager().removeBuffer(editPane, b);
            }
        });
    }

    private void updateGutterBorders() {
        EditPane[] editPanes = this.getEditPanes();
        for (int i = 0; i < editPanes.length; ++i) {
            editPanes[i].getTextArea().getGutter().updateBorder();
        }
    }

    private Set<Buffer> getOpenBuffers() {
        HashSet<Buffer> openBuffers = new HashSet<Buffer>();
        for (EditPane editPane : this.getEditPanes()) {
            openBuffers.addAll(Arrays.asList(editPane.getBufferSet().getAllBuffers()));
        }
        return openBuffers;
    }

    private static void mergeBufferSets(EditPane target, EditPane source) {
        BufferSetManager manager = jEdit.getBufferSetManager();
        for (Buffer buffer : source.getBufferSet().getAllBuffers()) {
            manager.addBuffer(target, buffer);
        }
    }

    private static boolean isInsideScreen(View parent, Rectangle r) {
        Rectangle bounds = parent == null ? GUIUtilities.getScreenBounds() : parent.getGraphicsConfiguration().getBounds();
        int minWidth = jEdit.getIntegerProperty("view.minStartupWidth");
        int minHeight = jEdit.getIntegerProperty("view.minStartupHeight");
        return r.x + r.width > bounds.x + minWidth && r.x < bounds.x + bounds.width - minWidth && r.y + r.height > bounds.y + minHeight && r.y < bounds.y + bounds.height - minHeight;
    }

    public void adjust(View parent, ViewConfig config) {
        if (config.width != 0 && config.height != 0) {
            Rectangle desired = new Rectangle(config.x, config.y, config.width, config.height);
            if (!View.isInsideScreen(parent, desired)) {
                this.setLocationRelativeTo(parent);
            } else if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
                new GUIUtilities.UnixWorkaround(this, "view", desired, config.extState);
            } else {
                this.setBounds(desired);
                this.setExtendedState(config.extState);
            }
        } else {
            this.setLocationRelativeTo(parent);
        }
    }

    private static class SetCursorVisitor
    extends JEditVisitorAdapter {
        private final Cursor cursor;

        SetCursorVisitor(Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        public void visit(EditPane editPane) {
            editPane.setCursor(this.cursor);
        }
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return GUIUtilities.getView(focusCycleRoot).getTextArea();
        }
    }

    public static class ViewConfig {
        public int x;
        public int y;
        public int width;
        public int height;
        public int extState;
        public boolean plainView;
        public String splitConfig;
        public DockableWindowManager.DockingLayout docking;
        public String title;

        public ViewConfig() {
        }

        public ViewConfig(boolean plainView) {
            this.plainView = plainView;
            String prefix = plainView ? "plain-view" : "view";
            this.x = jEdit.getIntegerProperty(prefix + ".x", 0);
            this.y = jEdit.getIntegerProperty(prefix + ".y", 0);
            this.width = jEdit.getIntegerProperty(prefix + ".width", 0);
            this.height = jEdit.getIntegerProperty(prefix + ".height", 0);
            this.extState = jEdit.getIntegerProperty(prefix + ".extendedState", 0);
        }

        public ViewConfig(boolean plainView, String splitConfig, int x, int y, int width, int height, int extState) {
            this.plainView = plainView;
            this.splitConfig = splitConfig;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.extState = extState;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent evt) {
            boolean appFocus = false;
            boolean viewChanged = false;
            View oldView = jEdit.getActiveViewInternal();
            if (oldView != View.this) {
                viewChanged = true;
            }
            if (evt.getOppositeWindow() == null) {
                appFocus = true;
            }
            jEdit.setActiveView(View.this);
            if (appFocus || viewChanged) {
                EditBus.send(new ViewUpdate(View.this, ViewUpdate.ACTIVATED));
            }
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            jEdit.closeView(View.this);
        }
    }

    private class ScrollHandler
    implements ScrollListener {
        private ScrollHandler() {
        }

        @Override
        public void scrolledVertically(TextArea textArea) {
            if (View.this.getTextArea() == textArea) {
                View.this.status.updateCaretStatus();
            }
        }

        @Override
        public void scrolledHorizontally(TextArea textArea) {
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component comp = (Component)evt.getSource();
            while (!(comp instanceof EditPane)) {
                if (comp == null) {
                    return;
                }
                comp = comp.getParent();
            }
            if (comp != View.this.editPane) {
                View.this.setEditPane((EditPane)comp);
            } else {
                View.this.updateGutterBorders();
            }
        }
    }

    private class CaretHandler
    implements CaretListener {
        private CaretHandler() {
        }

        @Override
        public void caretUpdate(CaretEvent evt) {
            if (evt.getSource() == View.this.getTextArea()) {
                View.this.status.updateCaretStatus();
            }
        }
    }
}

