/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.util.Log;

public class ErrorListDialog
extends EnhancedDialog {
    private JButton ok;
    private JButton pluginMgr;

    public ErrorListDialog(Frame frame, String title, String caption, Vector<ErrorEntry> messages, boolean pluginError) {
        super(frame, title, !pluginError);
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(caption);
        label.setBorder(new EmptyBorder(0, 0, 6, 0));
        centerPanel.add("North", label);
        JTextPaneSized errors = new JTextPaneSized();
        errors.setEditable(false);
        errors.setForeground(jEdit.getColorProperty("view.fgColor"));
        errors.setBackground(jEdit.getColorProperty("view.bgColor"));
        errors.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        errors.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        StyledDocument doc = errors.getStyledDocument();
        Font plainFont = new JLabel().getFont();
        SimpleAttributeSet plainFontAttrSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(plainFontAttrSet, plainFont.getFamily());
        SimpleAttributeSet boldFontAttrSet = (SimpleAttributeSet)plainFontAttrSet.clone();
        StyleConstants.setBold(boldFontAttrSet, true);
        for (ErrorEntry entry : messages) {
            try {
                doc.insertString(doc.getLength(), entry.path + ":\n", boldFontAttrSet);
                for (String s : entry.messages) {
                    doc.insertString(doc.getLength(), s + "\n", plainFontAttrSet);
                }
            }
            catch (BadLocationException e) {
            }
        }
        JScrollPane scrollPane = new JScrollPane(errors);
        centerPanel.add("Center", scrollPane);
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(new ActionHandler());
        if (pluginError) {
            this.pluginMgr = new JButton(jEdit.getProperty("error-list.plugin-manager"));
            this.pluginMgr.addActionListener(new ActionHandler());
            buttons.add(this.pluginMgr);
            buttons.add(Box.createHorizontalStrut(6));
        }
        buttons.add(this.ok);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.getRootPane().setDefaultButton(this.ok);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ErrorListDialog.this.ok) {
                ErrorListDialog.this.dispose();
            } else if (evt.getSource() == ErrorListDialog.this.pluginMgr) {
                PluginManager.showPluginManager(JOptionPane.getFrameForComponent(ErrorListDialog.this));
            }
        }
    }

    protected class JTextPaneSized
    extends JTextPane {
        protected JTextPaneSized() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            int width = 80 * metrics.charWidth('X');
            int height = 25 * metrics.getHeight();
            return new Dimension(width, height);
        }
    }

    public static class ErrorEntry {
        String path;
        String[] messages;

        public ErrorEntry(String path, String messageProp, Object[] args) {
            this(path, messageProp, args, 9);
        }

        public ErrorEntry(String path, String messageProp, Object[] args, int urgency) {
            this.path = path;
            String message = jEdit.getProperty(messageProp, args);
            if (message == null) {
                message = "Undefined property: " + messageProp;
            }
            Log.log(urgency, this, path + ":");
            Log.log(urgency, this, message);
            Vector<String> tokenizedMessage = new Vector<String>();
            int lastIndex = -1;
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != '\n') continue;
                tokenizedMessage.addElement(message.substring(lastIndex + 1, i));
                lastIndex = i;
            }
            if (lastIndex != message.length()) {
                tokenizedMessage.addElement(message.substring(lastIndex + 1));
            }
            this.messages = new String[tokenizedMessage.size()];
            tokenizedMessage.copyInto(this.messages);
        }

        public boolean equals(Object o) {
            if (o instanceof ErrorEntry) {
                ErrorEntry e = (ErrorEntry)o;
                return e.path.equals(this.path);
            }
            return false;
        }

        public String toString() {
            return this.path + ":\n" + TextUtilities.join(Arrays.asList(this.messages), "\n");
        }
    }
}

