/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.PropertiesChanged;

public class EnhancedMenu
extends JMenu
implements MenuListener {
    protected int initialComponentCount;
    protected ActionContext context;
    protected String providerCode;
    protected DynamicMenuProvider provider;
    protected EditBusStub ebStub;

    public EnhancedMenu(String name) {
        this(name, jEdit.getProperty(name.concat(".label")), jEdit.getActionContext());
    }

    public EnhancedMenu(String name, String label) {
        this(name, label, jEdit.getActionContext());
    }

    public EnhancedMenu(String name, String label, ActionContext context) {
        String menuItems;
        char mnemonic;
        int index;
        this.context = context;
        if (label == null) {
            label = name;
        }
        if ((index = label.indexOf(36)) != -1 && label.length() - index > 1) {
            mnemonic = Character.toLowerCase(label.charAt(index + 1));
            label = label.substring(0, index).concat(label.substring(++index));
        } else {
            mnemonic = '\u0000';
        }
        this.setText(label);
        if (!OperatingSystem.isMacOS()) {
            this.setMnemonic(mnemonic);
        }
        if ((menuItems = jEdit.getProperty(name)) != null) {
            StringTokenizer st = new StringTokenizer(menuItems);
            while (st.hasMoreTokens()) {
                String menuItemName = st.nextToken();
                if (menuItemName.equals("-")) {
                    this.addSeparator();
                    continue;
                }
                this.add(GUIUtilities.loadMenuItem(context, menuItemName, true));
            }
        }
        this.initialComponentCount = this.getMenuComponentCount();
        this.providerCode = jEdit.getProperty(name + ".code");
        this.ebStub = new EditBusStub(name);
        this.ebStub.menuOutOfDate = true;
        this.addMenuListener(this);
        if (this.providerCode != null) {
            EditBus.addToBus(this.ebStub);
        }
    }

    @Override
    public void menuSelected(MenuEvent evt) {
        this.init();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    public void init() {
        if (this.providerCode == null) {
            return;
        }
        if (this.provider == null) {
            Object obj = BeanShell.eval(null, BeanShell.getNameSpace(), this.providerCode);
            this.provider = (DynamicMenuProvider)obj;
        }
        if (this.provider == null) {
            this.providerCode = null;
            return;
        }
        if (this.ebStub.menuOutOfDate || this.provider.updateEveryTime()) {
            this.ebStub.menuOutOfDate = false;
            while (this.getMenuComponentCount() != this.initialComponentCount) {
                this.remove(this.getMenuComponentCount() - 1);
            }
            if (this.provider != null) {
                this.provider.update(this);
            }
        }
    }

    protected void finalize() throws Exception {
        if (this.ebStub != null) {
            EditBus.removeFromBus(this.ebStub);
        }
    }

    public static class EditBusStub {
        String name;
        boolean menuOutOfDate;

        EditBusStub(String name) {
            this.name = name;
            this.menuOutOfDate = true;
        }

        @EditBus.EBHandler
        public void handleDynamicMenuChanged(DynamicMenuChanged msg) {
            if (this.name.equals(msg.getMenuName())) {
                this.menuOutOfDate = true;
            }
        }

        @EditBus.EBHandler
        public void handlePropertiesChanged(PropertiesChanged msg) {
            this.menuOutOfDate = true;
        }
    }
}

