/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.EncodingServer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class ReloadWithEncodingProvider
implements ActionListener,
DynamicMenuProvider {
    private View view;

    @Override
    public boolean updateEveryTime() {
        return false;
    }

    @Override
    public void update(JMenu menu) {
        this.view = GUIUtilities.getView(menu);
        JMenuItem auto = new JMenuItem(jEdit.getProperty("vfs.browser.commands.encoding.auto-detect"));
        auto.setActionCommand("auto-detect");
        auto.addActionListener(this);
        menu.add(auto);
        menu.addSeparator();
        Object[] encodings = MiscUtilities.getEncodings(true);
        String systemEncoding = System.getProperty("file.encoding");
        if (Arrays.binarySearch(encodings, systemEncoding) < 0) {
            String[] tmp_a = new String[encodings.length + 1];
            System.arraycopy(encodings, 0, tmp_a, 0, encodings.length);
            tmp_a[encodings.length] = systemEncoding;
            encodings = tmp_a;
        }
        Arrays.sort(encodings);
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        for (int i = 0; i < encodings.length; ++i) {
            JMenuItem mi = new JMenuItem((String)encodings[i]);
            mi.setActionCommand("encoding@" + (String)encodings[i]);
            mi.addActionListener(this);
            if (menu.getMenuComponentCount() >= maxItems && i < encodings.length) {
                JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                menu.add(newMenu);
                menu = newMenu;
            }
            menu.add(mi);
        }
        menu.addSeparator();
        JMenuItem other = new JMenuItem(jEdit.getProperty("vfs.browser.other-encoding.label"));
        other.setActionCommand("other-encoding");
        other.addActionListener(this);
        menu.add(other);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JMenuItem mi = (JMenuItem)ae.getSource();
        String action = mi.getActionCommand();
        String encoding = null;
        Hashtable<String, Object> props = null;
        if (action.startsWith("encoding@")) {
            encoding = action.substring(9);
        } else if ("other-encoding".equals(action)) {
            encoding = JOptionPane.showInputDialog(this.view, jEdit.getProperty("encoding-prompt.message"), jEdit.getProperty("encoding-prompt.title"), 3);
            if (encoding == null) {
                return;
            }
            if (!EncodingServer.hasEncoding(encoding)) {
                String msg = jEdit.getProperty("reload-encoding.error", new Object[]{encoding});
                JOptionPane.showMessageDialog(this.view, msg, jEdit.getProperty("common.error"), 0);
                return;
            }
        }
        if (encoding != null) {
            props = new Hashtable<String, Object>();
            props.put("encoding", encoding);
            props.put("encodingAutodetect", false);
            this.view.getBuffer().setStringProperty("encoding", encoding);
        }
        String path = this.view.getBuffer().getPath();
        jEdit.closeBuffer(this.view, this.view.getBuffer());
        jEdit.openFile(this.view, null, path, false, props);
    }
}

