/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.gui.NumericTextField;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.IconTheme;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;

public class AppearanceOptionPane
extends AbstractOptionPane {
    public static final String[] builtInIconThemes = new String[]{"tango", "old"};
    private String oldTheme;
    private UIManager.LookAndFeelInfo[] lfs;
    private JComboBox lookAndFeel;
    private FontSelector primaryFont;
    private FontSelector secondaryFont;
    private FontSelector helpViewerFont;
    private JTextField history;
    private JTextField menuSpillover;
    private JCheckBox showTips;
    private JCheckBox showSplash;
    private JCheckBox textColors;
    private JCheckBox decorateFrames;
    private JCheckBox decorateDialogs;
    private JComboBox antiAliasExtras;
    private JComboBox iconThemes;
    private JCheckBox systemTrayIcon;
    private JCheckBox useQuartz;

    public AppearanceOptionPane() {
        super("appearance");
    }

    @Override
    protected void _init() {
        this.lfs = UIManager.getInstalledLookAndFeels();
        String[] names = new String[this.lfs.length];
        String lf = UIManager.getLookAndFeel().getClass().getName();
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.lfs[i].getName();
            if (!lf.equals(this.lfs[i].getClassName())) continue;
            index = i;
        }
        this.lookAndFeel = new JComboBox<String>(names);
        this.lookAndFeel.setSelectedIndex(index);
        this.lookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppearanceOptionPane.this.updateEnabled();
            }
        });
        this.addComponent(jEdit.getProperty("options.appearance.lf"), (Component)this.lookAndFeel);
        String[] themes = IconTheme.builtInNames();
        this.iconThemes = new JComboBox<String>(themes);
        this.addComponent(jEdit.getProperty("options.appearance.iconTheme"), (Component)this.iconThemes);
        this.oldTheme = IconTheme.get();
        for (int i = 0; i < themes.length; ++i) {
            if (!themes[i].equals(this.oldTheme)) continue;
            this.iconThemes.setSelectedIndex(i);
            break;
        }
        Font pf = jEdit.getFontProperty("metal.primary.font");
        this.primaryFont = new FontSelector(pf);
        this.addComponent(jEdit.getProperty("options.appearance.primaryFont"), (Component)this.primaryFont);
        this.secondaryFont = new FontSelector(jEdit.getFontProperty("metal.secondary.font"));
        this.addComponent(jEdit.getProperty("options.appearance.secondaryFont"), (Component)this.secondaryFont);
        this.helpViewerFont = new FontSelector(jEdit.getFontProperty("helpviewer.font", pf));
        this.addComponent(jEdit.getProperty("options.appearance.helpViewerFont"), (Component)this.helpViewerFont);
        this.updateEnabled();
        this.history = new NumericTextField(jEdit.getProperty("history"), true);
        this.addComponent(jEdit.getProperty("options.appearance.history"), (Component)this.history);
        this.menuSpillover = new NumericTextField(jEdit.getProperty("menu.spillover"), true);
        this.addComponent(jEdit.getProperty("options.appearance.menuSpillover"), (Component)this.menuSpillover);
        this.systemTrayIcon = new JCheckBox(jEdit.getProperty("options.general.systrayicon", "Show the systray icon"));
        this.systemTrayIcon.setSelected(jEdit.getBooleanProperty("systrayicon", true));
        this.addComponent(this.systemTrayIcon);
        this.addSeparator("options.appearance.startup.label");
        this.showSplash = new JCheckBox(jEdit.getProperty("options.appearance.showSplash"));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            this.showSplash.setSelected(true);
        } else {
            this.showSplash.setSelected(!new File(settingsDirectory, "nosplash").exists());
        }
        this.addComponent(this.showSplash);
        this.showTips = new JCheckBox(jEdit.getProperty("options.appearance.showTips"));
        this.showTips.setSelected(jEdit.getBooleanProperty("tip.show"));
        this.addComponent(this.showTips);
        this.addSeparator("options.appearance.experimental.label");
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.appearance.experimental.caption")));
        this.textColors = new JCheckBox(jEdit.getProperty("options.appearance.textColors"));
        this.textColors.setSelected(jEdit.getBooleanProperty("textColors"));
        this.addComponent(this.textColors);
        this.decorateFrames = new JCheckBox(jEdit.getProperty("options.appearance.decorateFrames"));
        this.decorateFrames.setSelected(jEdit.getBooleanProperty("decorate.frames"));
        this.addComponent(this.decorateFrames);
        this.decorateDialogs = new JCheckBox(jEdit.getProperty("options.appearance.decorateDialogs"));
        this.decorateDialogs.setSelected(jEdit.getBooleanProperty("decorate.dialogs"));
        this.addComponent(this.decorateDialogs);
    }

    @Override
    protected void _save() {
        String lf = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
        jEdit.setProperty("lookAndFeel", lf);
        jEdit.setFontProperty("metal.primary.font", this.primaryFont.getFont());
        jEdit.setFontProperty("metal.secondary.font", this.secondaryFont.getFont());
        jEdit.setFontProperty("helpviewer.font", this.helpViewerFont.getFont());
        jEdit.setProperty("history", this.history.getText());
        jEdit.setProperty("menu.spillover", this.menuSpillover.getText());
        jEdit.setBooleanProperty("tip.show", this.showTips.isSelected());
        jEdit.setBooleanProperty("systrayicon", this.systemTrayIcon.isSelected());
        IconTheme.set(this.iconThemes.getSelectedItem().toString());
        this.setFileFlag("nosplash", !this.showSplash.isSelected());
        jEdit.setBooleanProperty("textColors", this.textColors.isSelected());
        jEdit.setBooleanProperty("decorate.frames", this.decorateFrames.isSelected());
        jEdit.setBooleanProperty("decorate.dialogs", this.decorateDialogs.isSelected());
    }

    private void updateEnabled() {
        String className = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
        if (className.equals("javax.swing.plaf.metal.MetalLookAndFeel") || className.equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
            this.primaryFont.setEnabled(true);
            this.secondaryFont.setEnabled(true);
        } else {
            this.primaryFont.setEnabled(false);
            this.secondaryFont.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFileFlag(String fileName, boolean present) {
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) return;
        File file = new File(settingsDirectory, fileName);
        if (!present) {
            file.delete();
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(10);
            out.close();
        }
        catch (IOException io) {
            try {
                Log.log(9, this, io);
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(out);
                throw throwable;
            }
            IOUtilities.closeQuietly(out);
            return;
        }
        IOUtilities.closeQuietly(out);
        return;
    }
}

