/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.PingPongList;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class EncodingsOptionPane
extends AbstractOptionPane {
    private JComboBox defaultEncoding;
    private JCheckBox encodingAutodetect;
    private JTextField encodingDetectors;
    private JTextField fallbackEncodings;
    private JComboBox lineSeparator;
    private PingPongList<String> pingPongList;

    public EncodingsOptionPane() {
        super("encodings");
    }

    @Override
    protected void _init() {
        String[] lineSeps = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(lineSeps);
        String lineSep = jEdit.getProperty("buffer.lineSeparator", System.getProperty("line.separator"));
        if ("\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(lineSep)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        this.addComponent(jEdit.getProperty("options.general.lineSeparator"), (Component)this.lineSeparator);
        String[] encodings = MiscUtilities.getEncodings(true);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        this.defaultEncoding = new JComboBox<String>(encodings);
        this.defaultEncoding.setEditable(true);
        this.defaultEncoding.setSelectedItem(jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding")));
        this.addComponent(jEdit.getProperty("options.general.encoding"), (Component)this.defaultEncoding);
        this.encodingAutodetect = new JCheckBox(jEdit.getProperty("options.general.encodingAutodetect"));
        this.encodingAutodetect.setSelected(jEdit.getBooleanProperty("buffer.encodingAutodetect"));
        this.addComponent((Component)this.encodingAutodetect, 1);
        this.encodingDetectors = new JTextField(jEdit.getProperty("encodingDetectors", ""));
        this.addComponent(jEdit.getProperty("options.general.encodingDetectors"), (Component)this.encodingDetectors);
        this.fallbackEncodings = new JTextField(jEdit.getProperty("fallbackEncodings", ""));
        this.fallbackEncodings.setToolTipText(jEdit.getProperty("options.general.fallbackEncodings.tooltip"));
        this.addComponent(jEdit.getProperty("options.general.fallbackEncodings"), (Component)this.fallbackEncodings);
        encodings = MiscUtilities.getEncodings(false);
        Arrays.sort(encodings, new StandardUtilities.StringCompare(true));
        ArrayList<String> availableEncodings = new ArrayList<String>();
        ArrayList<String> selectedEncodings = new ArrayList<String>();
        for (String encoding : encodings) {
            boolean selected;
            boolean bl = selected = !jEdit.getBooleanProperty("encoding.opt-out." + encoding, false);
            if (selected) {
                selectedEncodings.add(encoding);
                continue;
            }
            availableEncodings.add(encoding);
        }
        this.pingPongList = new PingPongList(availableEncodings, selectedEncodings);
        this.pingPongList.setLeftTitle(jEdit.getProperty("options.encodings.available"));
        this.pingPongList.setRightTitle(jEdit.getProperty("options.encodings.selected"));
        this.pingPongList.setLeftTooltip(jEdit.getProperty("options.encodings.available.tooltip"));
        this.pingPongList.setRightTooltip(jEdit.getProperty("options.encodings.selected.tooltip"));
        this.addComponent(this.pingPongList, 1);
    }

    @Override
    protected void _save() {
        String lineSep = null;
        switch (this.lineSeparator.getSelectedIndex()) {
            case 0: {
                lineSep = "\n";
                break;
            }
            case 1: {
                lineSep = "\r\n";
                break;
            }
            case 2: {
                lineSep = "\r";
            }
        }
        jEdit.setProperty("buffer.lineSeparator", lineSep);
        jEdit.setProperty("buffer.encoding", (String)this.defaultEncoding.getSelectedItem());
        jEdit.setBooleanProperty("buffer.encodingAutodetect", this.encodingAutodetect.isSelected());
        jEdit.setProperty("encodingDetectors", this.encodingDetectors.getText());
        jEdit.setProperty("fallbackEncodings", this.fallbackEncodings.getText());
        Iterator<String> available = this.pingPongList.getLeftDataIterator();
        while (available.hasNext()) {
            String encoding = available.next();
            jEdit.setBooleanProperty("encoding.opt-out." + encoding, true);
        }
        Iterator<String> selected = this.pingPongList.getRightDataIterator();
        while (selected.hasNext()) {
            String encoding = selected.next();
            jEdit.unsetProperty("encoding.opt-out." + encoding);
        }
    }
}

