/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.print;

import java.awt.Font;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.print.BufferPrintable;
import org.gjt.sp.util.Log;

public class BufferPrinter1_4 {
    private static PrintRequestAttributeSet format;
    private static PrinterJob job;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrinterJob getPrintJob(String jobName) {
        String printSpecPath;
        File filePrintSpec;
        job = PrinterJob.getPrinterJob();
        format = new HashPrintRequestAttributeSet();
        String settings = jEdit.getSettingsDirectory();
        if (settings != null && (filePrintSpec = new File(printSpecPath = MiscUtilities.constructPath(settings, "printspec"))).exists()) {
            ObjectInputStream obIn = null;
            try {
                FileInputStream fileIn = new FileInputStream(filePrintSpec);
                obIn = new ObjectInputStream(fileIn);
                format = (HashPrintRequestAttributeSet)obIn.readObject();
            }
            catch (Exception e) {
                Log.log(9, BufferPrinter1_4.class, e);
            }
            finally {
                try {
                    obIn.close();
                }
                catch (IOException e) {}
            }
            if (jEdit.getBooleanProperty("print.color")) {
                format.add(Chromaticity.COLOR);
            } else {
                format.add(Chromaticity.MONOCHROME);
            }
            format.add(new JobName(jobName, null));
        }
        return job;
    }

    public static void pageSetup(View view) {
        PrinterJob prnJob = BufferPrinter1_4.getPrintJob("PageSetupOnly");
        if (prnJob.pageDialog(format) != null) {
            BufferPrinter1_4.savePrintSpec();
        }
    }

    public static void print(View view, Buffer buffer, boolean selection) {
        job = BufferPrinter1_4.getPrintJob(MiscUtilities.abbreviateView(buffer.getPath()));
        boolean header = jEdit.getBooleanProperty("print.header");
        boolean footer = jEdit.getBooleanProperty("print.footer");
        boolean lineNumbers = jEdit.getBooleanProperty("print.lineNumbers");
        boolean color = jEdit.getBooleanProperty("print.color");
        Font font = jEdit.getFontProperty("print.font");
        BufferPrintable printable = new BufferPrintable(job, format, view, buffer, font, header, footer, lineNumbers, color);
        job.setPrintable(printable);
        if (!job.printDialog(format)) {
            return;
        }
        BufferPrinter1_4.savePrintSpec();
        printable.print();
    }

    public static PageFormat getPageFormat() {
        PrinterJob prnJob = BufferPrinter1_4.getPrintJob(" ");
        PageFormat pf = prnJob.defaultPage();
        Paper pap = pf.getPaper();
        MediaSizeName media = (MediaSizeName)format.get(Media.class);
        MediaSize ms = MediaSize.getMediaSizeForName(media);
        MediaPrintableArea mediaarea = (MediaPrintableArea)format.get(MediaPrintableArea.class);
        if (mediaarea != null) {
            pap.setImageableArea(mediaarea.getX(25400) * 72.0f, mediaarea.getY(25400) * 72.0f, mediaarea.getWidth(25400) * 72.0f, mediaarea.getHeight(25400) * 72.0f);
        }
        if (ms != null) {
            pap.setSize(ms.getX(25400) * 72.0f, ms.getY(25400) * 72.0f);
        }
        pf.setPaper(pap);
        OrientationRequested orientation = (OrientationRequested)format.get(OrientationRequested.class);
        if (orientation != null) {
            if (orientation.getValue() == OrientationRequested.LANDSCAPE.getValue()) {
                pf.setOrientation(0);
            } else if (orientation.getValue() == OrientationRequested.REVERSE_LANDSCAPE.getValue()) {
                pf.setOrientation(2);
            } else if (orientation.getValue() == OrientationRequested.PORTRAIT.getValue()) {
                pf.setOrientation(1);
            } else if (orientation.getValue() == OrientationRequested.REVERSE_PORTRAIT.getValue()) {
                pf.setOrientation(1);
            }
        }
        return pf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePrintSpec() {
        String settings = jEdit.getSettingsDirectory();
        if (settings == null) {
            return;
        }
        String printSpecPath = MiscUtilities.constructPath(settings, "printspec");
        File filePrintSpec = new File(printSpecPath);
        ObjectOutputStream obOut = null;
        try {
            FileOutputStream fileOut = new FileOutputStream(filePrintSpec);
            obOut = new ObjectOutputStream(fileOut);
            obOut.writeObject(format);
            Chromaticity cc = (Chromaticity)format.get(Chromaticity.class);
            if (cc != null) {
                jEdit.setBooleanProperty("print.color", cc.getValue() == Chromaticity.COLOR.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (obOut != null) {
                try {
                    obOut.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

