/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.ArrayList;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.util.StandardUtilities;

public abstract class Selection
implements Cloneable {
    int start;
    int end;
    int startLine;
    int endLine;

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public abstract int getStart(JEditBuffer var1, int var2);

    public abstract int getEnd(JEditBuffer var1, int var2);

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean overlaps(Selection s) {
        return this.start >= s.start && this.start <= s.end || this.end >= s.start && this.end <= s.end;
    }

    public String toString() {
        return this.getClass().getName() + "[start=" + this.start + ",end=" + this.end + ",startLine=" + this.startLine + ",endLine=" + this.endLine + ']';
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("I just drank a whole bottle of cough syrup and I feel funny!");
        }
    }

    protected Selection() {
    }

    protected Selection(Selection sel) {
        this.start = sel.start;
        this.end = sel.end;
    }

    protected Selection(int start, int end) {
        this.start = start;
        this.end = end;
    }

    abstract void getText(JEditBuffer var1, StringBuilder var2);

    abstract int setText(JEditBuffer var1, String var2);

    abstract boolean contentInserted(JEditBuffer var1, int var2, int var3, int var4, int var5);

    abstract boolean contentRemoved(JEditBuffer var1, int var2, int var3, int var4, int var5);

    public static class Rect
    extends Selection {
        int extraStartVirt;
        int extraEndVirt;

        public Rect() {
        }

        public Rect(Selection sel) {
            super(sel);
        }

        public Rect(int start, int end) {
            super(start, end);
        }

        public Rect(int startLine, int start, int endLine, int end) {
            this.startLine = startLine;
            this.start = start;
            this.endLine = endLine;
            this.end = end;
        }

        public Rect(JEditBuffer buffer, int startLine, int startColumn, int endLine, int endColumn) {
            this.startLine = startLine;
            this.endLine = endLine;
            int[] width = new int[1];
            int startOffset = buffer.getOffsetOfVirtualColumn(startLine, startColumn, width);
            if (startOffset == -1) {
                this.extraStartVirt = startColumn - width[0];
                startOffset = buffer.getLineEndOffset(startLine) - 1;
            } else {
                startOffset += buffer.getLineStartOffset(startLine);
            }
            int endOffset = buffer.getOffsetOfVirtualColumn(endLine, endColumn, width);
            if (endOffset == -1) {
                this.extraEndVirt = endColumn - width[0];
                endOffset = buffer.getLineEndOffset(endLine) - 1;
            } else {
                endOffset += buffer.getLineStartOffset(endLine);
            }
            this.start = startOffset;
            this.end = endOffset;
        }

        public int getStartColumn(JEditBuffer buffer) {
            int virtColStart = buffer.getVirtualWidth(this.startLine, this.start - buffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int virtColEnd = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.min(virtColStart, virtColEnd);
        }

        public int getEndColumn(JEditBuffer buffer) {
            int virtColStart = buffer.getVirtualWidth(this.startLine, this.start - buffer.getLineStartOffset(this.startLine)) + this.extraStartVirt;
            int virtColEnd = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine)) + this.extraEndVirt;
            return Math.max(virtColStart, virtColEnd);
        }

        @Override
        public int getStart(JEditBuffer buffer, int line) {
            return Rect.getColumnOnOtherLine(buffer, line, this.getStartColumn(buffer));
        }

        @Override
        public int getEnd(JEditBuffer buffer, int line) {
            return Rect.getColumnOnOtherLine(buffer, line, this.getEndColumn(buffer));
        }

        @Override
        void getText(JEditBuffer buffer, StringBuilder buf) {
            int start = this.getStartColumn(buffer);
            int end = this.getEndColumn(buffer);
            for (int i = this.startLine; i <= this.endLine; ++i) {
                int rectEnd;
                int lineStart = buffer.getLineStartOffset(i);
                int lineLen = buffer.getLineLength(i);
                int rectStart = buffer.getOffsetOfVirtualColumn(i, start, null);
                if (rectStart == -1) {
                    rectStart = lineLen;
                }
                if ((rectEnd = buffer.getOffsetOfVirtualColumn(i, end, null)) == -1) {
                    rectEnd = lineLen;
                }
                if (rectEnd < rectStart) {
                    System.err.println(i + ":::" + start + ':' + end + " ==> " + rectStart + ':' + rectEnd);
                }
                buf.append(buffer.getText(lineStart + rectStart, rectEnd - rectStart));
                if (i == this.endLine) continue;
                buf.append('\n');
            }
        }

        @Override
        int setText(JEditBuffer buffer, String text) {
            int startColumn = this.getStartColumn(buffer);
            int endColumn = this.getEndColumn(buffer);
            int tabSize = buffer.getTabSize();
            int maxWidth = 0;
            int totalLines = 0;
            ArrayList<Object> lines = new ArrayList<Object>();
            if (text != null) {
                int lastNewline = 0;
                int currentWidth = startColumn;
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (ch == '\n') {
                        ++totalLines;
                        lines.add(text.substring(lastNewline, i));
                        lastNewline = i + 1;
                        maxWidth = Math.max(maxWidth, currentWidth);
                        lines.add(currentWidth);
                        currentWidth = startColumn;
                        continue;
                    }
                    if (ch == '\t') {
                        currentWidth += tabSize - currentWidth % tabSize;
                        continue;
                    }
                    ++currentWidth;
                }
                if (lastNewline != text.length()) {
                    ++totalLines;
                    lines.add(text.substring(lastNewline));
                    lines.add(currentWidth);
                    maxWidth = Math.max(maxWidth, currentWidth);
                }
            }
            int endOffset = 0;
            int[] total = new int[1];
            int lastLine = Math.max(this.startLine + totalLines - 1, this.endLine);
            for (int i = this.startLine; i <= lastLine; ++i) {
                int endWhitespace;
                int startWhitespace;
                if (i == buffer.getLineCount()) {
                    buffer.insert(buffer.getLength(), "\n");
                }
                int lineStart = buffer.getLineStartOffset(i);
                int lineLen = buffer.getLineLength(i);
                int rectStart = buffer.getOffsetOfVirtualColumn(i, startColumn, total);
                if (rectStart == -1) {
                    startWhitespace = startColumn - total[0];
                    rectStart = lineLen;
                } else {
                    startWhitespace = 0;
                }
                int rectEnd = buffer.getOffsetOfVirtualColumn(i, endColumn, null);
                if (rectEnd == -1) {
                    rectEnd = lineLen;
                }
                buffer.remove(rectStart + lineStart, rectEnd - rectStart);
                if (startWhitespace != 0) {
                    buffer.insert(rectStart + lineStart, StandardUtilities.createWhiteSpace(startWhitespace, 0));
                }
                if (totalLines == 0) {
                    endWhitespace = rectEnd == lineLen ? 0 : maxWidth - startColumn;
                } else {
                    int index = 2 * ((i - this.startLine) % totalLines);
                    String str = (String)lines.get(index);
                    buffer.insert(rectStart + lineStart + startWhitespace, str);
                    endWhitespace = rectEnd == lineLen ? 0 : maxWidth - (Integer)lines.get(index + 1);
                    startWhitespace += str.length();
                }
                if (endWhitespace != 0) {
                    buffer.insert(rectStart + lineStart + startWhitespace, StandardUtilities.createWhiteSpace(endWhitespace, 0));
                }
                endOffset = rectStart + lineStart + startWhitespace + endWhitespace;
            }
            if (text == null || text.length() == 0) {
                return this.end;
            }
            return endOffset;
        }

        @Override
        boolean contentInserted(JEditBuffer buffer, int startLine, int start, int numLines, int length) {
            if (this.end < start) {
                return false;
            }
            this.end += length;
            if (this.startLine > startLine) {
                this.start += length;
                if (numLines != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                    this.endLine = buffer.getLineOfOffset(this.end);
                }
                return true;
            }
            int endVirtualColumn = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine));
            if (this.start == start) {
                int[] totalVirtualWidth;
                int startVirtualColumn = buffer.getVirtualWidth(this.startLine, start - buffer.getLineStartOffset(this.startLine));
                this.start += length;
                int newStartVirtualColumn = buffer.getVirtualWidth(startLine, start - buffer.getLineStartOffset(this.startLine));
                int newEnd = buffer.getOffsetOfVirtualColumn(this.endLine, endVirtualColumn + newStartVirtualColumn - startVirtualColumn, totalVirtualWidth = new int[1]);
                if (newEnd != -1) {
                    this.end = buffer.getLineStartOffset(this.endLine) + newEnd;
                } else {
                    this.end = buffer.getLineEndOffset(this.endLine) - 1;
                    this.extraEndVirt = totalVirtualWidth[0] - endVirtualColumn;
                }
            } else if (this.start > start) {
                this.start += length;
                if (numLines != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                }
            }
            if (numLines != 0) {
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            int newEndVirtualColumn = buffer.getVirtualWidth(this.endLine, this.end - buffer.getLineStartOffset(this.endLine));
            if (startLine == this.endLine && this.extraEndVirt != 0) {
                this.extraEndVirt += endVirtualColumn - newEndVirtualColumn;
            } else if (startLine == this.startLine && this.extraStartVirt != 0) {
                this.extraStartVirt += endVirtualColumn - newEndVirtualColumn;
            }
            return true;
        }

        @Override
        boolean contentRemoved(JEditBuffer buffer, int startLine, int start, int numLines, int length) {
            int end = start + length;
            boolean changed = false;
            if (this.start > start && this.start <= end) {
                this.start = start;
                changed = true;
            } else if (this.start > end) {
                this.start -= length;
                changed = true;
            }
            if (this.end > start && this.end <= end) {
                this.end = start;
                changed = true;
            } else if (this.end > end) {
                this.end -= length;
                changed = true;
            }
            if (changed && numLines != 0) {
                this.startLine = buffer.getLineOfOffset(this.start);
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            return changed;
        }

        private static int getColumnOnOtherLine(JEditBuffer buffer, int line, int col) {
            int returnValue = buffer.getOffsetOfVirtualColumn(line, col, null);
            if (returnValue == -1) {
                return buffer.getLineEndOffset(line) - 1;
            }
            return buffer.getLineStartOffset(line) + returnValue;
        }
    }

    public static class Range
    extends Selection {
        public Range() {
        }

        public Range(Selection sel) {
            super(sel);
        }

        public Range(int start, int end) {
            super(start, end);
        }

        @Override
        public int getStart(JEditBuffer buffer, int line) {
            if (line == this.startLine) {
                return this.start;
            }
            return buffer.getLineStartOffset(line);
        }

        @Override
        public int getEnd(JEditBuffer buffer, int line) {
            if (line == this.endLine) {
                return this.end;
            }
            return buffer.getLineEndOffset(line) - 1;
        }

        @Override
        void getText(JEditBuffer buffer, StringBuilder buf) {
            buf.append(buffer.getText(this.start, this.end - this.start));
        }

        @Override
        int setText(JEditBuffer buffer, String text) {
            buffer.remove(this.start, this.end - this.start);
            if (text != null && text.length() != 0) {
                buffer.insert(this.start, text);
                return this.start + text.length();
            }
            return this.start;
        }

        @Override
        boolean contentInserted(JEditBuffer buffer, int startLine, int start, int numLines, int length) {
            boolean changed = false;
            if (this.start >= start) {
                this.start += length;
                if (numLines != 0) {
                    this.startLine = buffer.getLineOfOffset(this.start);
                }
                changed = true;
            }
            if (this.end >= start) {
                this.end += length;
                if (numLines != 0) {
                    this.endLine = buffer.getLineOfOffset(this.end);
                }
                changed = true;
            }
            return changed;
        }

        @Override
        boolean contentRemoved(JEditBuffer buffer, int startLine, int start, int numLines, int length) {
            int end = start + length;
            boolean changed = false;
            if (this.start > start && this.start <= end) {
                this.start = start;
                changed = true;
            } else if (this.start > end) {
                this.start -= length;
                changed = true;
            }
            if (this.end > start && this.end <= end) {
                this.end = start;
                changed = true;
            } else if (this.end > end) {
                this.end -= length;
                changed = true;
            }
            if (changed && numLines != 0) {
                this.startLine = buffer.getLineOfOffset(this.start);
                this.endLine = buffer.getLineOfOffset(this.end);
            }
            return changed;
        }
    }
}

