/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.text.TabExpander;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.syntax.Chunk;
import org.gjt.sp.jedit.syntax.DefaultTokenHandler;
import org.gjt.sp.jedit.syntax.SyntaxStyle;
import org.gjt.sp.jedit.syntax.Token;
import org.gjt.sp.jedit.textarea.AntiAlias;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.util.Log;

public class TextAreaPainter
extends JComponent
implements TabExpander {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int BACKGROUND_LAYER = -60;
    public static final int LINE_BACKGROUND_LAYER = -50;
    public static final int BELOW_SELECTION_LAYER = -40;
    public static final int SELECTION_LAYER = -30;
    public static final int WRAP_GUIDE_LAYER = -20;
    public static final int BELOW_MOST_EXTENSIONS_LAYER = -10;
    public static final int DEFAULT_LAYER = 0;
    public static final int BLOCK_CARET_LAYER = 50;
    public static final int BRACKET_HIGHLIGHT_LAYER = 100;
    public static final int TEXT_LAYER = 200;
    public static final int CARET_LAYER = 300;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    TextArea textArea;
    SyntaxStyle[] styles;
    Color caretColor;
    Color selectionColor;
    Color multipleSelectionColor;
    Color lineHighlightColor;
    Color structureHighlightColor;
    Color eolMarkerColor;
    Color wrapGuideColor;
    SyntaxStyle[] foldLineStyle;
    boolean blockCaret;
    boolean thickCaret;
    boolean lineHighlight;
    boolean structureHighlight;
    boolean eolMarkers;
    boolean wrapGuide;
    AntiAlias antiAlias;
    boolean fracFontMetrics;
    RenderingHints renderingHints;
    boolean selectionFg;
    Color selectionFgColor;
    FontMetrics fm;
    int extraLineSpacing;
    private final ExtensionManager extensionMgr;
    private final PaintCaret caretExtension;
    private FontRenderContext fontRenderContext;
    private Cursor hiddenCursor;
    private boolean defaultCursor = true;

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (x == this.getX() && y == this.getY() && width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        super.setBounds(x, y, width, height);
        this.textArea.recalculateVisibleLines();
        if (!this.textArea.getBuffer().isLoading()) {
            this.textArea.recalculateLastPhysicalLine();
        }
        this.textArea.propertiesChanged();
        this.textArea.updateMaxHorizontalScrollWidth();
        this.textArea.scrollBarsInitialized = true;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.hiddenCursor = this.getToolkit().createCustomCursor(this.getGraphicsConfiguration().createCompatibleImage(16, 16, 2), new Point(0, 0), "Hidden");
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.defaultCursor = cursor == this.hiddenCursor || cursor.getType() == 2;
        super.setCursor(cursor);
    }

    public void resetCursor() {
        this.defaultCursor = true;
    }

    void showCursor() {
        if (this.defaultCursor) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    void hideCursor() {
        if (this.defaultCursor) {
            this.setCursor(this.hiddenCursor);
        }
    }

    @Override
    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public final SyntaxStyle[] getStyles() {
        return this.styles;
    }

    public final void setStyles(SyntaxStyle[] styles) {
        this.styles = styles;
        styles[0] = new SyntaxStyle(this.getForeground(), null, this.getFont());
        this.textArea.chunkCache.reset();
        this.repaint();
    }

    public final Color getCaretColor() {
        return this.caretColor;
    }

    public final void setCaretColor(Color caretColor) {
        this.caretColor = caretColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(Color selectionColor) {
        this.selectionColor = selectionColor;
        this.textArea.repaint();
    }

    public final Color getMultipleSelectionColor() {
        return this.multipleSelectionColor;
    }

    public final void setMultipleSelectionColor(Color multipleSelectionColor) {
        this.multipleSelectionColor = multipleSelectionColor;
        this.textArea.repaint();
    }

    public final Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public final void setLineHighlightColor(Color lineHighlightColor) {
        this.lineHighlightColor = lineHighlightColor;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isLineHighlightEnabled() {
        return this.lineHighlight;
    }

    public final void setLineHighlightEnabled(boolean lineHighlight) {
        this.lineHighlight = lineHighlight;
        this.textArea.repaint();
    }

    public final Color getSelectionFgColor() {
        return this.selectionFgColor;
    }

    public final void setSelectionFgColor(Color selectionFgColor) {
        this.selectionFgColor = selectionFgColor;
        if (this.isSelectionFgColorEnabled()) {
            this.textArea.repaint();
        }
    }

    public final boolean isSelectionFgColorEnabled() {
        return this.selectionFg;
    }

    public final void setSelectionFgColorEnabled(boolean selectionFg) {
        this.selectionFg = selectionFg;
        this.textArea.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color structureHighlightColor) {
        this.structureHighlightColor = structureHighlightColor;
        this.textArea.invalidateStructureMatch();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean structureHighlight) {
        this.structureHighlight = structureHighlight;
        this.textArea.invalidateStructureMatch();
    }

    public final boolean isBlockCaretEnabled() {
        return this.blockCaret;
    }

    public final void setBlockCaretEnabled(boolean blockCaret) {
        this.blockCaret = blockCaret;
        this.extensionMgr.removeExtension(this.caretExtension);
        if (blockCaret) {
            this.addExtension(50, this.caretExtension);
        } else {
            this.addExtension(300, this.caretExtension);
        }
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final boolean isThickCaretEnabled() {
        return this.thickCaret;
    }

    public final void setThickCaretEnabled(boolean thickCaret) {
        this.thickCaret = thickCaret;
        if (this.textArea.getBuffer() != null) {
            this.textArea.invalidateLine(this.textArea.getCaretLine());
        }
    }

    public final Color getEOLMarkerColor() {
        return this.eolMarkerColor;
    }

    public final void setEOLMarkerColor(Color eolMarkerColor) {
        this.eolMarkerColor = eolMarkerColor;
        this.repaint();
    }

    public final boolean getEOLMarkersPainted() {
        return this.eolMarkers;
    }

    public final void setEOLMarkersPainted(boolean eolMarkers) {
        this.eolMarkers = eolMarkers;
        this.repaint();
    }

    public final Color getWrapGuideColor() {
        return this.wrapGuideColor;
    }

    public final void setWrapGuideColor(Color wrapGuideColor) {
        this.wrapGuideColor = wrapGuideColor;
        this.repaint();
    }

    public final boolean isWrapGuidePainted() {
        return this.wrapGuide;
    }

    public final void setWrapGuidePainted(boolean wrapGuide) {
        this.wrapGuide = wrapGuide;
        this.repaint();
    }

    public final SyntaxStyle[] getFoldLineStyle() {
        return this.foldLineStyle;
    }

    public final void setFoldLineStyle(SyntaxStyle[] foldLineStyle) {
        this.foldLineStyle = foldLineStyle;
        this.textArea.chunkCache.reset();
        this.repaint();
    }

    public void setAntiAlias(AntiAlias newValue) {
        this.antiAlias = newValue;
        this.updateRenderingHints();
    }

    public AntiAlias getAntiAlias() {
        return this.antiAlias;
    }

    public void setFractionalFontMetricsEnabled(boolean fracFontMetrics) {
        this.fracFontMetrics = fracFontMetrics;
        this.updateRenderingHints();
    }

    public boolean isFractionalFontMetricsEnabled() {
        return this.fracFontMetrics;
    }

    public FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public void addExtension(TextAreaExtension extension) {
        this.extensionMgr.addExtension(0, extension);
        this.repaint();
    }

    public void addExtension(int layer, TextAreaExtension extension) {
        this.extensionMgr.addExtension(layer, extension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension extension) {
        this.extensionMgr.removeExtension(extension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.textArea.getBuffer().isLoading()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(evt.getX(), evt.getY());
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public int getLineHeight() {
        return this.fm.getHeight() + this.extraLineSpacing;
    }

    public int getFontHeight() {
        return this.fm.getHeight();
    }

    public int getLineExtraSpacing() {
        return this.extraLineSpacing;
    }

    public void setLineExtraSpacing(int spacing) {
        this.extraLineSpacing = spacing;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.textArea.recalculateVisibleLines();
        if (this.textArea.getBuffer() != null && !this.textArea.getBuffer().isLoading()) {
            this.textArea.recalculateLastPhysicalLine();
        }
    }

    public float getStringWidth(String str) {
        if (this.textArea.charWidth != 0) {
            return this.textArea.charWidth * str.length();
        }
        return (float)this.getFont().getStringBounds(str, this.getFontRenderContext()).getWidth();
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void update(Graphics _gfx) {
        this.paint(_gfx);
    }

    @Override
    public void paint(Graphics _gfx) {
        assert (_gfx instanceof Graphics2D);
        Graphics2D gfx = (Graphics2D)_gfx;
        gfx.setRenderingHints(this.renderingHints);
        this.fontRenderContext = gfx.getFontRenderContext();
        Rectangle clipRect = gfx.getClipBounds();
        int lineHeight = this.getLineHeight();
        int charHeight = this.getFontHeight();
        if (lineHeight == 0 || this.textArea.getBuffer().isLoading()) {
            gfx.setColor(this.getBackground());
            gfx.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        } else {
            long prepareTime = System.nanoTime();
            int firstLine = clipRect.y / lineHeight;
            int lastLine = (clipRect.y + clipRect.height - 1) / lineHeight;
            gfx.setColor(this.getBackground());
            gfx.setFont(this.getFont());
            prepareTime = System.nanoTime() - prepareTime;
            long linesTime = System.nanoTime();
            int numLines = lastLine - firstLine + 1;
            int y = firstLine * lineHeight;
            gfx.fillRect(0, y, this.getWidth(), numLines * lineHeight);
            this.extensionMgr.paintScreenLineRange(this.textArea, gfx, firstLine, lastLine, y, lineHeight);
            linesTime = System.nanoTime() - linesTime;
            if (Debug.PAINT_TIMER && numLines >= 1) {
                Log.log(1, this, "repainting " + numLines + " lines took " + prepareTime + "/" + linesTime + " ns");
            }
        }
        this.textArea.updateMaxHorizontalScrollWidth();
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        int ntabs = (int)(x / this.textArea.tabSize);
        return (float)(ntabs + 1) * this.textArea.tabSize;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = new Dimension();
        char[] foo = new char[80];
        for (int i = 0; i < foo.length; ++i) {
            foo[i] = 32;
        }
        dim.width = (int)this.getStringWidth(new String(foo));
        dim.height = this.getLineHeight() * 25;
        return dim;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    TextAreaPainter(TextArea textArea) {
        this.enableEvents(28L);
        this.textArea = textArea;
        this.antiAlias = new AntiAlias(0);
        this.extensionMgr = new ExtensionManager();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.setDoubleBuffered(false);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.fontRenderContext = new FontRenderContext(null, false, false);
        this.addExtension(-50, new PaintLineBackground());
        this.addExtension(-30, new PaintSelection());
        this.addExtension(-20, new PaintWrapGuide());
        this.addExtension(100, new StructureMatcher.Highlight(textArea));
        this.addExtension(200, new PaintText());
        this.addExtension(200, new PaintSelectionText());
        this.caretExtension = new PaintCaret();
        this.extraLineSpacing = 0;
    }

    private void updateRenderingHints() {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, this.antiAlias.renderHint());
        if (this.antiAlias.val() == 0) {
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        } else if (this.antiAlias.val() > 1) {
            Object fontRenderHint = this.fracFontMetrics ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.renderHint(), fontRenderHint);
        } else {
            hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.fontRenderContext = new FontRenderContext(null, this.antiAlias.val() > 0, this.fracFontMetrics);
        }
        this.renderingHints = new RenderingHints(hints);
    }

    private class PaintCaret
    extends TextAreaExtension {
        private PaintCaret() {
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (!TextAreaPainter.this.textArea.isCaretVisible()) {
                return;
            }
            int caret = TextAreaPainter.this.textArea.getCaretPosition();
            if (caret < start || caret >= end) {
                return;
            }
            int offset = caret - TextAreaPainter.this.textArea.getLineStartOffset(physicalLine);
            TextAreaPainter.this.textArea.offsetToXY(physicalLine, offset, TextAreaPainter.this.textArea.offsetXY);
            int caretX = TextAreaPainter.this.textArea.offsetXY.x;
            int lineHeight = TextAreaPainter.this.getLineHeight();
            int charHeight = TextAreaPainter.this.getFontHeight();
            int charOffset = lineHeight - charHeight;
            gfx.setColor(TextAreaPainter.this.caretColor);
            if (TextAreaPainter.this.textArea.isOverwriteEnabled()) {
                if (TextAreaPainter.this.thickCaret) {
                    gfx.fillRect(caretX, y + lineHeight - 4, TextAreaPainter.this.textArea.charWidth, 3);
                } else {
                    gfx.drawLine(caretX, y + lineHeight - 1, caretX + TextAreaPainter.this.textArea.charWidth, y + lineHeight - 1);
                }
            } else if (TextAreaPainter.this.blockCaret) {
                gfx.drawRect(caretX, y + charOffset, TextAreaPainter.this.textArea.charWidth - 1, charHeight - 1);
            } else if (TextAreaPainter.this.thickCaret) {
                gfx.fillRect(caretX, y + charOffset, 3, charHeight - 1);
            } else {
                gfx.drawLine(caretX, y + charOffset, caretX, y + charOffset + charHeight - 1);
            }
        }
    }

    private class PaintText
    extends TextAreaExtension {
        private PaintText() {
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            int x;
            ChunkCache.LineInfo lineInfo = TextAreaPainter.this.textArea.chunkCache.getLineInfo(screenLine);
            Font defaultFont = TextAreaPainter.this.getFont();
            Color defaultColor = TextAreaPainter.this.getForeground();
            gfx.setFont(defaultFont);
            gfx.setColor(defaultColor);
            int originalX = x = TextAreaPainter.this.textArea.getHorizontalOffset();
            float baseLine = y + TextAreaPainter.this.getLineHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
            if (lineInfo.chunks != null) {
                x = (int)((float)x + Chunk.paintChunkList(lineInfo.chunks, gfx, TextAreaPainter.this.textArea.getHorizontalOffset(), baseLine, !Debug.DISABLE_GLYPH_VECTOR));
            }
            JEditBuffer buffer = TextAreaPainter.this.textArea.getBuffer();
            if (!lineInfo.lastSubregion) {
                gfx.setFont(defaultFont);
                gfx.setColor(TextAreaPainter.this.eolMarkerColor);
                gfx.drawString(":", (float)Math.max(x, TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.wrapMargin + TextAreaPainter.this.textArea.charWidth), baseLine);
                x += TextAreaPainter.this.textArea.charWidth;
            } else if (physicalLine < buffer.getLineCount() - 1 && buffer.isFoldStart(physicalLine) && !TextAreaPainter.this.textArea.displayManager.isLineVisible(physicalLine + 1)) {
                int level = buffer.getFoldLevel(physicalLine + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    level = Math.max(1, level / buffer.getIndentSize());
                }
                if (level > 3) {
                    level = 0;
                }
                SyntaxStyle foldLineStyle = TextAreaPainter.this.foldLineStyle[level];
                Font font = foldLineStyle.getFont();
                gfx.setFont(font);
                gfx.setColor(foldLineStyle.getForegroundColor());
                int nextScreenLine = screenLine + 1;
                int nextLine = nextScreenLine < TextAreaPainter.this.textArea.getVisibleLines() ? TextAreaPainter.this.textArea.chunkCache.getLineInfo((int)nextScreenLine).physicalLine : TextAreaPainter.this.textArea.displayManager.getNextVisibleLine(physicalLine);
                if (nextLine == -1) {
                    nextLine = TextAreaPainter.this.textArea.getLineCount();
                }
                int count = nextLine - physicalLine - 1;
                String str = " [" + count + " lines]";
                float width = TextAreaPainter.this.getStringWidth(str);
                gfx.drawString(str, (float)x, baseLine);
                x = (int)((float)x + width);
            } else if (TextAreaPainter.this.eolMarkers) {
                gfx.setFont(defaultFont);
                gfx.setColor(TextAreaPainter.this.eolMarkerColor);
                gfx.drawString(".", (float)x, baseLine);
                x += TextAreaPainter.this.textArea.charWidth;
            }
            lineInfo.width = x - originalX;
        }
    }

    private class PaintWrapGuide
    extends TextAreaExtension {
        private PaintWrapGuide() {
        }

        @Override
        public void paintScreenLineRange(Graphics2D gfx, int firstLine, int lastLine, int[] physicalLines, int[] start, int[] end, int y, int lineHeight) {
            if (TextAreaPainter.this.textArea.wrapMargin != 0 && !TextAreaPainter.this.textArea.wrapToWidth && TextAreaPainter.this.isWrapGuidePainted()) {
                gfx.setColor(TextAreaPainter.this.getWrapGuideColor());
                int x = TextAreaPainter.this.textArea.getHorizontalOffset() + TextAreaPainter.this.textArea.wrapMargin;
                gfx.drawLine(x, y, x, y + (lastLine - firstLine + 1) * lineHeight);
            }
        }

        @Override
        public String getToolTipText(int x, int y) {
            int wrapGuidePos;
            if (TextAreaPainter.this.textArea.wrapMargin != 0 && !TextAreaPainter.this.textArea.wrapToWidth && TextAreaPainter.this.isWrapGuidePainted() && Math.abs(x - (wrapGuidePos = TextAreaPainter.this.textArea.wrapMargin + TextAreaPainter.this.textArea.getHorizontalOffset())) < 5) {
                return String.valueOf(TextAreaPainter.this.textArea.getBuffer().getProperty("maxLineLen"));
            }
            return null;
        }
    }

    private class PaintSelectionText
    extends TextAreaExtension {
        private float indent;
        private boolean indentFound = false;

        private PaintSelectionText() {
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (TextAreaPainter.this.textArea.getSelectionCount() == 0) {
                return;
            }
            if (!TextAreaPainter.this.isSelectionFgColorEnabled() || TextAreaPainter.this.getSelectionFgColor() == null) {
                return;
            }
            Iterator<Selection> iter = TextAreaPainter.this.textArea.getSelectionIterator();
            while (iter.hasNext()) {
                Selection s = iter.next();
                this.paintSelection(gfx, screenLine, physicalLine, y, s);
            }
        }

        private void paintSelection(Graphics2D gfx, int screenLine, int physicalLine, int y, Selection s) {
            int endOffset;
            int startOffset;
            if (physicalLine < s.getStartLine() || physicalLine > s.getEndLine()) {
                return;
            }
            float x = this.indent = (float)TextAreaPainter.this.textArea.getHorizontalOffset();
            float baseLine = y + TextAreaPainter.this.fm.getHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
            DefaultTokenHandler tokenHandler = new DefaultTokenHandler();
            TextAreaPainter.this.textArea.getBuffer().markTokens(physicalLine, tokenHandler);
            Token token = tokenHandler.getTokens();
            int lineStart = TextAreaPainter.this.textArea.getLineStartOffset(physicalLine);
            if (s instanceof Selection.Rect) {
                Selection.Rect r = (Selection.Rect)s;
                startOffset = r.getStart(TextAreaPainter.this.textArea.getBuffer(), physicalLine);
                endOffset = r.getEnd(TextAreaPainter.this.textArea.getBuffer(), physicalLine);
            } else {
                startOffset = s.getStart() > lineStart ? s.getStart() : lineStart;
                endOffset = s.getEnd();
            }
            int screenLineStart = TextAreaPainter.this.textArea.getScreenLineStartOffset(screenLine);
            int screenLineEnd = TextAreaPainter.this.textArea.getScreenLineEndOffset(screenLine);
            if (screenLineStart > startOffset) {
                startOffset = screenLineStart;
            }
            if (screenLineEnd < endOffset) {
                endOffset = screenLineEnd;
            }
            this.indentFound = false;
            int tokenStart = lineStart;
            while (token.id != 127) {
                int next = tokenStart + token.length;
                String sub = null;
                SyntaxStyle style = TextAreaPainter.this.styles[token.id];
                if (next > startOffset) {
                    if (tokenStart >= endOffset) break;
                    if (style != null) {
                        int strStart;
                        gfx.setFont(style.getFont());
                        gfx.setColor(TextAreaPainter.this.getSelectionFgColor());
                        if (startOffset > tokenStart) {
                            strStart = startOffset;
                            x = this.nextX(x, style, sub, tokenStart, startOffset);
                        } else {
                            strStart = tokenStart;
                        }
                        int strEnd = endOffset > next ? next : endOffset;
                        sub = TextAreaPainter.this.textArea.getText(strStart, strEnd - strStart);
                        gfx.drawString(sub, x, baseLine);
                        x = this.nextX(x, style, sub, strStart, strEnd);
                    }
                }
                if (sub == null) {
                    x = this.nextX(x, style, null, tokenStart, next);
                }
                tokenStart = next;
                token = token.next;
                if (tokenStart != screenLineStart) continue;
                x = this.indent;
            }
        }

        float nextX(float x, SyntaxStyle style, String s, int startOffset, int endOffset) {
            if (s == null) {
                s = TextAreaPainter.this.textArea.getText(startOffset, endOffset - startOffset);
            }
            if (s.equals("\t")) {
                int horzOffset = TextAreaPainter.this.textArea.getHorizontalOffset();
                x = TextAreaPainter.this.nextTabStop(x - (float)horzOffset, endOffset) + (float)horzOffset;
            } else {
                if (!this.indentFound && !s.equals(" ")) {
                    this.indentFound = true;
                    this.indent = x;
                }
                Font font = style != null ? style.getFont() : TextAreaPainter.this.getFont();
                x = (float)((double)x + font.getStringBounds(s, TextAreaPainter.this.getFontRenderContext()).getWidth());
            }
            return x;
        }
    }

    private class PaintSelection
    extends TextAreaExtension {
        private PaintSelection() {
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            if (TextAreaPainter.this.textArea.getSelectionCount() == 0) {
                return;
            }
            gfx.setColor(TextAreaPainter.this.textArea.isMultipleSelectionEnabled() ? TextAreaPainter.this.getMultipleSelectionColor() : TextAreaPainter.this.getSelectionColor());
            Iterator<Selection> iter = TextAreaPainter.this.textArea.getSelectionIterator();
            while (iter.hasNext()) {
                Selection s = iter.next();
                this.paintSelection(gfx, screenLine, physicalLine, y, s);
            }
        }

        private void paintSelection(Graphics2D gfx, int screenLine, int physicalLine, int y, Selection s) {
            int[] selectionStartAndEnd = TextAreaPainter.this.textArea.selectionManager.getSelectionStartAndEnd(screenLine, physicalLine, s);
            if (selectionStartAndEnd == null) {
                return;
            }
            int x1 = selectionStartAndEnd[0];
            int x2 = selectionStartAndEnd[1];
            gfx.fillRect(x1, y, x2 - x1, TextAreaPainter.this.getLineHeight());
        }
    }

    private class PaintLineBackground
    extends TextAreaExtension {
        private PaintLineBackground() {
        }

        private boolean shouldPaintLineHighlight(int caret, int start, int end) {
            if (!TextAreaPainter.this.isLineHighlightEnabled() || caret < start || caret >= end) {
                return false;
            }
            int count = TextAreaPainter.this.textArea.getSelectionCount();
            if (count == 1) {
                Selection s = TextAreaPainter.this.textArea.getSelection(0);
                return s.getStartLine() == s.getEndLine();
            }
            return count == 0;
        }

        @Override
        public void paintValidLine(Graphics2D gfx, int screenLine, int physicalLine, int start, int end, int y) {
            Color bgColor;
            int caret;
            boolean paintLineHighlight;
            TextArea textArea = TextAreaPainter.this.textArea;
            JEditBuffer buffer = textArea.getBuffer();
            boolean collapsedFold = physicalLine < buffer.getLineCount() - 1 && buffer.isFoldStart(physicalLine) && !textArea.displayManager.isLineVisible(physicalLine + 1);
            SyntaxStyle foldLineStyle = null;
            if (collapsedFold) {
                int level = buffer.getFoldLevel(physicalLine + 1);
                if (buffer.getFoldHandler() instanceof IndentFoldHandler) {
                    level = Math.max(1, level / buffer.getIndentSize());
                }
                if (level > 3) {
                    level = 0;
                }
                foldLineStyle = TextAreaPainter.this.foldLineStyle[level];
            }
            if (paintLineHighlight = this.shouldPaintLineHighlight(caret = textArea.getCaretPosition(), start, end)) {
                bgColor = TextAreaPainter.this.lineHighlightColor;
            } else if (collapsedFold) {
                bgColor = foldLineStyle.getBackgroundColor();
                if (bgColor == null) {
                    bgColor = TextAreaPainter.this.getBackground();
                }
            } else {
                bgColor = TextAreaPainter.this.getBackground();
            }
            if (paintLineHighlight || collapsedFold) {
                gfx.setColor(bgColor);
                gfx.fillRect(0, y, TextAreaPainter.this.getWidth(), TextAreaPainter.this.getLineHeight());
            }
            ChunkCache.LineInfo lineInfo = textArea.chunkCache.getLineInfo(screenLine);
            if (lineInfo.chunks != null) {
                float baseLine = y + TextAreaPainter.this.getLineHeight() - (TextAreaPainter.this.fm.getLeading() + 1) - TextAreaPainter.this.fm.getDescent();
                Chunk.paintChunkBackgrounds(lineInfo.chunks, gfx, textArea.getHorizontalOffset(), baseLine, TextAreaPainter.this.getLineHeight());
            }
        }
    }
}

