/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jnpad.GUIUtilities;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.text.IBuffer;
import jnpad.ui.EscapableDialog;
import jnpad.ui.JNPadCheckBox;
import jnpad.ui.JNPadLabel;
import jnpad.ui.icon.CompositeIcon;
import jnpad.ui.tab.ITabbedPane;
import jnpad.util.Utilities;

public class ExitDialog
extends EscapableDialog {
    JPanel contentPane;
    JPanel pnBackground = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JPanel pnList = new JPanel();
    JPanel pnFiles = new JPanel();
    JPanel pnClosingFilesNotSaved = new JPanel();
    JPanel pnButtons = new JPanel();
    JPanel pnWest = new JPanel();
    JPanel pnEast = new JPanel();
    JButton btAll = new JButton();
    JButton btNone = new JButton();
    JButton btOk = new JButton();
    JButton btCancel = new JButton();
    GridLayout gridLayout = new GridLayout();
    GridLayout gridLayout2 = new GridLayout();
    private JNPadFrame jNPad;
    private ITabbedPane tabbedPane;
    private boolean isOk;
    private int mode;
    private List<JCheckBox> l_checkBoxs = new ArrayList<JCheckBox>();
    private List<JCheckBox> l_checkBoxs2 = new ArrayList<JCheckBox>();
    public static final int SAVE = 1;
    public static final int CLOSE = 2;
    public static final int CLOSE_WITHOUT_CONFIRMATION = 3;
    private static final Color BACKGROUND = Config.TEXT_BACKGROUND.getValue();
    private static final Color FOREGROUND = Config.TEXT_FOREGROUND.getValue();
    private static final Color SELECTION_BACKGROUND = Config.TEXT_SELECTION_BACKGROUND.getValue();
    private static final Color SELECTION_FOREGROUND = Config.TEXT_SELECTION_FOREGROUND.getValue();
    private static final Logger LOGGER = Logger.getLogger(ExitDialog.class.getName());
    private static final long serialVersionUID = 5244491784231898377L;

    private ExitDialog(JNPadFrame jNPad, ITabbedPane tabbedPane, int mode) throws HeadlessException {
        super(jNPad, "", true);
        jNPad.repaint();
        this.jNPad = jNPad;
        this.tabbedPane = tabbedPane;
        this.mode = mode;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.pnButtons, "South");
        this.contentPane.add((Component)this.pnBackground, "Center");
        this.pnBackground.setBorder(GUIUtilities.createEmptyBorder(5));
        this.pnBackground.setLayout(new BorderLayout());
        this.pnBackground.add((Component)this.scrollPane, "Center");
        this.pnButtons.setLayout(new BorderLayout());
        this.pnButtons.add((Component)this.pnWest, "West");
        this.pnButtons.add((Component)this.pnEast, "East");
        this.pnEast.add((Component)this.btOk, null);
        this.pnEast.add((Component)this.btCancel, null);
        this.pnWest.add((Component)this.btAll, null);
        this.pnWest.add((Component)this.btNone, null);
        this.pnList.setBackground(BACKGROUND);
        this.pnList.setLayout(new BorderLayout());
        this.scrollPane.getViewport().add((Component)this.pnList, null);
        this.pnList.add((Component)this.pnFiles, "North");
        this.pnFiles.setLayout(this.gridLayout);
        this.pnClosingFilesNotSaved.setLayout(this.gridLayout2);
        GUIUtilities.setLocalizedText(this.btAll, JNPadBundle.getAllButtonText());
        GUIUtilities.setLocalizedText(this.btNone, JNPadBundle.getNoneButtonText());
        GUIUtilities.setLocalizedText(this.btCancel, JNPadBundle.getCancelButtonText());
        GUIUtilities.setLocalizedText(this.btOk, JNPadBundle.getOkButtonText());
        Dimension dimension = this.btCancel.getPreferredSize();
        this.btAll.setPreferredSize(dimension);
        this.btNone.setPreferredSize(dimension);
        this.btOk.setPreferredSize(dimension);
        ActionHandler actionHandler = new ActionHandler();
        this.btAll.addActionListener(actionHandler);
        this.btNone.addActionListener(actionHandler);
        this.btOk.addActionListener(actionHandler);
        this.btCancel.addActionListener(actionHandler);
    }

    private void load(String text, String tooltip, Icon icon, boolean isSelected, List<JCheckBox> list, JPanel panel) {
        Element elem = new Element(text, tooltip, icon, isSelected);
        panel.add((Component)elem, null);
        list.add(elem.jCheckBox);
    }

    public static boolean showDialog(JNPadFrame jNPad, ITabbedPane tabbedPane, int mode) {
        ExitDialog dlg = new ExitDialog(jNPad, tabbedPane, mode);
        boolean isOk = dlg.showFileSaveDialog();
        dlg.dispose();
        dlg = null;
        return isOk;
    }

    private boolean showFileSaveDialog() {
        this.setTitle(this.mode == 1 ? JNPadBundle.getString("ExitDialog.save", new Object[0]) : JNPadBundle.getString("ExitDialog.close", new Object[0]));
        int i = 0;
        int j = 0;
        while (j < this.tabbedPane.getTabCount()) {
            IBuffer editFile = (IBuffer)((Object)this.tabbedPane.getComponentAt(j));
            boolean flag = false;
            if (editFile.isDirty() && this.mode == 1) {
                flag = true;
            }
            if (editFile.isDirty() || this.mode != 1) {
                this.load(this.get_name(editFile.getFilePath()), editFile.getFilePath(), this.get_icon(j), flag, this.l_checkBoxs, this.pnFiles);
                ++i;
            }
            ++j;
        }
        if (i == 0) {
            return true;
        }
        this.gridLayout.setColumns(1);
        this.gridLayout.setRows(i);
        this.setSize(new Dimension(380, 300));
        this.validate();
        this.setLocationRelativeTo(this.jNPad);
        this.setVisible(true);
        return this.isOk;
    }

    private Icon get_icon(int index) {
        Icon icon;
        if (index > -1 && this.tabbedPane.getTabCount() > index) {
            icon = this.tabbedPane.getIconAt(index);
            if (icon instanceof CompositeIcon && ((CompositeIcon)icon).hasMainIcon()) {
                icon = ((CompositeIcon)icon).getMainIcon();
            }
        } else {
            icon = null;
        }
        return icon;
    }

    private String get_name(String path) {
        String name = Utilities.isURL(path) ? path.substring(path.lastIndexOf(47) + 1) : path.substring(path.lastIndexOf(Utilities.DIR_SEPARATOR) + 1);
        return name;
    }

    private void selectAll(boolean flag) {
        if (this.mode == 3) {
            for (JCheckBox aL_checkBoxs2 : this.l_checkBoxs2) {
                aL_checkBoxs2.getModel().setSelected(flag);
            }
        } else {
            for (JCheckBox l_checkBox : this.l_checkBoxs) {
                l_checkBox.getModel().setSelected(flag);
            }
        }
    }

    private void fileOkAction() {
        for (JCheckBox cb : this.l_checkBoxs) {
            if (!cb.isSelected()) continue;
            if (this.mode == 1) {
                this.jNPad.saveFile(cb.getToolTipText());
                continue;
            }
            this.jNPad.closeFile(cb.getToolTipText(), false);
        }
    }

    private void ok() {
        if (this.mode == 1) {
            this.fileOkAction();
            this.isOk = true;
            this.setVisible(false);
        } else if (this.mode == 2) {
            int j = 0;
            int k = 0;
            while (k < this.l_checkBoxs.size()) {
                IBuffer editFile = (IBuffer)((Object)this.tabbedPane.getComponentAt(k));
                JCheckBox cb = this.l_checkBoxs.get(k);
                if (cb.isSelected() && editFile.isDirty()) {
                    this.load(this.get_name(editFile.getFilePath()), editFile.getFilePath(), this.get_icon(k), true, this.l_checkBoxs2, this.pnClosingFilesNotSaved);
                    ++j;
                }
                ++k;
            }
            if (j == 0) {
                this.fileOkAction();
                this.isOk = true;
                this.setVisible(false);
            }
            this.setTitle(JNPadBundle.getString("ExitDialog.save", new Object[0]));
            this.pnList.remove(this.pnFiles);
            this.pnList.add((Component)this.pnClosingFilesNotSaved, "North");
            this.gridLayout2.setColumns(1);
            this.gridLayout2.setRows(j);
            this.validate();
            this.repaint();
            this.setLocationRelativeTo(this.jNPad);
            this.mode = 3;
        } else if (this.mode == 3) {
            for (JCheckBox cb : this.l_checkBoxs2) {
                if (!cb.isSelected()) continue;
                this.jNPad.saveFile(cb.getToolTipText());
            }
            this.fileOkAction();
            this.isOk = true;
            this.setVisible(false);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj == ExitDialog.this.btAll) {
                ExitDialog.this.selectAll(true);
            } else if (obj == ExitDialog.this.btNone) {
                ExitDialog.this.selectAll(false);
            } else if (obj == ExitDialog.this.btOk) {
                ExitDialog.this.ok();
            } else if (obj == ExitDialog.this.btCancel) {
                ExitDialog.this.setVisible(false);
            }
        }
    }

    static class Element
    extends JPanel {
        JLabel jLabel = new JNPadLabel();
        JCheckBox jCheckBox = new JNPadCheckBox();
        private boolean isItemStateChangedEnabled = true;
        private static final long serialVersionUID = 4259566005639886427L;

        Element(String text, String tooltip, Icon icon, boolean isSelected) {
            super(new FlowLayout(0, 2, 0));
            this.setBackground(BACKGROUND);
            this.add((Component)this.jCheckBox, null);
            this.add((Component)this.jLabel, null);
            this.jLabel.setText(text);
            this.jLabel.setOpaque(true);
            this.jLabel.setIcon(icon);
            this.jLabel.setToolTipText(tooltip);
            this.jCheckBox.setOpaque(true);
            this.jCheckBox.setBackground(BACKGROUND);
            this.jCheckBox.setToolTipText(tooltip);
            this.select(isSelected);
            this.jLabel.addMouseListener(new MouseHandler());
            this.jCheckBox.addItemListener(new ItemHandler());
        }

        private void select(boolean isSelected) {
            if (isSelected) {
                this.jLabel.setBackground(SELECTION_BACKGROUND);
                this.jLabel.setForeground(SELECTION_FOREGROUND);
            } else {
                this.jLabel.setBackground(BACKGROUND);
                this.jLabel.setForeground(FOREGROUND);
            }
            this.isItemStateChangedEnabled = false;
            this.jCheckBox.setSelected(isSelected);
            this.isItemStateChangedEnabled = true;
        }

        private class ItemHandler
        implements ItemListener {
            private ItemHandler() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!Element.this.isItemStateChangedEnabled) {
                    return;
                }
                Element.this.select(Element.this.jCheckBox.isSelected());
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Element.this.select(!Element.this.jCheckBox.isSelected());
            }
        }
    }
}

