/*
 * Decompiled with CFR 0.152.
 */
package jnpad;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ChangeEvent;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.config.Config;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.text.Viewer;
import jnpad.util.Utilities;

public abstract class JNPadViewer
extends Viewer {
    JMenu mWindow;
    ButtonGroup bgWindow = new ButtonGroup();
    boolean isItemStateEnabled = true;
    final ItemListener itemHandler = new ItemHandler();
    static ImageIcon iiFile;
    static ImageIcon iiFileReadOnly;
    static ImageIcon iiFileModified;
    static ImageIcon iiFileModifiedReadOnly;
    static ImageIcon iiFileNew;
    static ImageIcon iiFileNewReadOnly;
    private static final Logger LOGGER;
    private static final long serialVersionUID = -812875419301736726L;

    static {
        LOGGER = Logger.getLogger(JNPadViewer.class.getName());
        try {
            iiFile = GUIUtilities.getIcon("file.png");
            iiFileReadOnly = GUIUtilities.getIcon("file-readonly.png");
            iiFileModified = GUIUtilities.getIcon("file-modified.png");
            iiFileModifiedReadOnly = GUIUtilities.getIcon("file-modified-readonly.png");
            iiFileNew = GUIUtilities.getIcon("file-new.png");
            iiFileNewReadOnly = GUIUtilities.getIcon("file-new-readonly.png");
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    public JNPadViewer(JNPadFrame jNPad, JMenu mWindow) {
        super(jNPad);
        this.mWindow = mWindow;
    }

    JNPadFrame getJNPad() {
        return this._jNPad;
    }

    @Override
    protected void handleStateChanged(ChangeEvent e) {
        if (this.isSuppressStateChangedEvents()) {
            return;
        }
        if (this.getActiveIndex() <= -1) {
            this._jNPad.setTitle("jNPad");
            return;
        }
        Buffer buffer = this.getActiveBuffer();
        buffer.requestFocus();
        this._jNPad.handleStateChanged(buffer);
        String path = buffer.getFilePath();
        Enumeration<AbstractButton> en = this.bgWindow.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (!rbmi.getToolTipText().equals(path)) continue;
            if (rbmi.isSelected()) break;
            this.isItemStateEnabled = false;
            rbmi.setSelected(true);
            this.isItemStateEnabled = true;
            break;
        }
    }

    protected Icon getIcon(Buffer buffer) {
        ImageIcon icon = buffer.isDirty() && !buffer.isReadOnly() ? iiFileModified : (buffer.isDirty() && buffer.isReadOnly() ? iiFileModifiedReadOnly : (!buffer.isDirty() && buffer.isReadOnly() ? iiFileReadOnly : (buffer.isNew() && !buffer.isReadOnly() ? iiFileNew : (buffer.isNew() && buffer.isReadOnly() ? iiFileNewReadOnly : iiFile))));
        return icon;
    }

    protected String getTitle(Buffer buffer) {
        int j;
        String path = buffer.getFilePath();
        String name = Utilities.getFileName(path);
        if (!Config.TAB_FILE_EXTENSION.getValue().booleanValue() && (j = name.lastIndexOf(46)) > -1) {
            name = name.substring(0, j);
        }
        return name;
    }

    public void setAllComponentIcon() {
        int i = 0;
        while (i < this.getBufferCount()) {
            this.setComponentIconAt(i);
            ++i;
        }
    }

    public void refreshNameAndIcon() {
        int i;
        if (Config.TAB_FILE_ICON.getValue().booleanValue()) {
            i = 0;
            while (i < this.getBufferCount()) {
                this.setComponentIconAt(i);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.getBufferCount()) {
                this._bufferSet.setIconAt(i, null);
                ++i;
            }
        }
        if (Config.TAB_FILE_EXTENSION.getValue().booleanValue()) {
            i = 0;
            while (i < this.getBufferCount()) {
                this.setTitleAt(i, this.getTitle(this.getBufferAt(i)));
                ++i;
            }
        }
    }

    @Override
    public void setComponentIconAt(int index) {
        Buffer buffer = this.getBufferAt(index);
        Icon icon = this.getIcon(buffer);
        this._bufferSet.setIconAt(index, icon);
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            if (bufferSet != this._bufferSet) {
                for (Buffer buff : bufferSet) {
                    if (!buffer.equals(buff)) continue;
                    bufferSet.setIconAt(bufferSet.indexOfComponent(buff), icon);
                }
            }
            ++n2;
        }
    }

    @Override
    public Buffer add(Buffer buffer) {
        String path = buffer.getFilePath();
        String name = Utilities.getFileName(path);
        String title = this.getTitle(buffer);
        Icon icon = Config.TAB_FILE_ICON.getValue() != false ? this.getIcon(buffer) : null;
        JRadioButtonMenuItem rbmi = new JRadioButtonMenuItem(name);
        rbmi.setToolTipText(path);
        rbmi.addItemListener(this.itemHandler);
        this.mWindow.add(rbmi);
        this.bgWindow.add(rbmi);
        this._bufferSet.insertTab(title, icon, buffer, path, this._bufferSet.getTabCount());
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            if (bufferSet != this._bufferSet) {
                bufferSet.insertTab(title, icon, JNPadViewer.create(bufferSet, buffer), path, bufferSet.getTabCount());
            }
            ++n2;
        }
        if (this.getBufferCount() == 2) {
            this._jNPad.actions.previousBufferAction.setEnabled(true);
            this._jNPad.actions.nextBufferAction.setEnabled(true);
        }
        return buffer;
    }

    @Override
    public void removeBufferAt(int index) {
        JRadioButtonMenuItem rbmi;
        String path = this.getBufferAt(index).getFilePath();
        super.removeBufferAt(index);
        int len = this.getBufferCount();
        if (len == 0) {
            this._jNPad.reset();
        } else if (len == 1) {
            this._jNPad.actions.previousBufferAction.setEnabled(false);
            this._jNPad.actions.nextBufferAction.setEnabled(false);
        }
        Enumeration<AbstractButton> en = this.bgWindow.getElements();
        while (en.hasMoreElements()) {
            rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (!rbmi.getToolTipText().equals(path)) continue;
            this.mWindow.remove(rbmi);
            this.bgWindow.remove(rbmi);
            rbmi.removeItemListener(this.itemHandler);
            break;
        }
        if (len > 0) {
            path = this.getToolTipTextAt(this.getActiveIndex());
            en = this.bgWindow.getElements();
            while (en.hasMoreElements()) {
                rbmi = (JRadioButtonMenuItem)en.nextElement();
                if (!rbmi.getToolTipText().equals(path)) continue;
                rbmi.setSelected(true);
                break;
            }
        }
    }

    @Override
    public void setToolTipTextAt(int index, String toolTipText) {
        String oldToolTipText = this.getToolTipTextAt(index);
        super.setToolTipTextAt(index, toolTipText);
        Enumeration<AbstractButton> en = this.bgWindow.getElements();
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (!rbmi.getToolTipText().equals(oldToolTipText)) continue;
            rbmi.setToolTipText(toolTipText);
            String text = Utilities.isURL(oldToolTipText) ? toolTipText.substring(toolTipText.lastIndexOf(47) + 1) : toolTipText.substring(toolTipText.lastIndexOf(Utilities.DIR_SEPARATOR) + 1);
            rbmi.setText(text);
            break;
        }
    }

    class ItemHandler
    implements ItemListener,
    Serializable {
        private static final long serialVersionUID = 1820255320037614656L;

        ItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!JNPadViewer.this.isItemStateEnabled) {
                return;
            }
            String tootip = ((JRadioButtonMenuItem)e.getItem()).getToolTipText();
            int i = 0;
            while (i < JNPadViewer.this._bufferSet.getTabCount()) {
                if (JNPadViewer.this._bufferSet.getToolTipTextAt(i).equals(tootip)) {
                    if (JNPadViewer.this._bufferSet.getSelectedIndex() == i) break;
                    JNPadViewer.this._bufferSet.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
    }
}

