/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import jnpad.JNPadFrame;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Accelerators;
import jnpad.config.Config;
import jnpad.config.ViewActionScope;
import jnpad.text.Viewer;

public final class LineWrapAction
extends JNPadAction {
    private static final long serialVersionUID = -4632156543872628477L;

    public LineWrapAction(JNPadFrame jNPad) {
        super(jNPad, "line-wrap", JNPadActions.Group.VIEW, Accelerators.LINE_WRAP, "line-wrap.png");
        this.setSelected(Config.TEXT_LINE_WRAP.getValue());
        this.setStateAction(true);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        ViewActionScope scope = Config.VIEW_ACTION_SCOPE.getValue();
        Viewer viewer = this.jNPad.getViewer();
        switch (scope) {
            case VIEWER: {
                viewer.setLineWrap(1 == e.getStateChange());
                break;
            }
            case BUFFER_SET: {
                viewer.getActiveBufferSet().setLineWrap(1 == e.getStateChange());
                break;
            }
            case EDIT_PANE: {
                viewer.getActiveEditPane().setLineWrap(1 == e.getStateChange());
                break;
            }
            default: {
                viewer.getActiveBuffer().setLineWrap(1 == e.getStateChange());
            }
        }
    }
}

