/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.ui.MnemonicHelper;

public final class SelectEncodingAction
extends JNPadAction
implements IEditAction {
    private String encoding;
    static final String NAME = "select-encoding";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = 5774689924855432940L;

    public SelectEncodingAction(JNPadFrame jNPad, String encoding, MnemonicHelper mnemonicHelper) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        char mnemonic;
        this.encoding = encoding;
        this.setLabel(encoding);
        String name = "select-encoding " + encoding;
        this.setName(name);
        if (mnemonicHelper != null && (mnemonic = mnemonicHelper.getMnemonic(this.getLabel())) != '\u0000') {
            this.setMnemonic(mnemonic);
        }
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), this.getLabel()));
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        Buffer buffer = this.jNPad.getActiveBuffer();
        if (buffer != null && 1 == e.getStateChange()) {
            buffer.setEncoding(this.encoding);
            this.jNPad.setStatus(ActionBundle.getString(NAME.concat(".message"), this.getLabel()), 10);
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

