/*
 * Decompiled with CFR 0.152.
 */
package jnpad.action;

import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import jnpad.JNPadBundle;
import jnpad.JNPadFrame;
import jnpad.action.ActionBundle;
import jnpad.action.JNPadAction;
import jnpad.action.JNPadActions;
import jnpad.config.Config;

public final class SelectLanguageAction
extends JNPadAction {
    private String lang;
    static final String NAME = "select-language";
    private static Map<String, JNPadAction> map = new HashMap<String, JNPadAction>();
    private static final long serialVersionUID = -6423115369750688232L;

    public SelectLanguageAction(JNPadFrame jNPad, String label, String lang, boolean selected) {
        super(jNPad, NAME, JNPadActions.Group.CONFIGURE);
        this.lang = lang;
        String name = "select-language " + lang;
        this.setName(name);
        this.setActionLabel(label);
        this.setDescription(ActionBundle.getString(NAME.concat(".description"), this.getLabel()));
        this.setSelected(selected);
        this.setStateAction(true);
        map.put(name, this);
    }

    @Override
    public void handleStateChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            Config.JNPAD_LANG.setValue(this.lang);
            String msg = ActionBundle.getString("select-language.message", this.getLabel());
            this.jNPad.setStatus(msg, 10);
            Object[] options = new String[]{JNPadBundle.getYesOptionText(), JNPadBundle.getNoOptionText()};
            int option = JOptionPane.showOptionDialog(this.jNPad, JNPadBundle.getString("JNPad.restart", msg), JNPadBundle.getString("select-language.title", new Object[0]), -1, 1, null, options, options[0]);
            if (option == 1 || option == -1) {
                return;
            }
            this.jNPad.restart();
        }
    }

    static List<String> getCompletionsForPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : map.keySet()) {
            JNPadAction action = map.get(key);
            if (!key.startsWith(prefix) || !action.isEnabled()) continue;
            list.add(key);
        }
        Collections.sort(list);
        return list;
    }

    static boolean performAction(String name) {
        JNPadAction action = map.get(name);
        if (action != null && action.isEnabled()) {
            action.setSelected(!action.isSelected());
            return true;
        }
        return false;
    }
}

