/*
 * Decompiled with CFR 0.152.
 */
package jnpad.config;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import jnpad.JNPadBundle;
import jnpad.config.BooleanProp;
import jnpad.config.Config;
import jnpad.util.Utilities;

public final class Accelerators {
    private static Properties shortcuts;
    private static final boolean USE_COMPOSITE_SHORTCUTS = true;
    private static Boolean useCompositeShortcuts;
    public static final KeyStroke NEW;
    public static final KeyStroke OPEN;
    public static final KeyStroke CLOSE;
    public static final KeyStroke CLOSE_FILES;
    public static final KeyStroke CLOSE_ALL;
    public static final KeyStroke SAVE;
    public static final KeyStroke SAVE_ALL;
    public static final KeyStroke SAVE_AS;
    public static final KeyStroke FILE_PROPERTIES;
    public static final KeyStroke FILE_BROWSER;
    public static final KeyStroke PRINT_SET;
    public static final KeyStroke PRINT;
    public static final KeyStroke RELOAD;
    public static final KeyStroke EXECUTE_ACTION;
    public static final KeyStroke REDUCE_AS_TRAY_ICON;
    public static final KeyStroke RESTART;
    public static final KeyStroke EXIT;
    public static final KeyStroke UNDO;
    public static final KeyStroke REDO;
    public static final KeyStroke CUT;
    public static final KeyStroke CUT_LINE;
    public static final KeyStroke COPY;
    public static final KeyStroke COPY_LINE;
    public static final KeyStroke PASTE;
    public static final KeyStroke SELECT_ALL;
    public static final KeyStroke SELECT_PARAGRAPH;
    public static final KeyStroke SELECTION_BEGIN_PARAGRAPH;
    public static final KeyStroke SELECTION_END_PARAGRAPH;
    public static final KeyStroke SELECT_LINE;
    public static final KeyStroke SELECTION_BEGIN_LINE;
    public static final KeyStroke SELECTION_END_LINE;
    public static final KeyStroke SELECT_WORD;
    public static final KeyStroke DELETE;
    public static final KeyStroke DELETE_PARAGRAPH;
    public static final KeyStroke DELETION_BEGIN_PARAGRAPH;
    public static final KeyStroke DELETION_END_PARAGRAPH;
    public static final KeyStroke DELETE_LINE;
    public static final KeyStroke DELETION_BEGIN_LINE;
    public static final KeyStroke DELETION_END_LINE;
    public static final KeyStroke DELETE_WORD;
    public static final KeyStroke TABS_TO_SPACES;
    public static final KeyStroke SPACES_TO_TABS;
    public static final KeyStroke BEGIN_LINES;
    public static final KeyStroke END_LINES;
    public static final KeyStroke DUPLICATE_CURRENT_LINE;
    public static final KeyStroke JOIN_LINES;
    public static final KeyStroke SORT_LINES_ASCENDING;
    public static final KeyStroke SORT_LINES_DESCENDING;
    public static final KeyStroke REMOVE_END_SPACES;
    public static final KeyStroke REMOVE_EMPTY_LINES;
    public static final KeyStroke COMPLETE_WORD;
    public static final KeyStroke COMPLETE_WORD_ALL;
    public static final KeyStroke WORD_COUNT;
    public static final KeyStroke INSERT_FILE_EXTENSION;
    public static final KeyStroke INSERT_FILE_FULL_NAME;
    public static final KeyStroke INSERT_FILE_NAME;
    public static final KeyStroke INSERT_FILE_FULL_PATH;
    public static final KeyStroke INSERT_FILE_PATH;
    public static final KeyStroke INSERT_DATE;
    public static final KeyStroke FIND;
    public static final KeyStroke FIND_NEXT;
    public static final KeyStroke FIND_PREVIOUS;
    public static final KeyStroke REPLACE;
    public static final KeyStroke REPLACE_NEXT;
    public static final KeyStroke INCREMENTAL_SEARCH;
    public static final KeyStroke GO_TO_LINE;
    public static final KeyStroke HIGHLIGHT_ALL_OCCURRENCES;
    public static final KeyStroke CLEAR_ALL_OCCURRENCES;
    public static final KeyStroke NEXT_OCCURRENCE;
    public static final KeyStroke PREVIOUS_OCCURRENCE;
    public static final KeyStroke NEXT_BOOKMARK;
    public static final KeyStroke PREVIOUS_BOOKMARK;
    public static final KeyStroke TOGGLE_BOOKMARK;
    public static final KeyStroke CLEAR_ALL_BOOKMARKS;
    public static final KeyStroke TOOLBAR_VISIBLE;
    public static final KeyStroke FINDRESULTS_VISIBLE;
    public static final KeyStroke STATUSBAR_VISIBLE;
    public static final KeyStroke LINE_WRAP;
    public static final KeyStroke LINE_NUMBERS;
    public static final KeyStroke ACTIVE_LINE;
    public static final KeyStroke RIGHT_MARGIN_LINE;
    public static final KeyStroke MARK_STRIP;
    public static final KeyStroke MARK_OCCURRENCES;
    public static final KeyStroke MARK_BRACKETS;
    public static final KeyStroke FOCUS_ON_MAIN_VIEW;
    public static final KeyStroke SELECT_SCOPE_AS_VIEWER;
    public static final KeyStroke SELECT_SCOPE_AS_VIEW_SET;
    public static final KeyStroke SELECT_SCOPE_AS_VIEW;
    public static final KeyStroke SELECT_SCOPE_AS_PANE;
    public static final KeyStroke FULLSCREEN;
    public static final KeyStroke RIGHT_INDENT;
    public static final KeyStroke LEFT_INDENT;
    public static final KeyStroke TO_UPPER;
    public static final KeyStroke TO_LOWER;
    public static final KeyStroke CAPITALIZE;
    public static final KeyStroke INVERT_UPPER_LOWER;
    public static final KeyStroke TO_TITLE;
    public static final KeyStroke SET_READ_ONLY;
    public static final KeyStroke ALIGN_STRINGS_BY_COMMA;
    public static final KeyStroke ALIGN_STRINGS_BY_EQUAL;
    public static final KeyStroke ALIGN_STRINGS_BY_CLIPBOARD;
    public static final KeyStroke INCREASE_FONT;
    public static final KeyStroke DECREASE_FONT;
    public static final KeyStroke FONTS;
    public static final KeyStroke WINDOW;
    public static final KeyStroke NEXT_BUFFER;
    public static final KeyStroke PREVIOUS_BUFFER;
    public static final KeyStroke SPLIT_VERTICALLY;
    public static final KeyStroke SPLIT_HORIZONTALLY;
    public static final KeyStroke UNSPLIT;
    public static final KeyStroke UNSPLIT_CURRENT;
    public static final KeyStroke RESTORE_SPLIT;
    public static final KeyStroke NEXT_EDIT_PANE;
    public static final KeyStroke PREVIOUS_EDIT_PANE;
    public static final KeyStroke SPLIT_VIEWER_VERTICALLY;
    public static final KeyStroke SPLIT_VIEWER_HORIZONTALLY;
    public static final KeyStroke UNSPLIT_VIEWER;
    public static final KeyStroke UNSPLIT_VIEWER_CURRENT;
    public static final KeyStroke RESTORE_VIEWER_SPLIT;
    public static final KeyStroke NEXT_BUFFER_SET;
    public static final KeyStroke PREVIOUS_BUFFER_SET;
    public static final KeyStroke ABOUT;
    public static final KeyStroke NEXT_COLORSCHEME;
    public static final KeyStroke PREVIOUS_COLORSCHEME;
    public static final KeyStroke SET_EXTENDED_STATE_MAXIMIZED;
    public static final KeyStroke SET_EXTENDED_STATE_ICONIFIED;
    public static final KeyStroke SHOW_POPUP_MENU;
    public static final KeyStroke SHOW_POPUP_MENU2;
    public static final KeyStroke SET_POSITION_SOUTH_WEST;
    public static final KeyStroke SET_POSITION_SOUTH;
    public static final KeyStroke SET_POSITION_SOUTH_EAST;
    public static final KeyStroke SET_POSITION_WEST;
    public static final KeyStroke SET_POSITION_CENTER;
    public static final KeyStroke SET_POSITION_EAST;
    public static final KeyStroke SET_POSITION_NORTH_WEST;
    public static final KeyStroke SET_POSITION_NORTH;
    public static final KeyStroke SET_POSITION_NORTH_EAST;
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(Accelerators.class.getName());
        shortcuts = new Properties();
        if (Config.isUsingCustomShortcuts()) {
            String path = String.valueOf(Config.KEYMAP_DIR) + Utilities.DIR_SEPARATOR + Config.JNPAD_KEYMAP.getValue() + ".properties";
            if (!new File(path).exists()) {
                LOGGER.config(String.valueOf(path) + " does not exist.");
                path = String.valueOf(Config.KEYMAP_DIR) + Utilities.DIR_SEPARATOR + (String)Config.JNPAD_KEYMAP.getDefault() + ".properties";
            }
            Accelerators.loadShortcuts(path);
        }
        int A = 512;
        int C = 128;
        int S = 64;
        int CA = 640;
        int CS = 192;
        int CAS = 704;
        int AS = 576;
        NEW = KeyStroke.getKeyStroke(78, 128);
        OPEN = KeyStroke.getKeyStroke(79, 128);
        CLOSE = KeyStroke.getKeyStroke(115, 128);
        CLOSE_FILES = KeyStroke.getKeyStroke(115, 192);
        CLOSE_ALL = KeyStroke.getKeyStroke(115, 64);
        SAVE = KeyStroke.getKeyStroke(83, 128);
        SAVE_ALL = KeyStroke.getKeyStroke(83, 192);
        SAVE_AS = KeyStroke.getKeyStroke(83, 640);
        FILE_PROPERTIES = KeyStroke.getKeyStroke(10, 128);
        FILE_BROWSER = KeyStroke.getKeyStroke(86, 192);
        PRINT_SET = KeyStroke.getKeyStroke(80, 192);
        PRINT = KeyStroke.getKeyStroke(80, 128);
        RELOAD = KeyStroke.getKeyStroke(116, 512);
        EXECUTE_ACTION = KeyStroke.getKeyStroke(46, 192);
        REDUCE_AS_TRAY_ICON = KeyStroke.getKeyStroke(117, 512);
        RESTART = KeyStroke.getKeyStroke(114, 512);
        EXIT = KeyStroke.getKeyStroke(115, 512);
        UNDO = KeyStroke.getKeyStroke(90, 128);
        REDO = KeyStroke.getKeyStroke(90, 192);
        CUT = KeyStroke.getKeyStroke(88, 128);
        CUT_LINE = KeyStroke.getKeyStroke(88, 192);
        COPY = KeyStroke.getKeyStroke(67, 128);
        COPY_LINE = KeyStroke.getKeyStroke(67, 192);
        PASTE = KeyStroke.getKeyStroke(86, 128);
        SELECT_ALL = KeyStroke.getKeyStroke(65, 128);
        SELECT_PARAGRAPH = KeyStroke.getKeyStroke(82, 128);
        SELECTION_BEGIN_PARAGRAPH = KeyStroke.getKeyStroke(82, 192);
        SELECTION_END_PARAGRAPH = KeyStroke.getKeyStroke(82, 640);
        SELECT_LINE = KeyStroke.getKeyStroke(76, 128);
        SELECTION_BEGIN_LINE = KeyStroke.getKeyStroke(76, 192);
        SELECTION_END_LINE = KeyStroke.getKeyStroke(76, 640);
        SELECT_WORD = KeyStroke.getKeyStroke(87, 128);
        DELETE = KeyStroke.getKeyStroke(127, 0);
        DELETE_PARAGRAPH = KeyStroke.getKeyStroke(75, 128);
        DELETION_BEGIN_PARAGRAPH = KeyStroke.getKeyStroke(75, 192);
        DELETION_END_PARAGRAPH = KeyStroke.getKeyStroke(75, 640);
        DELETE_LINE = KeyStroke.getKeyStroke(68, 128);
        DELETION_BEGIN_LINE = KeyStroke.getKeyStroke(68, 192);
        DELETION_END_LINE = KeyStroke.getKeyStroke(68, 640);
        DELETE_WORD = KeyStroke.getKeyStroke(87, 192);
        TABS_TO_SPACES = KeyStroke.getKeyStroke(83, 704);
        SPACES_TO_TABS = KeyStroke.getKeyStroke(84, 704);
        BEGIN_LINES = KeyStroke.getKeyStroke(66, 128);
        END_LINES = KeyStroke.getKeyStroke(66, 192);
        DUPLICATE_CURRENT_LINE = KeyStroke.getKeyStroke(84, 128);
        JOIN_LINES = KeyStroke.getKeyStroke(73, 128);
        SORT_LINES_ASCENDING = KeyStroke.getKeyStroke(81, 128);
        SORT_LINES_DESCENDING = KeyStroke.getKeyStroke(81, 192);
        REMOVE_END_SPACES = KeyStroke.getKeyStroke(89, 128);
        REMOVE_EMPTY_LINES = KeyStroke.getKeyStroke(89, 192);
        COMPLETE_WORD = KeyStroke.getKeyStroke(32, 128);
        COMPLETE_WORD_ALL = KeyStroke.getKeyStroke(32, 192);
        WORD_COUNT = KeyStroke.getKeyStroke(71, 192);
        INSERT_FILE_EXTENSION = KeyStroke.getKeyStroke(77, 128);
        INSERT_FILE_FULL_NAME = KeyStroke.getKeyStroke(77, 192);
        INSERT_FILE_NAME = KeyStroke.getKeyStroke(77, 640);
        INSERT_FILE_FULL_PATH = KeyStroke.getKeyStroke(74, 128);
        INSERT_FILE_PATH = KeyStroke.getKeyStroke(74, 192);
        INSERT_DATE = KeyStroke.getKeyStroke(116, 0);
        FIND = KeyStroke.getKeyStroke(70, 128);
        FIND_NEXT = KeyStroke.getKeyStroke(114, 0);
        FIND_PREVIOUS = KeyStroke.getKeyStroke(114, 64);
        REPLACE = KeyStroke.getKeyStroke(69, 128);
        REPLACE_NEXT = KeyStroke.getKeyStroke(115, 0);
        INCREMENTAL_SEARCH = KeyStroke.getKeyStroke(73, 640);
        GO_TO_LINE = KeyStroke.getKeyStroke(71, 128);
        HIGHLIGHT_ALL_OCCURRENCES = KeyStroke.getKeyStroke(78, 192);
        CLEAR_ALL_OCCURRENCES = KeyStroke.getKeyStroke(69, 192);
        NEXT_OCCURRENCE = KeyStroke.getKeyStroke(40, 192);
        PREVIOUS_OCCURRENCE = KeyStroke.getKeyStroke(38, 192);
        NEXT_BOOKMARK = KeyStroke.getKeyStroke(113, 0);
        PREVIOUS_BOOKMARK = KeyStroke.getKeyStroke(113, 64);
        TOGGLE_BOOKMARK = KeyStroke.getKeyStroke(113, 128);
        CLEAR_ALL_BOOKMARKS = KeyStroke.getKeyStroke(113, 192);
        TOOLBAR_VISIBLE = KeyStroke.getKeyStroke(84, 640);
        FINDRESULTS_VISIBLE = KeyStroke.getKeyStroke(70, 640);
        STATUSBAR_VISIBLE = KeyStroke.getKeyStroke(83, 640);
        LINE_WRAP = KeyStroke.getKeyStroke(116, 128);
        LINE_NUMBERS = KeyStroke.getKeyStroke(117, 128);
        ACTIVE_LINE = KeyStroke.getKeyStroke(118, 128);
        RIGHT_MARGIN_LINE = KeyStroke.getKeyStroke(119, 128);
        MARK_STRIP = KeyStroke.getKeyStroke(120, 128);
        MARK_OCCURRENCES = KeyStroke.getKeyStroke(121, 128);
        MARK_BRACKETS = KeyStroke.getKeyStroke(122, 128);
        FOCUS_ON_MAIN_VIEW = KeyStroke.getKeyStroke(33, 576);
        SELECT_SCOPE_AS_VIEWER = KeyStroke.getKeyStroke(48, 192);
        SELECT_SCOPE_AS_VIEW_SET = KeyStroke.getKeyStroke(49, 192);
        SELECT_SCOPE_AS_VIEW = KeyStroke.getKeyStroke(50, 192);
        SELECT_SCOPE_AS_PANE = KeyStroke.getKeyStroke(51, 192);
        FULLSCREEN = KeyStroke.getKeyStroke(122, 0);
        RIGHT_INDENT = KeyStroke.getKeyStroke(9, 0);
        LEFT_INDENT = KeyStroke.getKeyStroke(9, 64);
        TO_UPPER = KeyStroke.getKeyStroke(85, 192);
        TO_LOWER = KeyStroke.getKeyStroke(85, 128);
        CAPITALIZE = KeyStroke.getKeyStroke(65, 192);
        INVERT_UPPER_LOWER = KeyStroke.getKeyStroke(73, 192);
        TO_TITLE = KeyStroke.getKeyStroke(84, 192);
        SET_READ_ONLY = KeyStroke.getKeyStroke(82, 704);
        ALIGN_STRINGS_BY_COMMA = KeyStroke.getKeyStroke(120, 192);
        ALIGN_STRINGS_BY_EQUAL = KeyStroke.getKeyStroke(121, 192);
        ALIGN_STRINGS_BY_CLIPBOARD = KeyStroke.getKeyStroke(122, 192);
        INCREASE_FONT = KeyStroke.getKeyStroke(107, 128);
        DECREASE_FONT = KeyStroke.getKeyStroke(109, 128);
        FONTS = KeyStroke.getKeyStroke(70, 192);
        WINDOW = KeyStroke.getKeyStroke(87, 576);
        NEXT_BUFFER = KeyStroke.getKeyStroke(39, 512);
        PREVIOUS_BUFFER = KeyStroke.getKeyStroke(37, 512);
        SPLIT_VERTICALLY = KeyStroke.getKeyStroke(86, 576);
        SPLIT_HORIZONTALLY = KeyStroke.getKeyStroke(72, 576);
        UNSPLIT = KeyStroke.getKeyStroke(67, 576);
        UNSPLIT_CURRENT = KeyStroke.getKeyStroke(85, 576);
        RESTORE_SPLIT = KeyStroke.getKeyStroke(82, 576);
        NEXT_EDIT_PANE = KeyStroke.getKeyStroke(39, 576);
        PREVIOUS_EDIT_PANE = KeyStroke.getKeyStroke(37, 576);
        SPLIT_VIEWER_VERTICALLY = KeyStroke.getKeyStroke(51, 128);
        SPLIT_VIEWER_HORIZONTALLY = KeyStroke.getKeyStroke(50, 128);
        UNSPLIT_VIEWER = KeyStroke.getKeyStroke(49, 128);
        UNSPLIT_VIEWER_CURRENT = KeyStroke.getKeyStroke(48, 128);
        RESTORE_VIEWER_SPLIT = KeyStroke.getKeyStroke(52, 128);
        NEXT_BUFFER_SET = KeyStroke.getKeyStroke(34, 512);
        PREVIOUS_BUFFER_SET = KeyStroke.getKeyStroke(33, 512);
        ABOUT = KeyStroke.getKeyStroke(112, 64);
        NEXT_COLORSCHEME = KeyStroke.getKeyStroke(117, 64);
        PREVIOUS_COLORSCHEME = KeyStroke.getKeyStroke(116, 64);
        SET_EXTENDED_STATE_MAXIMIZED = KeyStroke.getKeyStroke(123, 64);
        SET_EXTENDED_STATE_ICONIFIED = KeyStroke.getKeyStroke(123, 128);
        SHOW_POPUP_MENU = KeyStroke.getKeyStroke(121, 64);
        SHOW_POPUP_MENU2 = KeyStroke.getKeyStroke(525, 0);
        SET_POSITION_SOUTH_WEST = KeyStroke.getKeyStroke(97, 128);
        SET_POSITION_SOUTH = KeyStroke.getKeyStroke(98, 128);
        SET_POSITION_SOUTH_EAST = KeyStroke.getKeyStroke(99, 128);
        SET_POSITION_WEST = KeyStroke.getKeyStroke(100, 128);
        SET_POSITION_CENTER = KeyStroke.getKeyStroke(101, 128);
        SET_POSITION_EAST = KeyStroke.getKeyStroke(102, 128);
        SET_POSITION_NORTH_WEST = KeyStroke.getKeyStroke(103, 128);
        SET_POSITION_NORTH = KeyStroke.getKeyStroke(104, 128);
        SET_POSITION_NORTH_EAST = KeyStroke.getKeyStroke(105, 128);
    }

    private Accelerators() {
    }

    private static void loadShortcuts(String filePath) {
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "UTF-8"));
                shortcuts.load(in);
            }
            catch (IOException iOException) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public static String getPropKeyBinding(String key) {
        if (!Config.isUsingCustomShortcuts() || !Accelerators.isUsingCompositeShortcuts()) {
            return null;
        }
        return shortcuts.getProperty(key);
    }

    public static KeyStroke getPropAccelerator(String key, KeyStroke def) {
        if (!Config.isUsingCustomShortcuts() || Accelerators.isUsingCompositeShortcuts()) {
            return def;
        }
        String propval = shortcuts.getProperty(key);
        if (propval != null) {
            try {
                KeyStroke keyStroke = Accelerators.parseKeyStroke(propval);
                if (keyStroke != null) {
                    return keyStroke;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        return def;
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        int ch;
        String key;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = 0;
        int index = keyStroke.indexOf(43);
        if (index != -1) {
            int i = 0;
            while (i < index) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= 8;
                        break;
                    }
                    case 'C': {
                        modifiers |= Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                        break;
                    }
                    case 'M': {
                        modifiers |= 4;
                        break;
                    }
                    case 'S': {
                        modifiers |= 1;
                        break;
                    }
                }
                ++i;
            }
        }
        if ((key = keyStroke.substring(index + 1)).length() == 1) {
            char ch2 = Character.toUpperCase(key.charAt(0));
            if (modifiers == 0) {
                return KeyStroke.getKeyStroke(ch2);
            }
            return KeyStroke.getKeyStroke((int)ch2, modifiers);
        }
        if (key.length() == 0) {
            LOGGER.log(Level.WARNING, "Invalid key stroke: " + keyStroke);
            return null;
        }
        try {
            ch = KeyEvent.class.getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Invalid key stroke: " + keyStroke, ex);
            return null;
        }
        return KeyStroke.getKeyStroke(ch, modifiers);
    }

    public static KeyStroke[] getPropKeyStrokes(String key, KeyStroke def) {
        block3: {
            String propval;
            if (Config.isUsingCustomShortcuts() && (propval = shortcuts.getProperty(key)) != null) {
                StringTokenizer st = new StringTokenizer(propval);
                KeyStroke[] result = new KeyStroke[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    KeyStroke keyStroke = Accelerators.parseKeyStroke(st.nextToken());
                    if (keyStroke != null) {
                        result[i] = keyStroke;
                        ++i;
                        continue;
                    }
                    break block3;
                }
                return result;
            }
        }
        return new KeyStroke[]{def};
    }

    public static boolean isUsingCompositeShortcuts() {
        if (!Config.isUsingCustomShortcuts()) {
            return false;
        }
        if (useCompositeShortcuts == null) {
            String propval = shortcuts.getProperty("shortcuts.composite");
            useCompositeShortcuts = propval != null ? Boolean.valueOf(BooleanProp.parse(propval)) : Boolean.valueOf(true);
        }
        return useCompositeShortcuts;
    }

    public static String getShortcutLabel(String action) {
        if (action == null) {
            return null;
        }
        String shortcut1 = Accelerators.getPropKeyBinding(String.valueOf(action) + ".shortcut");
        String shortcut2 = Accelerators.getPropKeyBinding(String.valueOf(action) + ".shortcut2");
        if (Utilities.isEmptyString(shortcut1)) {
            if (Utilities.isEmptyString(shortcut2)) {
                return null;
            }
            return shortcut2;
        }
        if (Utilities.isEmptyString(shortcut2)) {
            return shortcut1;
        }
        return JNPadBundle.getString("Accelerators.getShortcutLabel", shortcut1, shortcut2);
    }

    public static void main(String[] args) throws Exception {
        Accelerators.checkUniquenessOfKeyStrokes();
    }

    public static void checkUniquenessOfKeyStrokes() throws Exception {
        Class<?> clazz = Class.forName("jnpad.config.Accelerators");
        HashSet<String> kss = new HashSet<String>();
        int collisions = 0;
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field fi = fieldArray[n2];
            Object vi = fi.get(null);
            if (vi instanceof KeyStroke) {
                KeyStroke ki = (KeyStroke)vi;
                String sig = String.valueOf(ki.getKeyCode());
                if ((ki.getModifiers() & 0x40) == 64) {
                    sig = String.valueOf(sig) + " Shift";
                }
                if ((ki.getModifiers() & 0x80) == 128) {
                    sig = String.valueOf(sig) + " Ctrl";
                }
                if ((ki.getModifiers() & 0x200) == 512) {
                    sig = String.valueOf(sig) + " Alt";
                }
                if ((ki.getModifiers() & 0x2000) == 8192) {
                    sig = String.valueOf(sig) + " AltGr";
                }
                if (kss.contains(sig)) {
                    System.err.println("KeyStroke collision " + fi.getName() + " value  <" + ki + "> is already used ! (" + sig + ")");
                    ++collisions;
                } else {
                    kss.add(sig);
                }
            }
            ++n2;
        }
        if (collisions == 0) {
            System.out.println("Check done. no accelerators collisions");
        } else {
            System.out.println(String.valueOf(collisions) + " accelerators collisions detected");
        }
    }
}

