/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jnpad.GUIUtilities;
import jnpad.JNPadFrame;
import jnpad.action.ActionManager;
import jnpad.config.Config;
import jnpad.config.Controlable;
import jnpad.text.Buffer;
import jnpad.text.BufferSet;
import jnpad.text.EditPane;
import jnpad.text.IView;
import jnpad.text.JNPadTextArea;
import jnpad.ui.JNPadSplitPane;
import jnpad.util.Utilities;

public abstract class Viewer
extends JPanel
implements Controlable,
IView {
    protected BufferSet _bufferSet;
    protected JNPadFrame _jNPad;
    private boolean _suppressStateChangedEvents = false;
    private static final Logger LOGGER = Logger.getLogger(Viewer.class.getName());
    private static final long serialVersionUID = 4270021627800454393L;
    JSplitPane splitPane;
    Component mainContent;
    String lastSplitConfig;
    int lastIndex;

    protected Viewer(JNPadFrame jNPad) {
        super(new BorderLayout());
        this._jNPad = jNPad;
    }

    public BufferSet getActiveBufferSet() {
        return this._bufferSet;
    }

    void setActiveBufferSet(BufferSet bufferSet) {
        if (this._bufferSet != bufferSet) {
            this._bufferSet = bufferSet;
            BufferSet[] bufferSetArray = this.getBufferSets();
            int n = bufferSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                BufferSet bufferset = bufferSetArray[n2];
                for (Buffer eview : bufferset) {
                    eview.repaintGutter();
                }
                ++n2;
            }
            this.handleStateChanged(new ChangeEvent(this));
        }
    }

    protected static Buffer create(BufferSet bufferSet, Buffer buffer) {
        return buffer.create(bufferSet);
    }

    public BufferSet[] getBufferSets() {
        if (this.splitPane == null) {
            return new BufferSet[]{this._bufferSet};
        }
        ArrayList<BufferSet> list = new ArrayList<BufferSet>();
        Viewer.lookForBufferSets(list, this.splitPane);
        BufferSet[] array = new BufferSet[list.size()];
        list.toArray(array);
        return array;
    }

    private static void lookForBufferSets(List<BufferSet> list, Component comp) {
        if (comp instanceof BufferSet) {
            list.add((BufferSet)((Object)comp));
        } else if (comp instanceof JSplitPane) {
            JSplitPane split = (JSplitPane)comp;
            Viewer.lookForBufferSets(list, split.getLeftComponent());
            Viewer.lookForBufferSets(list, split.getRightComponent());
        }
    }

    public int getActiveBufferSetIndex() {
        BufferSet[] bufferSets = this.getBufferSets();
        int i = 0;
        while (i < bufferSets.length) {
            if (this._bufferSet == bufferSets[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Buffer getActiveBuffer() {
        return this._bufferSet.getSelectedBuffer();
    }

    public Buffer[] getBuffers() {
        int len = this.getBufferCount();
        Buffer[] result = new Buffer[len];
        int i = 0;
        while (i < len) {
            result[i] = this.getBufferAt(i);
            ++i;
        }
        return result;
    }

    public Buffer[] getSelectedBuffers() {
        ArrayList<Buffer> list = new ArrayList<Buffer>();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            list.add(bufferSet.getSelectedBuffer());
            ++n2;
        }
        Buffer[] array = new Buffer[list.size()];
        list.toArray(array);
        return array;
    }

    public Buffer[] getGlobalBuffers() {
        ArrayList<Buffer> list = new ArrayList<Buffer>();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            for (Buffer buffer : bufferSet) {
                list.add(buffer);
            }
            ++n2;
        }
        Buffer[] array = new Buffer[list.size()];
        list.toArray(array);
        return array;
    }

    public EditPane getActiveEditPane() {
        return this.getActiveBuffer().getSelectedEditPane();
    }

    public EditPane[] getActiveEditPanes() {
        return this.getActiveBuffer().getEditPanes();
    }

    public EditPane[] getSelectedEditPanes() {
        int len = this.getBufferCount();
        EditPane[] result = new EditPane[len];
        int i = 0;
        while (i < len) {
            result[i] = this.getBufferAt(i).getSelectedEditPane();
            ++i;
        }
        return result;
    }

    public EditPane[] getGlobalSelectedEditPanes() {
        ArrayList<EditPane> list = new ArrayList<EditPane>();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            for (Buffer eview : eviews) {
                list.add(eview.getSelectedEditPane());
            }
            ++n2;
        }
        EditPane[] array = new EditPane[list.size()];
        list.toArray(array);
        return array;
    }

    public EditPane[] getEditPanes() {
        ArrayList list = new ArrayList();
        for (Buffer eview : this.getActiveBufferSet()) {
            Collections.addAll(list, eview.getEditPanes());
        }
        EditPane[] array = new EditPane[list.size()];
        list.toArray(array);
        return array;
    }

    public EditPane[] getGlobalEditPanes() {
        ArrayList list = new ArrayList();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            for (Buffer eview : eviews) {
                Collections.addAll(list, eview.getEditPanes());
            }
            ++n2;
        }
        EditPane[] array = new EditPane[list.size()];
        list.toArray(array);
        return array;
    }

    public JNPadTextArea getActiveTextArea() {
        return this.getActiveBuffer().getSelectedTextArea();
    }

    public JNPadTextArea[] getActiveTextAreas() {
        return this.getActiveBuffer().getTextAreas();
    }

    public JNPadTextArea[] getSelectedTextAreas() {
        int len = this.getBufferCount();
        JNPadTextArea[] result = new JNPadTextArea[len];
        int i = 0;
        while (i < len) {
            result[i] = this.getBufferAt(i).getSelectedTextArea();
            ++i;
        }
        return result;
    }

    public JNPadTextArea[] getGlobalSelectedTextAreas() {
        ArrayList<JNPadTextArea> list = new ArrayList<JNPadTextArea>();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            for (Buffer eview : eviews) {
                list.add(eview.getSelectedTextArea());
            }
            ++n2;
        }
        JNPadTextArea[] array = new JNPadTextArea[list.size()];
        list.toArray(array);
        return array;
    }

    public JNPadTextArea[] getTextAreas() {
        ArrayList<JNPadTextArea> list = new ArrayList<JNPadTextArea>();
        for (Buffer eview : this.getActiveBufferSet()) {
            EditPane[] editPaneArray = eview.getEditPanes();
            int n = editPaneArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditPane epane = editPaneArray[n2];
                list.add(epane.getTextArea());
                ++n2;
            }
        }
        JNPadTextArea[] array = new JNPadTextArea[list.size()];
        list.toArray(array);
        return array;
    }

    public JNPadTextArea[] getGlobalTextAreas() {
        ArrayList<JNPadTextArea> list = new ArrayList<JNPadTextArea>();
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            for (Buffer eview : eviews) {
                EditPane[] editPaneArray = eview.getEditPanes();
                int n3 = editPaneArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    EditPane epane = editPaneArray[n4];
                    list.add(epane.getTextArea());
                    ++n4;
                }
            }
            ++n2;
        }
        JNPadTextArea[] array = new JNPadTextArea[list.size()];
        list.toArray(array);
        return array;
    }

    public void nextBufferSet() {
        BufferSet[] bufferSets = this.getBufferSets();
        int index = this.getActiveBufferSetIndex();
        if (index > -1 && index < bufferSets.length - 1) {
            this.setActiveBufferSet(bufferSets[++index]);
            this._bufferSet.focusOnSelectedComponent();
        } else if (index == bufferSets.length - 1) {
            this.setActiveBufferSet(bufferSets[0]);
            this._bufferSet.focusOnSelectedComponent();
        }
    }

    public void previousBufferSet() {
        BufferSet[] bufferSets = this.getBufferSets();
        int index = this.getActiveBufferSetIndex();
        if (index > 0 && index < bufferSets.length) {
            this.setActiveBufferSet(bufferSets[--index]);
            this._bufferSet.focusOnSelectedComponent();
        } else if (index == 0) {
            this.setActiveBufferSet(bufferSets[bufferSets.length - 1]);
            this._bufferSet.focusOnSelectedComponent();
        }
    }

    @Override
    public void configure(int cfg) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.configure(cfg);
            ++n2;
        }
    }

    @Override
    public void updateControls() {
        this.updateControls(8191);
    }

    @Override
    public void updateControls(int ctrls) {
        if ((ctrls & 2) != 0) {
            boolean b = this.isSplitted();
            ActionManager.INSTANCE.setEnabled("unsplit-viewer", b);
            ActionManager.INSTANCE.setEnabled("unsplit-viewer-current", b);
            ActionManager.INSTANCE.setEnabled("next-buffer-set", b);
            ActionManager.INSTANCE.setEnabled("previous-buffer-set", b);
        }
    }

    @Override
    public void setActiveLineVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setActiveLineVisible(b);
            ++n2;
        }
        Config.ACTIVE_LINE_VISIBLE.setValue(b);
    }

    @Override
    public void setLineNumbersVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setLineNumbersVisible(b);
            ++n2;
        }
        Config.GUTTER_VISIBLE.setValue(b);
    }

    @Override
    public void setLineWrap(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setLineWrap(b);
            ++n2;
        }
        Config.TEXT_LINE_WRAP.setValue(b);
    }

    @Override
    public void setRightMarginLineVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setRightMarginLineVisible(b);
            ++n2;
        }
        Config.TEXT_RIGHT_MARGIN_LINE_VISIBLE.setValue(b);
    }

    @Override
    public void setMarkStripVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setMarkStripVisible(b);
            ++n2;
        }
        Config.MARKER_VISIBLE.setValue(b);
    }

    @Override
    public void setOccurrencesHighlighterVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setOccurrencesHighlighterVisible(b);
            ++n2;
        }
        Config.OCCURRENCES_HIGHLIGHTER_VISIBLE.setValue(b);
    }

    @Override
    public void setBracketHighlighterVisible(boolean b) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setBracketHighlighterVisible(b);
            ++n2;
        }
        Config.BRACKET_HIGHLIGHTER_VISIBLE.setValue(b);
    }

    public int getBufferCount() {
        return this._bufferSet.getBufferCount();
    }

    public Buffer getBufferAt(int index) {
        return this._bufferSet.getBufferAt(index);
    }

    public void nextBuffer() {
        this._bufferSet.nextTab();
    }

    public void previousBuffer() {
        this._bufferSet.previousTab();
    }

    public int indexOf(Component c) {
        return this._bufferSet.indexOfComponent(c);
    }

    public abstract Buffer add(Buffer var1);

    public void removeBufferAt(int index) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            bufferSet.removeTabAt(index);
            ++n2;
        }
    }

    public void setActiveBuffer(Buffer buffer) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            bufferSet.setSelectedComponent(buffer);
            ++n2;
        }
    }

    public void setActiveIndex(int index) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet bufferSet = bufferSetArray[n2];
            bufferSet.setSelectedIndex(index);
            ++n2;
        }
    }

    public int getActiveIndex() {
        return this._bufferSet.getSelectedIndex();
    }

    public void focusOnActiveBuffer() {
        Buffer activeBuffer = this.getActiveBuffer();
        if (activeBuffer != null) {
            GUIUtilities.requestFocus(activeBuffer);
        }
    }

    public abstract void setComponentIconAt(int var1);

    public void setToolTipTextAt(int index, String toolTipText) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setToolTipTextAt(index, toolTipText);
            ++n2;
        }
    }

    public String getToolTipTextAt(int index) {
        return this._bufferSet.getToolTipTextAt(index);
    }

    public void setTitleAt(int index, String title) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setTitleAt(index, title);
            ++n2;
        }
    }

    public void setSuppressStateChangedEvents(boolean suppress) {
        this._suppressStateChangedEvents = suppress;
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.setSuppressStateChangedEvents(suppress);
            ++n2;
        }
    }

    protected abstract void handleStateChanged(ChangeEvent var1);

    public boolean isSuppressStateChangedEvents() {
        return this._suppressStateChangedEvents;
    }

    public void addChangeListener(ChangeListener l) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.addChangeListener(l);
            ++n2;
        }
    }

    public void removeChangeListener(ChangeListener l) {
        BufferSet[] bufferSetArray = this.getBufferSets();
        int n = bufferSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            BufferSet eviews = bufferSetArray[n2];
            eviews.removeChangeListener(l);
            ++n2;
        }
    }

    protected void setMainContent(Component c) {
        if (this.mainContent != null) {
            this.remove(this.mainContent);
        }
        this.mainContent = c;
        this.add(this.mainContent, "Center");
        if (c instanceof JSplitPane) {
            this.splitPane = (JSplitPane)c;
        } else {
            this.splitPane = null;
            this._bufferSet = (BufferSet)((Object)c);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isSplitted() {
        return this.splitPane != null;
    }

    protected abstract BufferSet createBufferSet(BufferSet var1);

    public BufferSet splitHorizontally() {
        return this.split(0);
    }

    public BufferSet splitVertically() {
        return this.split(1);
    }

    public BufferSet split(int orientation) {
        BufferSet oldBufferSet = this._bufferSet;
        BufferSet newBufferSet = this.createBufferSet(oldBufferSet);
        JComponent oldParent = (JComponent)oldBufferSet.toComponent().getParent();
        final JNPadSplitPane newSplitPane = new JNPadSplitPane(orientation);
        int parentSize = orientation == 0 ? oldBufferSet.toComponent().getHeight() : oldBufferSet.toComponent().getWidth();
        final int dividerPosition = (int)((double)(parentSize - newSplitPane.getDividerSize()) * 0.5);
        newSplitPane.setDividerLocation(dividerPosition);
        if (oldParent instanceof JSplitPane) {
            JSplitPane oldSplitPane = (JSplitPane)oldParent;
            int dividerPos = oldSplitPane.getDividerLocation();
            Component left = oldSplitPane.getLeftComponent();
            if (left == oldBufferSet) {
                oldSplitPane.setLeftComponent(newSplitPane);
            } else {
                oldSplitPane.setRightComponent(newSplitPane);
            }
            newSplitPane.setLeftComponent(oldBufferSet.toComponent());
            newSplitPane.setRightComponent(newBufferSet.toComponent());
            oldSplitPane.setDividerLocation(dividerPos);
        } else {
            this.splitPane = newSplitPane;
            newSplitPane.setLeftComponent(oldBufferSet.toComponent());
            newSplitPane.setRightComponent(newBufferSet.toComponent());
            this.setMainContent(newSplitPane);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                newSplitPane.setDividerLocation(dividerPosition);
            }
        });
        newBufferSet.focusOnSelectedComponent();
        return newBufferSet;
    }

    public void unsplit() {
        if (this.splitPane != null) {
            this.saveLastConfig();
            this.setMainContent(this._bufferSet.toComponent());
            this.splitPane = null;
            this._bufferSet.focusOnSelectedComponent();
        } else {
            GUIUtilities.beep();
        }
    }

    public void unsplitCurrent() {
        if (this.splitPane != null) {
            JComponent parent;
            this.saveLastConfig();
            Container comp = this._bufferSet.toComponent();
            while (!(comp instanceof JSplitPane) && comp != null) {
                comp = comp.getParent();
            }
            JComponent jComponent = parent = comp == null ? null : (JComponent)comp.getParent();
            if (parent instanceof JSplitPane) {
                JSplitPane parentSplit = (JSplitPane)parent;
                int pos = parentSplit.getDividerLocation();
                if (parentSplit.getLeftComponent() == comp) {
                    parentSplit.setLeftComponent(this._bufferSet.toComponent());
                } else {
                    parentSplit.setRightComponent(this._bufferSet.toComponent());
                }
                parentSplit.setDividerLocation(pos);
                parent.revalidate();
            } else {
                this.setMainContent(this._bufferSet.toComponent());
                this.splitPane = null;
            }
            this._bufferSet.focusOnSelectedComponent();
        } else {
            GUIUtilities.beep();
        }
    }

    public void restoreSplit() {
        if (this.lastSplitConfig == null) {
            GUIUtilities.beep();
        } else {
            this.setLastConfig();
        }
    }

    private void saveLastConfig() {
        this.lastSplitConfig = this.getSplitConfig();
        this.lastIndex = this.getActiveBufferSetIndex();
    }

    private void setLastConfig() {
        this.setSplitConfig(this.lastSplitConfig);
        try {
            this.getBufferSets()[this.lastIndex].focusOnSelectedComponent();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setSplitConfig(String splitConfig) {
        try {
            Component comp = this.restoreSplitConfig(splitConfig);
            this.setMainContent(comp);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    private Component restoreSplitConfig(String splitConfig) throws IOException {
        if (Utilities.isEmptyString(splitConfig)) {
            return this._bufferSet.toComponent();
        }
        Stack<Object> stack = new Stack<Object>();
        StreamTokenizer st = new StreamTokenizer(new StringReader(splitConfig));
        st.whitespaceChars(0, 32);
        st.wordChars(35, 126);
        st.commentChar(33);
        st.quoteChar(34);
        st.eolIsSignificant(false);
        block5: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block5;
                }
                case -3: {
                    if (st.sval.equals("vertical") || st.sval.equals("horizontal")) {
                        int orientation = st.sval.equals("vertical") ? 0 : 1;
                        int divider = (Integer)stack.pop();
                        Object obj1 = stack.pop();
                        Object obj2 = stack.pop();
                        if (obj1 instanceof BufferSet) {
                            BufferSet b1 = (BufferSet)obj1;
                            this._bufferSet = this.createBufferSet(b1);
                            obj1 = this._bufferSet;
                        }
                        if (obj2 instanceof BufferSet) {
                            BufferSet b2 = (BufferSet)obj2;
                            obj2 = this.createBufferSet(b2);
                        }
                        this.splitPane = new JNPadSplitPane(orientation, (Component)obj1, (Component)obj2);
                        stack.push(this.splitPane);
                        this.splitPane.setDividerLocation(divider);
                        continue block5;
                    }
                    if (!st.sval.equals("BufferSet")) continue block5;
                    stack.push(this._bufferSet);
                    continue block5;
                }
                case -2: {
                    stack.push((int)st.nval);
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        Object obj = stack.peek();
        return (Component)obj;
    }

    public String getSplitConfig() {
        StringBuilder sb = new StringBuilder();
        if (this.splitPane != null) {
            Viewer.appendToSplitConfig(this.splitPane, sb);
        } else {
            Viewer.appendToSplitConfig(sb, this._bufferSet.toComponent());
        }
        return sb.toString();
    }

    private static void appendToSplitConfig(JSplitPane splitPane, StringBuilder sb) {
        Component right = splitPane.getRightComponent();
        Viewer.appendToSplitConfig(sb, right);
        sb.append(' ');
        Component left = splitPane.getLeftComponent();
        Viewer.appendToSplitConfig(sb, left);
        sb.append(' ');
        sb.append(splitPane.getDividerLocation());
        sb.append(' ');
        sb.append(splitPane.getOrientation() == 0 ? "vertical" : "horizontal");
    }

    private static void appendToSplitConfig(StringBuilder sb, Component component) {
        if (component instanceof JSplitPane) {
            Viewer.appendToSplitConfig((JSplitPane)component, sb);
        } else {
            sb.append("BufferSet");
        }
    }
}

