/*
 * Decompiled with CFR 0.152.
 */
package jnpad.text.syntax;

import java.awt.Color;
import java.awt.Font;
import jnpad.config.Config;
import jnpad.text.syntax.SyntaxScheme;

public class PropertiesScheme
extends SyntaxScheme {
    static Color valueColor;
    Font valueFont;
    private static final long serialVersionUID = -8334881204062472217L;

    public PropertiesScheme(boolean mini) {
        super(mini);
        this.doUpdateColors();
        this.doUpdateFonts();
    }

    private void doUpdateColors() {
        valueColor = Config.SYNTAX_KEYWORD6_COLOR.getValue();
    }

    private void doUpdateFonts() {
        this.valueFont = this.textFont.deriveFont(Config.SYNTAX_KEYWORD6_STYLE.getValue());
    }

    @Override
    public void setTextFont(Font f) {
        super.setTextFont(f);
        this.doUpdateFonts();
    }

    @Override
    public void configure(int cfg) {
        super.configure(cfg);
        if ((cfg & 1) != 0) {
            this.doUpdateColors();
        }
        if ((cfg & 2) != 0) {
            this.doUpdateFonts();
        }
    }

    public Color getValueColor() {
        return valueColor;
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    @Override
    public String getContentType() {
        return "text/properties";
    }

    @Override
    public String[] getStartComment() {
        return new String[]{"#"};
    }

    @Override
    public String[] getEndComment() {
        return new String[]{"\n"};
    }
}

