/*
 * Decompiled with CFR 0.152.
 */
package jnpad.ui;

import java.awt.Color;
import jnpad.ui.Gray;

public final class ColorUtilities {
    public static final int LIGHT_LUMINANCE = 229;
    public static final int DARK_LUMINANCE = 51;

    private ColorUtilities() {
    }

    public static String getColorHexString(Color c) {
        String colString = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        return "#000000".substring(0, 7 - colString.length()).concat(colString);
    }

    public static Color[] createColorArr(Color c1, Color c2, int steps) {
        if (c1 == null || c2 == null) {
            return null;
        }
        Color[] colors = new Color[steps];
        double r = c1.getRed();
        double g = c1.getGreen();
        double b = c1.getBlue();
        double dr = ((double)c2.getRed() - r) / (double)steps;
        double dg = ((double)c2.getGreen() - g) / (double)steps;
        double db = ((double)c2.getBlue() - b) / (double)steps;
        colors[0] = c1;
        int i = 1;
        while (i < steps - 1) {
            colors[i] = new Color((int)(r += dr), (int)(g += dg), (int)(b += db));
            ++i;
        }
        colors[steps - 1] = c2;
        return colors;
    }

    public static Color brighter(Color c, double p) {
        if (c == null) {
            return null;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        double rd = 255.0 - r;
        double gd = 255.0 - g;
        double bd = 255.0 - b;
        return new Color((int)(r += rd * p / 100.0), (int)(g += gd * p / 100.0), (int)(b += bd * p / 100.0));
    }

    public static Color darker(Color c, double p) {
        if (c == null) {
            return null;
        }
        double r = c.getRed();
        double g = c.getGreen();
        double b = c.getBlue();
        r -= r * p / 100.0;
        g -= g * p / 100.0;
        b -= b * p / 100.0;
        return new Color((int)r, (int)g, (int)b);
    }

    public static Color median(Color c1, Color c2) {
        if (c1 == null || c2 == null) {
            return null;
        }
        int r = (c1.getRed() + c2.getRed()) / 2;
        int g = (c1.getGreen() + c2.getGreen()) / 2;
        int b = (c1.getBlue() + c2.getBlue()) / 2;
        return new Color(r, g, b);
    }

    public static Color deriveColor(Color color, float ratio) {
        if (color != null) {
            float[] hsl = ColorUtilities.RGBtoHSL(color);
            if ((double)hsl[2] < 0.4) {
                hsl[2] = 0.4f;
            }
            hsl[2] = (double)ratio > 0.5 ? (float)((double)hsl[2] + (double)((1.0f - hsl[2]) * 2.0f) * ((double)ratio - 0.5)) : (float)((double)hsl[2] - (double)(hsl[2] * 2.0f) * (0.5 - (double)ratio));
            int colorRGB = ColorUtilities.HSLtoRGB(hsl);
            return new Color(colorRGB);
        }
        return Color.GRAY;
    }

    public static float[] RGBtoHSL(Color colorRGB) {
        float l;
        float s;
        float h;
        float r = (float)colorRGB.getRed() / 256.0f;
        float g = (float)colorRGB.getGreen() / 256.0f;
        float b = (float)colorRGB.getBlue() / 256.0f;
        float maxColor = Math.max(r, Math.max(g, b));
        float minColor = Math.min(r, Math.min(g, b));
        if ((double)Math.abs(r - g) < 1.0E-7 && (double)Math.abs(g - b) < 1.0E-7) {
            h = 0.0f;
            s = 0.0f;
            l = r;
        } else {
            l = (minColor + maxColor) / 2.0f;
            s = (double)l < 0.5 ? (maxColor - minColor) / (maxColor + minColor) : (maxColor - minColor) / (2.0f - maxColor - minColor);
            h = (double)Math.abs(r - maxColor) < 1.0E-7 ? (g - b) / (maxColor - minColor) : ((double)Math.abs(g - maxColor) < 1.0E-7 ? 2.0f + (b - r) / (maxColor - minColor) : 4.0f + (r - g) / (maxColor - minColor));
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        float[] hsl = new float[]{h, s, l};
        return hsl;
    }

    public static int HSLtoRGB(float[] hsl) {
        float r;
        float g;
        float b;
        float h = hsl[0];
        float s = hsl[1];
        float l = hsl[2];
        if (s == 0.0f) {
            g = b = l;
            r = b;
        } else {
            float temp2 = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float temp1 = 2.0f * l - temp2;
            float tempr = h + 0.33333334f;
            if (tempr > 1.0f) {
                tempr -= 1.0f;
            }
            float tempg = h;
            float tempb = h - 0.33333334f;
            if (tempb < 0.0f) {
                tempb += 1.0f;
            }
            r = (double)tempr < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempr : ((double)tempr < 0.5 ? temp2 : ((double)tempr < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempr) * 6.0f : temp1));
            g = (double)tempg < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempg : ((double)tempg < 0.5 ? temp2 : ((double)tempg < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempg) * 6.0f : temp1));
            b = (double)tempb < 0.16666666666666666 ? temp1 + (temp2 - temp1) * 6.0f * tempb : ((double)tempb < 0.5 ? temp2 : ((double)tempb < 0.6666666666666666 ? temp1 + (temp2 - temp1) * (0.6666667f - tempb) * 6.0f : temp1));
        }
        int result = 0;
        result += ((int)(r * 255.0f) & 0xFF) << 16;
        result += ((int)(g * 255.0f) & 0xFF) << 8;
        return result += (int)(b * 255.0f) & 0xFF;
    }

    public static Color toGrayscale(Color c) {
        int gray = (int)((double)c.getRed() * 0.3 + (double)c.getGreen() * 0.59 + (double)c.getBlue() * 0.11);
        return new Gray(gray);
    }

    public static Color giveYellowTouch(Color c) {
        int oldb = c.getBlue();
        return new Color(c.getRed(), c.getGreen(), oldb > 128 ? oldb * 10 / 11 : oldb * 11 / 10);
    }

    public static Color createPureColor(Color c) {
        if (c == null) {
            return Color.RED;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static Color removeAlpha(Color c) {
        return ColorUtilities.withAlpha(c, 255);
    }

    public static Color withAlpha(Color c, int alpha) throws IllegalArgumentException {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Valor alpha inv\u00e1lido");
        }
        return c == null ? null : new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Color add(Color c1, Color c2) {
        return c1 == null ? c2 : (c2 == null ? c1 : new Color(Math.min(255, c1.getRed() + c2.getRed()), Math.min(255, c1.getGreen() + c2.getGreen()), Math.min(255, c1.getBlue() + c2.getBlue()), c1.getAlpha()));
    }

    public static Color copy(Color c) {
        return c == null ? null : new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static Color oposite(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue(), c.getAlpha());
    }

    public static Color getColor_1_2(Color c1, Color c2) {
        return new Color(ColorUtilities.propInt(c1.getRed(), c2.getRed(), 2), ColorUtilities.propInt(c1.getGreen(), c2.getGreen(), 2), ColorUtilities.propInt(c1.getBlue(), c2.getBlue(), 2));
    }

    public static Color getColor_1_3(Color c1, Color c2) {
        return new Color(ColorUtilities.propInt(c1.getRed(), c2.getRed(), 3), ColorUtilities.propInt(c1.getGreen(), c2.getGreen(), 3), ColorUtilities.propInt(c1.getBlue(), c2.getBlue(), 3));
    }

    private static int propInt(int a, int b, int prop) {
        return b + (a - b) / prop;
    }

    public static Color getSimiliarColor(Color c, float factor) {
        return new Color(ColorUtilities.between((int)((float)c.getRed() * factor), 0, 255), ColorUtilities.between((int)((float)c.getGreen() * factor), 0, 255), ColorUtilities.between((int)((float)c.getBlue() * factor), 0, 255), c.getAlpha());
    }

    private static int between(int v, int min, int max) {
        return Math.max(min, Math.min(v, max));
    }

    public static Color computeForeground(Color bg) {
        float[] rgb = bg.getRGBColorComponents(null);
        float y = 0.3f * rgb[0] + 0.59f * rgb[1] + 0.11f * rgb[2];
        return y > 0.5f ? Color.BLACK : Color.WHITE;
    }

    public static boolean isLightForeground(Color fg) {
        return fg.getRed() > 160 && fg.getGreen() > 160 && fg.getBlue() > 160;
    }

    public static boolean isDark(Color c) {
        return 1.0 - (0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue()) / 255.0 >= 0.5;
    }

    public static int getApproximateLuminance(Color color) {
        return (color.getRed() >> 2) + (color.getGreen() >> 1) + (color.getBlue() >> 2);
    }

    public static boolean isVeryDark(Color color) {
        return ColorUtilities.getApproximateLuminance(color) < 51;
    }

    public static boolean isVeryLight(Color color) {
        return ColorUtilities.getApproximateLuminance(color) > 229;
    }

    public static Color blend(Color color1, Color color2, double ratio) {
        float r = (float)ratio;
        float ir = 1.0f - r;
        float[] rgb1 = new float[3];
        float[] rgb2 = new float[3];
        color1.getColorComponents(rgb1);
        color2.getColorComponents(rgb2);
        return new Color(rgb1[0] * r + rgb2[0] * ir, rgb1[1] * r + rgb2[1] * ir, rgb1[2] * r + rgb2[2] * ir);
    }

    public static Color blend(Color color1, Color color2) {
        return ColorUtilities.blend(color1, color2, 0.5);
    }

    public static Color getMiddle(Color c1, Color c2) {
        return new Color((c1.getRed() + c2.getRed()) / 2, (c1.getGreen() + c2.getGreen()) / 2, (c1.getBlue() + c2.getBlue()) / 2);
    }

    public static Color adjustColor(Color c, int rDiff, int gDiff, int bDiff) {
        int red = Math.max(0, Math.min(255, c.getRed() + rDiff));
        int green = Math.max(0, Math.min(255, c.getGreen() + gDiff));
        int blue = Math.max(0, Math.min(255, c.getBlue() + bDiff));
        return new Color(red, green, blue);
    }

    public static boolean isBrighter(Color a, Color b) {
        int[] ac = new int[]{a.getRed(), a.getGreen(), a.getBlue()};
        int[] bc = new int[]{b.getRed(), b.getGreen(), b.getBlue()};
        int dif = 0;
        int i = 0;
        while (i < 3) {
            int currDif = ac[i] - bc[i];
            if (Math.abs(currDif) > Math.abs(dif)) {
                dif = currDif;
            }
            ++i;
        }
        return dif > 0;
    }

    public static double colorDistance(double r1, double g1, double b1, double r2, double g2, double b2) {
        double a = r2 - r1;
        double b = g2 - g1;
        double c = b2 - b1;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public static double colorDistance(double[] color1, double[] color2) {
        return ColorUtilities.colorDistance(color1[0], color1[1], color1[2], color2[0], color2[1], color2[2]);
    }

    public static double colorDistance(Color color1, Color color2) {
        float[] rgb1 = new float[3];
        float[] rgb2 = new float[3];
        color1.getColorComponents(rgb1);
        color2.getColorComponents(rgb2);
        return ColorUtilities.colorDistance(rgb1[0], rgb1[1], rgb1[2], rgb2[0], rgb2[1], rgb2[2]);
    }
}

