/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_DUPLICATE_CURRENT_LINE;

import java.util.logging.Level;
import java.util.logging.Logger;

import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

import jnpad.JNPadFrame;
import jnpad.action.JNPadActions.Group;
import jnpad.config.Accelerators;
import jnpad.text.Buffer;
import jnpad.text.IEditAction;
import jnpad.text.TextUtilities;
import jnpad.ui.status.StatusDisplayable.StatusType;
import jnpad.util.Utilities;

/**
 * The Class DuplicateCurrentLineAction.
 *
 * @version 0.3
 * @since jNPad 0.1
 */
public final class DuplicateCurrentLineAction extends JNPadAction implements IEditAction {
  /** Logger */
  private static final Logger LOGGER           = Logger.getLogger(SortLinesAscendingAction.class.getName());

  /** UID */
  private static final long   serialVersionUID = 2088612702394865299L;

  /**
   * Instantiates a new duplicate current line action.
   *
   * @param jNPad the jNPad's frame
   */
  public DuplicateCurrentLineAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_DUPLICATE_CURRENT_LINE,
          Group.EDIT,
          Accelerators.DUPLICATE_CURRENT_LINE, null);
  }

  /**
   * Perform action.
   *
   * @see jnpad.action.JNPadAction#performAction()
   */
  @Override
  public void performAction() {
    Buffer buffer = jNPad.getActiveBuffer();

    if (buffer != null) {
      try {
        buffer.beginCompoundEdit();

        JTextComponent target = buffer.getSelectedTextArea();
        Document doc = target.getDocument();

        int line = TextUtilities.getCurrentLineIndex(target);

        Element lineElem = TextUtilities.getLine(doc, line);

        int end = lineElem.getEndOffset();

        String text = TextUtilities.getTextOfLine(doc, line);

        final boolean b = end > doc.getLength();

        if (b) {
          end = doc.getLength();
          text = Utilities.LF_STRING + text;
        }

        doc.insertString(end, text, null);

        target.setCaretPosition(b ? end + 1 : end);
      }
      catch (Exception ex) {
        LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        jNPad.setStatus(StatusType.ERROR, "Error - ".concat(getLabel())); //$NON-NLS-1$
      }
      finally {
        buffer.endCompoundEdit();
      }
    }
  }
}
