/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.action;

import static jnpad.action.JNPadActions.ACTION_NAME_SELECT_SCOPE_AS_BUFFER_SET;
import jnpad.JNPadFrame;
import jnpad.config.Accelerators;
import jnpad.config.ViewActionScope;

/**
 * The Class SelectScopeAsBufferSetAction.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class SelectScopeAsBufferSetAction extends SelectViewActionScopeAction {
  /** UID */
  private static final long serialVersionUID = 4758422694543902054L;

  /**
   * Instantiates a new select scope as buffer set action.
   *
   * @param jNPad the jNPad's frame
   */
  public SelectScopeAsBufferSetAction(JNPadFrame jNPad) {
    super(jNPad,
          ACTION_NAME_SELECT_SCOPE_AS_BUFFER_SET,
          Accelerators.SELECT_SCOPE_AS_VIEW_SET,
          ViewActionScope.BUFFER_SET);
  }

}
