/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.config;

/**
 * The Class BooleanProp2.
 * 
 * @version 0.3
 * @since jNPad 0.1
 */
public class BooleanProp2 extends BooleanProp {
  private Boolean           value;

  /** UID */
  private static final long serialVersionUID = -4294504912835536630L;

  /**
   * Instantiates a new boolean prop2.
   * 
   * @param name the name
   * @param def the def
   */
  public BooleanProp2(String name, boolean def) {
    super(name, def);
  }

  /**
   * Gets the value.
   * 
   * @return the value
   * @see jnpad.config.BooleanProp#getValue()
   */
  @Override
  public Boolean getValue() {
    if (value == null) {
      value = super.getValue();
    }
    return value;
  }

  /**
   * Sets the value.
   *
   * @param value the new value
   * @see jnpad.config.Prop#setValue(java.lang.Object)
   */
  @Override
  public void setValue(Boolean value) {
    super.setValue(value);
    this.value = value;
  }

}
