/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.icon;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.Icon;

/**
 * The Class IconClickTarget.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class IconClickTarget implements Icon {
  private int  _x;
  private int  _y;
  private int  _iconHeight;
  private int  _iconWidth;
  private Icon _target;

  /**
   * Instantiates a new icon click target.
   *
   * @param target Icon
   */
  public IconClickTarget(Icon target) {
    _target = target;
    _iconWidth = target.getIconWidth();
    _iconHeight = target.getIconHeight();
  }

  /**
   * Paint icon.
   *
   * @param c the Component
   * @param g the Graphics
   * @param x the x
   * @param y the y
   * @see javax.swing.Icon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
   */
  @Override
  public void paintIcon(Component c, Graphics g, int x, int y) {
    _x = x;
    _y = y;
    _target.paintIcon(c, g, x, y);
  }

  /**
   * Gets the icon height.
   *
   * @return the icon height
   * @see javax.swing.Icon#getIconHeight()
   */
  @Override
  public int getIconHeight() {
    return _iconHeight;
  }

  /**
   * Gets the icon width.
   *
   * @return the icon width
   * @see javax.swing.Icon#getIconWidth()
   */
  @Override
  public int getIconWidth() {
    return _iconWidth;
  }

  /**
   * Gets the target.
   *
   * @return the target
   */
  public Icon getTarget() {
    return _target;
  }

  /**
   * Checks if is hit.
   *
   * @param p the point
   * @return true, if is hit
   */
  public boolean isHit(Point p) {
    Rectangle rect = new Rectangle(_x, _y, _iconWidth, _iconHeight);
    return rect.contains(p.x, p.y);
  }

}
