/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.plaf;

import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

/**
 * The Class JNPadToolbarSeparatorUI.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public final class JNPadToolbarSeparatorUI extends javax.swing.plaf.basic.BasicToolBarSeparatorUI {
  /**
   * Instantiates a new jNPad toolbar separator ui.
   */
  private JNPadToolbarSeparatorUI() {
    shadow    = UIManager.getColor("controlDkShadow");    //$NON-NLS-1$
    highlight = UIManager.getColor("controlLtHighlight"); //$NON-NLS-1$
  }

  /**
   *
   * @param c JComponent
   * @return ComponentUI
   */
  public static ComponentUI createUI(JComponent c) {
    return new JNPadToolbarSeparatorUI();
  }

  /**
   *
   * @param c JComponent
   * @return Dimension
   */
  @Override
  public Dimension getPreferredSize(JComponent c) {
    Dimension size = super.getPreferredSize(c);
    if (size != null) {
      size = size.getSize();
    }
    else {
      size = new Dimension(2, 2);
      if ( ( (JSeparator) c).getOrientation() == SwingConstants.VERTICAL) {
        size.height = 0;
      }
      else {
        size.width = 0;
      }
    }
    return size;
  }

  /**
   *
   * @param c JComponent
   * @return Dimension
   */
  @Override
  public Dimension getMaximumSize(JComponent c) {
    Dimension pref = getPreferredSize(c);
    if ( ( (JSeparator) c).getOrientation() == SwingConstants.VERTICAL) {
      return new Dimension(pref.width, Short.MAX_VALUE);
    }
    return new Dimension(Short.MAX_VALUE, pref.height);
  }

  /**
   *
   * @param g Graphics
   * @param c JComponent
   */
  @Override
  public final void paint(final Graphics g, final JComponent c) {
    boolean vertical = ( (JSeparator) c).getOrientation() == SwingConstants.VERTICAL;
    Dimension size = c.getSize();

    if (vertical) {
      int x = (size.width / 2) - 1;
      g.setColor(shadow);
      g.drawLine(x, 2, x, size.height - 2);

      g.setColor(highlight);
      g.drawLine(x + 1, 2, x + 1, size.height - 2);
    }
    else {
      int y = (size.height / 2) - 1;
      g.setColor(shadow);
      g.drawLine(2, y, size.width - 2, y);
      g.setColor(highlight);
      g.drawLine(2, y + 1, size.width - 2, y + 1);
    }
  }

}
