/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.table;

import java.awt.Component;
import java.awt.Font;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import jnpad.ui.plaf.LAFUtils;
import jnpad.util.Utilities;

/**
 * The Class JNPadDefaultHeaderTableCellRenderer.
 *
 * @version 0.3
 * @since   jNPad v0.1
 */
public class JNPadDefaultHeaderTableCellRenderer extends JLabel implements TableCellRenderer {
  
  /** UID. */
  private static final long serialVersionUID = 4469803228290770539L;

  /**
   * Instantiates a new jN pad default header table cell renderer.
   */
  public JNPadDefaultHeaderTableCellRenderer() {
    setOpaque(true);
    setHorizontalAlignment(CENTER);
  }

  /**
   * Gets the table cell renderer component.
   *
   * @param table the table
   * @param value the value
   * @param isSelected is selected
   * @param hasFocus has focus
   * @param row the row
   * @param column the column
   * @return the table cell renderer component
   * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
   */
  @Override
  public Component getTableCellRendererComponent(JTable table,
                                                 Object value,
                                                 boolean isSelected,
                                                 boolean hasFocus,
                                                 int row,
                                                 int column) {

    setForeground(LAFUtils.getTableSelectionForeground());
    setBackground(LAFUtils.getTableSelectionBackground());
    setFont(LAFUtils.getTableFont().deriveFont(Font.BOLD));

    setText(Utilities.toString(value));

    return this;
  }

}
