/*
 * jNPad v0.3 - jNPad's an Simple Text Editor written in Java
 *
 * Copyright (C) 2014-2017  rgs
 *
 * Require JDK 1.6 (or later)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 *
 * Info, Questions, Suggestions & Bugs Report to rgsevero@gmail.com
 */

package jnpad.ui.toolbar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import jnpad.ui.plaf.LAFUtils;

/**
 * The base class for any decorated icon. The icon to decorate is supplied as
 * the constructor and the decoration defined as a pattern buffer in the
 * concrete class.
 * 
 * @version 0.3
 * @since   jNPad v0.1
 */
public abstract class DecoratedIcon extends ImageIcon {
  /** */
  public static final int   ROLLOVER         = 0;

  /** */
  public static final int   STANDARD         = 1;

  /** Sprite buffer for the arrow image of the left button. */
  protected int[][]         buffer;

  /** The popup icon width. */
  protected int             popupIconWidth  = 11;
  
  /** The popup icon height. */
  protected int             popupIconHeight = 16;
  
  private int               popupIconOffset = 5;

  private ImageIcon         imageIcon;

  /** UID */
  private static final long serialVersionUID = 7144078227340209320L;

  /**
   * Instantiates a new decorated icon.
   *
   * @param imageIcon the image icon
   */
  protected DecoratedIcon(ImageIcon imageIcon) {
    this.imageIcon = imageIcon;
  }

  /**
   * Inits the.
   *
   * @param buffer the buffer
   */
  protected void init(int[][] buffer) {
    this.buffer = buffer;
    popupIconWidth = buffer[0].length;
    popupIconHeight = buffer.length;

    int newWidth = imageIcon.getIconWidth() + popupIconOffset + popupIconWidth;
    int newHeight = imageIcon.getIconHeight();

    BufferedImage mergedImage = new BufferedImage(newWidth, newHeight, BufferedImage.TYPE_INT_ARGB);
    Graphics2D g2D = mergedImage.createGraphics();
    g2D.drawImage(imageIcon.getImage(), null, null);
    setImage(mergedImage);
  }

  /**
   * Paints the icon. The top-left corner of the icon is drawn at the point (x,
   * y) in the coordinate space of the graphics context g. If this icon has no
   * image observer, this method uses the c component as the observer.
   * 
   * @param c the component to be used as the observer if this icon has no image
   *          observer
   * @param g the graphics context
   * @param x the X coordinate of the icon's top-left corner
   * @param y the Y coordinate of the icon's top-left corner
   * @see javax.swing.ImageIcon#paintIcon(java.awt.Component, java.awt.Graphics, int, int)
   */
  @Override
  public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
    super.paintIcon(c, g, x, y);

    int xOffset = x + imageIcon.getIconWidth() + popupIconOffset;

    Color[] colors = {
        c.getBackground(),
        LAFUtils.getControlDkShadow(),
        LAFUtils.getControlText(),
        LAFUtils.getControlHighlight() };

    for (int i = 0; i < popupIconWidth; i++) {
      for (int j = 0; j < popupIconHeight; j++) {
        if (buffer[j][i] != 0) {
          g.setColor(colors[buffer[j][i]]);
          g.drawLine(xOffset + i, y + j, xOffset + i, y + j);
        }
      }
    }
  }

}
