/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.Face;
import com.jthomas.javafaces.FaceButton;
import com.jthomas.javafaces.FaceEvent;
import com.jthomas.javafaces.FaceEventListener;
import com.jthomas.javafaces.FaceOptions;
import com.jthomas.javafaces.FaceProperties;
import com.jthomas.javafaces.FaceScrollablePanel;
import com.jthomas.javafaces.FaceStatusLabel;
import com.jthomas.javafaces.JavaFaces;
import com.jthomas.javafaces.Mailmsg;
import com.jthomas.javafaces.MsgDialog;
import com.jthomas.util.Debug;
import com.jthomas.util.Queue;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FaceBoard
extends Panel
implements Runnable {
    static final int ICONSIZE = 52;
    static final int VGAP = 4;
    static final int HGAP = 4;
    private FaceScrollablePanel _ScrollPane;
    private Panel _FacePanel;
    private FaceStatusLabel _Status;
    private MenuBar _MBar;
    private JavaFaces _JavaFaces;
    private FaceOptions _Options = FaceOptions.getRef();
    private Queue _Queue;
    private Hashtable _Faces;
    private boolean _NoMailIcon;
    private int _Number;
    private boolean _FaceUpdate;
    private int _ShowMax = 10;
    private int _ShowMin = 4;
    private int _Width;
    private int _WidthOld;
    private int _HeightOld;
    private int _Height;
    private Point _Location;
    private FaceProperties _Properties;

    FaceBoard() {
        this._JavaFaces = JavaFaces.getRef();
        this._Queue = new Queue(100);
        this._Properties = FaceProperties.getRef();
        this.refreshOptions();
        this._JavaFaces.addFaceEventListener(new 1());
    }

    public synchronized void refreshOptions() {
        Debug.out("FaceBoard:refreshOptions()");
        this._ShowMax = this._Options.getInt("ShowMaxPIcons", this._ShowMax);
        this._ShowMin = this._Options.getInt("ShowMinPIcons", this._ShowMin);
        if (this._ScrollPane != null) {
            this._ScrollPane.setMax(this._ShowMax);
            this._FaceUpdate = true;
            Graphics g = this.getGraphics();
            this.paint(g);
        }
    }

    public void setup() {
        this.setLayout(new BorderLayout(0, 0));
        this._ShowMax = Integer.parseInt(this._Properties.getProperty("FaceFrameShowMax", String.valueOf(this._ShowMax)));
        this._Faces = new Hashtable(20);
        this._FacePanel = new Panel();
        this._FacePanel.setLayout(new FlowLayout(0, 0, 0));
        this._FacePanel.setSize(52 * this._ShowMin, 52);
        this._ScrollPane = new FaceScrollablePanel(this._FacePanel, 52, 52, this._ShowMin, this._ShowMax);
        this.add("Center", this._ScrollPane);
        Dimension d = this._ScrollPane.getPreferredSize();
        this._ScrollPane.setSize(d);
        this._Width = d.width;
        this._HeightOld = this._Height = d.height;
        this._WidthOld = this.getSize().width;
        this._Location = this.getLocation();
        Graphics g = this.getGraphics();
        this.paint(g);
    }

    public synchronized void paint(Graphics g) {
        Dimension d = this._ScrollPane.getSize();
        int width = d.width;
        int height = d.height;
        Debug.out("FaceBoard.paint(): " + d);
        if (!(width != 0 && width != this._WidthOld || height != 0 && height != this._HeightOld || this._FaceUpdate)) {
            super.paint(g);
            return;
        }
        if (width != this._WidthOld && this._Number > 0) {
            int n;
            Debug.out("w=" + width + " _W=" + this._WidthOld + " " + this._Number);
            Insets in = this.getInsets();
            int mainwidth = width - in.left + in.right;
            this._ShowMax = width < this._WidthOld ? Math.max(mainwidth / 52, this._ShowMin) : ((n = mainwidth / 52) > this._Number ? Math.max(this._Number, this._ShowMin) : Math.max(n, this._ShowMin));
            this._ScrollPane.setMax(this._ShowMax);
            this._FaceUpdate = true;
            ((Hashtable)this._Properties).put("FaceFrameShowMax", String.valueOf(this._ShowMax));
            this._Properties.save();
        }
        Debug.out("_Number=" + this._Number + " _ShowMax=" + this._ShowMax + " _ShowMin=" + this._ShowMin);
        if (this._FaceUpdate) {
            this._FaceUpdate = false;
            int n = this._Number - this._ShowMax;
            if (n > 0) {
                Adjustable adjust = this._ScrollPane.getHAdjustable();
                this._ScrollPane.setScrollPosition(n *= adjust.getUnitIncrement(), 0);
            }
            this.invalidate();
            Container c = this;
            while (c != null && !(c instanceof Frame)) {
                c = c.getParent();
            }
            if (c != null) {
                ((Frame)c).pack();
            }
        }
        d = this._ScrollPane.getSize();
        this._WidthOld = d.width;
        this._HeightOld = d.height;
        super.paint(g);
    }

    private synchronized void reset() {
        Debug.out("FaceBoard.reset()");
        if (this._Faces != null) {
            Enumeration e = this._Faces.elements();
            while (e.hasMoreElements()) {
                ((Face)e.nextElement()).reset();
            }
        }
        this._FacePanel.removeAll();
        this._FacePanel.setVisible(false);
        this._Faces = new Hashtable(20);
        this._Number = 0;
        Graphics g = this.getGraphics();
        this._FaceUpdate = true;
    }

    public void run() {
        while (true) {
            Object o;
            if ((o = this._Queue.get()) instanceof Mailmsg) {
                Mailmsg mailmsg = (Mailmsg)o;
                Debug.out("From Queue: Mailmsg " + mailmsg.getKey() + " " + mailmsg.getImageURL());
                this.update(mailmsg);
                continue;
            }
            if (!(o instanceof String)) continue;
            String s = (String)o;
            Debug.out("From Queue: String " + s);
            if (s.equals("NOMAIL")) {
                this.reset();
                this.nomail();
                continue;
            }
            if (!s.equals("RESET")) continue;
            this.reset();
        }
    }

    public void queuePut(Object obj) {
        this._Queue.put(obj);
    }

    public synchronized void update(Mailmsg mailmsg) {
        Graphics g;
        Object image = null;
        FaceButton button = null;
        if (this._NoMailIcon & mailmsg.getAction() != 10) {
            this.reset();
            this._NoMailIcon = false;
        }
        if (mailmsg.getAction() == 4) {
            Face face = mailmsg.getFace();
            if (face != null) {
                face.update(mailmsg);
                if (face.getNumber() == 0) {
                    button = face.getButton();
                    this._FacePanel.remove(button);
                    this._Faces.remove(mailmsg.getImageURL());
                    --this._Number;
                    this._ScrollPane.setNumber(this._Number);
                    if (this._Number - this._ShowMin == -1) {
                        Debug.out("Clear Panel - Special handling");
                        this._FaceUpdate = true;
                        this._ScrollPane.setVisible(false);
                        this._ScrollPane.invalidate();
                        this._ScrollPane.doLayout();
                        g = this.getGraphics();
                        this.paint(g);
                        this._ScrollPane.setVisible(true);
                    }
                }
            }
        } else {
            String imageurl = mailmsg.getImageURL();
            if (imageurl == null) {
                Debug.out("No image to display");
                return;
            }
            Face face = mailmsg.isBuildIcon() ? (Face)this._Faces.get(mailmsg.getHeader("From")) : (Face)this._Faces.get(imageurl);
            if (face != null) {
                face.update(mailmsg);
            } else {
                ++this._Number;
                face = new Face(this);
                face.update(mailmsg, imageurl);
                button = this.displayImage(mailmsg, imageurl);
                if (button == null && (button = this.displayImage(mailmsg, imageurl = this._Options.get("DefaultImageURL"))) == null) {
                    Debug.out("Unable to create a Face Button from image " + imageurl);
                    --this._Number;
                    return;
                }
                if (mailmsg.isBuildIcon()) {
                    this._Faces.put(mailmsg.getHeader("From"), face);
                } else {
                    this._Faces.put(imageurl, face);
                }
                face.setButton(button);
                button.setFace(face);
                this._ScrollPane.setNumber(this._Number);
            }
            mailmsg.setFace(face);
        }
        this._FaceUpdate = true;
        g = this.getGraphics();
        this._FacePanel.paintComponents(g);
        this.paint(g);
    }

    public Mailmsg[] getAllMailmsgs() {
        Mailmsg[] answer = null;
        Vector<Mailmsg> temp = new Vector<Mailmsg>(50);
        Enumeration<Object> enumeration = this._Faces.elements();
        while (enumeration.hasMoreElements()) {
            Face face = (Face)enumeration.nextElement();
            Mailmsg[] msgs = face.getMailmsgs();
            int i = 0;
            while (i < msgs.length) {
                temp.addElement(msgs[i]);
                ++i;
            }
        }
        enumeration = temp.elements();
        answer = new Mailmsg[temp.size()];
        int i = 0;
        while (enumeration.hasMoreElements()) {
            answer[i] = (Mailmsg)enumeration.nextElement();
            ++i;
        }
        return answer;
    }

    private synchronized void nomail() {
        FaceButton button = null;
        this._Number = 1;
        String imageurl = this._Options.get("NoMailURL");
        button = this.displayImage(null, imageurl);
        this._NoMailIcon = true;
        this._ScrollPane.setNumber(this._Number);
        Graphics g = this.getGraphics();
        this._FacePanel.paintComponents(g);
        this._FaceUpdate = true;
        this.paint(g);
    }

    private FaceButton displayImage(Mailmsg mailmsg, String imageurl) {
        Image image = null;
        if ((imageurl = FaceBoard.checkURL(imageurl)) == null) {
            return null;
        }
        Toolkit t = Toolkit.getDefaultToolkit();
        try {
            image = t.getImage(new URL(imageurl));
        }
        catch (MalformedURLException malformedURLException) {
            Debug.out("Invalid URL for Image\n" + imageurl);
            MsgDialog.create("Invalid URL for Image\n" + imageurl);
            return null;
        }
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Debug.out("MediaTracker Failed to get image " + imageurl);
            MsgDialog.create("MediaTracker failed to get image:\n  " + imageurl);
            return null;
        }
        if (tracker.isErrorAny()) {
            image.flush();
            Debug.out("Error loading image for " + imageurl);
            MsgDialog.create("Error loading image:\n  " + imageurl);
            return null;
        }
        FaceButton ibutton = new FaceButton(image);
        ibutton.setBorderWidth(2);
        ibutton.setSize(52, 52);
        if (mailmsg != null && mailmsg.isBuildIcon()) {
            String[] overlay = this.parseEmailAddr(mailmsg.getHeader("From"));
            ibutton.setText(overlay);
        }
        this._FacePanel.add(ibutton);
        this._FacePanel.setSize(new Dimension(52 * this._Number, 52));
        this._FacePanel.setVisible(true);
        return ibutton;
    }

    private String[] parseEmailAddr(String from) {
        String[] answer = new String[]{"Unknown", "?", "?"};
        String[] temp = Mailmsg.parseNetworkAddress(from);
        if (temp[0].length() > 0) {
            answer[0] = temp[0];
        }
        StringTokenizer st = new StringTokenizer(temp[1], ".");
        int n = st.countTokens();
        int i = 0;
        while (st.hasMoreElements()) {
            String str = st.nextToken();
            if (i == n - 2) {
                answer[1] = str;
            } else if (i == n - 1) {
                answer[2] = str;
            }
            ++i;
        }
        return answer;
    }

    public static String checkURL(String imageURL) {
        String newURL = null;
        String filename = null;
        if (imageURL.startsWith("file:")) {
            filename = imageURL.substring(5);
            if (filename.startsWith("./")) {
                filename = filename.substring(2);
            } else if (filename.startsWith("//")) {
                filename = filename.substring(2);
            }
            File file = new File(filename);
            if (!file.exists()) {
                MsgDialog.create("Selected local image " + imageURL + " does not exist.");
                Debug.out("url=" + imageURL + " filename=" + filename);
                return null;
            }
            newURL = "file:" + file.getAbsolutePath().replace(File.separatorChar, '/');
            return newURL;
        }
        return imageURL;
    }

    public Dimension getMinimumSize() {
        return this._ScrollPane.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private final class 1
    implements FaceEventListener {
        public void actionPerformed(FaceEvent e) {
            if (e.getID() == 20) {
                FaceBoard.this.refreshOptions();
            }
        }

        /* synthetic */ 1() {
        }
    }
}

