/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.util.Debug;
import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.ScrollPane;

class FaceScrollablePanel
extends ScrollPane {
    private Panel _InnerPanel;
    private int _ShowMin;
    private int _ShowMax;
    private int _Number;
    private int _Width;
    private int _Height;
    private int _Increment;

    public FaceScrollablePanel(Panel p, int width, int height, int min, int max) {
        this._Width = width;
        this._Height = height;
        this._ShowMin = min;
        this._ShowMax = max;
        this._Number = 0;
        this._InnerPanel = p;
        this.add(this._InnerPanel);
        this.setSize(this.getMinimumSize());
        this.setVisible(true);
        this._Increment = width;
        Adjustable adj = this.getHAdjustable();
        adj.setUnitIncrement(this._Increment);
    }

    public void setNumber(int number) {
        int old = this._Number;
        this._Number = number;
        if (this._Number > old && this._Number > this._ShowMax) {
            Adjustable adjust = this.getHAdjustable();
            int v = (this._Number - this._ShowMax) * adjust.getUnitIncrement();
            adjust.setValue(v);
            this.setScrollPosition(v, 0);
            this.validate();
            this.doLayout();
        }
    }

    public void setMax(int max) {
        this._ShowMax = max;
    }

    public Dimension getMinimumSize() {
        Debug.out("FaceScrollablePanel.getMinimumSize()");
        int width = 0;
        int height = 0;
        if (this._Number > this._ShowMax) {
            width = this._Increment * this._ShowMax + 4;
            height = this._Height + this.getHScrollbarHeight() + 4;
        } else if (this._Number > this._ShowMin) {
            width = this._Increment * Math.min(this._Number, this._ShowMax) + 4;
            height = this._Height + 4;
        } else {
            width = this._Increment * Math.max(this._Number, this._ShowMin) + 4;
            height = this._Height + 4;
        }
        Debug.out("n=" + this._Number + " w=" + width + " h=" + height);
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

