/*
 * Decompiled with CFR 0.152.
 */
package com.jthomas.javafaces;

import com.jthomas.javafaces.Face;
import com.jthomas.util.Debug;
import java.util.Hashtable;

public class Mailmsg {
    private String[] _HeaderLines;
    private boolean _HeadersParsed;
    private Hashtable _Headers = new Hashtable(40);
    private String _Key;
    private boolean _Modified;
    private int _Size = -1;
    private String _Uidl;
    private int _MsgNum;
    private boolean _ToBeDeleted = false;
    private boolean _KillCandidate = false;
    private String _ImageURL;
    private String _AudioURL;
    private String _PiconImageURL;
    private boolean _BuildIcon = false;
    private int _Action;
    public static final int ActionDone = 0;
    public static final int ActionDelete = 1;
    public static final int ActionRemove = 4;
    public static final int ActionResolve = 5;
    public static final int ActionResolveAfter = 6;
    public static final int ActionPiconDB = 7;
    public static final int ActionPiconDBDefer = 8;
    public static final int ActionDummy = 10;
    private int _ServerStatus;
    public static final int StatusUnknown = 0;
    public static final int StatusOld = 1;
    public static final int StatusNew = 2;
    private Face _Face;

    public Mailmsg(int msgnum) {
        this._MsgNum = msgnum;
    }

    public synchronized void putHeader(String type, String value) {
        this._Headers.put(type.trim().toUpperCase(), value);
    }

    public synchronized String getHeader(String type) {
        String value;
        if (!this._HeadersParsed && this._HeaderLines != null) {
            int i = 0;
            while (i < this._HeaderLines.length) {
                String[] headerinfo;
                String line = this._HeaderLines[i];
                if (line == null || line.length() == 0) break;
                int j = i + 1;
                while (j < this._HeaderLines.length && this._HeaderLines[j] != null) {
                    if (this._HeaderLines[j].length() <= 0 || !Character.isSpaceChar(this._HeaderLines[j].charAt(0))) break;
                    line = String.valueOf(line) + this._HeaderLines[j];
                    ++i;
                    ++j;
                }
                if ((headerinfo = this.parse(line))[0] != null && headerinfo[0].length() > 0) {
                    headerinfo[0] = headerinfo[0].toUpperCase();
                    line = (String)this._Headers.get(headerinfo[0]);
                    if (line == null) {
                        this.putHeader(headerinfo[0], headerinfo[1]);
                    } else {
                        line = String.valueOf(line) + headerinfo[1];
                        this.putHeader(headerinfo[0], line);
                    }
                }
                ++i;
            }
            this.verifyFromHeader();
            this._HeadersParsed = true;
        }
        return (value = (String)this._Headers.get(type.toUpperCase())) == null ? "" : value;
    }

    private void verifyFromHeader() {
        String value = (String)this._Headers.get("FROM");
        Debug.out("From: " + value);
        if (value == null || value.length() == 0) {
            value = "-@-";
        } else {
            String[] tokens = Mailmsg.parseNetworkAddress(value);
            if (tokens[0].equals("-") || tokens[1].equals("-")) {
                String newvalue = String.valueOf(tokens[0]) + "@" + tokens[1];
                Debug.out("Replace '" + value + "' with '" + newvalue + "'");
                value = newvalue;
            }
        }
        Debug.out("From: " + value);
        this._Headers.put("FROM", value);
    }

    public synchronized String getKey() {
        if (this._Uidl == null) {
            String key = this.getHeader("Message-ID");
            if (!key.equals("")) {
                return key;
            }
            return Integer.toString(this._MsgNum);
        }
        return this._Uidl;
    }

    public void setAction(int code) {
        this._Action = code;
    }

    public int getAction() {
        return this._Action;
    }

    public synchronized void setServerStatus(int code) {
        this._ServerStatus = code;
    }

    public synchronized int getServerStatus() {
        return this._ServerStatus;
    }

    public void setSize(int size) {
        this._Size = size;
    }

    public int getSize() {
        return this._Size;
    }

    public synchronized int getMsgNum() {
        return this._MsgNum;
    }

    public synchronized void setUidl(String uidl) {
        this._Uidl = uidl;
    }

    public synchronized void setHeaderLines(String[] headerlines) {
        this._HeaderLines = headerlines;
    }

    public synchronized void setDeleteFlag(boolean flag) {
        this._ToBeDeleted = flag;
    }

    public synchronized boolean getDeleteFlag() {
        return this._ToBeDeleted;
    }

    public synchronized void setKillCandidate(boolean flag) {
        this._KillCandidate = flag;
    }

    public synchronized boolean getKillCandidate() {
        return this._KillCandidate;
    }

    public void setImageURL(String imageURL) {
        this._ImageURL = imageURL;
    }

    public String getImageURL() {
        return this._ImageURL;
    }

    public void setPiconImageURL(String imageURL) {
        this._ImageURL = imageURL;
    }

    public String getPiconImageURL() {
        return this._ImageURL;
    }

    public void setAudioURL(String audioURL) {
        this._AudioURL = audioURL;
    }

    public String getAudioURL() {
        return this._AudioURL;
    }

    public void setFace(Face face) {
        this._Face = face;
    }

    public Face getFace() {
        return this._Face;
    }

    public void setBuildIcon(boolean setting) {
        this._BuildIcon = setting;
    }

    public boolean isBuildIcon() {
        return this._BuildIcon;
    }

    private String[] parse(String headerline) {
        int colonpos;
        String[] tokens = null;
        tokens = new String[3];
        tokens[0] = "";
        tokens[1] = "";
        if (headerline != null && (colonpos = headerline.indexOf(58)) > 0) {
            tokens[0] = headerline.substring(0, colonpos);
            tokens[1] = headerline.substring(colonpos + 1).trim();
        }
        return tokens;
    }

    public static String[] parseNetworkAddress(String address) {
        String[] tokens = new String[]{"-", "-", "?"};
        boolean failed = false;
        String netaddress = "";
        if (address == null) {
            return tokens;
        }
        int end = address.lastIndexOf(62);
        if (end != -1) {
            int start = address.lastIndexOf(60, end);
            if (start != -1) {
                tokens[2] = address.substring(0, start).trim();
                netaddress = address.substring(start + 1, end).trim();
            } else {
                failed = true;
            }
        } else {
            end = address.lastIndexOf(41);
            if (end != -1) {
                int start = address.lastIndexOf(40, end);
                if (start != -1) {
                    tokens[2] = address.substring(start + 1, end).trim();
                    netaddress = address.substring(0, start).trim();
                }
            } else {
                end = address.lastIndexOf(64);
                if (end != -1) {
                    netaddress = address.trim();
                } else {
                    failed = true;
                }
            }
        }
        if (!failed) {
            end = netaddress.indexOf(64);
            if (end == -1) {
                tokens[0] = netaddress.trim();
            } else if (end == 0) {
                tokens[1] = netaddress.substring(1).trim();
            } else {
                tokens[0] = netaddress.substring(0, end).trim();
                tokens[1] = netaddress.substring(end + 1).trim();
            }
        }
        return tokens;
    }
}

