/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.ACALL;
import j51.intel.AJMP;
import j51.intel.ANL_C_DIRECT;
import j51.intel.ANL_C_NOT_DIRECT;
import j51.intel.ANL_DIRECT_A;
import j51.intel.ANL_DIRECT_DATA;
import j51.intel.Arithmetic;
import j51.intel.ArithmeticADD;
import j51.intel.ArithmeticADDC;
import j51.intel.ArithmeticANL;
import j51.intel.ArithmeticORL;
import j51.intel.ArithmeticOperation;
import j51.intel.ArithmeticSUBB;
import j51.intel.ArithmeticXRL;
import j51.intel.AsyncTimer;
import j51.intel.AsyncTimerListener;
import j51.intel.CJNE_A_DATA;
import j51.intel.CJNE_A_DIRECT;
import j51.intel.CJNE_RI_DATA;
import j51.intel.CJNE_R_DATA;
import j51.intel.CLR_A;
import j51.intel.CLR_BIT;
import j51.intel.CLR_C;
import j51.intel.CPL_A;
import j51.intel.CPL_BIT;
import j51.intel.CPL_C;
import j51.intel.CallListener;
import j51.intel.Code;
import j51.intel.DA_A;
import j51.intel.DEC_A;
import j51.intel.DEC_DIRECT;
import j51.intel.DEC_R;
import j51.intel.DEC_RI;
import j51.intel.DIV_AB;
import j51.intel.DJNZ_DIRECT;
import j51.intel.DJNZ_R;
import j51.intel.EmulationListener;
import j51.intel.INC_A;
import j51.intel.INC_DIRECT;
import j51.intel.INC_DPTR;
import j51.intel.INC_R;
import j51.intel.INC_RI;
import j51.intel.InterruptSource;
import j51.intel.InterruptStatistic;
import j51.intel.JB;
import j51.intel.JBC;
import j51.intel.JC;
import j51.intel.JMP_A_DPTR;
import j51.intel.JNB;
import j51.intel.JNC;
import j51.intel.JNZ;
import j51.intel.JZ;
import j51.intel.LCALL;
import j51.intel.LJMP;
import j51.intel.MCS51Constants;
import j51.intel.MCS51Opcode;
import j51.intel.MCS51Performance;
import j51.intel.MCS51Peripheral;
import j51.intel.MOVC_A_DPTR_A;
import j51.intel.MOVC_A_PC_A;
import j51.intel.MOVX_A_DPTR;
import j51.intel.MOVX_A_RI;
import j51.intel.MOVX_DPTR_A;
import j51.intel.MOVX_RI_A;
import j51.intel.MOV_A_DATA;
import j51.intel.MOV_A_DIRECT;
import j51.intel.MOV_A_R;
import j51.intel.MOV_A_RI;
import j51.intel.MOV_BIT_C;
import j51.intel.MOV_C_BIT;
import j51.intel.MOV_DIRECT_A;
import j51.intel.MOV_DIRECT_DATA;
import j51.intel.MOV_DIRECT_DIRECT;
import j51.intel.MOV_DIRECT_R;
import j51.intel.MOV_DIRECT_RI;
import j51.intel.MOV_DPTR_DATA16;
import j51.intel.MOV_RI_A;
import j51.intel.MOV_RI_DATA;
import j51.intel.MOV_RI_DIRECT;
import j51.intel.MOV_R_A;
import j51.intel.MOV_R_DATA;
import j51.intel.MOV_R_DIRECT;
import j51.intel.MUL_AB;
import j51.intel.MachineCyclesListener;
import j51.intel.MemoryReadListener;
import j51.intel.MemoryReadListenerSfr;
import j51.intel.MemoryWriteListener;
import j51.intel.MemoryWriteListenerSfr;
import j51.intel.NOP;
import j51.intel.ORL_C_BIT;
import j51.intel.ORL_C_NBIT;
import j51.intel.ORL_DIRECT_A;
import j51.intel.ORL_DIRECT_DATA;
import j51.intel.OpenCollectorMemoryBit;
import j51.intel.POP_DIRECT;
import j51.intel.PUSH_DIRECT;
import j51.intel.RESERVED;
import j51.intel.RET;
import j51.intel.RETI;
import j51.intel.RLC_A;
import j51.intel.RL_A;
import j51.intel.RRC_A;
import j51.intel.RR_A;
import j51.intel.ResetListener;
import j51.intel.SETB_BIT;
import j51.intel.SETB_C;
import j51.intel.SJMP;
import j51.intel.SWAP_A;
import j51.intel.SfrPage;
import j51.intel.SfrReadListener;
import j51.intel.SfrRegister;
import j51.intel.SfrWriteListener;
import j51.intel.VolatileCode;
import j51.intel.XCHD_A_RI;
import j51.intel.XCH_A_DIRECT;
import j51.intel.XCH_A_R;
import j51.intel.XCH_A_RI;
import j51.intel.XRL_DIRECT_A;
import j51.intel.XRL_DIRECT_DATA;
import j51.swing.UpdatableComponent;
import j51.util.FastArray;
import j51.util.Hex;
import j51.util.Logger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class MCS51
implements MCS51Constants {
    private static Logger log = Logger.getLogger(MCS51.class);
    private FastArray<InterruptStatistic> interruptStatistics = new FastArray();
    private FastArray<InterruptSource> interruptList = new FastArray();
    private SfrPage[] sfrPages;
    private SfrPage sfrCurrent;
    private int sfrPage = -1;
    private int sfrXdataHi = 128;
    private long clock = 0L;
    private int pc = 0;
    private int oscillator = 12000000;
    protected int machineCycle = 12;
    private String[] codeNames = new String[65536];
    private String[] bitNames = new String[256];
    private int[] sfrBitmap = new int[256];
    private boolean[] breakPoint = new boolean[65536];
    private long[] executionCounter = new long[65536];
    private CallListener[] callListeners = new CallListener[65536];
    private byte[] xdata;
    private byte[] idata;
    private String[] idataNames;
    private static MCS51Opcode[] opcodes = new MCS51Opcode[256];
    private long[] opcodesCounter = new long[256];
    private FastArray<MCS51Peripheral> peripherals = new FastArray();
    private FastArray<Runnable> runQueue = new FastArray();
    private FastArray<InterruptSource> interruptRequest = new FastArray();
    private FastArray<EmulationListener> emulationListeners = new FastArray();
    private FastArray<ResetListener> resetListeners = new FastArray();
    private FastArray<MachineCyclesListener> machineListeners = new FastArray();
    private FastArray performance = new FastArray();
    private InterruptSource currentInterrupt = null;
    private FastArray<AsyncTimer> asyncTimers = new FastArray();
    private Code code;
    private int currentDptr;
    private int[] dptrs = new int[16];
    private int regPtr;
    private FastArray<UpdatableComponent> updatableComponents = new FastArray();
    private Timer updateTimer = null;
    private boolean ie = false;
    private static MCS51 current = null;

    public static void breakNext() {
        current.setBreakAtPC();
    }

    public MCS51() {
        this(12000000, 1);
    }

    public MCS51(int n) {
        this(n, 1);
    }

    public MCS51(int n, int n2) {
        int n3;
        log.info("Created processor with " + n2 + " SFR pages, Clock " + n);
        this.setOscillator(n);
        current = this;
        this.sfrPage = -1;
        this.sfrPages = new SfrPage[n2];
        this.sfrPages[0] = new SfrPage(0);
        for (n3 = 1; n3 < n2; ++n3) {
            this.sfrPages[n3] = new SfrPage(n3, this.sfrPages[0]);
        }
        this.setSfrPage(0);
        this.setCode(new VolatileCode());
        this.setCodeSize(65536);
        this.setXdataSize(65536);
        this.setIdataSize(256);
        for (n3 = 0; n3 < 128; ++n3) {
            this.setSfrBitmap(n3, 32 + n3 / 8);
        }
        for (n3 = 128; n3 < 256; ++n3) {
            this.setSfrBitmap(n3, n3 & 0xF8);
        }
        for (n3 = 0; n3 < this.breakPoint.length; ++n3) {
            this.breakPoint[n3] = false;
        }
        for (n3 = 0; n3 < this.callListeners.length; ++n3) {
            this.callListeners[n3] = null;
        }
        for (n3 = 0; n3 < 65536; ++n3) {
            this.setCodeName(n3, "#" + Hex.bin2word(n3));
        }
        this.setSfrName(224, "ACC");
        this.setSfrName(240, "B");
        this.setSfrName(208, "PSW");
        this.setSfrName(129, "SP");
        this.setSfrName(130, "DPL");
        this.setSfrName(131, "DPH");
        this.setSfrName(128, "P0");
        this.setSfrName(132, "P0M1");
        this.setSfrName(133, "P0M2");
        this.setSfrName(144, "P1");
        this.setSfrName(145, "P1M1");
        this.setSfrName(146, "P1M2");
        this.setSfrName(160, "P2");
        this.setSfrName(164, "P2M1");
        this.setSfrName(165, "P2M2");
        this.setSfrName(176, "P3");
        this.setSfrName(177, "P3M1");
        this.setSfrName(178, "P3M2");
        this.setSfrName(152, "SCON");
        this.setSfrName(153, "SBUF");
        this.setSfrName(136, "TCON");
        this.setSfrName(137, "TMOD");
        this.setSfrName(140, "TH0");
        this.setSfrName(138, "TL0");
        this.setSfrName(141, "TH1");
        this.setSfrName(139, "TL1");
        this.setSfrName(168, "IE");
        this.setBitName(152, "RI");
        this.setBitName(153, "TI");
        this.setBitName(154, "RB8");
        this.setBitName(155, "TB8");
        this.setBitName(156, "REN");
        this.setBitName(157, "SM2");
        this.setBitName(158, "SM1");
        this.setBitName(159, "SM0");
        this.setBitName(143, "TF1");
        this.setBitName(142, "TR1");
        this.setBitName(141, "TF0");
        this.setBitName(140, "TR0");
        this.setBitName(175, "EA");
        this.setBitName(174, "EC");
        this.setBitName(173, "ET2");
        this.setBitName(172, "ES");
        this.setBitName(171, "ET1");
        this.setBitName(170, "EX1");
        this.setBitName(169, "ET0");
        this.setBitName(168, "EX0");
        this.setBitName(215, "CY");
        this.setBitName(214, "AC");
        this.setBitName(213, "F0");
        this.setBitName(212, "RS1");
        this.setBitName(211, "RS0");
        this.setBitName(210, "OV");
        this.setBitName(209, "F1");
        this.setBitName(208, "P");
        for (n3 = 0; n3 < 8; ++n3) {
            this.setIdataName(n3, "R" + n3);
        }
        this.addSfrWriteListener(208, new SfrWriteListener(){

            @Override
            public void sfrWrite(int n, int n2) {
                MCS51.this.regPtr = (n2 >> 3 & 3) * 8;
            }
        });
        this.addSfrWriteListener(168, new SfrWriteListener(){

            @Override
            public void sfrWrite(int n, int n2) {
                MCS51.this.ie = (n2 & 0x80) != 0;
            }
        });
    }

    public final void setEmulation(boolean bl) {
        int n = this.emulationListeners.size();
        while (--n >= 0) {
            this.emulationListeners.get(n).setEmulation(bl);
        }
    }

    public void addEmulationListener(EmulationListener emulationListener) {
        this.emulationListeners.add(emulationListener);
    }

    public OpenCollectorMemoryBit createSfrBitOc(int n, int n2) {
        return new OpenCollectorMemoryBit(this.sfrCurrent, n, n2);
    }

    public void addUpdatableComponent(UpdatableComponent updatableComponent) {
        this.updatableComponents.add(updatableComponent);
        if (this.updateTimer == null) {
            this.updateTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MCS51.this.updatableComponents.size();
                    while (--n >= 0) {
                        ((UpdatableComponent)MCS51.this.updatableComponents.get(n)).update();
                    }
                }
            });
            this.updateTimer.start();
        }
    }

    public Object getPeripheralByClass(Class clazz) {
        for (int i = 0; i < this.getPeripheralsCount(); ++i) {
            MCS51Peripheral mCS51Peripheral = this.getPeripheralAt(i);
            if (!clazz.isInstance(mCS51Peripheral)) continue;
            return mCS51Peripheral;
        }
        return null;
    }

    public Object getPeripheralByClass(String string) throws Exception {
        Class<?> clazz = Class.forName(string);
        return this.getPeripheralByClass(clazz);
    }

    public void setCallListener(int n, CallListener callListener) throws Exception {
        if (this.callListeners[n] != null) {
            throw new Exception("Duplicate call trap at " + Hex.bin2word(n));
        }
        this.callListeners[n] = callListener;
    }

    public CallListener getCallListener(int n) {
        return this.callListeners[n];
    }

    public MCS51Opcode getOpcode(int n) {
        return opcodes[n];
    }

    public String getOpcodeDescription(int n) {
        return opcodes[n].getDescription();
    }

    public long getOpcodeCounter(int n) {
        return this.opcodesCounter[n];
    }

    public void setCode(Code code) {
        this.code = code;
    }

    private static void initOpcodes() {
        int n;
        for (n = 0; n < 256; ++n) {
            MCS51.setOpcode(n, null);
        }
        for (n = 0; n < 8; ++n) {
            MCS51.setOpcode(new ACALL(n << 5 | 0x11));
            MCS51.setOpcode(new AJMP(n << 5 | 1));
        }
        MCS51.arithmetic(new ArithmeticADD(), 32, "ADD");
        MCS51.arithmetic(new ArithmeticADDC(), 48, "ADDC");
        MCS51.arithmetic(new ArithmeticANL(), 80, "ANL");
        MCS51.arithmetic(new ArithmeticORL(), 64, "ORL");
        MCS51.arithmetic(new ArithmeticSUBB(), 144, "SUBB");
        MCS51.arithmetic(new ArithmeticXRL(), 96, "XRL");
        MCS51.setOpcode(new ANL_DIRECT_A());
        MCS51.setOpcode(new ANL_DIRECT_DATA());
        MCS51.setOpcode(new ANL_C_DIRECT());
        MCS51.setOpcode(new ANL_C_NOT_DIRECT());
        MCS51.setOpcode(new CJNE_A_DIRECT());
        MCS51.setOpcode(new CJNE_A_DATA());
        for (n = 0; n < 8; ++n) {
            MCS51.setOpcode(new CJNE_R_DATA(n));
            MCS51.setOpcode(new DEC_R(n));
            MCS51.setOpcode(new DJNZ_R(n));
            MCS51.setOpcode(new INC_R(n));
            MCS51.setOpcode(new MOV_A_R(n));
            MCS51.setOpcode(new MOV_R_A(n));
            MCS51.setOpcode(new MOV_R_DIRECT(n));
            MCS51.setOpcode(new MOV_R_DATA(n));
            MCS51.setOpcode(new MOV_DIRECT_R(n));
            MCS51.setOpcode(new XCH_A_R(n));
        }
        for (n = 0; n < 2; ++n) {
            MCS51.setOpcode(new CJNE_RI_DATA(n));
            MCS51.setOpcode(new DEC_RI(n));
            MCS51.setOpcode(new INC_RI(n));
            MCS51.setOpcode(new MOV_A_RI(n));
            MCS51.setOpcode(new MOV_RI_A(n));
            MCS51.setOpcode(new MOV_DIRECT_RI(n));
            MCS51.setOpcode(new MOV_RI_DIRECT(n));
            MCS51.setOpcode(new MOV_RI_DATA(n));
            MCS51.setOpcode(new MOVX_A_RI(n));
            MCS51.setOpcode(new MOVX_RI_A(n));
            MCS51.setOpcode(new XCH_A_RI(n));
            MCS51.setOpcode(new XCHD_A_RI(n));
        }
        MCS51.setOpcode(new CLR_A());
        MCS51.setOpcode(new CLR_C());
        MCS51.setOpcode(new CLR_BIT());
        MCS51.setOpcode(new CPL_A());
        MCS51.setOpcode(new CPL_C());
        MCS51.setOpcode(new CPL_BIT());
        MCS51.setOpcode(new DA_A());
        MCS51.setOpcode(new DEC_A());
        MCS51.setOpcode(new DEC_DIRECT());
        MCS51.setOpcode(new DIV_AB());
        MCS51.setOpcode(new DJNZ_DIRECT());
        MCS51.setOpcode(new INC_A());
        MCS51.setOpcode(new INC_DIRECT());
        MCS51.setOpcode(new INC_DPTR());
        MCS51.setOpcode(new JB());
        MCS51.setOpcode(new JBC());
        MCS51.setOpcode(new JC());
        MCS51.setOpcode(new JMP_A_DPTR());
        MCS51.setOpcode(new JNB());
        MCS51.setOpcode(new JNC());
        MCS51.setOpcode(new JNZ());
        MCS51.setOpcode(new JZ());
        MCS51.setOpcode(new LCALL());
        MCS51.setOpcode(new LJMP());
        MCS51.setOpcode(new MOV_A_DIRECT());
        MCS51.setOpcode(new MOV_A_DATA());
        MCS51.setOpcode(new MOV_DIRECT_A());
        MCS51.setOpcode(new MOV_DIRECT_DIRECT());
        MCS51.setOpcode(new MOV_DIRECT_DATA());
        MCS51.setOpcode(new MOV_C_BIT());
        MCS51.setOpcode(new MOV_BIT_C());
        MCS51.setOpcode(new MOV_DPTR_DATA16());
        MCS51.setOpcode(new MOVC_A_DPTR_A());
        MCS51.setOpcode(new MOVC_A_PC_A());
        MCS51.setOpcode(new MOVX_A_DPTR());
        MCS51.setOpcode(new MOVX_DPTR_A());
        MCS51.setOpcode(new MUL_AB());
        MCS51.setOpcode(new NOP());
        MCS51.setOpcode(new ORL_C_BIT());
        MCS51.setOpcode(new ORL_C_NBIT());
        MCS51.setOpcode(new POP_DIRECT());
        MCS51.setOpcode(new PUSH_DIRECT());
        MCS51.setOpcode(new RET());
        MCS51.setOpcode(new RETI());
        MCS51.setOpcode(new RL_A());
        MCS51.setOpcode(new RLC_A());
        MCS51.setOpcode(new RR_A());
        MCS51.setOpcode(new RRC_A());
        MCS51.setOpcode(new SETB_C());
        MCS51.setOpcode(new SETB_BIT());
        MCS51.setOpcode(new SJMP());
        MCS51.setOpcode(new SWAP_A());
        MCS51.setOpcode(new XCH_A_DIRECT());
        MCS51.setOpcode(new XRL_DIRECT_A());
        MCS51.setOpcode(new XRL_DIRECT_DATA());
        MCS51.setOpcode(new ORL_DIRECT_A());
        MCS51.setOpcode(new ORL_DIRECT_DATA());
        MCS51.setOpcode(new RESERVED());
    }

    protected int getSfrXdataHi() {
        return this.sfrXdataHi;
    }

    protected void setSfrXdataHi(int n) {
        this.sfrXdataHi = n;
    }

    public void addResetListener(ResetListener resetListener) {
        this.resetListeners.add(resetListener);
    }

    public void addAsyncTimerListener(int n, AsyncTimerListener asyncTimerListener) {
        for (int i = 0; i < this.asyncTimers.size(); ++i) {
            AsyncTimer asyncTimer = this.asyncTimers.get(i);
            if (n == asyncTimer.timeout) {
                asyncTimer.add(asyncTimerListener);
                return;
            }
            if (n < asyncTimer.timeout) {
                AsyncTimer asyncTimer2 = new AsyncTimer();
                asyncTimer2.timeout = n;
                asyncTimer2.add(asyncTimerListener);
                asyncTimer.timeout -= n;
                this.asyncTimers.add(i, asyncTimer2);
                return;
            }
            n -= asyncTimer.timeout;
        }
        AsyncTimer asyncTimer = new AsyncTimer();
        asyncTimer.timeout = n;
        asyncTimer.add(asyncTimerListener);
        this.asyncTimers.add(asyncTimer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunQueue(Runnable runnable) {
        FastArray<Runnable> fastArray = this.runQueue;
        synchronized (fastArray) {
            this.runQueue.add(runnable);
        }
    }

    public void addAsyncTimerListenerMillis(int n, AsyncTimerListener asyncTimerListener) {
        this.addAsyncTimerListener(this.oscillator / this.machineCycle / 1000 * n, asyncTimerListener);
    }

    public void addInterruptSource(int n, InterruptSource interruptSource) {
        this.addInterruptSource(n, interruptSource, " INT");
    }

    public int getInterruptCount() {
        return this.interruptList.size();
    }

    public InterruptStatistic getInterruptAt(int n) {
        return this.interruptStatistics.get(n);
    }

    public void addInterruptSource(int n, InterruptSource interruptSource, String string) {
        if (this.interruptList.indexOf(interruptSource) == -1) {
            while (string.length() < 16) {
                string = string + " ";
            }
            this.interruptStatistics.add(new InterruptStatistic(interruptSource, string + " AT 0x" + Hex.bin2word(interruptSource.getInterruptVector())));
            this.interruptList.add(interruptSource);
        }
        SfrRegister sfrRegister = this.getSfr(n);
        sfrRegister.interruptSources.add(interruptSource);
    }

    public void addMachineCycleListener(MachineCyclesListener machineCyclesListener) {
        this.machineListeners.add(machineCyclesListener);
    }

    public void addPerformanceListener(MCS51Performance mCS51Performance) {
        this.performance.remove(mCS51Performance);
        this.performance.add(mCS51Performance);
    }

    public void addSfrMemoryReadListener(int n, MemoryReadListener memoryReadListener) {
        this.sfrCurrent.addMemoryReadListener(n, memoryReadListener);
    }

    public void addSfrReadListener(int n, SfrReadListener sfrReadListener) {
        this.addSfrMemoryReadListener(n, new MemoryReadListenerSfr(sfrReadListener));
    }

    public void addSfrMemoryWriteListener(int n, MemoryWriteListener memoryWriteListener) {
        this.sfrCurrent.addMemoryWriteListener(n, memoryWriteListener);
    }

    public void addSfrWriteListener(int n, SfrWriteListener sfrWriteListener) {
        this.addSfrMemoryWriteListener(n, new MemoryWriteListenerSfr(sfrWriteListener));
    }

    public int getPeripheralsCount() {
        return this.peripherals.size();
    }

    protected void addPeripheral(MCS51Peripheral mCS51Peripheral) {
        mCS51Peripheral.registerCpu(this);
        this.peripherals.add(mCS51Peripheral);
    }

    public MCS51Peripheral getPeripheralAt(int n) {
        return this.peripherals.get(n);
    }

    private static void arithmetic(ArithmeticOperation arithmeticOperation, int n, String string) {
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            MCS51.setOpcode(new Arithmetic(n | 8 | n2, 1, arithmeticOperation, string){

                @Override
                public int getValue(MCS51 mCS51, int n) {
                    return mCS51.r(this.opcode & 7);
                }

                @Override
                public String toString() {
                    return this.description + "\tA,R" + (this.opcode & 7);
                }
            });
        }
        MCS51.setOpcode(new Arithmetic(n | 5, 2, arithmeticOperation, string){

            @Override
            public int getValue(MCS51 mCS51, int n) {
                return mCS51.getDirectCODE(n + 1);
            }

            @Override
            public String toString() {
                return this.description + "\tA,DIRECT";
            }
        });
        for (n2 = 0; n2 < 2; ++n2) {
            MCS51.setOpcode(new Arithmetic(n | 6 | n2, 1, arithmeticOperation, string){

                @Override
                public int getValue(MCS51 mCS51, int n) {
                    return mCS51.idata(mCS51.r(this.opcode & 1));
                }

                @Override
                public String toString() {
                    return this.description + "\tA,R" + (this.opcode & 1);
                }
            });
        }
        MCS51.setOpcode(new Arithmetic(n | 4, 2, arithmeticOperation, string){

            @Override
            public int getValue(MCS51 mCS51, int n) {
                return mCS51.code(n + 1);
            }

            @Override
            public String toString() {
                return this.description + "\tA,#DATA8";
            }
        });
    }

    private static void setOpcode(MCS51Opcode mCS51Opcode) {
        MCS51.setOpcode(mCS51Opcode.getOpcode(), mCS51Opcode);
    }

    private static void setOpcode(int n, MCS51Opcode mCS51Opcode) {
        if (opcodes[n] != null) {
            System.out.println("Error " + Integer.toHexString(n) + " " + opcodes[n] + " e " + mCS51Opcode);
            System.exit(1);
        }
        MCS51.opcodes[n] = mCS51Opcode;
    }

    public final int getDirectCODE(int n) {
        return this.getDirect(this.code(n));
    }

    public String getDirectName(int n) {
        if (n >= 128) {
            return this.getSfrName(n);
        }
        return this.getIdataName(n);
    }

    public final int getDirect(int n) {
        if (n >= 128) {
            return this.sfr(n);
        }
        return this.idata(n);
    }

    public final int getDirectDirect(int n) {
        if (n >= 128) {
            return this.sfrCurrent.readDirect(n);
        }
        return this.idata(n);
    }

    public final void setDirect(int n, int n2) {
        if (n >= 128) {
            this.sfr(n, n2);
        } else {
            this.idata(n, n2);
        }
    }

    public final void setBitName(int n, String string) {
        this.bitNames[n] = string;
    }

    public final String getBitName(int n) {
        if (this.bitNames[n] != null) {
            return this.bitNames[n];
        }
        int n2 = n & 7;
        n = n < 128 ? 32 + n / 8 : (n &= 0xF8);
        return this.getDirectName(n) + "^" + n2;
    }

    public final boolean getBitCODE(int n) {
        return this.getBit(this.code(n));
    }

    public final void setSfrBitmap(int n, int n2) {
        this.sfrBitmap[n] = n2;
    }

    public final boolean getBit(int n) {
        int n2 = this.getDirect(this.sfrBitmap[n]);
        return (n2 & 1 << (n & 7)) != 0;
    }

    public final void setBit(int n, boolean bl) {
        int n2 = 1 << (n & 7);
        n = this.sfrBitmap[n];
        int n3 = this.getDirectDirect(n);
        n3 = bl ? (n3 |= n2) : (n3 &= ~n2);
        this.setDirect(n, n3);
    }

    public final int sp() {
        return this.sfr(129);
    }

    public final void sp(int n) {
        this.sfr(129, n);
    }

    public final int pc() {
        return this.pc;
    }

    public final void pc(int n) {
        this.pc = n & 0xFFFF;
    }

    public final int dpl() {
        return this.sfr(130);
    }

    public final void dpl(int n) {
        this.sfr(130, n);
    }

    public final int dph() {
        return this.sfr(131);
    }

    public final void dph(int n) {
        this.sfr(131, n);
    }

    public int getDptr(int n) {
        if (n == this.currentDptr) {
            return this.dptr();
        }
        return this.dptrs[n];
    }

    public final int dptr() {
        return this.sfr(131) * 256 | this.sfr(130);
    }

    public final void dptr(int n) {
        this.sfr(131, n >> 8);
        this.sfr(130, n);
    }

    public final void r(int n, int n2) {
        this.idata(this.regPtr + n, n2);
    }

    public final int r(int n) {
        return this.idata(this.regPtr + n);
    }

    public final int b() {
        return this.sfr(240);
    }

    public final void b(int n) {
        this.sfr(240, n);
    }

    public final int acc() {
        return this.sfr(224);
    }

    public final void acc(int n) {
        this.sfr(224, n);
    }

    public final int psw() {
        return this.sfr(208);
    }

    public final void psw(int n) {
        this.sfr(208, n);
    }

    public final void cy(boolean bl) {
        if (bl) {
            this.pswSet(128);
        } else {
            this.pswReset(128);
        }
    }

    public final boolean cy() {
        return (this.psw() & 0x80) != 0;
    }

    public final void ac(boolean bl) {
        if (bl) {
            this.pswSet(64);
        } else {
            this.pswReset(64);
        }
    }

    public final boolean ac() {
        return (this.psw() & 0x40) != 0;
    }

    public final void ov(boolean bl) {
        if (bl) {
            this.pswSet(4);
        } else {
            this.pswReset(4);
        }
    }

    public final boolean ov() {
        return (this.psw() & 4) != 0;
    }

    private final void pswSet(int n) {
        this.sfr(208, this.sfr(208) | n);
    }

    private final void pswReset(int n) {
        this.sfr(208, this.sfr(208) & ~n);
    }

    private void setCodeSize(int n) {
        this.code.setCodeSize(n);
    }

    public int getXdataSize() {
        return this.xdata.length;
    }

    protected void setXdataSize(int n) {
        this.xdata = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.xdata[i] = 0;
        }
    }

    private void setIdataSize(int n) {
        this.idata = new byte[n];
        this.idataNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.idata[i] = 0;
            this.setIdataName(i, Hex.bin2byte(i));
        }
    }

    private void setIdataName(int n, String string) {
        this.idataNames[n] = string;
    }

    public String getIdataName(int n) {
        return this.idataNames[n];
    }

    public void setCodeName(int n, String string) {
        this.codeNames[n] = string;
    }

    public String getCodeName(int n) {
        return this.codeNames[n];
    }

    public void setSfrName(int n, String string) {
        this.sfrCurrent.setName(n, string);
    }

    public String getSfrName(int n) {
        return this.sfrCurrent.getName(n);
    }

    public final void code(int n, int n2) {
        this.code.setCode(n, n2);
    }

    public final int getCodeSize() {
        return this.code.getCodeSize();
    }

    public final int code(int n, boolean bl) {
        return this.code.getCode(n, bl);
    }

    public final int code(int n) {
        return this.code(n, false);
    }

    public final int code16(int n, boolean bl) {
        return this.code.getCode16(n, bl);
    }

    public final int code16(int n) {
        return this.code16(n, false);
    }

    public int xdata(int n) {
        int n2 = this.xdata[n & 0xFFFF] & 0xFF;
        return n2;
    }

    public void xdata(int n, int n2) {
        this.xdata[n] = (byte)n2;
    }

    public final int idata(int n) {
        return this.idata[n] & 0xFF;
    }

    public final void idata(int n, int n2) {
        this.idata[n] = (byte)n2;
    }

    private int setSfrPage(int n) {
        if (n != this.sfrPage) {
            int n2 = this.sfrPage;
            this.sfrCurrent = this.sfrPages[n];
            this.sfrPage = n;
            return n2;
        }
        return n;
    }

    public final SfrRegister getSfr(int n) {
        return this.sfrCurrent.getReg(n);
    }

    public final int sfr(int n) {
        return this.sfrCurrent.read(n);
    }

    public final boolean sfrIsSet(int n, int n2) {
        return (this.sfr(n) & n2) == n2;
    }

    public final void sfrSet(int n, int n2) {
        this.sfr(n, this.sfr(n) | n2);
    }

    public final void sfrReset(int n, int n2) {
        this.sfr(n, this.sfr(n) & ~n2);
    }

    public final int sfr16(int n, int n2) {
        return this.sfr(n) * 256 + this.sfr(n2);
    }

    public final void sfr16(int n, int n2, int n3) {
        this.sfr(n2, n >> 8);
        this.sfr(n3, n);
    }

    public final void sfr(int n, int n2) {
        this.sfrCurrent.write(n, n2);
        SfrRegister sfrRegister = this.getSfr(n);
        if (this.sfrCurrent.getWriteListener()) {
            for (int i = 0; i < sfrRegister.interruptSources.size(); ++i) {
                InterruptSource interruptSource = sfrRegister.interruptSources.get(i);
                if (!interruptSource.interruptCondition() || this.interruptRequest.contains(interruptSource)) continue;
                int n3 = this.interruptList.indexOf(interruptSource);
                if (n3 != -1) {
                    this.interruptStatistics.get(n3).incCounter();
                }
                this.interruptRequest.add(interruptSource);
            }
        }
    }

    public void reset() {
        int n;
        log.info("Begin Reset");
        this.setSfrPage(0);
        for (n = 0; n < this.executionCounter.length; ++n) {
            this.executionCounter[n] = 0L;
        }
        for (n = 0; n < 256; ++n) {
            this.opcodesCounter[n] = 0L;
        }
        for (n = 0; n < this.xdata.length; ++n) {
            this.xdata(n, 0);
        }
        for (n = 0; n < this.idata.length; ++n) {
            this.idata(n, 0);
        }
        this.sfrCurrent.setWriteListener(false);
        for (n = 0; n < 256; ++n) {
            this.sfr(n, 0);
        }
        this.sfrCurrent.setWriteListener(true);
        this.sfr(129, 7);
        this.pc = 0;
        this.clock = 0L;
        this.currentDptr = 0;
        for (n = 0; n < this.dptrs.length; ++n) {
            this.dptrs[n] = 0;
        }
        for (n = 0; n < this.resetListeners.size(); ++n) {
            this.resetListeners.get(n).reset(this);
        }
        log.info("End Reset");
    }

    public void swapDptr(int n) {
        if (n >= this.dptrs.length) {
            n = this.dptrs.length - 1;
        }
        if (n != this.currentDptr) {
            this.dptrs[this.currentDptr] = this.dptr();
            this.dptr(this.dptrs[n]);
            this.currentDptr = n;
        }
    }

    public final int popw() throws Exception {
        int n = this.sfr(129);
        int n2 = this.idata(n) << 8;
        if (--n < 0) {
            throw new Exception("Stack underflow at " + Hex.bin2word(this.pc));
        }
        n2 |= this.idata(n);
        if (--n < 0) {
            throw new Exception("Stack underflow at " + Hex.bin2word(this.pc));
        }
        this.sfr(129, n);
        return n2;
    }

    public final int pop() throws Exception {
        int n = this.sfr(129);
        int n2 = this.idata(n);
        if (--n < 0) {
            throw new Exception("Stack underflow at " + Hex.bin2word(this.pc));
        }
        this.sfr(129, n);
        return n2;
    }

    public final void pushw(int n) throws Exception {
        int n2 = this.sfr(129);
        if (++n2 > 255) {
            throw new Exception("Stack overflow at " + Hex.bin2word(this.pc));
        }
        this.idata(n2, n);
        if (++n2 > 255) {
            throw new Exception("Stack overflow at " + Hex.bin2word(this.pc));
        }
        this.idata(n2, n >> 8);
        this.sfr(129, n2);
    }

    public final void push(int n) throws Exception {
        int n2 = this.sfr(129);
        if (++n2 > 255) {
            throw new Exception("Stack overflow at " + Hex.bin2word(this.pc));
        }
        this.idata(n2, n);
        this.sfr(129, n2);
    }

    public final void eoi() {
        if (this.currentInterrupt != null) {
            if (this.currentInterrupt.interruptCondition()) {
                this.interruptRequest.add(this.currentInterrupt);
            }
            this.currentInterrupt = null;
        }
    }

    public void go() throws Exception {
        this.go(-1);
    }

    public final void go(int n) throws Exception {
        long l;
        int n2 = 0;
        long l2 = l = System.currentTimeMillis();
        int n3 = 0;
        if (n != -1) {
            this.breakPoint[n] = true;
        }
        int n4 = this.oscillator * 10 / 1000;
        while (true) {
            int n5;
            int n6 = n4;
            do {
                int n7 = this._step();
                this.clock += (long)n7;
                n6 -= n7;
                if (!this.breakPoint[this.pc]) continue;
                if (this.pc == n) {
                    this.breakPoint[n] = false;
                }
                throw new InterruptedException("Break point at " + Hex.bin2word(this.pc));
            } while (n6 > 0);
            this.checkRunQueue();
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l;
            n2 += 10;
            int n8 = (int)(l3 - l2);
            if (n8 >= 5000) {
                n5 = (n8 - n3) * 100 / n8;
                l2 = l3;
                n3 = 0;
                for (int i = 0; i < this.performance.size(); ++i) {
                    ((MCS51Performance)this.performance.get(i)).cpuPerformance(n5, n8);
                }
                if (n5 >= 99) {
                    Thread.sleep(10L);
                    n3 = 10;
                }
            }
            if ((n5 = (int)((long)n2 - l4)) <= 10) continue;
            l = l3 + (long)n5;
            n3 += n5;
            n2 = 0;
            Thread.sleep(n5);
        }
    }

    public void pass() throws Exception {
        MCS51Opcode mCS51Opcode = opcodes[this.code(this.pc)];
        int n = this.pc + mCS51Opcode.getLength();
        this.go(n);
    }

    public long getExecutionCounter(int n) {
        return this.executionCounter[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkRunQueue() {
        if (this.runQueue.size() > 0) {
            FastArray<Runnable> fastArray = this.runQueue;
            synchronized (fastArray) {
                int n = this.runQueue.size() - 1;
                while (--n >= 0) {
                    this.runQueue.get(n).run();
                }
                this.runQueue.clear();
            }
        }
    }

    public final int step() throws Exception {
        this.checkRunQueue();
        int n = this._step();
        this.clock += (long)n;
        return n;
    }

    public final int _step() throws Exception {
        int n;
        if (this.currentInterrupt == null && this.ie && this.interruptRequest.size() > 0) {
            this.currentInterrupt = this.interruptRequest.get(0);
            this.interruptRequest.remove(0);
            this.pushw(this.pc);
            this.pc(this.currentInterrupt.getInterruptVector());
            this.currentInterrupt.interruptStart();
            return 2;
        }
        int n2 = this.pc;
        this.executionCounter[n2] = this.executionCounter[n2] + 1L;
        int n3 = this.pc;
        int n4 = n = this.code.getCode(n3, false);
        this.opcodesCounter[n4] = this.opcodesCounter[n4] + 1L;
        MCS51Opcode mCS51Opcode = opcodes[n];
        int n5 = mCS51Opcode.getCycle();
        this.pc += mCS51Opcode.getLength();
        mCS51Opcode.exec(this, n3);
        int n6 = this.machineListeners.size();
        while (--n6 >= 0) {
            this.machineListeners.get(n6).cycles(n5);
        }
        while (this.asyncTimers.size() > 0) {
            AsyncTimer asyncTimer = this.asyncTimers.get(0);
            asyncTimer.timeout -= n5;
            if (asyncTimer.timeout > 0) break;
            this.asyncTimers.remove(0);
            n6 = asyncTimer.size();
            while (--n6 >= 0) {
                AsyncTimerListener asyncTimerListener = (AsyncTimerListener)asyncTimer.get(n6);
                asyncTimerListener.expired(this);
            }
        }
        return n5 * this.machineCycle;
    }

    public boolean getBreakPoint(int n) {
        return this.breakPoint[n];
    }

    public void setBreakAtPC() {
        this.setBreakPoint(this.pc, true);
    }

    public void setBreakPoint(int n, boolean bl) {
        this.breakPoint[n] = bl;
    }

    public String getDecodeAt(int n) {
        MCS51Opcode mCS51Opcode = opcodes[this.code(n)];
        return mCS51Opcode.decode(this, n);
    }

    public String getDescriptionAt(int n) {
        MCS51Opcode mCS51Opcode = opcodes[this.code(n)];
        return mCS51Opcode.getDescription();
    }

    public int getLengthAt(int n) {
        MCS51Opcode mCS51Opcode = opcodes[this.code(n)];
        return mCS51Opcode.getLength();
    }

    public void setOscillator(int n) {
        if (n != this.oscillator) {
            log.info("Set oscillator " + n);
            this.oscillator = n;
        }
    }

    public int getOscillator() {
        return this.oscillator;
    }

    public long clock() {
        return this.clock;
    }

    public void machineCycle(int n) {
        this.machineCycle = n;
    }

    public int machineCycle() {
        return this.machineCycle;
    }

    public String toString() {
        return "Intel MCS51 $Id: MCS51.java 75 2010-07-07 06:04:05Z mviara $";
    }

    public static void main(String[] stringArray) {
        MCS51 mCS51 = new MCS51();
        mCS51.reset();
    }

    static {
        MCS51.initOpcodes();
    }
}

