/*
 * Decompiled with CFR 0.152.
 */
package j51.keil;

import java.awt.Color;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

class MCB900PCB
extends JLabel {
    private int led = 0;
    private Color on = Color.green;
    private Color off = Color.gray;

    MCB900PCB() {
        URL uRL = ClassLoader.getSystemResource("j51/keil/images/mcb900.jpg");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIcon(imageIcon);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        for (int i = 0; i < 8; ++i) {
            Color color = this.off;
            if ((this.led & 1 << i) != 0) {
                color = this.on;
            }
            graphics.setColor(color);
            graphics.fill3DRect(185 + (7 - i) * 13, 5, 8, 12, false);
        }
    }

    void setLed(int n) {
        if (this.led != n) {
            this.led = n;
            this.repaint(185, 5, 104, 12);
        }
    }

    int getLed() {
        return this.led;
    }
}

