/*
 * Decompiled with CFR 0.152.
 */
package j51.swing;

import j51.swing.HexTextDocument;
import j51.swing.JFixedField;
import j51.util.Hex;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class JHexField
extends JFixedField
implements KeyListener {
    JHexField(int n) {
        this(n, false);
    }

    JHexField(int n, boolean bl) {
        super(n, bl);
        this.setDocument(new HexTextDocument(n));
        this.setHorizontalAlignment(4);
        this.setValue(0);
        this.addKeyListener(this);
    }

    public int getValue() throws Exception {
        String string = this.getText();
        int n = 0;
        try {
            for (int i = 0; i < string.length(); ++i) {
                n = n << 4 | Hex.getDigit(string, i);
            }
            this.setValue(n);
        }
        catch (Exception exception) {
            this.setText("0");
        }
        return n;
    }

    public void setValue(int n) {
        String string = this.len == 4 ? Hex.bin2word(n) : Hex.bin2byte(n);
        String string2 = this.getText();
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals(string2)) {
            if (this.getSelected()) {
                this.setSelected(false);
            }
        } else {
            this.setSelected(true);
            this.setText(string);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.key(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void key(KeyEvent keyEvent) {
        int n = 0;
        if (this.isEditable()) {
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    n = 16;
                    break;
                }
                case 34: {
                    n = -16;
                    break;
                }
                case 38: {
                    n = 1;
                    break;
                }
                case 40: {
                    n = -1;
                }
            }
            if (n != 0) {
                try {
                    int n2 = this.getValue();
                    this.setValue(n2 + n & 0xFFFF);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (n != 0) {
            keyEvent.setKeyCode(10);
        }
    }
}

